/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceagreement.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAgreementResponse extends MarketplaceAgreementResponse implements
        ToCopyableBuilder<DescribeAgreementResponse.Builder, DescribeAgreementResponse> {
    private static final SdkField<Instant> ACCEPTANCE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("acceptanceTime").getter(getter(DescribeAgreementResponse::acceptanceTime))
            .setter(setter(Builder::acceptanceTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptanceTime").build()).build();

    private static final SdkField<Acceptor> ACCEPTOR_FIELD = SdkField.<Acceptor> builder(MarshallingType.SDK_POJO)
            .memberName("acceptor").getter(getter(DescribeAgreementResponse::acceptor)).setter(setter(Builder::acceptor))
            .constructor(Acceptor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptor").build()).build();

    private static final SdkField<String> AGREEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agreementId").getter(getter(DescribeAgreementResponse::agreementId))
            .setter(setter(Builder::agreementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agreementId").build()).build();

    private static final SdkField<String> AGREEMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agreementType").getter(getter(DescribeAgreementResponse::agreementType))
            .setter(setter(Builder::agreementType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agreementType").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(DescribeAgreementResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<EstimatedCharges> ESTIMATED_CHARGES_FIELD = SdkField
            .<EstimatedCharges> builder(MarshallingType.SDK_POJO).memberName("estimatedCharges")
            .getter(getter(DescribeAgreementResponse::estimatedCharges)).setter(setter(Builder::estimatedCharges))
            .constructor(EstimatedCharges::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedCharges").build()).build();

    private static final SdkField<ProposalSummary> PROPOSAL_SUMMARY_FIELD = SdkField
            .<ProposalSummary> builder(MarshallingType.SDK_POJO).memberName("proposalSummary")
            .getter(getter(DescribeAgreementResponse::proposalSummary)).setter(setter(Builder::proposalSummary))
            .constructor(ProposalSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("proposalSummary").build()).build();

    private static final SdkField<Proposer> PROPOSER_FIELD = SdkField.<Proposer> builder(MarshallingType.SDK_POJO)
            .memberName("proposer").getter(getter(DescribeAgreementResponse::proposer)).setter(setter(Builder::proposer))
            .constructor(Proposer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("proposer").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(DescribeAgreementResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DescribeAgreementResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPTANCE_TIME_FIELD,
            ACCEPTOR_FIELD, AGREEMENT_ID_FIELD, AGREEMENT_TYPE_FIELD, END_TIME_FIELD, ESTIMATED_CHARGES_FIELD,
            PROPOSAL_SUMMARY_FIELD, PROPOSER_FIELD, START_TIME_FIELD, STATUS_FIELD));

    private final Instant acceptanceTime;

    private final Acceptor acceptor;

    private final String agreementId;

    private final String agreementType;

    private final Instant endTime;

    private final EstimatedCharges estimatedCharges;

    private final ProposalSummary proposalSummary;

    private final Proposer proposer;

    private final Instant startTime;

    private final String status;

    private DescribeAgreementResponse(BuilderImpl builder) {
        super(builder);
        this.acceptanceTime = builder.acceptanceTime;
        this.acceptor = builder.acceptor;
        this.agreementId = builder.agreementId;
        this.agreementType = builder.agreementType;
        this.endTime = builder.endTime;
        this.estimatedCharges = builder.estimatedCharges;
        this.proposalSummary = builder.proposalSummary;
        this.proposer = builder.proposer;
        this.startTime = builder.startTime;
        this.status = builder.status;
    }

    /**
     * <p>
     * The date and time the offer was accepted or the agreement was created.
     * </p>
     * <note>
     * <p>
     * <code>AcceptanceTime</code> and <code>StartTime</code> can differ for future dated agreements (FDAs).
     * </p>
     * </note>
     * 
     * @return The date and time the offer was accepted or the agreement was created.</p> <note>
     *         <p>
     *         <code>AcceptanceTime</code> and <code>StartTime</code> can differ for future dated agreements (FDAs).
     *         </p>
     */
    public final Instant acceptanceTime() {
        return acceptanceTime;
    }

    /**
     * <p>
     * The details of the party accepting the agreement terms. This is commonly the buyer for
     * <code>PurchaseAgreement</code>.
     * </p>
     * 
     * @return The details of the party accepting the agreement terms. This is commonly the buyer for
     *         <code>PurchaseAgreement</code>.
     */
    public final Acceptor acceptor() {
        return acceptor;
    }

    /**
     * <p>
     * The unique identifier of the agreement.
     * </p>
     * 
     * @return The unique identifier of the agreement.
     */
    public final String agreementId() {
        return agreementId;
    }

    /**
     * <p>
     * The type of agreement. Values are <code>PurchaseAgreement</code> or <code>VendorInsightsAgreement</code>.
     * </p>
     * 
     * @return The type of agreement. Values are <code>PurchaseAgreement</code> or <code>VendorInsightsAgreement</code>.
     */
    public final String agreementType() {
        return agreementType;
    }

    /**
     * <p>
     * The date and time when the agreement ends. The field is <code>null</code> for pay-as-you-go agreements, which
     * don’t have end dates.
     * </p>
     * 
     * @return The date and time when the agreement ends. The field is <code>null</code> for pay-as-you-go agreements,
     *         which don’t have end dates.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The estimated cost of the agreement.
     * </p>
     * 
     * @return The estimated cost of the agreement.
     */
    public final EstimatedCharges estimatedCharges() {
        return estimatedCharges;
    }

    /**
     * <p>
     * A summary of the proposal received from the proposer.
     * </p>
     * 
     * @return A summary of the proposal received from the proposer.
     */
    public final ProposalSummary proposalSummary() {
        return proposalSummary;
    }

    /**
     * <p>
     * The details of the party proposing the agreement terms. This is commonly the seller for
     * <code>PurchaseAgreement</code>.
     * </p>
     * 
     * @return The details of the party proposing the agreement terms. This is commonly the seller for
     *         <code>PurchaseAgreement</code>.
     */
    public final Proposer proposer() {
        return proposer;
    }

    /**
     * <p>
     * The date and time when the agreement starts.
     * </p>
     * 
     * @return The date and time when the agreement starts.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The current status of the agreement.
     * </p>
     * <p>
     * Statuses include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> – The terms of the agreement are active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARCHIVED</code> – The agreement ended without a specified reason.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELLED</code> – The acceptor ended the agreement before the defined end date.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXPIRED</code> – The agreement ended on the defined end date.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RENEWED</code> – The agreement was renewed into a new agreement (for example, an auto-renewal).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REPLACED</code> – The agreement was replaced using an agreement replacement offer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ROLLED_BACK</code> (Only applicable to inactive agreement revisions) – The agreement revision has been
     * rolled back because of an error. An earlier revision is now active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUPERCEDED</code> (Only applicable to inactive agreement revisions) – The agreement revision is no longer
     * active and another agreement revision is now active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TERMINATED</code> – The agreement ended before the defined end date because of an AWS termination (for
     * example, a payment failure).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgreementStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the agreement.</p>
     *         <p>
     *         Statuses include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> – The terms of the agreement are active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARCHIVED</code> – The agreement ended without a specified reason.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELLED</code> – The acceptor ended the agreement before the defined end date.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXPIRED</code> – The agreement ended on the defined end date.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RENEWED</code> – The agreement was renewed into a new agreement (for example, an auto-renewal).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REPLACED</code> – The agreement was replaced using an agreement replacement offer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ROLLED_BACK</code> (Only applicable to inactive agreement revisions) – The agreement revision has
     *         been rolled back because of an error. An earlier revision is now active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUPERCEDED</code> (Only applicable to inactive agreement revisions) – The agreement revision is no
     *         longer active and another agreement revision is now active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TERMINATED</code> – The agreement ended before the defined end date because of an AWS termination
     *         (for example, a payment failure).
     *         </p>
     *         </li>
     * @see AgreementStatus
     */
    public final AgreementStatus status() {
        return AgreementStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the agreement.
     * </p>
     * <p>
     * Statuses include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> – The terms of the agreement are active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARCHIVED</code> – The agreement ended without a specified reason.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELLED</code> – The acceptor ended the agreement before the defined end date.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXPIRED</code> – The agreement ended on the defined end date.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RENEWED</code> – The agreement was renewed into a new agreement (for example, an auto-renewal).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REPLACED</code> – The agreement was replaced using an agreement replacement offer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ROLLED_BACK</code> (Only applicable to inactive agreement revisions) – The agreement revision has been
     * rolled back because of an error. An earlier revision is now active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUPERCEDED</code> (Only applicable to inactive agreement revisions) – The agreement revision is no longer
     * active and another agreement revision is now active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TERMINATED</code> – The agreement ended before the defined end date because of an AWS termination (for
     * example, a payment failure).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgreementStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the agreement.</p>
     *         <p>
     *         Statuses include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> – The terms of the agreement are active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARCHIVED</code> – The agreement ended without a specified reason.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELLED</code> – The acceptor ended the agreement before the defined end date.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXPIRED</code> – The agreement ended on the defined end date.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RENEWED</code> – The agreement was renewed into a new agreement (for example, an auto-renewal).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REPLACED</code> – The agreement was replaced using an agreement replacement offer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ROLLED_BACK</code> (Only applicable to inactive agreement revisions) – The agreement revision has
     *         been rolled back because of an error. An earlier revision is now active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUPERCEDED</code> (Only applicable to inactive agreement revisions) – The agreement revision is no
     *         longer active and another agreement revision is now active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TERMINATED</code> – The agreement ended before the defined end date because of an AWS termination
     *         (for example, a payment failure).
     *         </p>
     *         </li>
     * @see AgreementStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptanceTime());
        hashCode = 31 * hashCode + Objects.hashCode(acceptor());
        hashCode = 31 * hashCode + Objects.hashCode(agreementId());
        hashCode = 31 * hashCode + Objects.hashCode(agreementType());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedCharges());
        hashCode = 31 * hashCode + Objects.hashCode(proposalSummary());
        hashCode = 31 * hashCode + Objects.hashCode(proposer());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAgreementResponse)) {
            return false;
        }
        DescribeAgreementResponse other = (DescribeAgreementResponse) obj;
        return Objects.equals(acceptanceTime(), other.acceptanceTime()) && Objects.equals(acceptor(), other.acceptor())
                && Objects.equals(agreementId(), other.agreementId()) && Objects.equals(agreementType(), other.agreementType())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(estimatedCharges(), other.estimatedCharges())
                && Objects.equals(proposalSummary(), other.proposalSummary()) && Objects.equals(proposer(), other.proposer())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAgreementResponse").add("AcceptanceTime", acceptanceTime()).add("Acceptor", acceptor())
                .add("AgreementId", agreementId()).add("AgreementType", agreementType()).add("EndTime", endTime())
                .add("EstimatedCharges", estimatedCharges()).add("ProposalSummary", proposalSummary())
                .add("Proposer", proposer()).add("StartTime", startTime()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "acceptanceTime":
            return Optional.ofNullable(clazz.cast(acceptanceTime()));
        case "acceptor":
            return Optional.ofNullable(clazz.cast(acceptor()));
        case "agreementId":
            return Optional.ofNullable(clazz.cast(agreementId()));
        case "agreementType":
            return Optional.ofNullable(clazz.cast(agreementType()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "estimatedCharges":
            return Optional.ofNullable(clazz.cast(estimatedCharges()));
        case "proposalSummary":
            return Optional.ofNullable(clazz.cast(proposalSummary()));
        case "proposer":
            return Optional.ofNullable(clazz.cast(proposer()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAgreementResponse, T> g) {
        return obj -> g.apply((DescribeAgreementResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MarketplaceAgreementResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAgreementResponse> {
        /**
         * <p>
         * The date and time the offer was accepted or the agreement was created.
         * </p>
         * <note>
         * <p>
         * <code>AcceptanceTime</code> and <code>StartTime</code> can differ for future dated agreements (FDAs).
         * </p>
         * </note>
         * 
         * @param acceptanceTime
         *        The date and time the offer was accepted or the agreement was created.</p> <note>
         *        <p>
         *        <code>AcceptanceTime</code> and <code>StartTime</code> can differ for future dated agreements (FDAs).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptanceTime(Instant acceptanceTime);

        /**
         * <p>
         * The details of the party accepting the agreement terms. This is commonly the buyer for
         * <code>PurchaseAgreement</code>.
         * </p>
         * 
         * @param acceptor
         *        The details of the party accepting the agreement terms. This is commonly the buyer for
         *        <code>PurchaseAgreement</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptor(Acceptor acceptor);

        /**
         * <p>
         * The details of the party accepting the agreement terms. This is commonly the buyer for
         * <code>PurchaseAgreement</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Acceptor.Builder} avoiding the need to
         * create one manually via {@link Acceptor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Acceptor.Builder#build()} is called immediately and its result is
         * passed to {@link #acceptor(Acceptor)}.
         * 
         * @param acceptor
         *        a consumer that will call methods on {@link Acceptor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acceptor(Acceptor)
         */
        default Builder acceptor(Consumer<Acceptor.Builder> acceptor) {
            return acceptor(Acceptor.builder().applyMutation(acceptor).build());
        }

        /**
         * <p>
         * The unique identifier of the agreement.
         * </p>
         * 
         * @param agreementId
         *        The unique identifier of the agreement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agreementId(String agreementId);

        /**
         * <p>
         * The type of agreement. Values are <code>PurchaseAgreement</code> or <code>VendorInsightsAgreement</code>.
         * </p>
         * 
         * @param agreementType
         *        The type of agreement. Values are <code>PurchaseAgreement</code> or
         *        <code>VendorInsightsAgreement</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agreementType(String agreementType);

        /**
         * <p>
         * The date and time when the agreement ends. The field is <code>null</code> for pay-as-you-go agreements, which
         * don’t have end dates.
         * </p>
         * 
         * @param endTime
         *        The date and time when the agreement ends. The field is <code>null</code> for pay-as-you-go
         *        agreements, which don’t have end dates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The estimated cost of the agreement.
         * </p>
         * 
         * @param estimatedCharges
         *        The estimated cost of the agreement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedCharges(EstimatedCharges estimatedCharges);

        /**
         * <p>
         * The estimated cost of the agreement.
         * </p>
         * This is a convenience method that creates an instance of the {@link EstimatedCharges.Builder} avoiding the
         * need to create one manually via {@link EstimatedCharges#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EstimatedCharges.Builder#build()} is called immediately and its
         * result is passed to {@link #estimatedCharges(EstimatedCharges)}.
         * 
         * @param estimatedCharges
         *        a consumer that will call methods on {@link EstimatedCharges.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #estimatedCharges(EstimatedCharges)
         */
        default Builder estimatedCharges(Consumer<EstimatedCharges.Builder> estimatedCharges) {
            return estimatedCharges(EstimatedCharges.builder().applyMutation(estimatedCharges).build());
        }

        /**
         * <p>
         * A summary of the proposal received from the proposer.
         * </p>
         * 
         * @param proposalSummary
         *        A summary of the proposal received from the proposer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proposalSummary(ProposalSummary proposalSummary);

        /**
         * <p>
         * A summary of the proposal received from the proposer.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProposalSummary.Builder} avoiding the
         * need to create one manually via {@link ProposalSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProposalSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #proposalSummary(ProposalSummary)}.
         * 
         * @param proposalSummary
         *        a consumer that will call methods on {@link ProposalSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proposalSummary(ProposalSummary)
         */
        default Builder proposalSummary(Consumer<ProposalSummary.Builder> proposalSummary) {
            return proposalSummary(ProposalSummary.builder().applyMutation(proposalSummary).build());
        }

        /**
         * <p>
         * The details of the party proposing the agreement terms. This is commonly the seller for
         * <code>PurchaseAgreement</code>.
         * </p>
         * 
         * @param proposer
         *        The details of the party proposing the agreement terms. This is commonly the seller for
         *        <code>PurchaseAgreement</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proposer(Proposer proposer);

        /**
         * <p>
         * The details of the party proposing the agreement terms. This is commonly the seller for
         * <code>PurchaseAgreement</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Proposer.Builder} avoiding the need to
         * create one manually via {@link Proposer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Proposer.Builder#build()} is called immediately and its result is
         * passed to {@link #proposer(Proposer)}.
         * 
         * @param proposer
         *        a consumer that will call methods on {@link Proposer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proposer(Proposer)
         */
        default Builder proposer(Consumer<Proposer.Builder> proposer) {
            return proposer(Proposer.builder().applyMutation(proposer).build());
        }

        /**
         * <p>
         * The date and time when the agreement starts.
         * </p>
         * 
         * @param startTime
         *        The date and time when the agreement starts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The current status of the agreement.
         * </p>
         * <p>
         * Statuses include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code> – The terms of the agreement are active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARCHIVED</code> – The agreement ended without a specified reason.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELLED</code> – The acceptor ended the agreement before the defined end date.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXPIRED</code> – The agreement ended on the defined end date.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RENEWED</code> – The agreement was renewed into a new agreement (for example, an auto-renewal).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REPLACED</code> – The agreement was replaced using an agreement replacement offer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ROLLED_BACK</code> (Only applicable to inactive agreement revisions) – The agreement revision has been
         * rolled back because of an error. An earlier revision is now active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUPERCEDED</code> (Only applicable to inactive agreement revisions) – The agreement revision is no
         * longer active and another agreement revision is now active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TERMINATED</code> – The agreement ended before the defined end date because of an AWS termination (for
         * example, a payment failure).
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the agreement.</p>
         *        <p>
         *        Statuses include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> – The terms of the agreement are active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARCHIVED</code> – The agreement ended without a specified reason.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELLED</code> – The acceptor ended the agreement before the defined end date.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXPIRED</code> – The agreement ended on the defined end date.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RENEWED</code> – The agreement was renewed into a new agreement (for example, an auto-renewal).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REPLACED</code> – The agreement was replaced using an agreement replacement offer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ROLLED_BACK</code> (Only applicable to inactive agreement revisions) – The agreement revision
         *        has been rolled back because of an error. An earlier revision is now active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUPERCEDED</code> (Only applicable to inactive agreement revisions) – The agreement revision is
         *        no longer active and another agreement revision is now active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TERMINATED</code> – The agreement ended before the defined end date because of an AWS
         *        termination (for example, a payment failure).
         *        </p>
         *        </li>
         * @see AgreementStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgreementStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the agreement.
         * </p>
         * <p>
         * Statuses include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code> – The terms of the agreement are active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARCHIVED</code> – The agreement ended without a specified reason.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELLED</code> – The acceptor ended the agreement before the defined end date.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXPIRED</code> – The agreement ended on the defined end date.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RENEWED</code> – The agreement was renewed into a new agreement (for example, an auto-renewal).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REPLACED</code> – The agreement was replaced using an agreement replacement offer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ROLLED_BACK</code> (Only applicable to inactive agreement revisions) – The agreement revision has been
         * rolled back because of an error. An earlier revision is now active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUPERCEDED</code> (Only applicable to inactive agreement revisions) – The agreement revision is no
         * longer active and another agreement revision is now active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TERMINATED</code> – The agreement ended before the defined end date because of an AWS termination (for
         * example, a payment failure).
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the agreement.</p>
         *        <p>
         *        Statuses include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> – The terms of the agreement are active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARCHIVED</code> – The agreement ended without a specified reason.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELLED</code> – The acceptor ended the agreement before the defined end date.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXPIRED</code> – The agreement ended on the defined end date.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RENEWED</code> – The agreement was renewed into a new agreement (for example, an auto-renewal).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REPLACED</code> – The agreement was replaced using an agreement replacement offer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ROLLED_BACK</code> (Only applicable to inactive agreement revisions) – The agreement revision
         *        has been rolled back because of an error. An earlier revision is now active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUPERCEDED</code> (Only applicable to inactive agreement revisions) – The agreement revision is
         *        no longer active and another agreement revision is now active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TERMINATED</code> – The agreement ended before the defined end date because of an AWS
         *        termination (for example, a payment failure).
         *        </p>
         *        </li>
         * @see AgreementStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgreementStatus
         */
        Builder status(AgreementStatus status);
    }

    static final class BuilderImpl extends MarketplaceAgreementResponse.BuilderImpl implements Builder {
        private Instant acceptanceTime;

        private Acceptor acceptor;

        private String agreementId;

        private String agreementType;

        private Instant endTime;

        private EstimatedCharges estimatedCharges;

        private ProposalSummary proposalSummary;

        private Proposer proposer;

        private Instant startTime;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAgreementResponse model) {
            super(model);
            acceptanceTime(model.acceptanceTime);
            acceptor(model.acceptor);
            agreementId(model.agreementId);
            agreementType(model.agreementType);
            endTime(model.endTime);
            estimatedCharges(model.estimatedCharges);
            proposalSummary(model.proposalSummary);
            proposer(model.proposer);
            startTime(model.startTime);
            status(model.status);
        }

        public final Instant getAcceptanceTime() {
            return acceptanceTime;
        }

        public final void setAcceptanceTime(Instant acceptanceTime) {
            this.acceptanceTime = acceptanceTime;
        }

        @Override
        public final Builder acceptanceTime(Instant acceptanceTime) {
            this.acceptanceTime = acceptanceTime;
            return this;
        }

        public final Acceptor.Builder getAcceptor() {
            return acceptor != null ? acceptor.toBuilder() : null;
        }

        public final void setAcceptor(Acceptor.BuilderImpl acceptor) {
            this.acceptor = acceptor != null ? acceptor.build() : null;
        }

        @Override
        public final Builder acceptor(Acceptor acceptor) {
            this.acceptor = acceptor;
            return this;
        }

        public final String getAgreementId() {
            return agreementId;
        }

        public final void setAgreementId(String agreementId) {
            this.agreementId = agreementId;
        }

        @Override
        public final Builder agreementId(String agreementId) {
            this.agreementId = agreementId;
            return this;
        }

        public final String getAgreementType() {
            return agreementType;
        }

        public final void setAgreementType(String agreementType) {
            this.agreementType = agreementType;
        }

        @Override
        public final Builder agreementType(String agreementType) {
            this.agreementType = agreementType;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final EstimatedCharges.Builder getEstimatedCharges() {
            return estimatedCharges != null ? estimatedCharges.toBuilder() : null;
        }

        public final void setEstimatedCharges(EstimatedCharges.BuilderImpl estimatedCharges) {
            this.estimatedCharges = estimatedCharges != null ? estimatedCharges.build() : null;
        }

        @Override
        public final Builder estimatedCharges(EstimatedCharges estimatedCharges) {
            this.estimatedCharges = estimatedCharges;
            return this;
        }

        public final ProposalSummary.Builder getProposalSummary() {
            return proposalSummary != null ? proposalSummary.toBuilder() : null;
        }

        public final void setProposalSummary(ProposalSummary.BuilderImpl proposalSummary) {
            this.proposalSummary = proposalSummary != null ? proposalSummary.build() : null;
        }

        @Override
        public final Builder proposalSummary(ProposalSummary proposalSummary) {
            this.proposalSummary = proposalSummary;
            return this;
        }

        public final Proposer.Builder getProposer() {
            return proposer != null ? proposer.toBuilder() : null;
        }

        public final void setProposer(Proposer.BuilderImpl proposer) {
            this.proposer = proposer != null ? proposer.build() : null;
        }

        @Override
        public final Builder proposer(Proposer proposer) {
            this.proposer = proposer;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgreementStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DescribeAgreementResponse build() {
            return new DescribeAgreementResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
