/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceagreement.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchAgreementsResponse extends MarketplaceAgreementResponse implements
        ToCopyableBuilder<SearchAgreementsResponse.Builder, SearchAgreementsResponse> {
    private static final SdkField<List<AgreementViewSummary>> AGREEMENT_VIEW_SUMMARIES_FIELD = SdkField
            .<List<AgreementViewSummary>> builder(MarshallingType.LIST)
            .memberName("agreementViewSummaries")
            .getter(getter(SearchAgreementsResponse::agreementViewSummaries))
            .setter(setter(Builder::agreementViewSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agreementViewSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AgreementViewSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AgreementViewSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(SearchAgreementsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AGREEMENT_VIEW_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<AgreementViewSummary> agreementViewSummaries;

    private final String nextToken;

    private SearchAgreementsResponse(BuilderImpl builder) {
        super(builder);
        this.agreementViewSummaries = builder.agreementViewSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AgreementViewSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAgreementViewSummaries() {
        return agreementViewSummaries != null && !(agreementViewSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A summary of the agreement, including top-level attributes (for example, the agreement ID, version, proposer, and
     * acceptor).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgreementViewSummaries} method.
     * </p>
     * 
     * @return A summary of the agreement, including top-level attributes (for example, the agreement ID, version,
     *         proposer, and acceptor).
     */
    public final List<AgreementViewSummary> agreementViewSummaries() {
        return agreementViewSummaries;
    }

    /**
     * <p>
     * The token used for pagination. The field is <code>null</code> if there are no more results.
     * </p>
     * 
     * @return The token used for pagination. The field is <code>null</code> if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAgreementViewSummaries() ? agreementViewSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchAgreementsResponse)) {
            return false;
        }
        SearchAgreementsResponse other = (SearchAgreementsResponse) obj;
        return hasAgreementViewSummaries() == other.hasAgreementViewSummaries()
                && Objects.equals(agreementViewSummaries(), other.agreementViewSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchAgreementsResponse")
                .add("AgreementViewSummaries", hasAgreementViewSummaries() ? agreementViewSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agreementViewSummaries":
            return Optional.ofNullable(clazz.cast(agreementViewSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchAgreementsResponse, T> g) {
        return obj -> g.apply((SearchAgreementsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MarketplaceAgreementResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, SearchAgreementsResponse> {
        /**
         * <p>
         * A summary of the agreement, including top-level attributes (for example, the agreement ID, version, proposer,
         * and acceptor).
         * </p>
         * 
         * @param agreementViewSummaries
         *        A summary of the agreement, including top-level attributes (for example, the agreement ID, version,
         *        proposer, and acceptor).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agreementViewSummaries(Collection<AgreementViewSummary> agreementViewSummaries);

        /**
         * <p>
         * A summary of the agreement, including top-level attributes (for example, the agreement ID, version, proposer,
         * and acceptor).
         * </p>
         * 
         * @param agreementViewSummaries
         *        A summary of the agreement, including top-level attributes (for example, the agreement ID, version,
         *        proposer, and acceptor).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agreementViewSummaries(AgreementViewSummary... agreementViewSummaries);

        /**
         * <p>
         * A summary of the agreement, including top-level attributes (for example, the agreement ID, version, proposer,
         * and acceptor).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.AgreementViewSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.AgreementViewSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.AgreementViewSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #agreementViewSummaries(List<AgreementViewSummary>)}.
         * 
         * @param agreementViewSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.marketplaceagreement.model.AgreementViewSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agreementViewSummaries(java.util.Collection<AgreementViewSummary>)
         */
        Builder agreementViewSummaries(Consumer<AgreementViewSummary.Builder>... agreementViewSummaries);

        /**
         * <p>
         * The token used for pagination. The field is <code>null</code> if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token used for pagination. The field is <code>null</code> if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MarketplaceAgreementResponse.BuilderImpl implements Builder {
        private List<AgreementViewSummary> agreementViewSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchAgreementsResponse model) {
            super(model);
            agreementViewSummaries(model.agreementViewSummaries);
            nextToken(model.nextToken);
        }

        public final List<AgreementViewSummary.Builder> getAgreementViewSummaries() {
            List<AgreementViewSummary.Builder> result = AgreementViewSummaryListCopier.copyToBuilder(this.agreementViewSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgreementViewSummaries(Collection<AgreementViewSummary.BuilderImpl> agreementViewSummaries) {
            this.agreementViewSummaries = AgreementViewSummaryListCopier.copyFromBuilder(agreementViewSummaries);
        }

        @Override
        public final Builder agreementViewSummaries(Collection<AgreementViewSummary> agreementViewSummaries) {
            this.agreementViewSummaries = AgreementViewSummaryListCopier.copy(agreementViewSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agreementViewSummaries(AgreementViewSummary... agreementViewSummaries) {
            agreementViewSummaries(Arrays.asList(agreementViewSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agreementViewSummaries(Consumer<AgreementViewSummary.Builder>... agreementViewSummaries) {
            agreementViewSummaries(Stream.of(agreementViewSummaries)
                    .map(c -> AgreementViewSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public SearchAgreementsResponse build() {
            return new SearchAgreementsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
