/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A subset of terms proposed by the proposer, which have been accepted by the acceptor as part of agreement creation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptedTerm implements SdkPojo, Serializable, ToCopyableBuilder<AcceptedTerm.Builder, AcceptedTerm> {
    private static final SdkField<ByolPricingTerm> BYOL_PRICING_TERM_FIELD = SdkField
            .<ByolPricingTerm> builder(MarshallingType.SDK_POJO).memberName("byolPricingTerm")
            .getter(getter(AcceptedTerm::byolPricingTerm)).setter(setter(Builder::byolPricingTerm))
            .constructor(ByolPricingTerm::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("byolPricingTerm").build()).build();

    private static final SdkField<ConfigurableUpfrontPricingTerm> CONFIGURABLE_UPFRONT_PRICING_TERM_FIELD = SdkField
            .<ConfigurableUpfrontPricingTerm> builder(MarshallingType.SDK_POJO)
            .memberName("configurableUpfrontPricingTerm")
            .getter(getter(AcceptedTerm::configurableUpfrontPricingTerm))
            .setter(setter(Builder::configurableUpfrontPricingTerm))
            .constructor(ConfigurableUpfrontPricingTerm::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurableUpfrontPricingTerm")
                    .build()).build();

    private static final SdkField<FixedUpfrontPricingTerm> FIXED_UPFRONT_PRICING_TERM_FIELD = SdkField
            .<FixedUpfrontPricingTerm> builder(MarshallingType.SDK_POJO).memberName("fixedUpfrontPricingTerm")
            .getter(getter(AcceptedTerm::fixedUpfrontPricingTerm)).setter(setter(Builder::fixedUpfrontPricingTerm))
            .constructor(FixedUpfrontPricingTerm::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixedUpfrontPricingTerm").build())
            .build();

    private static final SdkField<FreeTrialPricingTerm> FREE_TRIAL_PRICING_TERM_FIELD = SdkField
            .<FreeTrialPricingTerm> builder(MarshallingType.SDK_POJO).memberName("freeTrialPricingTerm")
            .getter(getter(AcceptedTerm::freeTrialPricingTerm)).setter(setter(Builder::freeTrialPricingTerm))
            .constructor(FreeTrialPricingTerm::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("freeTrialPricingTerm").build())
            .build();

    private static final SdkField<LegalTerm> LEGAL_TERM_FIELD = SdkField.<LegalTerm> builder(MarshallingType.SDK_POJO)
            .memberName("legalTerm").getter(getter(AcceptedTerm::legalTerm)).setter(setter(Builder::legalTerm))
            .constructor(LegalTerm::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("legalTerm").build()).build();

    private static final SdkField<PaymentScheduleTerm> PAYMENT_SCHEDULE_TERM_FIELD = SdkField
            .<PaymentScheduleTerm> builder(MarshallingType.SDK_POJO).memberName("paymentScheduleTerm")
            .getter(getter(AcceptedTerm::paymentScheduleTerm)).setter(setter(Builder::paymentScheduleTerm))
            .constructor(PaymentScheduleTerm::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentScheduleTerm").build())
            .build();

    private static final SdkField<RecurringPaymentTerm> RECURRING_PAYMENT_TERM_FIELD = SdkField
            .<RecurringPaymentTerm> builder(MarshallingType.SDK_POJO).memberName("recurringPaymentTerm")
            .getter(getter(AcceptedTerm::recurringPaymentTerm)).setter(setter(Builder::recurringPaymentTerm))
            .constructor(RecurringPaymentTerm::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recurringPaymentTerm").build())
            .build();

    private static final SdkField<RenewalTerm> RENEWAL_TERM_FIELD = SdkField.<RenewalTerm> builder(MarshallingType.SDK_POJO)
            .memberName("renewalTerm").getter(getter(AcceptedTerm::renewalTerm)).setter(setter(Builder::renewalTerm))
            .constructor(RenewalTerm::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renewalTerm").build()).build();

    private static final SdkField<SupportTerm> SUPPORT_TERM_FIELD = SdkField.<SupportTerm> builder(MarshallingType.SDK_POJO)
            .memberName("supportTerm").getter(getter(AcceptedTerm::supportTerm)).setter(setter(Builder::supportTerm))
            .constructor(SupportTerm::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportTerm").build()).build();

    private static final SdkField<UsageBasedPricingTerm> USAGE_BASED_PRICING_TERM_FIELD = SdkField
            .<UsageBasedPricingTerm> builder(MarshallingType.SDK_POJO).memberName("usageBasedPricingTerm")
            .getter(getter(AcceptedTerm::usageBasedPricingTerm)).setter(setter(Builder::usageBasedPricingTerm))
            .constructor(UsageBasedPricingTerm::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageBasedPricingTerm").build())
            .build();

    private static final SdkField<ValidityTerm> VALIDITY_TERM_FIELD = SdkField.<ValidityTerm> builder(MarshallingType.SDK_POJO)
            .memberName("validityTerm").getter(getter(AcceptedTerm::validityTerm)).setter(setter(Builder::validityTerm))
            .constructor(ValidityTerm::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validityTerm").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYOL_PRICING_TERM_FIELD,
            CONFIGURABLE_UPFRONT_PRICING_TERM_FIELD, FIXED_UPFRONT_PRICING_TERM_FIELD, FREE_TRIAL_PRICING_TERM_FIELD,
            LEGAL_TERM_FIELD, PAYMENT_SCHEDULE_TERM_FIELD, RECURRING_PAYMENT_TERM_FIELD, RENEWAL_TERM_FIELD, SUPPORT_TERM_FIELD,
            USAGE_BASED_PRICING_TERM_FIELD, VALIDITY_TERM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ByolPricingTerm byolPricingTerm;

    private final ConfigurableUpfrontPricingTerm configurableUpfrontPricingTerm;

    private final FixedUpfrontPricingTerm fixedUpfrontPricingTerm;

    private final FreeTrialPricingTerm freeTrialPricingTerm;

    private final LegalTerm legalTerm;

    private final PaymentScheduleTerm paymentScheduleTerm;

    private final RecurringPaymentTerm recurringPaymentTerm;

    private final RenewalTerm renewalTerm;

    private final SupportTerm supportTerm;

    private final UsageBasedPricingTerm usageBasedPricingTerm;

    private final ValidityTerm validityTerm;

    private final Type type;

    private AcceptedTerm(BuilderImpl builder) {
        this.byolPricingTerm = builder.byolPricingTerm;
        this.configurableUpfrontPricingTerm = builder.configurableUpfrontPricingTerm;
        this.fixedUpfrontPricingTerm = builder.fixedUpfrontPricingTerm;
        this.freeTrialPricingTerm = builder.freeTrialPricingTerm;
        this.legalTerm = builder.legalTerm;
        this.paymentScheduleTerm = builder.paymentScheduleTerm;
        this.recurringPaymentTerm = builder.recurringPaymentTerm;
        this.renewalTerm = builder.renewalTerm;
        this.supportTerm = builder.supportTerm;
        this.usageBasedPricingTerm = builder.usageBasedPricingTerm;
        this.validityTerm = builder.validityTerm;
        this.type = builder.type;
    }

    /**
     * <p>
     * Enables you and your customers to move your existing agreements to AWS Marketplace. The customer won't be charged
     * for product usage in AWS Marketplace because they already paid for the product outside of AWS Marketplace.
     * </p>
     * 
     * @return Enables you and your customers to move your existing agreements to AWS Marketplace. The customer won't be
     *         charged for product usage in AWS Marketplace because they already paid for the product outside of AWS
     *         Marketplace.
     */
    public final ByolPricingTerm byolPricingTerm() {
        return byolPricingTerm;
    }

    /**
     * <p>
     * Defines a prepaid payment model that allows buyers to configure the entitlements they want to purchase and the
     * duration.
     * </p>
     * 
     * @return Defines a prepaid payment model that allows buyers to configure the entitlements they want to purchase
     *         and the duration.
     */
    public final ConfigurableUpfrontPricingTerm configurableUpfrontPricingTerm() {
        return configurableUpfrontPricingTerm;
    }

    /**
     * <p>
     * Defines a pre-paid pricing model where the customers are charged a fixed upfront amount.
     * </p>
     * 
     * @return Defines a pre-paid pricing model where the customers are charged a fixed upfront amount.
     */
    public final FixedUpfrontPricingTerm fixedUpfrontPricingTerm() {
        return fixedUpfrontPricingTerm;
    }

    /**
     * <p>
     * Defines a short-term free pricing model where the buyers aren’t charged anything within a specified limit.
     * </p>
     * 
     * @return Defines a short-term free pricing model where the buyers aren’t charged anything within a specified
     *         limit.
     */
    public final FreeTrialPricingTerm freeTrialPricingTerm() {
        return freeTrialPricingTerm;
    }

    /**
     * <p>
     * Defines the list of text agreements proposed to the acceptors. An example is the end user license agreement
     * (EULA).
     * </p>
     * 
     * @return Defines the list of text agreements proposed to the acceptors. An example is the end user license
     *         agreement (EULA).
     */
    public final LegalTerm legalTerm() {
        return legalTerm;
    }

    /**
     * <p>
     * Defines an installment-based pricing model where customers are charged a fixed price on different dates during
     * the agreement validity period. This is used most commonly for flexible payment schedule pricing.
     * </p>
     * 
     * @return Defines an installment-based pricing model where customers are charged a fixed price on different dates
     *         during the agreement validity period. This is used most commonly for flexible payment schedule pricing.
     */
    public final PaymentScheduleTerm paymentScheduleTerm() {
        return paymentScheduleTerm;
    }

    /**
     * <p>
     * Defines a pricing model where customers are charged a fixed recurring price at the end of each billing period.
     * </p>
     * 
     * @return Defines a pricing model where customers are charged a fixed recurring price at the end of each billing
     *         period.
     */
    public final RecurringPaymentTerm recurringPaymentTerm() {
        return recurringPaymentTerm;
    }

    /**
     * <p>
     * Defines that on graceful expiration of the agreement (when the agreement ends on its pre-defined end date), a new
     * agreement will be created using the accepted terms on the existing agreement. In other words, the agreement will
     * be renewed. Presence of <code>RenewalTerm</code> in the offer document means that auto-renewal is allowed. Buyers
     * will have the option to accept or decline auto-renewal at the offer acceptance/agreement creation. Buyers can
     * also change this flag from <code>True</code> to <code>False</code> or <code>False</code> to <code>True</code> at
     * anytime during the agreement's lifecycle.
     * </p>
     * 
     * @return Defines that on graceful expiration of the agreement (when the agreement ends on its pre-defined end
     *         date), a new agreement will be created using the accepted terms on the existing agreement. In other
     *         words, the agreement will be renewed. Presence of <code>RenewalTerm</code> in the offer document means
     *         that auto-renewal is allowed. Buyers will have the option to accept or decline auto-renewal at the offer
     *         acceptance/agreement creation. Buyers can also change this flag from <code>True</code> to
     *         <code>False</code> or <code>False</code> to <code>True</code> at anytime during the agreement's
     *         lifecycle.
     */
    public final RenewalTerm renewalTerm() {
        return renewalTerm;
    }

    /**
     * <p>
     * Defines the customer support available for the acceptors when they purchase the software.
     * </p>
     * 
     * @return Defines the customer support available for the acceptors when they purchase the software.
     */
    public final SupportTerm supportTerm() {
        return supportTerm;
    }

    /**
     * <p>
     * Defines a usage-based pricing model (typically, pay-as-you-go pricing), where the customers are charged based on
     * product usage.
     * </p>
     * 
     * @return Defines a usage-based pricing model (typically, pay-as-you-go pricing), where the customers are charged
     *         based on product usage.
     */
    public final UsageBasedPricingTerm usageBasedPricingTerm() {
        return usageBasedPricingTerm;
    }

    /**
     * <p>
     * Defines the conditions that will keep an agreement created from this offer valid.
     * </p>
     * 
     * @return Defines the conditions that will keep an agreement created from this offer valid.
     */
    public final ValidityTerm validityTerm() {
        return validityTerm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(byolPricingTerm());
        hashCode = 31 * hashCode + Objects.hashCode(configurableUpfrontPricingTerm());
        hashCode = 31 * hashCode + Objects.hashCode(fixedUpfrontPricingTerm());
        hashCode = 31 * hashCode + Objects.hashCode(freeTrialPricingTerm());
        hashCode = 31 * hashCode + Objects.hashCode(legalTerm());
        hashCode = 31 * hashCode + Objects.hashCode(paymentScheduleTerm());
        hashCode = 31 * hashCode + Objects.hashCode(recurringPaymentTerm());
        hashCode = 31 * hashCode + Objects.hashCode(renewalTerm());
        hashCode = 31 * hashCode + Objects.hashCode(supportTerm());
        hashCode = 31 * hashCode + Objects.hashCode(usageBasedPricingTerm());
        hashCode = 31 * hashCode + Objects.hashCode(validityTerm());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptedTerm)) {
            return false;
        }
        AcceptedTerm other = (AcceptedTerm) obj;
        return Objects.equals(byolPricingTerm(), other.byolPricingTerm())
                && Objects.equals(configurableUpfrontPricingTerm(), other.configurableUpfrontPricingTerm())
                && Objects.equals(fixedUpfrontPricingTerm(), other.fixedUpfrontPricingTerm())
                && Objects.equals(freeTrialPricingTerm(), other.freeTrialPricingTerm())
                && Objects.equals(legalTerm(), other.legalTerm())
                && Objects.equals(paymentScheduleTerm(), other.paymentScheduleTerm())
                && Objects.equals(recurringPaymentTerm(), other.recurringPaymentTerm())
                && Objects.equals(renewalTerm(), other.renewalTerm()) && Objects.equals(supportTerm(), other.supportTerm())
                && Objects.equals(usageBasedPricingTerm(), other.usageBasedPricingTerm())
                && Objects.equals(validityTerm(), other.validityTerm());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcceptedTerm").add("ByolPricingTerm", byolPricingTerm())
                .add("ConfigurableUpfrontPricingTerm", configurableUpfrontPricingTerm())
                .add("FixedUpfrontPricingTerm", fixedUpfrontPricingTerm()).add("FreeTrialPricingTerm", freeTrialPricingTerm())
                .add("LegalTerm", legalTerm()).add("PaymentScheduleTerm", paymentScheduleTerm())
                .add("RecurringPaymentTerm", recurringPaymentTerm()).add("RenewalTerm", renewalTerm())
                .add("SupportTerm", supportTerm()).add("UsageBasedPricingTerm", usageBasedPricingTerm())
                .add("ValidityTerm", validityTerm()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "byolPricingTerm":
            return Optional.ofNullable(clazz.cast(byolPricingTerm()));
        case "configurableUpfrontPricingTerm":
            return Optional.ofNullable(clazz.cast(configurableUpfrontPricingTerm()));
        case "fixedUpfrontPricingTerm":
            return Optional.ofNullable(clazz.cast(fixedUpfrontPricingTerm()));
        case "freeTrialPricingTerm":
            return Optional.ofNullable(clazz.cast(freeTrialPricingTerm()));
        case "legalTerm":
            return Optional.ofNullable(clazz.cast(legalTerm()));
        case "paymentScheduleTerm":
            return Optional.ofNullable(clazz.cast(paymentScheduleTerm()));
        case "recurringPaymentTerm":
            return Optional.ofNullable(clazz.cast(recurringPaymentTerm()));
        case "renewalTerm":
            return Optional.ofNullable(clazz.cast(renewalTerm()));
        case "supportTerm":
            return Optional.ofNullable(clazz.cast(supportTerm()));
        case "usageBasedPricingTerm":
            return Optional.ofNullable(clazz.cast(usageBasedPricingTerm()));
        case "validityTerm":
            return Optional.ofNullable(clazz.cast(validityTerm()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #byolPricingTerm()} initialized to the given value.
     *
     * <p>
     * Enables you and your customers to move your existing agreements to AWS Marketplace. The customer won't be charged
     * for product usage in AWS Marketplace because they already paid for the product outside of AWS Marketplace.
     * </p>
     * 
     * @param byolPricingTerm
     *        Enables you and your customers to move your existing agreements to AWS Marketplace. The customer won't be
     *        charged for product usage in AWS Marketplace because they already paid for the product outside of AWS
     *        Marketplace.
     */
    public static AcceptedTerm fromByolPricingTerm(ByolPricingTerm byolPricingTerm) {
        return builder().byolPricingTerm(byolPricingTerm).build();
    }

    /**
     * Create an instance of this class with {@link #byolPricingTerm()} initialized to the given value.
     *
     * <p>
     * Enables you and your customers to move your existing agreements to AWS Marketplace. The customer won't be charged
     * for product usage in AWS Marketplace because they already paid for the product outside of AWS Marketplace.
     * </p>
     * 
     * @param byolPricingTerm
     *        Enables you and your customers to move your existing agreements to AWS Marketplace. The customer won't be
     *        charged for product usage in AWS Marketplace because they already paid for the product outside of AWS
     *        Marketplace.
     */
    public static AcceptedTerm fromByolPricingTerm(Consumer<ByolPricingTerm.Builder> byolPricingTerm) {
        ByolPricingTerm.Builder builder = ByolPricingTerm.builder();
        byolPricingTerm.accept(builder);
        return fromByolPricingTerm(builder.build());
    }

    /**
     * Create an instance of this class with {@link #configurableUpfrontPricingTerm()} initialized to the given value.
     *
     * <p>
     * Defines a prepaid payment model that allows buyers to configure the entitlements they want to purchase and the
     * duration.
     * </p>
     * 
     * @param configurableUpfrontPricingTerm
     *        Defines a prepaid payment model that allows buyers to configure the entitlements they want to purchase and
     *        the duration.
     */
    public static AcceptedTerm fromConfigurableUpfrontPricingTerm(ConfigurableUpfrontPricingTerm configurableUpfrontPricingTerm) {
        return builder().configurableUpfrontPricingTerm(configurableUpfrontPricingTerm).build();
    }

    /**
     * Create an instance of this class with {@link #configurableUpfrontPricingTerm()} initialized to the given value.
     *
     * <p>
     * Defines a prepaid payment model that allows buyers to configure the entitlements they want to purchase and the
     * duration.
     * </p>
     * 
     * @param configurableUpfrontPricingTerm
     *        Defines a prepaid payment model that allows buyers to configure the entitlements they want to purchase and
     *        the duration.
     */
    public static AcceptedTerm fromConfigurableUpfrontPricingTerm(
            Consumer<ConfigurableUpfrontPricingTerm.Builder> configurableUpfrontPricingTerm) {
        ConfigurableUpfrontPricingTerm.Builder builder = ConfigurableUpfrontPricingTerm.builder();
        configurableUpfrontPricingTerm.accept(builder);
        return fromConfigurableUpfrontPricingTerm(builder.build());
    }

    /**
     * Create an instance of this class with {@link #fixedUpfrontPricingTerm()} initialized to the given value.
     *
     * <p>
     * Defines a pre-paid pricing model where the customers are charged a fixed upfront amount.
     * </p>
     * 
     * @param fixedUpfrontPricingTerm
     *        Defines a pre-paid pricing model where the customers are charged a fixed upfront amount.
     */
    public static AcceptedTerm fromFixedUpfrontPricingTerm(FixedUpfrontPricingTerm fixedUpfrontPricingTerm) {
        return builder().fixedUpfrontPricingTerm(fixedUpfrontPricingTerm).build();
    }

    /**
     * Create an instance of this class with {@link #fixedUpfrontPricingTerm()} initialized to the given value.
     *
     * <p>
     * Defines a pre-paid pricing model where the customers are charged a fixed upfront amount.
     * </p>
     * 
     * @param fixedUpfrontPricingTerm
     *        Defines a pre-paid pricing model where the customers are charged a fixed upfront amount.
     */
    public static AcceptedTerm fromFixedUpfrontPricingTerm(Consumer<FixedUpfrontPricingTerm.Builder> fixedUpfrontPricingTerm) {
        FixedUpfrontPricingTerm.Builder builder = FixedUpfrontPricingTerm.builder();
        fixedUpfrontPricingTerm.accept(builder);
        return fromFixedUpfrontPricingTerm(builder.build());
    }

    /**
     * Create an instance of this class with {@link #freeTrialPricingTerm()} initialized to the given value.
     *
     * <p>
     * Defines a short-term free pricing model where the buyers aren’t charged anything within a specified limit.
     * </p>
     * 
     * @param freeTrialPricingTerm
     *        Defines a short-term free pricing model where the buyers aren’t charged anything within a specified limit.
     */
    public static AcceptedTerm fromFreeTrialPricingTerm(FreeTrialPricingTerm freeTrialPricingTerm) {
        return builder().freeTrialPricingTerm(freeTrialPricingTerm).build();
    }

    /**
     * Create an instance of this class with {@link #freeTrialPricingTerm()} initialized to the given value.
     *
     * <p>
     * Defines a short-term free pricing model where the buyers aren’t charged anything within a specified limit.
     * </p>
     * 
     * @param freeTrialPricingTerm
     *        Defines a short-term free pricing model where the buyers aren’t charged anything within a specified limit.
     */
    public static AcceptedTerm fromFreeTrialPricingTerm(Consumer<FreeTrialPricingTerm.Builder> freeTrialPricingTerm) {
        FreeTrialPricingTerm.Builder builder = FreeTrialPricingTerm.builder();
        freeTrialPricingTerm.accept(builder);
        return fromFreeTrialPricingTerm(builder.build());
    }

    /**
     * Create an instance of this class with {@link #legalTerm()} initialized to the given value.
     *
     * <p>
     * Defines the list of text agreements proposed to the acceptors. An example is the end user license agreement
     * (EULA).
     * </p>
     * 
     * @param legalTerm
     *        Defines the list of text agreements proposed to the acceptors. An example is the end user license
     *        agreement (EULA).
     */
    public static AcceptedTerm fromLegalTerm(LegalTerm legalTerm) {
        return builder().legalTerm(legalTerm).build();
    }

    /**
     * Create an instance of this class with {@link #legalTerm()} initialized to the given value.
     *
     * <p>
     * Defines the list of text agreements proposed to the acceptors. An example is the end user license agreement
     * (EULA).
     * </p>
     * 
     * @param legalTerm
     *        Defines the list of text agreements proposed to the acceptors. An example is the end user license
     *        agreement (EULA).
     */
    public static AcceptedTerm fromLegalTerm(Consumer<LegalTerm.Builder> legalTerm) {
        LegalTerm.Builder builder = LegalTerm.builder();
        legalTerm.accept(builder);
        return fromLegalTerm(builder.build());
    }

    /**
     * Create an instance of this class with {@link #paymentScheduleTerm()} initialized to the given value.
     *
     * <p>
     * Defines an installment-based pricing model where customers are charged a fixed price on different dates during
     * the agreement validity period. This is used most commonly for flexible payment schedule pricing.
     * </p>
     * 
     * @param paymentScheduleTerm
     *        Defines an installment-based pricing model where customers are charged a fixed price on different dates
     *        during the agreement validity period. This is used most commonly for flexible payment schedule pricing.
     */
    public static AcceptedTerm fromPaymentScheduleTerm(PaymentScheduleTerm paymentScheduleTerm) {
        return builder().paymentScheduleTerm(paymentScheduleTerm).build();
    }

    /**
     * Create an instance of this class with {@link #paymentScheduleTerm()} initialized to the given value.
     *
     * <p>
     * Defines an installment-based pricing model where customers are charged a fixed price on different dates during
     * the agreement validity period. This is used most commonly for flexible payment schedule pricing.
     * </p>
     * 
     * @param paymentScheduleTerm
     *        Defines an installment-based pricing model where customers are charged a fixed price on different dates
     *        during the agreement validity period. This is used most commonly for flexible payment schedule pricing.
     */
    public static AcceptedTerm fromPaymentScheduleTerm(Consumer<PaymentScheduleTerm.Builder> paymentScheduleTerm) {
        PaymentScheduleTerm.Builder builder = PaymentScheduleTerm.builder();
        paymentScheduleTerm.accept(builder);
        return fromPaymentScheduleTerm(builder.build());
    }

    /**
     * Create an instance of this class with {@link #recurringPaymentTerm()} initialized to the given value.
     *
     * <p>
     * Defines a pricing model where customers are charged a fixed recurring price at the end of each billing period.
     * </p>
     * 
     * @param recurringPaymentTerm
     *        Defines a pricing model where customers are charged a fixed recurring price at the end of each billing
     *        period.
     */
    public static AcceptedTerm fromRecurringPaymentTerm(RecurringPaymentTerm recurringPaymentTerm) {
        return builder().recurringPaymentTerm(recurringPaymentTerm).build();
    }

    /**
     * Create an instance of this class with {@link #recurringPaymentTerm()} initialized to the given value.
     *
     * <p>
     * Defines a pricing model where customers are charged a fixed recurring price at the end of each billing period.
     * </p>
     * 
     * @param recurringPaymentTerm
     *        Defines a pricing model where customers are charged a fixed recurring price at the end of each billing
     *        period.
     */
    public static AcceptedTerm fromRecurringPaymentTerm(Consumer<RecurringPaymentTerm.Builder> recurringPaymentTerm) {
        RecurringPaymentTerm.Builder builder = RecurringPaymentTerm.builder();
        recurringPaymentTerm.accept(builder);
        return fromRecurringPaymentTerm(builder.build());
    }

    /**
     * Create an instance of this class with {@link #renewalTerm()} initialized to the given value.
     *
     * <p>
     * Defines that on graceful expiration of the agreement (when the agreement ends on its pre-defined end date), a new
     * agreement will be created using the accepted terms on the existing agreement. In other words, the agreement will
     * be renewed. Presence of <code>RenewalTerm</code> in the offer document means that auto-renewal is allowed. Buyers
     * will have the option to accept or decline auto-renewal at the offer acceptance/agreement creation. Buyers can
     * also change this flag from <code>True</code> to <code>False</code> or <code>False</code> to <code>True</code> at
     * anytime during the agreement's lifecycle.
     * </p>
     * 
     * @param renewalTerm
     *        Defines that on graceful expiration of the agreement (when the agreement ends on its pre-defined end
     *        date), a new agreement will be created using the accepted terms on the existing agreement. In other words,
     *        the agreement will be renewed. Presence of <code>RenewalTerm</code> in the offer document means that
     *        auto-renewal is allowed. Buyers will have the option to accept or decline auto-renewal at the offer
     *        acceptance/agreement creation. Buyers can also change this flag from <code>True</code> to
     *        <code>False</code> or <code>False</code> to <code>True</code> at anytime during the agreement's lifecycle.
     */
    public static AcceptedTerm fromRenewalTerm(RenewalTerm renewalTerm) {
        return builder().renewalTerm(renewalTerm).build();
    }

    /**
     * Create an instance of this class with {@link #renewalTerm()} initialized to the given value.
     *
     * <p>
     * Defines that on graceful expiration of the agreement (when the agreement ends on its pre-defined end date), a new
     * agreement will be created using the accepted terms on the existing agreement. In other words, the agreement will
     * be renewed. Presence of <code>RenewalTerm</code> in the offer document means that auto-renewal is allowed. Buyers
     * will have the option to accept or decline auto-renewal at the offer acceptance/agreement creation. Buyers can
     * also change this flag from <code>True</code> to <code>False</code> or <code>False</code> to <code>True</code> at
     * anytime during the agreement's lifecycle.
     * </p>
     * 
     * @param renewalTerm
     *        Defines that on graceful expiration of the agreement (when the agreement ends on its pre-defined end
     *        date), a new agreement will be created using the accepted terms on the existing agreement. In other words,
     *        the agreement will be renewed. Presence of <code>RenewalTerm</code> in the offer document means that
     *        auto-renewal is allowed. Buyers will have the option to accept or decline auto-renewal at the offer
     *        acceptance/agreement creation. Buyers can also change this flag from <code>True</code> to
     *        <code>False</code> or <code>False</code> to <code>True</code> at anytime during the agreement's lifecycle.
     */
    public static AcceptedTerm fromRenewalTerm(Consumer<RenewalTerm.Builder> renewalTerm) {
        RenewalTerm.Builder builder = RenewalTerm.builder();
        renewalTerm.accept(builder);
        return fromRenewalTerm(builder.build());
    }

    /**
     * Create an instance of this class with {@link #supportTerm()} initialized to the given value.
     *
     * <p>
     * Defines the customer support available for the acceptors when they purchase the software.
     * </p>
     * 
     * @param supportTerm
     *        Defines the customer support available for the acceptors when they purchase the software.
     */
    public static AcceptedTerm fromSupportTerm(SupportTerm supportTerm) {
        return builder().supportTerm(supportTerm).build();
    }

    /**
     * Create an instance of this class with {@link #supportTerm()} initialized to the given value.
     *
     * <p>
     * Defines the customer support available for the acceptors when they purchase the software.
     * </p>
     * 
     * @param supportTerm
     *        Defines the customer support available for the acceptors when they purchase the software.
     */
    public static AcceptedTerm fromSupportTerm(Consumer<SupportTerm.Builder> supportTerm) {
        SupportTerm.Builder builder = SupportTerm.builder();
        supportTerm.accept(builder);
        return fromSupportTerm(builder.build());
    }

    /**
     * Create an instance of this class with {@link #usageBasedPricingTerm()} initialized to the given value.
     *
     * <p>
     * Defines a usage-based pricing model (typically, pay-as-you-go pricing), where the customers are charged based on
     * product usage.
     * </p>
     * 
     * @param usageBasedPricingTerm
     *        Defines a usage-based pricing model (typically, pay-as-you-go pricing), where the customers are charged
     *        based on product usage.
     */
    public static AcceptedTerm fromUsageBasedPricingTerm(UsageBasedPricingTerm usageBasedPricingTerm) {
        return builder().usageBasedPricingTerm(usageBasedPricingTerm).build();
    }

    /**
     * Create an instance of this class with {@link #usageBasedPricingTerm()} initialized to the given value.
     *
     * <p>
     * Defines a usage-based pricing model (typically, pay-as-you-go pricing), where the customers are charged based on
     * product usage.
     * </p>
     * 
     * @param usageBasedPricingTerm
     *        Defines a usage-based pricing model (typically, pay-as-you-go pricing), where the customers are charged
     *        based on product usage.
     */
    public static AcceptedTerm fromUsageBasedPricingTerm(Consumer<UsageBasedPricingTerm.Builder> usageBasedPricingTerm) {
        UsageBasedPricingTerm.Builder builder = UsageBasedPricingTerm.builder();
        usageBasedPricingTerm.accept(builder);
        return fromUsageBasedPricingTerm(builder.build());
    }

    /**
     * Create an instance of this class with {@link #validityTerm()} initialized to the given value.
     *
     * <p>
     * Defines the conditions that will keep an agreement created from this offer valid.
     * </p>
     * 
     * @param validityTerm
     *        Defines the conditions that will keep an agreement created from this offer valid.
     */
    public static AcceptedTerm fromValidityTerm(ValidityTerm validityTerm) {
        return builder().validityTerm(validityTerm).build();
    }

    /**
     * Create an instance of this class with {@link #validityTerm()} initialized to the given value.
     *
     * <p>
     * Defines the conditions that will keep an agreement created from this offer valid.
     * </p>
     * 
     * @param validityTerm
     *        Defines the conditions that will keep an agreement created from this offer valid.
     */
    public static AcceptedTerm fromValidityTerm(Consumer<ValidityTerm.Builder> validityTerm) {
        ValidityTerm.Builder builder = ValidityTerm.builder();
        validityTerm.accept(builder);
        return fromValidityTerm(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("byolPricingTerm", BYOL_PRICING_TERM_FIELD);
        map.put("configurableUpfrontPricingTerm", CONFIGURABLE_UPFRONT_PRICING_TERM_FIELD);
        map.put("fixedUpfrontPricingTerm", FIXED_UPFRONT_PRICING_TERM_FIELD);
        map.put("freeTrialPricingTerm", FREE_TRIAL_PRICING_TERM_FIELD);
        map.put("legalTerm", LEGAL_TERM_FIELD);
        map.put("paymentScheduleTerm", PAYMENT_SCHEDULE_TERM_FIELD);
        map.put("recurringPaymentTerm", RECURRING_PAYMENT_TERM_FIELD);
        map.put("renewalTerm", RENEWAL_TERM_FIELD);
        map.put("supportTerm", SUPPORT_TERM_FIELD);
        map.put("usageBasedPricingTerm", USAGE_BASED_PRICING_TERM_FIELD);
        map.put("validityTerm", VALIDITY_TERM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AcceptedTerm, T> g) {
        return obj -> g.apply((AcceptedTerm) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AcceptedTerm> {
        /**
         * <p>
         * Enables you and your customers to move your existing agreements to AWS Marketplace. The customer won't be
         * charged for product usage in AWS Marketplace because they already paid for the product outside of AWS
         * Marketplace.
         * </p>
         * 
         * @param byolPricingTerm
         *        Enables you and your customers to move your existing agreements to AWS Marketplace. The customer won't
         *        be charged for product usage in AWS Marketplace because they already paid for the product outside of
         *        AWS Marketplace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byolPricingTerm(ByolPricingTerm byolPricingTerm);

        /**
         * <p>
         * Enables you and your customers to move your existing agreements to AWS Marketplace. The customer won't be
         * charged for product usage in AWS Marketplace because they already paid for the product outside of AWS
         * Marketplace.
         * </p>
         * This is a convenience method that creates an instance of the {@link ByolPricingTerm.Builder} avoiding the
         * need to create one manually via {@link ByolPricingTerm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ByolPricingTerm.Builder#build()} is called immediately and its
         * result is passed to {@link #byolPricingTerm(ByolPricingTerm)}.
         * 
         * @param byolPricingTerm
         *        a consumer that will call methods on {@link ByolPricingTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #byolPricingTerm(ByolPricingTerm)
         */
        default Builder byolPricingTerm(Consumer<ByolPricingTerm.Builder> byolPricingTerm) {
            return byolPricingTerm(ByolPricingTerm.builder().applyMutation(byolPricingTerm).build());
        }

        /**
         * <p>
         * Defines a prepaid payment model that allows buyers to configure the entitlements they want to purchase and
         * the duration.
         * </p>
         * 
         * @param configurableUpfrontPricingTerm
         *        Defines a prepaid payment model that allows buyers to configure the entitlements they want to purchase
         *        and the duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurableUpfrontPricingTerm(ConfigurableUpfrontPricingTerm configurableUpfrontPricingTerm);

        /**
         * <p>
         * Defines a prepaid payment model that allows buyers to configure the entitlements they want to purchase and
         * the duration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConfigurableUpfrontPricingTerm.Builder}
         * avoiding the need to create one manually via {@link ConfigurableUpfrontPricingTerm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfigurableUpfrontPricingTerm.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #configurableUpfrontPricingTerm(ConfigurableUpfrontPricingTerm)}.
         * 
         * @param configurableUpfrontPricingTerm
         *        a consumer that will call methods on {@link ConfigurableUpfrontPricingTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurableUpfrontPricingTerm(ConfigurableUpfrontPricingTerm)
         */
        default Builder configurableUpfrontPricingTerm(
                Consumer<ConfigurableUpfrontPricingTerm.Builder> configurableUpfrontPricingTerm) {
            return configurableUpfrontPricingTerm(ConfigurableUpfrontPricingTerm.builder()
                    .applyMutation(configurableUpfrontPricingTerm).build());
        }

        /**
         * <p>
         * Defines a pre-paid pricing model where the customers are charged a fixed upfront amount.
         * </p>
         * 
         * @param fixedUpfrontPricingTerm
         *        Defines a pre-paid pricing model where the customers are charged a fixed upfront amount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedUpfrontPricingTerm(FixedUpfrontPricingTerm fixedUpfrontPricingTerm);

        /**
         * <p>
         * Defines a pre-paid pricing model where the customers are charged a fixed upfront amount.
         * </p>
         * This is a convenience method that creates an instance of the {@link FixedUpfrontPricingTerm.Builder} avoiding
         * the need to create one manually via {@link FixedUpfrontPricingTerm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FixedUpfrontPricingTerm.Builder#build()} is called immediately
         * and its result is passed to {@link #fixedUpfrontPricingTerm(FixedUpfrontPricingTerm)}.
         * 
         * @param fixedUpfrontPricingTerm
         *        a consumer that will call methods on {@link FixedUpfrontPricingTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fixedUpfrontPricingTerm(FixedUpfrontPricingTerm)
         */
        default Builder fixedUpfrontPricingTerm(Consumer<FixedUpfrontPricingTerm.Builder> fixedUpfrontPricingTerm) {
            return fixedUpfrontPricingTerm(FixedUpfrontPricingTerm.builder().applyMutation(fixedUpfrontPricingTerm).build());
        }

        /**
         * <p>
         * Defines a short-term free pricing model where the buyers aren’t charged anything within a specified limit.
         * </p>
         * 
         * @param freeTrialPricingTerm
         *        Defines a short-term free pricing model where the buyers aren’t charged anything within a specified
         *        limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder freeTrialPricingTerm(FreeTrialPricingTerm freeTrialPricingTerm);

        /**
         * <p>
         * Defines a short-term free pricing model where the buyers aren’t charged anything within a specified limit.
         * </p>
         * This is a convenience method that creates an instance of the {@link FreeTrialPricingTerm.Builder} avoiding
         * the need to create one manually via {@link FreeTrialPricingTerm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FreeTrialPricingTerm.Builder#build()} is called immediately and
         * its result is passed to {@link #freeTrialPricingTerm(FreeTrialPricingTerm)}.
         * 
         * @param freeTrialPricingTerm
         *        a consumer that will call methods on {@link FreeTrialPricingTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #freeTrialPricingTerm(FreeTrialPricingTerm)
         */
        default Builder freeTrialPricingTerm(Consumer<FreeTrialPricingTerm.Builder> freeTrialPricingTerm) {
            return freeTrialPricingTerm(FreeTrialPricingTerm.builder().applyMutation(freeTrialPricingTerm).build());
        }

        /**
         * <p>
         * Defines the list of text agreements proposed to the acceptors. An example is the end user license agreement
         * (EULA).
         * </p>
         * 
         * @param legalTerm
         *        Defines the list of text agreements proposed to the acceptors. An example is the end user license
         *        agreement (EULA).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legalTerm(LegalTerm legalTerm);

        /**
         * <p>
         * Defines the list of text agreements proposed to the acceptors. An example is the end user license agreement
         * (EULA).
         * </p>
         * This is a convenience method that creates an instance of the {@link LegalTerm.Builder} avoiding the need to
         * create one manually via {@link LegalTerm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LegalTerm.Builder#build()} is called immediately and its result
         * is passed to {@link #legalTerm(LegalTerm)}.
         * 
         * @param legalTerm
         *        a consumer that will call methods on {@link LegalTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #legalTerm(LegalTerm)
         */
        default Builder legalTerm(Consumer<LegalTerm.Builder> legalTerm) {
            return legalTerm(LegalTerm.builder().applyMutation(legalTerm).build());
        }

        /**
         * <p>
         * Defines an installment-based pricing model where customers are charged a fixed price on different dates
         * during the agreement validity period. This is used most commonly for flexible payment schedule pricing.
         * </p>
         * 
         * @param paymentScheduleTerm
         *        Defines an installment-based pricing model where customers are charged a fixed price on different
         *        dates during the agreement validity period. This is used most commonly for flexible payment schedule
         *        pricing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentScheduleTerm(PaymentScheduleTerm paymentScheduleTerm);

        /**
         * <p>
         * Defines an installment-based pricing model where customers are charged a fixed price on different dates
         * during the agreement validity period. This is used most commonly for flexible payment schedule pricing.
         * </p>
         * This is a convenience method that creates an instance of the {@link PaymentScheduleTerm.Builder} avoiding the
         * need to create one manually via {@link PaymentScheduleTerm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PaymentScheduleTerm.Builder#build()} is called immediately and
         * its result is passed to {@link #paymentScheduleTerm(PaymentScheduleTerm)}.
         * 
         * @param paymentScheduleTerm
         *        a consumer that will call methods on {@link PaymentScheduleTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #paymentScheduleTerm(PaymentScheduleTerm)
         */
        default Builder paymentScheduleTerm(Consumer<PaymentScheduleTerm.Builder> paymentScheduleTerm) {
            return paymentScheduleTerm(PaymentScheduleTerm.builder().applyMutation(paymentScheduleTerm).build());
        }

        /**
         * <p>
         * Defines a pricing model where customers are charged a fixed recurring price at the end of each billing
         * period.
         * </p>
         * 
         * @param recurringPaymentTerm
         *        Defines a pricing model where customers are charged a fixed recurring price at the end of each billing
         *        period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringPaymentTerm(RecurringPaymentTerm recurringPaymentTerm);

        /**
         * <p>
         * Defines a pricing model where customers are charged a fixed recurring price at the end of each billing
         * period.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecurringPaymentTerm.Builder} avoiding
         * the need to create one manually via {@link RecurringPaymentTerm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecurringPaymentTerm.Builder#build()} is called immediately and
         * its result is passed to {@link #recurringPaymentTerm(RecurringPaymentTerm)}.
         * 
         * @param recurringPaymentTerm
         *        a consumer that will call methods on {@link RecurringPaymentTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recurringPaymentTerm(RecurringPaymentTerm)
         */
        default Builder recurringPaymentTerm(Consumer<RecurringPaymentTerm.Builder> recurringPaymentTerm) {
            return recurringPaymentTerm(RecurringPaymentTerm.builder().applyMutation(recurringPaymentTerm).build());
        }

        /**
         * <p>
         * Defines that on graceful expiration of the agreement (when the agreement ends on its pre-defined end date), a
         * new agreement will be created using the accepted terms on the existing agreement. In other words, the
         * agreement will be renewed. Presence of <code>RenewalTerm</code> in the offer document means that auto-renewal
         * is allowed. Buyers will have the option to accept or decline auto-renewal at the offer acceptance/agreement
         * creation. Buyers can also change this flag from <code>True</code> to <code>False</code> or <code>False</code>
         * to <code>True</code> at anytime during the agreement's lifecycle.
         * </p>
         * 
         * @param renewalTerm
         *        Defines that on graceful expiration of the agreement (when the agreement ends on its pre-defined end
         *        date), a new agreement will be created using the accepted terms on the existing agreement. In other
         *        words, the agreement will be renewed. Presence of <code>RenewalTerm</code> in the offer document means
         *        that auto-renewal is allowed. Buyers will have the option to accept or decline auto-renewal at the
         *        offer acceptance/agreement creation. Buyers can also change this flag from <code>True</code> to
         *        <code>False</code> or <code>False</code> to <code>True</code> at anytime during the agreement's
         *        lifecycle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renewalTerm(RenewalTerm renewalTerm);

        /**
         * <p>
         * Defines that on graceful expiration of the agreement (when the agreement ends on its pre-defined end date), a
         * new agreement will be created using the accepted terms on the existing agreement. In other words, the
         * agreement will be renewed. Presence of <code>RenewalTerm</code> in the offer document means that auto-renewal
         * is allowed. Buyers will have the option to accept or decline auto-renewal at the offer acceptance/agreement
         * creation. Buyers can also change this flag from <code>True</code> to <code>False</code> or <code>False</code>
         * to <code>True</code> at anytime during the agreement's lifecycle.
         * </p>
         * This is a convenience method that creates an instance of the {@link RenewalTerm.Builder} avoiding the need to
         * create one manually via {@link RenewalTerm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RenewalTerm.Builder#build()} is called immediately and its result
         * is passed to {@link #renewalTerm(RenewalTerm)}.
         * 
         * @param renewalTerm
         *        a consumer that will call methods on {@link RenewalTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #renewalTerm(RenewalTerm)
         */
        default Builder renewalTerm(Consumer<RenewalTerm.Builder> renewalTerm) {
            return renewalTerm(RenewalTerm.builder().applyMutation(renewalTerm).build());
        }

        /**
         * <p>
         * Defines the customer support available for the acceptors when they purchase the software.
         * </p>
         * 
         * @param supportTerm
         *        Defines the customer support available for the acceptors when they purchase the software.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportTerm(SupportTerm supportTerm);

        /**
         * <p>
         * Defines the customer support available for the acceptors when they purchase the software.
         * </p>
         * This is a convenience method that creates an instance of the {@link SupportTerm.Builder} avoiding the need to
         * create one manually via {@link SupportTerm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SupportTerm.Builder#build()} is called immediately and its result
         * is passed to {@link #supportTerm(SupportTerm)}.
         * 
         * @param supportTerm
         *        a consumer that will call methods on {@link SupportTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supportTerm(SupportTerm)
         */
        default Builder supportTerm(Consumer<SupportTerm.Builder> supportTerm) {
            return supportTerm(SupportTerm.builder().applyMutation(supportTerm).build());
        }

        /**
         * <p>
         * Defines a usage-based pricing model (typically, pay-as-you-go pricing), where the customers are charged based
         * on product usage.
         * </p>
         * 
         * @param usageBasedPricingTerm
         *        Defines a usage-based pricing model (typically, pay-as-you-go pricing), where the customers are
         *        charged based on product usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageBasedPricingTerm(UsageBasedPricingTerm usageBasedPricingTerm);

        /**
         * <p>
         * Defines a usage-based pricing model (typically, pay-as-you-go pricing), where the customers are charged based
         * on product usage.
         * </p>
         * This is a convenience method that creates an instance of the {@link UsageBasedPricingTerm.Builder} avoiding
         * the need to create one manually via {@link UsageBasedPricingTerm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UsageBasedPricingTerm.Builder#build()} is called immediately and
         * its result is passed to {@link #usageBasedPricingTerm(UsageBasedPricingTerm)}.
         * 
         * @param usageBasedPricingTerm
         *        a consumer that will call methods on {@link UsageBasedPricingTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usageBasedPricingTerm(UsageBasedPricingTerm)
         */
        default Builder usageBasedPricingTerm(Consumer<UsageBasedPricingTerm.Builder> usageBasedPricingTerm) {
            return usageBasedPricingTerm(UsageBasedPricingTerm.builder().applyMutation(usageBasedPricingTerm).build());
        }

        /**
         * <p>
         * Defines the conditions that will keep an agreement created from this offer valid.
         * </p>
         * 
         * @param validityTerm
         *        Defines the conditions that will keep an agreement created from this offer valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validityTerm(ValidityTerm validityTerm);

        /**
         * <p>
         * Defines the conditions that will keep an agreement created from this offer valid.
         * </p>
         * This is a convenience method that creates an instance of the {@link ValidityTerm.Builder} avoiding the need
         * to create one manually via {@link ValidityTerm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ValidityTerm.Builder#build()} is called immediately and its
         * result is passed to {@link #validityTerm(ValidityTerm)}.
         * 
         * @param validityTerm
         *        a consumer that will call methods on {@link ValidityTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validityTerm(ValidityTerm)
         */
        default Builder validityTerm(Consumer<ValidityTerm.Builder> validityTerm) {
            return validityTerm(ValidityTerm.builder().applyMutation(validityTerm).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ByolPricingTerm byolPricingTerm;

        private ConfigurableUpfrontPricingTerm configurableUpfrontPricingTerm;

        private FixedUpfrontPricingTerm fixedUpfrontPricingTerm;

        private FreeTrialPricingTerm freeTrialPricingTerm;

        private LegalTerm legalTerm;

        private PaymentScheduleTerm paymentScheduleTerm;

        private RecurringPaymentTerm recurringPaymentTerm;

        private RenewalTerm renewalTerm;

        private SupportTerm supportTerm;

        private UsageBasedPricingTerm usageBasedPricingTerm;

        private ValidityTerm validityTerm;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptedTerm model) {
            byolPricingTerm(model.byolPricingTerm);
            configurableUpfrontPricingTerm(model.configurableUpfrontPricingTerm);
            fixedUpfrontPricingTerm(model.fixedUpfrontPricingTerm);
            freeTrialPricingTerm(model.freeTrialPricingTerm);
            legalTerm(model.legalTerm);
            paymentScheduleTerm(model.paymentScheduleTerm);
            recurringPaymentTerm(model.recurringPaymentTerm);
            renewalTerm(model.renewalTerm);
            supportTerm(model.supportTerm);
            usageBasedPricingTerm(model.usageBasedPricingTerm);
            validityTerm(model.validityTerm);
        }

        public final ByolPricingTerm.Builder getByolPricingTerm() {
            return byolPricingTerm != null ? byolPricingTerm.toBuilder() : null;
        }

        public final void setByolPricingTerm(ByolPricingTerm.BuilderImpl byolPricingTerm) {
            Object oldValue = this.byolPricingTerm;
            this.byolPricingTerm = byolPricingTerm != null ? byolPricingTerm.build() : null;
            handleUnionValueChange(Type.BYOL_PRICING_TERM, oldValue, this.byolPricingTerm);
        }

        @Override
        public final Builder byolPricingTerm(ByolPricingTerm byolPricingTerm) {
            Object oldValue = this.byolPricingTerm;
            this.byolPricingTerm = byolPricingTerm;
            handleUnionValueChange(Type.BYOL_PRICING_TERM, oldValue, this.byolPricingTerm);
            return this;
        }

        public final ConfigurableUpfrontPricingTerm.Builder getConfigurableUpfrontPricingTerm() {
            return configurableUpfrontPricingTerm != null ? configurableUpfrontPricingTerm.toBuilder() : null;
        }

        public final void setConfigurableUpfrontPricingTerm(
                ConfigurableUpfrontPricingTerm.BuilderImpl configurableUpfrontPricingTerm) {
            Object oldValue = this.configurableUpfrontPricingTerm;
            this.configurableUpfrontPricingTerm = configurableUpfrontPricingTerm != null ? configurableUpfrontPricingTerm.build()
                    : null;
            handleUnionValueChange(Type.CONFIGURABLE_UPFRONT_PRICING_TERM, oldValue, this.configurableUpfrontPricingTerm);
        }

        @Override
        public final Builder configurableUpfrontPricingTerm(ConfigurableUpfrontPricingTerm configurableUpfrontPricingTerm) {
            Object oldValue = this.configurableUpfrontPricingTerm;
            this.configurableUpfrontPricingTerm = configurableUpfrontPricingTerm;
            handleUnionValueChange(Type.CONFIGURABLE_UPFRONT_PRICING_TERM, oldValue, this.configurableUpfrontPricingTerm);
            return this;
        }

        public final FixedUpfrontPricingTerm.Builder getFixedUpfrontPricingTerm() {
            return fixedUpfrontPricingTerm != null ? fixedUpfrontPricingTerm.toBuilder() : null;
        }

        public final void setFixedUpfrontPricingTerm(FixedUpfrontPricingTerm.BuilderImpl fixedUpfrontPricingTerm) {
            Object oldValue = this.fixedUpfrontPricingTerm;
            this.fixedUpfrontPricingTerm = fixedUpfrontPricingTerm != null ? fixedUpfrontPricingTerm.build() : null;
            handleUnionValueChange(Type.FIXED_UPFRONT_PRICING_TERM, oldValue, this.fixedUpfrontPricingTerm);
        }

        @Override
        public final Builder fixedUpfrontPricingTerm(FixedUpfrontPricingTerm fixedUpfrontPricingTerm) {
            Object oldValue = this.fixedUpfrontPricingTerm;
            this.fixedUpfrontPricingTerm = fixedUpfrontPricingTerm;
            handleUnionValueChange(Type.FIXED_UPFRONT_PRICING_TERM, oldValue, this.fixedUpfrontPricingTerm);
            return this;
        }

        public final FreeTrialPricingTerm.Builder getFreeTrialPricingTerm() {
            return freeTrialPricingTerm != null ? freeTrialPricingTerm.toBuilder() : null;
        }

        public final void setFreeTrialPricingTerm(FreeTrialPricingTerm.BuilderImpl freeTrialPricingTerm) {
            Object oldValue = this.freeTrialPricingTerm;
            this.freeTrialPricingTerm = freeTrialPricingTerm != null ? freeTrialPricingTerm.build() : null;
            handleUnionValueChange(Type.FREE_TRIAL_PRICING_TERM, oldValue, this.freeTrialPricingTerm);
        }

        @Override
        public final Builder freeTrialPricingTerm(FreeTrialPricingTerm freeTrialPricingTerm) {
            Object oldValue = this.freeTrialPricingTerm;
            this.freeTrialPricingTerm = freeTrialPricingTerm;
            handleUnionValueChange(Type.FREE_TRIAL_PRICING_TERM, oldValue, this.freeTrialPricingTerm);
            return this;
        }

        public final LegalTerm.Builder getLegalTerm() {
            return legalTerm != null ? legalTerm.toBuilder() : null;
        }

        public final void setLegalTerm(LegalTerm.BuilderImpl legalTerm) {
            Object oldValue = this.legalTerm;
            this.legalTerm = legalTerm != null ? legalTerm.build() : null;
            handleUnionValueChange(Type.LEGAL_TERM, oldValue, this.legalTerm);
        }

        @Override
        public final Builder legalTerm(LegalTerm legalTerm) {
            Object oldValue = this.legalTerm;
            this.legalTerm = legalTerm;
            handleUnionValueChange(Type.LEGAL_TERM, oldValue, this.legalTerm);
            return this;
        }

        public final PaymentScheduleTerm.Builder getPaymentScheduleTerm() {
            return paymentScheduleTerm != null ? paymentScheduleTerm.toBuilder() : null;
        }

        public final void setPaymentScheduleTerm(PaymentScheduleTerm.BuilderImpl paymentScheduleTerm) {
            Object oldValue = this.paymentScheduleTerm;
            this.paymentScheduleTerm = paymentScheduleTerm != null ? paymentScheduleTerm.build() : null;
            handleUnionValueChange(Type.PAYMENT_SCHEDULE_TERM, oldValue, this.paymentScheduleTerm);
        }

        @Override
        public final Builder paymentScheduleTerm(PaymentScheduleTerm paymentScheduleTerm) {
            Object oldValue = this.paymentScheduleTerm;
            this.paymentScheduleTerm = paymentScheduleTerm;
            handleUnionValueChange(Type.PAYMENT_SCHEDULE_TERM, oldValue, this.paymentScheduleTerm);
            return this;
        }

        public final RecurringPaymentTerm.Builder getRecurringPaymentTerm() {
            return recurringPaymentTerm != null ? recurringPaymentTerm.toBuilder() : null;
        }

        public final void setRecurringPaymentTerm(RecurringPaymentTerm.BuilderImpl recurringPaymentTerm) {
            Object oldValue = this.recurringPaymentTerm;
            this.recurringPaymentTerm = recurringPaymentTerm != null ? recurringPaymentTerm.build() : null;
            handleUnionValueChange(Type.RECURRING_PAYMENT_TERM, oldValue, this.recurringPaymentTerm);
        }

        @Override
        public final Builder recurringPaymentTerm(RecurringPaymentTerm recurringPaymentTerm) {
            Object oldValue = this.recurringPaymentTerm;
            this.recurringPaymentTerm = recurringPaymentTerm;
            handleUnionValueChange(Type.RECURRING_PAYMENT_TERM, oldValue, this.recurringPaymentTerm);
            return this;
        }

        public final RenewalTerm.Builder getRenewalTerm() {
            return renewalTerm != null ? renewalTerm.toBuilder() : null;
        }

        public final void setRenewalTerm(RenewalTerm.BuilderImpl renewalTerm) {
            Object oldValue = this.renewalTerm;
            this.renewalTerm = renewalTerm != null ? renewalTerm.build() : null;
            handleUnionValueChange(Type.RENEWAL_TERM, oldValue, this.renewalTerm);
        }

        @Override
        public final Builder renewalTerm(RenewalTerm renewalTerm) {
            Object oldValue = this.renewalTerm;
            this.renewalTerm = renewalTerm;
            handleUnionValueChange(Type.RENEWAL_TERM, oldValue, this.renewalTerm);
            return this;
        }

        public final SupportTerm.Builder getSupportTerm() {
            return supportTerm != null ? supportTerm.toBuilder() : null;
        }

        public final void setSupportTerm(SupportTerm.BuilderImpl supportTerm) {
            Object oldValue = this.supportTerm;
            this.supportTerm = supportTerm != null ? supportTerm.build() : null;
            handleUnionValueChange(Type.SUPPORT_TERM, oldValue, this.supportTerm);
        }

        @Override
        public final Builder supportTerm(SupportTerm supportTerm) {
            Object oldValue = this.supportTerm;
            this.supportTerm = supportTerm;
            handleUnionValueChange(Type.SUPPORT_TERM, oldValue, this.supportTerm);
            return this;
        }

        public final UsageBasedPricingTerm.Builder getUsageBasedPricingTerm() {
            return usageBasedPricingTerm != null ? usageBasedPricingTerm.toBuilder() : null;
        }

        public final void setUsageBasedPricingTerm(UsageBasedPricingTerm.BuilderImpl usageBasedPricingTerm) {
            Object oldValue = this.usageBasedPricingTerm;
            this.usageBasedPricingTerm = usageBasedPricingTerm != null ? usageBasedPricingTerm.build() : null;
            handleUnionValueChange(Type.USAGE_BASED_PRICING_TERM, oldValue, this.usageBasedPricingTerm);
        }

        @Override
        public final Builder usageBasedPricingTerm(UsageBasedPricingTerm usageBasedPricingTerm) {
            Object oldValue = this.usageBasedPricingTerm;
            this.usageBasedPricingTerm = usageBasedPricingTerm;
            handleUnionValueChange(Type.USAGE_BASED_PRICING_TERM, oldValue, this.usageBasedPricingTerm);
            return this;
        }

        public final ValidityTerm.Builder getValidityTerm() {
            return validityTerm != null ? validityTerm.toBuilder() : null;
        }

        public final void setValidityTerm(ValidityTerm.BuilderImpl validityTerm) {
            Object oldValue = this.validityTerm;
            this.validityTerm = validityTerm != null ? validityTerm.build() : null;
            handleUnionValueChange(Type.VALIDITY_TERM, oldValue, this.validityTerm);
        }

        @Override
        public final Builder validityTerm(ValidityTerm validityTerm) {
            Object oldValue = this.validityTerm;
            this.validityTerm = validityTerm;
            handleUnionValueChange(Type.VALIDITY_TERM, oldValue, this.validityTerm);
            return this;
        }

        @Override
        public AcceptedTerm build() {
            return new AcceptedTerm(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AcceptedTerm#type()
     */
    public enum Type {
        BYOL_PRICING_TERM,

        CONFIGURABLE_UPFRONT_PRICING_TERM,

        FIXED_UPFRONT_PRICING_TERM,

        FREE_TRIAL_PRICING_TERM,

        LEGAL_TERM,

        PAYMENT_SCHEDULE_TERM,

        RECURRING_PAYMENT_TERM,

        RENEWAL_TERM,

        SUPPORT_TERM,

        USAGE_BASED_PRICING_TERM,

        VALIDITY_TERM,

        UNKNOWN_TO_SDK_VERSION
    }
}
