/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines an installment-based pricing model where customers are charged a fixed price on different dates during the
 * agreement validity period. This is used most commonly for flexible payment schedule pricing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PaymentScheduleTerm implements SdkPojo, Serializable,
        ToCopyableBuilder<PaymentScheduleTerm.Builder, PaymentScheduleTerm> {
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currencyCode").getter(getter(PaymentScheduleTerm::currencyCode)).setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencyCode").build()).build();

    private static final SdkField<List<ScheduleItem>> SCHEDULE_FIELD = SdkField
            .<List<ScheduleItem>> builder(MarshallingType.LIST)
            .memberName("schedule")
            .getter(getter(PaymentScheduleTerm::schedule))
            .setter(setter(Builder::schedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScheduleItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScheduleItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(PaymentScheduleTerm::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_CODE_FIELD,
            SCHEDULE_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String currencyCode;

    private final List<ScheduleItem> schedule;

    private final String type;

    private PaymentScheduleTerm(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.schedule = builder.schedule;
        this.type = builder.type;
    }

    /**
     * <p>
     * Defines the currency for the prices mentioned in the term.
     * </p>
     * 
     * @return Defines the currency for the prices mentioned in the term.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * For responses, this returns true if the service returned a value for the Schedule property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSchedule() {
        return schedule != null && !(schedule instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of the payment schedule where each element defines one installment of payment. It contains the information
     * necessary for calculating the price.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSchedule} method.
     * </p>
     * 
     * @return List of the payment schedule where each element defines one installment of payment. It contains the
     *         information necessary for calculating the price.
     */
    public final List<ScheduleItem> schedule() {
        return schedule;
    }

    /**
     * <p>
     * Type of the term.
     * </p>
     * 
     * @return Type of the term.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(hasSchedule() ? schedule() : null);
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaymentScheduleTerm)) {
            return false;
        }
        PaymentScheduleTerm other = (PaymentScheduleTerm) obj;
        return Objects.equals(currencyCode(), other.currencyCode()) && hasSchedule() == other.hasSchedule()
                && Objects.equals(schedule(), other.schedule()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PaymentScheduleTerm").add("CurrencyCode", currencyCode())
                .add("Schedule", hasSchedule() ? schedule() : null).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "currencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("currencyCode", CURRENCY_CODE_FIELD);
        map.put("schedule", SCHEDULE_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PaymentScheduleTerm, T> g) {
        return obj -> g.apply((PaymentScheduleTerm) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PaymentScheduleTerm> {
        /**
         * <p>
         * Defines the currency for the prices mentioned in the term.
         * </p>
         * 
         * @param currencyCode
         *        Defines the currency for the prices mentioned in the term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * List of the payment schedule where each element defines one installment of payment. It contains the
         * information necessary for calculating the price.
         * </p>
         * 
         * @param schedule
         *        List of the payment schedule where each element defines one installment of payment. It contains the
         *        information necessary for calculating the price.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(Collection<ScheduleItem> schedule);

        /**
         * <p>
         * List of the payment schedule where each element defines one installment of payment. It contains the
         * information necessary for calculating the price.
         * </p>
         * 
         * @param schedule
         *        List of the payment schedule where each element defines one installment of payment. It contains the
         *        information necessary for calculating the price.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(ScheduleItem... schedule);

        /**
         * <p>
         * List of the payment schedule where each element defines one installment of payment. It contains the
         * information necessary for calculating the price.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.ScheduleItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.ScheduleItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.ScheduleItem.Builder#build()} is called
         * immediately and its result is passed to {@link #schedule(List<ScheduleItem>)}.
         * 
         * @param schedule
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.marketplaceagreement.model.ScheduleItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(java.util.Collection<ScheduleItem>)
         */
        Builder schedule(Consumer<ScheduleItem.Builder>... schedule);

        /**
         * <p>
         * Type of the term.
         * </p>
         * 
         * @param type
         *        Type of the term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String currencyCode;

        private List<ScheduleItem> schedule = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(PaymentScheduleTerm model) {
            currencyCode(model.currencyCode);
            schedule(model.schedule);
            type(model.type);
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final List<ScheduleItem.Builder> getSchedule() {
            List<ScheduleItem.Builder> result = ScheduleListCopier.copyToBuilder(this.schedule);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchedule(Collection<ScheduleItem.BuilderImpl> schedule) {
            this.schedule = ScheduleListCopier.copyFromBuilder(schedule);
        }

        @Override
        public final Builder schedule(Collection<ScheduleItem> schedule) {
            this.schedule = ScheduleListCopier.copy(schedule);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schedule(ScheduleItem... schedule) {
            schedule(Arrays.asList(schedule));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schedule(Consumer<ScheduleItem.Builder>... schedule) {
            schedule(Stream.of(schedule).map(c -> ScheduleItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public PaymentScheduleTerm build() {
            return new PaymentScheduleTerm(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
