/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the per unit rates for each individual product dimension.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RateCardItem implements SdkPojo, Serializable, ToCopyableBuilder<RateCardItem.Builder, RateCardItem> {
    private static final SdkField<String> DIMENSION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dimensionKey").getter(getter(RateCardItem::dimensionKey)).setter(setter(Builder::dimensionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimensionKey").build()).build();

    private static final SdkField<String> PRICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("price")
            .getter(getter(RateCardItem::price)).setter(setter(Builder::price))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("price").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_KEY_FIELD,
            PRICE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dimensionKey;

    private final String price;

    private RateCardItem(BuilderImpl builder) {
        this.dimensionKey = builder.dimensionKey;
        this.price = builder.price;
    }

    /**
     * <p>
     * Dimension for which the given entitlement applies. Dimensions represent categories of capacity in a product and
     * are specified when the product is listed in AWS Marketplace.
     * </p>
     * 
     * @return Dimension for which the given entitlement applies. Dimensions represent categories of capacity in a
     *         product and are specified when the product is listed in AWS Marketplace.
     */
    public final String dimensionKey() {
        return dimensionKey;
    }

    /**
     * <p>
     * Per unit price for the product dimension that’s used for calculating the amount to be charged.
     * </p>
     * 
     * @return Per unit price for the product dimension that’s used for calculating the amount to be charged.
     */
    public final String price() {
        return price;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensionKey());
        hashCode = 31 * hashCode + Objects.hashCode(price());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RateCardItem)) {
            return false;
        }
        RateCardItem other = (RateCardItem) obj;
        return Objects.equals(dimensionKey(), other.dimensionKey()) && Objects.equals(price(), other.price());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RateCardItem").add("DimensionKey", dimensionKey()).add("Price", price()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dimensionKey":
            return Optional.ofNullable(clazz.cast(dimensionKey()));
        case "price":
            return Optional.ofNullable(clazz.cast(price()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dimensionKey", DIMENSION_KEY_FIELD);
        map.put("price", PRICE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RateCardItem, T> g) {
        return obj -> g.apply((RateCardItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RateCardItem> {
        /**
         * <p>
         * Dimension for which the given entitlement applies. Dimensions represent categories of capacity in a product
         * and are specified when the product is listed in AWS Marketplace.
         * </p>
         * 
         * @param dimensionKey
         *        Dimension for which the given entitlement applies. Dimensions represent categories of capacity in a
         *        product and are specified when the product is listed in AWS Marketplace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionKey(String dimensionKey);

        /**
         * <p>
         * Per unit price for the product dimension that’s used for calculating the amount to be charged.
         * </p>
         * 
         * @param price
         *        Per unit price for the product dimension that’s used for calculating the amount to be charged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder price(String price);
    }

    static final class BuilderImpl implements Builder {
        private String dimensionKey;

        private String price;

        private BuilderImpl() {
        }

        private BuilderImpl(RateCardItem model) {
            dimensionKey(model.dimensionKey);
            price(model.price);
        }

        public final String getDimensionKey() {
            return dimensionKey;
        }

        public final void setDimensionKey(String dimensionKey) {
            this.dimensionKey = dimensionKey;
        }

        @Override
        public final Builder dimensionKey(String dimensionKey) {
            this.dimensionKey = dimensionKey;
            return this;
        }

        public final String getPrice() {
            return price;
        }

        public final void setPrice(String price) {
            this.price = price;
        }

        @Override
        public final Builder price(String price) {
            this.price = price;
            return this;
        }

        @Override
        public RateCardItem build() {
            return new RateCardItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
