/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An individual installment of the payment that includes the date and amount of the charge.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduleItem implements SdkPojo, Serializable, ToCopyableBuilder<ScheduleItem.Builder, ScheduleItem> {
    private static final SdkField<String> CHARGE_AMOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("chargeAmount").getter(getter(ScheduleItem::chargeAmount)).setter(setter(Builder::chargeAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chargeAmount").build()).build();

    private static final SdkField<Instant> CHARGE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("chargeDate").getter(getter(ScheduleItem::chargeDate)).setter(setter(Builder::chargeDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chargeDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHARGE_AMOUNT_FIELD,
            CHARGE_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String chargeAmount;

    private final Instant chargeDate;

    private ScheduleItem(BuilderImpl builder) {
        this.chargeAmount = builder.chargeAmount;
        this.chargeDate = builder.chargeDate;
    }

    /**
     * <p>
     * The price that the customer would pay on the scheduled date (chargeDate).
     * </p>
     * 
     * @return The price that the customer would pay on the scheduled date (chargeDate).
     */
    public final String chargeAmount() {
        return chargeAmount;
    }

    /**
     * <p>
     * The date that the customer would pay the price defined in this payment schedule term. Invoices are generated on
     * the date provided.
     * </p>
     * 
     * @return The date that the customer would pay the price defined in this payment schedule term. Invoices are
     *         generated on the date provided.
     */
    public final Instant chargeDate() {
        return chargeDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(chargeAmount());
        hashCode = 31 * hashCode + Objects.hashCode(chargeDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleItem)) {
            return false;
        }
        ScheduleItem other = (ScheduleItem) obj;
        return Objects.equals(chargeAmount(), other.chargeAmount()) && Objects.equals(chargeDate(), other.chargeDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduleItem").add("ChargeAmount", chargeAmount()).add("ChargeDate", chargeDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "chargeAmount":
            return Optional.ofNullable(clazz.cast(chargeAmount()));
        case "chargeDate":
            return Optional.ofNullable(clazz.cast(chargeDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("chargeAmount", CHARGE_AMOUNT_FIELD);
        map.put("chargeDate", CHARGE_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduleItem, T> g) {
        return obj -> g.apply((ScheduleItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduleItem> {
        /**
         * <p>
         * The price that the customer would pay on the scheduled date (chargeDate).
         * </p>
         * 
         * @param chargeAmount
         *        The price that the customer would pay on the scheduled date (chargeDate).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chargeAmount(String chargeAmount);

        /**
         * <p>
         * The date that the customer would pay the price defined in this payment schedule term. Invoices are generated
         * on the date provided.
         * </p>
         * 
         * @param chargeDate
         *        The date that the customer would pay the price defined in this payment schedule term. Invoices are
         *        generated on the date provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chargeDate(Instant chargeDate);
    }

    static final class BuilderImpl implements Builder {
        private String chargeAmount;

        private Instant chargeDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleItem model) {
            chargeAmount(model.chargeAmount);
            chargeDate(model.chargeDate);
        }

        public final String getChargeAmount() {
            return chargeAmount;
        }

        public final void setChargeAmount(String chargeAmount) {
            this.chargeAmount = chargeAmount;
        }

        @Override
        public final Builder chargeAmount(String chargeAmount) {
            this.chargeAmount = chargeAmount;
            return this;
        }

        public final Instant getChargeDate() {
            return chargeDate;
        }

        public final void setChargeDate(Instant chargeDate) {
            this.chargeDate = chargeDate;
        }

        @Override
        public final Builder chargeDate(Instant chargeDate) {
            this.chargeDate = chargeDate;
            return this;
        }

        @Override
        public ScheduleItem build() {
            return new ScheduleItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
