/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Within the pay-as-you-go model defined under <code>UsageBasedPricingTerm</code>, the
 * <code>UsageBasedRateCardItem</code> defines an individual rate for a product dimension.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UsageBasedRateCardItem implements SdkPojo, Serializable,
        ToCopyableBuilder<UsageBasedRateCardItem.Builder, UsageBasedRateCardItem> {
    private static final SdkField<List<RateCardItem>> RATE_CARD_FIELD = SdkField
            .<List<RateCardItem>> builder(MarshallingType.LIST)
            .memberName("rateCard")
            .getter(getter(UsageBasedRateCardItem::rateCard))
            .setter(setter(Builder::rateCard))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateCard").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RateCardItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(RateCardItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RATE_CARD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<RateCardItem> rateCard;

    private UsageBasedRateCardItem(BuilderImpl builder) {
        this.rateCard = builder.rateCard;
    }

    /**
     * For responses, this returns true if the service returned a value for the RateCard property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRateCard() {
        return rateCard != null && !(rateCard instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines the per unit rates for product dimensions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRateCard} method.
     * </p>
     * 
     * @return Defines the per unit rates for product dimensions.
     */
    public final List<RateCardItem> rateCard() {
        return rateCard;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRateCard() ? rateCard() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageBasedRateCardItem)) {
            return false;
        }
        UsageBasedRateCardItem other = (UsageBasedRateCardItem) obj;
        return hasRateCard() == other.hasRateCard() && Objects.equals(rateCard(), other.rateCard());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UsageBasedRateCardItem").add("RateCard", hasRateCard() ? rateCard() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rateCard":
            return Optional.ofNullable(clazz.cast(rateCard()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("rateCard", RATE_CARD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UsageBasedRateCardItem, T> g) {
        return obj -> g.apply((UsageBasedRateCardItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UsageBasedRateCardItem> {
        /**
         * <p>
         * Defines the per unit rates for product dimensions.
         * </p>
         * 
         * @param rateCard
         *        Defines the per unit rates for product dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rateCard(Collection<RateCardItem> rateCard);

        /**
         * <p>
         * Defines the per unit rates for product dimensions.
         * </p>
         * 
         * @param rateCard
         *        Defines the per unit rates for product dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rateCard(RateCardItem... rateCard);

        /**
         * <p>
         * Defines the per unit rates for product dimensions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.RateCardItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.RateCardItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.RateCardItem.Builder#build()} is called
         * immediately and its result is passed to {@link #rateCard(List<RateCardItem>)}.
         * 
         * @param rateCard
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.marketplaceagreement.model.RateCardItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rateCard(java.util.Collection<RateCardItem>)
         */
        Builder rateCard(Consumer<RateCardItem.Builder>... rateCard);
    }

    static final class BuilderImpl implements Builder {
        private List<RateCardItem> rateCard = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UsageBasedRateCardItem model) {
            rateCard(model.rateCard);
        }

        public final List<RateCardItem.Builder> getRateCard() {
            List<RateCardItem.Builder> result = RateCardListCopier.copyToBuilder(this.rateCard);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRateCard(Collection<RateCardItem.BuilderImpl> rateCard) {
            this.rateCard = RateCardListCopier.copyFromBuilder(rateCard);
        }

        @Override
        public final Builder rateCard(Collection<RateCardItem> rateCard) {
            this.rateCard = RateCardListCopier.copy(rateCard);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rateCard(RateCardItem... rateCard) {
            rateCard(Arrays.asList(rateCard));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rateCard(Consumer<RateCardItem.Builder>... rateCard) {
            rateCard(Stream.of(rateCard).map(c -> RateCardItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public UsageBasedRateCardItem build() {
            return new UsageBasedRateCardItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
