/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the conditions that will keep an agreement created from this offer valid.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidityTerm implements SdkPojo, Serializable, ToCopyableBuilder<ValidityTerm.Builder, ValidityTerm> {
    private static final SdkField<String> AGREEMENT_DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agreementDuration").getter(getter(ValidityTerm::agreementDuration))
            .setter(setter(Builder::agreementDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agreementDuration").build()).build();

    private static final SdkField<Instant> AGREEMENT_END_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("agreementEndDate").getter(getter(ValidityTerm::agreementEndDate))
            .setter(setter(Builder::agreementEndDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agreementEndDate").build()).build();

    private static final SdkField<Instant> AGREEMENT_START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("agreementStartDate").getter(getter(ValidityTerm::agreementStartDate))
            .setter(setter(Builder::agreementStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agreementStartDate").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ValidityTerm::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGREEMENT_DURATION_FIELD,
            AGREEMENT_END_DATE_FIELD, AGREEMENT_START_DATE_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String agreementDuration;

    private final Instant agreementEndDate;

    private final Instant agreementStartDate;

    private final String type;

    private ValidityTerm(BuilderImpl builder) {
        this.agreementDuration = builder.agreementDuration;
        this.agreementEndDate = builder.agreementEndDate;
        this.agreementStartDate = builder.agreementStartDate;
        this.type = builder.type;
    }

    /**
     * <p>
     * Defines the duration that the agreement remains active. If <code>AgreementStartDate</code> isn’t provided, the
     * agreement duration is relative to the agreement signature time. The duration is represented in the ISO_8601
     * format.
     * </p>
     * 
     * @return Defines the duration that the agreement remains active. If <code>AgreementStartDate</code> isn’t
     *         provided, the agreement duration is relative to the agreement signature time. The duration is represented
     *         in the ISO_8601 format.
     */
    public final String agreementDuration() {
        return agreementDuration;
    }

    /**
     * <p>
     * Defines the date when the agreement ends. The agreement ends at 23:59:59.999 UTC on the date provided. If
     * <code>AgreementEndDate</code> isn’t provided, the agreement end date is determined by the validity of individual
     * terms.
     * </p>
     * 
     * @return Defines the date when the agreement ends. The agreement ends at 23:59:59.999 UTC on the date provided. If
     *         <code>AgreementEndDate</code> isn’t provided, the agreement end date is determined by the validity of
     *         individual terms.
     */
    public final Instant agreementEndDate() {
        return agreementEndDate;
    }

    /**
     * <p>
     * Defines the date when agreement starts. The agreement starts at 00:00:00.000 UTC on the date provided. If
     * <code>AgreementStartDate</code> isn’t provided, the agreement start date is determined based on agreement
     * signature time.
     * </p>
     * 
     * @return Defines the date when agreement starts. The agreement starts at 00:00:00.000 UTC on the date provided. If
     *         <code>AgreementStartDate</code> isn’t provided, the agreement start date is determined based on agreement
     *         signature time.
     */
    public final Instant agreementStartDate() {
        return agreementStartDate;
    }

    /**
     * <p>
     * Category of the term being updated.
     * </p>
     * 
     * @return Category of the term being updated.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agreementDuration());
        hashCode = 31 * hashCode + Objects.hashCode(agreementEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(agreementStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidityTerm)) {
            return false;
        }
        ValidityTerm other = (ValidityTerm) obj;
        return Objects.equals(agreementDuration(), other.agreementDuration())
                && Objects.equals(agreementEndDate(), other.agreementEndDate())
                && Objects.equals(agreementStartDate(), other.agreementStartDate()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidityTerm").add("AgreementDuration", agreementDuration())
                .add("AgreementEndDate", agreementEndDate()).add("AgreementStartDate", agreementStartDate()).add("Type", type())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agreementDuration":
            return Optional.ofNullable(clazz.cast(agreementDuration()));
        case "agreementEndDate":
            return Optional.ofNullable(clazz.cast(agreementEndDate()));
        case "agreementStartDate":
            return Optional.ofNullable(clazz.cast(agreementStartDate()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agreementDuration", AGREEMENT_DURATION_FIELD);
        map.put("agreementEndDate", AGREEMENT_END_DATE_FIELD);
        map.put("agreementStartDate", AGREEMENT_START_DATE_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidityTerm, T> g) {
        return obj -> g.apply((ValidityTerm) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidityTerm> {
        /**
         * <p>
         * Defines the duration that the agreement remains active. If <code>AgreementStartDate</code> isn’t provided,
         * the agreement duration is relative to the agreement signature time. The duration is represented in the
         * ISO_8601 format.
         * </p>
         * 
         * @param agreementDuration
         *        Defines the duration that the agreement remains active. If <code>AgreementStartDate</code> isn’t
         *        provided, the agreement duration is relative to the agreement signature time. The duration is
         *        represented in the ISO_8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agreementDuration(String agreementDuration);

        /**
         * <p>
         * Defines the date when the agreement ends. The agreement ends at 23:59:59.999 UTC on the date provided. If
         * <code>AgreementEndDate</code> isn’t provided, the agreement end date is determined by the validity of
         * individual terms.
         * </p>
         * 
         * @param agreementEndDate
         *        Defines the date when the agreement ends. The agreement ends at 23:59:59.999 UTC on the date provided.
         *        If <code>AgreementEndDate</code> isn’t provided, the agreement end date is determined by the validity
         *        of individual terms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agreementEndDate(Instant agreementEndDate);

        /**
         * <p>
         * Defines the date when agreement starts. The agreement starts at 00:00:00.000 UTC on the date provided. If
         * <code>AgreementStartDate</code> isn’t provided, the agreement start date is determined based on agreement
         * signature time.
         * </p>
         * 
         * @param agreementStartDate
         *        Defines the date when agreement starts. The agreement starts at 00:00:00.000 UTC on the date provided.
         *        If <code>AgreementStartDate</code> isn’t provided, the agreement start date is determined based on
         *        agreement signature time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agreementStartDate(Instant agreementStartDate);

        /**
         * <p>
         * Category of the term being updated.
         * </p>
         * 
         * @param type
         *        Category of the term being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String agreementDuration;

        private Instant agreementEndDate;

        private Instant agreementStartDate;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidityTerm model) {
            agreementDuration(model.agreementDuration);
            agreementEndDate(model.agreementEndDate);
            agreementStartDate(model.agreementStartDate);
            type(model.type);
        }

        public final String getAgreementDuration() {
            return agreementDuration;
        }

        public final void setAgreementDuration(String agreementDuration) {
            this.agreementDuration = agreementDuration;
        }

        @Override
        public final Builder agreementDuration(String agreementDuration) {
            this.agreementDuration = agreementDuration;
            return this;
        }

        public final Instant getAgreementEndDate() {
            return agreementEndDate;
        }

        public final void setAgreementEndDate(Instant agreementEndDate) {
            this.agreementEndDate = agreementEndDate;
        }

        @Override
        public final Builder agreementEndDate(Instant agreementEndDate) {
            this.agreementEndDate = agreementEndDate;
            return this;
        }

        public final Instant getAgreementStartDate() {
            return agreementStartDate;
        }

        public final void setAgreementStartDate(Instant agreementStartDate) {
            this.agreementStartDate = agreementStartDate;
        }

        @Override
        public final Builder agreementStartDate(Instant agreementStartDate) {
            this.agreementStartDate = agreementStartDate;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public ValidityTerm build() {
            return new ValidityTerm(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
