/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplaceagreement.model.UsageBasedRateCardItem;
import software.amazon.awssdk.services.marketplaceagreement.model.UsageBasedRateCardListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UsageBasedPricingTerm
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UsageBasedPricingTerm> {
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currencyCode").getter(UsageBasedPricingTerm.getter(UsageBasedPricingTerm::currencyCode)).setter(UsageBasedPricingTerm.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencyCode").build()}).build();
    private static final SdkField<List<UsageBasedRateCardItem>> RATE_CARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rateCards").getter(UsageBasedPricingTerm.getter(UsageBasedPricingTerm::rateCards)).setter(UsageBasedPricingTerm.setter(Builder::rateCards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateCards").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageBasedRateCardItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(UsageBasedPricingTerm.getter(UsageBasedPricingTerm::type)).setter(UsageBasedPricingTerm.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_CODE_FIELD, RATE_CARDS_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UsageBasedPricingTerm.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String currencyCode;
    private final List<UsageBasedRateCardItem> rateCards;
    private final String type;

    private UsageBasedPricingTerm(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.rateCards = builder.rateCards;
        this.type = builder.type;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final boolean hasRateCards() {
        return this.rateCards != null && !(this.rateCards instanceof SdkAutoConstructList);
    }

    public final List<UsageBasedRateCardItem> rateCards() {
        return this.rateCards;
    }

    public final String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRateCards() ? this.rateCards() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageBasedPricingTerm)) {
            return false;
        }
        UsageBasedPricingTerm other = (UsageBasedPricingTerm)obj;
        return Objects.equals(this.currencyCode(), other.currencyCode()) && this.hasRateCards() == other.hasRateCards() && Objects.equals(this.rateCards(), other.rateCards()) && Objects.equals(this.type(), other.type());
    }

    public final String toString() {
        return ToString.builder((String)"UsageBasedPricingTerm").add("CurrencyCode", (Object)this.currencyCode()).add("RateCards", this.hasRateCards() ? this.rateCards() : null).add("Type", (Object)this.type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "currencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "rateCards": {
                return Optional.ofNullable(clazz.cast(this.rateCards()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("currencyCode", CURRENCY_CODE_FIELD);
        map.put("rateCards", RATE_CARDS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UsageBasedPricingTerm, T> g) {
        return obj -> g.apply((UsageBasedPricingTerm)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String currencyCode;
        private List<UsageBasedRateCardItem> rateCards = DefaultSdkAutoConstructList.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(UsageBasedPricingTerm model) {
            this.currencyCode(model.currencyCode);
            this.rateCards(model.rateCards);
            this.type(model.type);
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final List<UsageBasedRateCardItem.Builder> getRateCards() {
            List<UsageBasedRateCardItem.Builder> result = UsageBasedRateCardListCopier.copyToBuilder(this.rateCards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRateCards(Collection<UsageBasedRateCardItem.BuilderImpl> rateCards) {
            this.rateCards = UsageBasedRateCardListCopier.copyFromBuilder(rateCards);
        }

        @Override
        public final Builder rateCards(Collection<UsageBasedRateCardItem> rateCards) {
            this.rateCards = UsageBasedRateCardListCopier.copy(rateCards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rateCards(UsageBasedRateCardItem ... rateCards) {
            this.rateCards(Arrays.asList(rateCards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rateCards(Consumer<UsageBasedRateCardItem.Builder> ... rateCards) {
            this.rateCards(Stream.of(rateCards).map(c -> (UsageBasedRateCardItem)((UsageBasedRateCardItem.Builder)UsageBasedRateCardItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public UsageBasedPricingTerm build() {
            return new UsageBasedPricingTerm(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UsageBasedPricingTerm> {
        public Builder currencyCode(String var1);

        public Builder rateCards(Collection<UsageBasedRateCardItem> var1);

        public Builder rateCards(UsageBasedRateCardItem ... var1);

        public Builder rateCards(Consumer<UsageBasedRateCardItem.Builder> ... var1);

        public Builder type(String var1);
    }
}

