/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceagreement.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplaceagreement.model.GrantItem;

final class GrantListCopier {
    GrantListCopier() {
    }

    static List<GrantItem> copy(Collection<? extends GrantItem> grantListParam) {
        Object list;
        if (grantListParam == null || grantListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(grantListParam.size());
            grantListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<GrantItem> copyFromBuilder(Collection<? extends GrantItem.Builder> grantListParam) {
        Object list;
        if (grantListParam == null || grantListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(grantListParam.size());
            grantListParam.forEach(entry -> {
                GrantItem member = entry == null ? null : (GrantItem)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<GrantItem.Builder> copyToBuilder(Collection<? extends GrantItem> grantListParam) {
        Object list;
        if (grantListParam == null || grantListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(grantListParam.size());
            grantListParam.forEach(entry -> {
                GrantItem.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

