/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a prepaid payment model that allows buyers to configure the entitlements they want to purchase and the
 * duration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurableUpfrontPricingTerm implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurableUpfrontPricingTerm.Builder, ConfigurableUpfrontPricingTerm> {
    private static final SdkField<ConfigurableUpfrontPricingTermConfiguration> CONFIGURATION_FIELD = SdkField
            .<ConfigurableUpfrontPricingTermConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(ConfigurableUpfrontPricingTerm::configuration)).setter(setter(Builder::configuration))
            .constructor(ConfigurableUpfrontPricingTermConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currencyCode").getter(getter(ConfigurableUpfrontPricingTerm::currencyCode))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencyCode").build()).build();

    private static final SdkField<List<ConfigurableUpfrontRateCardItem>> RATE_CARDS_FIELD = SdkField
            .<List<ConfigurableUpfrontRateCardItem>> builder(MarshallingType.LIST)
            .memberName("rateCards")
            .getter(getter(ConfigurableUpfrontPricingTerm::rateCards))
            .setter(setter(Builder::rateCards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateCards").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurableUpfrontRateCardItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurableUpfrontRateCardItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ConfigurableUpfrontPricingTerm::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD,
            CURRENCY_CODE_FIELD, RATE_CARDS_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ConfigurableUpfrontPricingTermConfiguration configuration;

    private final String currencyCode;

    private final List<ConfigurableUpfrontRateCardItem> rateCards;

    private final String type;

    private ConfigurableUpfrontPricingTerm(BuilderImpl builder) {
        this.configuration = builder.configuration;
        this.currencyCode = builder.currencyCode;
        this.rateCards = builder.rateCards;
        this.type = builder.type;
    }

    /**
     * <p>
     * Additional parameters specified by the acceptor while accepting the term.
     * </p>
     * 
     * @return Additional parameters specified by the acceptor while accepting the term.
     */
    public final ConfigurableUpfrontPricingTermConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * Defines the currency for the prices mentioned in the term.
     * </p>
     * 
     * @return Defines the currency for the prices mentioned in the term.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * For responses, this returns true if the service returned a value for the RateCards property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRateCards() {
        return rateCards != null && !(rateCards instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A rate card defines the per unit rates for product dimensions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRateCards} method.
     * </p>
     * 
     * @return A rate card defines the per unit rates for product dimensions.
     */
    public final List<ConfigurableUpfrontRateCardItem> rateCards() {
        return rateCards;
    }

    /**
     * <p>
     * Category of selector.
     * </p>
     * 
     * @return Category of selector.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(hasRateCards() ? rateCards() : null);
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurableUpfrontPricingTerm)) {
            return false;
        }
        ConfigurableUpfrontPricingTerm other = (ConfigurableUpfrontPricingTerm) obj;
        return Objects.equals(configuration(), other.configuration()) && Objects.equals(currencyCode(), other.currencyCode())
                && hasRateCards() == other.hasRateCards() && Objects.equals(rateCards(), other.rateCards())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurableUpfrontPricingTerm").add("Configuration", configuration())
                .add("CurrencyCode", currencyCode()).add("RateCards", hasRateCards() ? rateCards() : null).add("Type", type())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "currencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "rateCards":
            return Optional.ofNullable(clazz.cast(rateCards()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("currencyCode", CURRENCY_CODE_FIELD);
        map.put("rateCards", RATE_CARDS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurableUpfrontPricingTerm, T> g) {
        return obj -> g.apply((ConfigurableUpfrontPricingTerm) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurableUpfrontPricingTerm> {
        /**
         * <p>
         * Additional parameters specified by the acceptor while accepting the term.
         * </p>
         * 
         * @param configuration
         *        Additional parameters specified by the acceptor while accepting the term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(ConfigurableUpfrontPricingTermConfiguration configuration);

        /**
         * <p>
         * Additional parameters specified by the acceptor while accepting the term.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConfigurableUpfrontPricingTermConfiguration.Builder} avoiding the need to create one manually via
         * {@link ConfigurableUpfrontPricingTermConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfigurableUpfrontPricingTermConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #configuration(ConfigurableUpfrontPricingTermConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link ConfigurableUpfrontPricingTermConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(ConfigurableUpfrontPricingTermConfiguration)
         */
        default Builder configuration(Consumer<ConfigurableUpfrontPricingTermConfiguration.Builder> configuration) {
            return configuration(ConfigurableUpfrontPricingTermConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * Defines the currency for the prices mentioned in the term.
         * </p>
         * 
         * @param currencyCode
         *        Defines the currency for the prices mentioned in the term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * A rate card defines the per unit rates for product dimensions.
         * </p>
         * 
         * @param rateCards
         *        A rate card defines the per unit rates for product dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rateCards(Collection<ConfigurableUpfrontRateCardItem> rateCards);

        /**
         * <p>
         * A rate card defines the per unit rates for product dimensions.
         * </p>
         * 
         * @param rateCards
         *        A rate card defines the per unit rates for product dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rateCards(ConfigurableUpfrontRateCardItem... rateCards);

        /**
         * <p>
         * A rate card defines the per unit rates for product dimensions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.ConfigurableUpfrontRateCardItem.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.ConfigurableUpfrontRateCardItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.ConfigurableUpfrontRateCardItem.Builder#build()}
         * is called immediately and its result is passed to {@link #rateCards(List<ConfigurableUpfrontRateCardItem>)}.
         * 
         * @param rateCards
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.marketplaceagreement.model.ConfigurableUpfrontRateCardItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rateCards(java.util.Collection<ConfigurableUpfrontRateCardItem>)
         */
        Builder rateCards(Consumer<ConfigurableUpfrontRateCardItem.Builder>... rateCards);

        /**
         * <p>
         * Category of selector.
         * </p>
         * 
         * @param type
         *        Category of selector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private ConfigurableUpfrontPricingTermConfiguration configuration;

        private String currencyCode;

        private List<ConfigurableUpfrontRateCardItem> rateCards = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurableUpfrontPricingTerm model) {
            configuration(model.configuration);
            currencyCode(model.currencyCode);
            rateCards(model.rateCards);
            type(model.type);
        }

        public final ConfigurableUpfrontPricingTermConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(ConfigurableUpfrontPricingTermConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ConfigurableUpfrontPricingTermConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final List<ConfigurableUpfrontRateCardItem.Builder> getRateCards() {
            List<ConfigurableUpfrontRateCardItem.Builder> result = ConfigurableUpfrontRateCardListCopier
                    .copyToBuilder(this.rateCards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRateCards(Collection<ConfigurableUpfrontRateCardItem.BuilderImpl> rateCards) {
            this.rateCards = ConfigurableUpfrontRateCardListCopier.copyFromBuilder(rateCards);
        }

        @Override
        public final Builder rateCards(Collection<ConfigurableUpfrontRateCardItem> rateCards) {
            this.rateCards = ConfigurableUpfrontRateCardListCopier.copy(rateCards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rateCards(ConfigurableUpfrontRateCardItem... rateCards) {
            rateCards(Arrays.asList(rateCards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rateCards(Consumer<ConfigurableUpfrontRateCardItem.Builder>... rateCards) {
            rateCards(Stream.of(rateCards).map(c -> ConfigurableUpfrontRateCardItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public ConfigurableUpfrontPricingTerm build() {
            return new ConfigurableUpfrontPricingTerm(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
