/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a prepaid payment model that allows buyers to configure the entitlements they want to purchase and the
 * duration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurableUpfrontPricingTermConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurableUpfrontPricingTermConfiguration.Builder, ConfigurableUpfrontPricingTermConfiguration> {
    private static final SdkField<List<Dimension>> DIMENSIONS_FIELD = SdkField
            .<List<Dimension>> builder(MarshallingType.LIST)
            .memberName("dimensions")
            .getter(getter(ConfigurableUpfrontPricingTermConfiguration::dimensions))
            .setter(setter(Builder::dimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Dimension> builder(MarshallingType.SDK_POJO)
                                            .constructor(Dimension::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SELECTOR_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("selectorValue").getter(getter(ConfigurableUpfrontPricingTermConfiguration::selectorValue))
            .setter(setter(Builder::selectorValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectorValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD,
            SELECTOR_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Dimension> dimensions;

    private final String selectorValue;

    private ConfigurableUpfrontPricingTermConfiguration(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.selectorValue = builder.selectorValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dimensions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDimensions() {
        return dimensions != null && !(dimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines the dimensions that the acceptor has purchased from the overall set of dimensions presented in the rate
     * card.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensions} method.
     * </p>
     * 
     * @return Defines the dimensions that the acceptor has purchased from the overall set of dimensions presented in
     *         the rate card.
     */
    public final List<Dimension> dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * Defines the length of time for which the particular pricing/dimension is being purchased by the acceptor.
     * </p>
     * 
     * @return Defines the length of time for which the particular pricing/dimension is being purchased by the acceptor.
     */
    public final String selectorValue() {
        return selectorValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensions() ? dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(selectorValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurableUpfrontPricingTermConfiguration)) {
            return false;
        }
        ConfigurableUpfrontPricingTermConfiguration other = (ConfigurableUpfrontPricingTermConfiguration) obj;
        return hasDimensions() == other.hasDimensions() && Objects.equals(dimensions(), other.dimensions())
                && Objects.equals(selectorValue(), other.selectorValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurableUpfrontPricingTermConfiguration")
                .add("Dimensions", hasDimensions() ? dimensions() : null).add("SelectorValue", selectorValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "selectorValue":
            return Optional.ofNullable(clazz.cast(selectorValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dimensions", DIMENSIONS_FIELD);
        map.put("selectorValue", SELECTOR_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurableUpfrontPricingTermConfiguration, T> g) {
        return obj -> g.apply((ConfigurableUpfrontPricingTermConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurableUpfrontPricingTermConfiguration> {
        /**
         * <p>
         * Defines the dimensions that the acceptor has purchased from the overall set of dimensions presented in the
         * rate card.
         * </p>
         * 
         * @param dimensions
         *        Defines the dimensions that the acceptor has purchased from the overall set of dimensions presented in
         *        the rate card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Collection<Dimension> dimensions);

        /**
         * <p>
         * Defines the dimensions that the acceptor has purchased from the overall set of dimensions presented in the
         * rate card.
         * </p>
         * 
         * @param dimensions
         *        Defines the dimensions that the acceptor has purchased from the overall set of dimensions presented in
         *        the rate card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Dimension... dimensions);

        /**
         * <p>
         * Defines the dimensions that the acceptor has purchased from the overall set of dimensions presented in the
         * rate card.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.Dimension.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.Dimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.Dimension.Builder#build()} is called
         * immediately and its result is passed to {@link #dimensions(List<Dimension>)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.marketplaceagreement.model.Dimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(java.util.Collection<Dimension>)
         */
        Builder dimensions(Consumer<Dimension.Builder>... dimensions);

        /**
         * <p>
         * Defines the length of time for which the particular pricing/dimension is being purchased by the acceptor.
         * </p>
         * 
         * @param selectorValue
         *        Defines the length of time for which the particular pricing/dimension is being purchased by the
         *        acceptor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectorValue(String selectorValue);
    }

    static final class BuilderImpl implements Builder {
        private List<Dimension> dimensions = DefaultSdkAutoConstructList.getInstance();

        private String selectorValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurableUpfrontPricingTermConfiguration model) {
            dimensions(model.dimensions);
            selectorValue(model.selectorValue);
        }

        public final List<Dimension.Builder> getDimensions() {
            List<Dimension.Builder> result = DimensionListCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<Dimension.BuilderImpl> dimensions) {
            this.dimensions = DimensionListCopier.copyFromBuilder(dimensions);
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionListCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension... dimensions) {
            dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<Dimension.Builder>... dimensions) {
            dimensions(Stream.of(dimensions).map(c -> Dimension.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSelectorValue() {
            return selectorValue;
        }

        public final void setSelectorValue(String selectorValue) {
            this.selectorValue = selectorValue;
        }

        @Override
        public final Builder selectorValue(String selectorValue) {
            this.selectorValue = selectorValue;
            return this;
        }

        @Override
        public ConfigurableUpfrontPricingTermConfiguration build() {
            return new ConfigurableUpfrontPricingTermConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
