/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a short-term free pricing model where the buyers aren’t charged anything within a specified limit.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FreeTrialPricingTerm implements SdkPojo, Serializable,
        ToCopyableBuilder<FreeTrialPricingTerm.Builder, FreeTrialPricingTerm> {
    private static final SdkField<String> DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("duration").getter(getter(FreeTrialPricingTerm::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()).build();

    private static final SdkField<List<GrantItem>> GRANTS_FIELD = SdkField
            .<List<GrantItem>> builder(MarshallingType.LIST)
            .memberName("grants")
            .getter(getter(FreeTrialPricingTerm::grants))
            .setter(setter(Builder::grants))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grants").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GrantItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(GrantItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(FreeTrialPricingTerm::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_FIELD, GRANTS_FIELD,
            TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String duration;

    private final List<GrantItem> grants;

    private final String type;

    private FreeTrialPricingTerm(BuilderImpl builder) {
        this.duration = builder.duration;
        this.grants = builder.grants;
        this.type = builder.type;
    }

    /**
     * <p>
     * Duration of the free trial period (5–31 days).
     * </p>
     * 
     * @return Duration of the free trial period (5–31 days).
     */
    public final String duration() {
        return duration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Grants property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGrants() {
        return grants != null && !(grants instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Entitlements granted to the acceptor of a free trial as part of an agreement execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGrants} method.
     * </p>
     * 
     * @return Entitlements granted to the acceptor of a free trial as part of an agreement execution.
     */
    public final List<GrantItem> grants() {
        return grants;
    }

    /**
     * <p>
     * Category of the term.
     * </p>
     * 
     * @return Category of the term.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(hasGrants() ? grants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FreeTrialPricingTerm)) {
            return false;
        }
        FreeTrialPricingTerm other = (FreeTrialPricingTerm) obj;
        return Objects.equals(duration(), other.duration()) && hasGrants() == other.hasGrants()
                && Objects.equals(grants(), other.grants()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FreeTrialPricingTerm").add("Duration", duration()).add("Grants", hasGrants() ? grants() : null)
                .add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "grants":
            return Optional.ofNullable(clazz.cast(grants()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("duration", DURATION_FIELD);
        map.put("grants", GRANTS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FreeTrialPricingTerm, T> g) {
        return obj -> g.apply((FreeTrialPricingTerm) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FreeTrialPricingTerm> {
        /**
         * <p>
         * Duration of the free trial period (5–31 days).
         * </p>
         * 
         * @param duration
         *        Duration of the free trial period (5–31 days).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(String duration);

        /**
         * <p>
         * Entitlements granted to the acceptor of a free trial as part of an agreement execution.
         * </p>
         * 
         * @param grants
         *        Entitlements granted to the acceptor of a free trial as part of an agreement execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grants(Collection<GrantItem> grants);

        /**
         * <p>
         * Entitlements granted to the acceptor of a free trial as part of an agreement execution.
         * </p>
         * 
         * @param grants
         *        Entitlements granted to the acceptor of a free trial as part of an agreement execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grants(GrantItem... grants);

        /**
         * <p>
         * Entitlements granted to the acceptor of a free trial as part of an agreement execution.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.GrantItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.GrantItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.GrantItem.Builder#build()} is called
         * immediately and its result is passed to {@link #grants(List<GrantItem>)}.
         * 
         * @param grants
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.marketplaceagreement.model.GrantItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grants(java.util.Collection<GrantItem>)
         */
        Builder grants(Consumer<GrantItem.Builder>... grants);

        /**
         * <p>
         * Category of the term.
         * </p>
         * 
         * @param type
         *        Category of the term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String duration;

        private List<GrantItem> grants = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(FreeTrialPricingTerm model) {
            duration(model.duration);
            grants(model.grants);
            type(model.type);
        }

        public final String getDuration() {
            return duration;
        }

        public final void setDuration(String duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(String duration) {
            this.duration = duration;
            return this;
        }

        public final List<GrantItem.Builder> getGrants() {
            List<GrantItem.Builder> result = GrantListCopier.copyToBuilder(this.grants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGrants(Collection<GrantItem.BuilderImpl> grants) {
            this.grants = GrantListCopier.copyFromBuilder(grants);
        }

        @Override
        public final Builder grants(Collection<GrantItem> grants) {
            this.grants = GrantListCopier.copy(grants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grants(GrantItem... grants) {
            grants(Arrays.asList(grants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grants(Consumer<GrantItem.Builder>... grants) {
            grants(Stream.of(grants).map(c -> GrantItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public FreeTrialPricingTerm build() {
            return new FreeTrialPricingTerm(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
