/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplaceagreement.model.GrantItem;
import software.amazon.awssdk.services.marketplaceagreement.model.GrantListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FreeTrialPricingTerm
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FreeTrialPricingTerm> {
    private static final SdkField<String> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("duration").getter(FreeTrialPricingTerm.getter(FreeTrialPricingTerm::duration)).setter(FreeTrialPricingTerm.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()}).build();
    private static final SdkField<List<GrantItem>> GRANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("grants").getter(FreeTrialPricingTerm.getter(FreeTrialPricingTerm::grants)).setter(FreeTrialPricingTerm.setter(Builder::grants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GrantItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(FreeTrialPricingTerm.getter(FreeTrialPricingTerm::type)).setter(FreeTrialPricingTerm.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_FIELD, GRANTS_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FreeTrialPricingTerm.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String duration;
    private final List<GrantItem> grants;
    private final String type;

    private FreeTrialPricingTerm(BuilderImpl builder) {
        this.duration = builder.duration;
        this.grants = builder.grants;
        this.type = builder.type;
    }

    public final String duration() {
        return this.duration;
    }

    public final boolean hasGrants() {
        return this.grants != null && !(this.grants instanceof SdkAutoConstructList);
    }

    public final List<GrantItem> grants() {
        return this.grants;
    }

    public final String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGrants() ? this.grants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FreeTrialPricingTerm)) {
            return false;
        }
        FreeTrialPricingTerm other = (FreeTrialPricingTerm)obj;
        return Objects.equals(this.duration(), other.duration()) && this.hasGrants() == other.hasGrants() && Objects.equals(this.grants(), other.grants()) && Objects.equals(this.type(), other.type());
    }

    public final String toString() {
        return ToString.builder((String)"FreeTrialPricingTerm").add("Duration", (Object)this.duration()).add("Grants", this.hasGrants() ? this.grants() : null).add("Type", (Object)this.type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "grants": {
                return Optional.ofNullable(clazz.cast(this.grants()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("duration", DURATION_FIELD);
        map.put("grants", GRANTS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FreeTrialPricingTerm, T> g) {
        return obj -> g.apply((FreeTrialPricingTerm)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String duration;
        private List<GrantItem> grants = DefaultSdkAutoConstructList.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(FreeTrialPricingTerm model) {
            this.duration(model.duration);
            this.grants(model.grants);
            this.type(model.type);
        }

        public final String getDuration() {
            return this.duration;
        }

        public final void setDuration(String duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(String duration) {
            this.duration = duration;
            return this;
        }

        public final List<GrantItem.Builder> getGrants() {
            List<GrantItem.Builder> result = GrantListCopier.copyToBuilder(this.grants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGrants(Collection<GrantItem.BuilderImpl> grants) {
            this.grants = GrantListCopier.copyFromBuilder(grants);
        }

        @Override
        public final Builder grants(Collection<GrantItem> grants) {
            this.grants = GrantListCopier.copy(grants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grants(GrantItem ... grants) {
            this.grants(Arrays.asList(grants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grants(Consumer<GrantItem.Builder> ... grants) {
            this.grants(Stream.of(grants).map(c -> (GrantItem)((GrantItem.Builder)GrantItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public FreeTrialPricingTerm build() {
            return new FreeTrialPricingTerm(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FreeTrialPricingTerm> {
        public Builder duration(String var1);

        public Builder grants(Collection<GrantItem> var1);

        public Builder grants(GrantItem ... var1);

        public Builder grants(Consumer<GrantItem.Builder> ... var1);

        public Builder type(String var1);
    }
}

