/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Within the prepaid payment model defined under <code>ConfigurableUpfrontPricingTerm</code>, the
 * <code>RateCardItem</code> defines all the various rate cards (including pricing and dimensions) that have been
 * proposed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurableUpfrontRateCardItem implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurableUpfrontRateCardItem.Builder, ConfigurableUpfrontRateCardItem> {
    private static final SdkField<Constraints> CONSTRAINTS_FIELD = SdkField.<Constraints> builder(MarshallingType.SDK_POJO)
            .memberName("constraints").getter(getter(ConfigurableUpfrontRateCardItem::constraints))
            .setter(setter(Builder::constraints)).constructor(Constraints::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("constraints").build()).build();

    private static final SdkField<List<RateCardItem>> RATE_CARD_FIELD = SdkField
            .<List<RateCardItem>> builder(MarshallingType.LIST)
            .memberName("rateCard")
            .getter(getter(ConfigurableUpfrontRateCardItem::rateCard))
            .setter(setter(Builder::rateCard))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateCard").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RateCardItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(RateCardItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Selector> SELECTOR_FIELD = SdkField.<Selector> builder(MarshallingType.SDK_POJO)
            .memberName("selector").getter(getter(ConfigurableUpfrontRateCardItem::selector)).setter(setter(Builder::selector))
            .constructor(Selector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selector").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSTRAINTS_FIELD,
            RATE_CARD_FIELD, SELECTOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Constraints constraints;

    private final List<RateCardItem> rateCard;

    private final Selector selector;

    private ConfigurableUpfrontRateCardItem(BuilderImpl builder) {
        this.constraints = builder.constraints;
        this.rateCard = builder.rateCard;
        this.selector = builder.selector;
    }

    /**
     * <p>
     * Defines limits on how the term can be configured by acceptors.
     * </p>
     * 
     * @return Defines limits on how the term can be configured by acceptors.
     */
    public final Constraints constraints() {
        return constraints;
    }

    /**
     * For responses, this returns true if the service returned a value for the RateCard property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRateCard() {
        return rateCard != null && !(rateCard instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines the per unit rates for product dimensions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRateCard} method.
     * </p>
     * 
     * @return Defines the per unit rates for product dimensions.
     */
    public final List<RateCardItem> rateCard() {
        return rateCard;
    }

    /**
     * <p>
     * Differentiates between the mutually exclusive rate cards in the same pricing term to be selected by the buyer.
     * </p>
     * 
     * @return Differentiates between the mutually exclusive rate cards in the same pricing term to be selected by the
     *         buyer.
     */
    public final Selector selector() {
        return selector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(constraints());
        hashCode = 31 * hashCode + Objects.hashCode(hasRateCard() ? rateCard() : null);
        hashCode = 31 * hashCode + Objects.hashCode(selector());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurableUpfrontRateCardItem)) {
            return false;
        }
        ConfigurableUpfrontRateCardItem other = (ConfigurableUpfrontRateCardItem) obj;
        return Objects.equals(constraints(), other.constraints()) && hasRateCard() == other.hasRateCard()
                && Objects.equals(rateCard(), other.rateCard()) && Objects.equals(selector(), other.selector());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurableUpfrontRateCardItem").add("Constraints", constraints())
                .add("RateCard", hasRateCard() ? rateCard() : null).add("Selector", selector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "constraints":
            return Optional.ofNullable(clazz.cast(constraints()));
        case "rateCard":
            return Optional.ofNullable(clazz.cast(rateCard()));
        case "selector":
            return Optional.ofNullable(clazz.cast(selector()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("constraints", CONSTRAINTS_FIELD);
        map.put("rateCard", RATE_CARD_FIELD);
        map.put("selector", SELECTOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurableUpfrontRateCardItem, T> g) {
        return obj -> g.apply((ConfigurableUpfrontRateCardItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurableUpfrontRateCardItem> {
        /**
         * <p>
         * Defines limits on how the term can be configured by acceptors.
         * </p>
         * 
         * @param constraints
         *        Defines limits on how the term can be configured by acceptors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constraints(Constraints constraints);

        /**
         * <p>
         * Defines limits on how the term can be configured by acceptors.
         * </p>
         * This is a convenience method that creates an instance of the {@link Constraints.Builder} avoiding the need to
         * create one manually via {@link Constraints#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Constraints.Builder#build()} is called immediately and its result
         * is passed to {@link #constraints(Constraints)}.
         * 
         * @param constraints
         *        a consumer that will call methods on {@link Constraints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #constraints(Constraints)
         */
        default Builder constraints(Consumer<Constraints.Builder> constraints) {
            return constraints(Constraints.builder().applyMutation(constraints).build());
        }

        /**
         * <p>
         * Defines the per unit rates for product dimensions.
         * </p>
         * 
         * @param rateCard
         *        Defines the per unit rates for product dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rateCard(Collection<RateCardItem> rateCard);

        /**
         * <p>
         * Defines the per unit rates for product dimensions.
         * </p>
         * 
         * @param rateCard
         *        Defines the per unit rates for product dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rateCard(RateCardItem... rateCard);

        /**
         * <p>
         * Defines the per unit rates for product dimensions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.RateCardItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.RateCardItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.RateCardItem.Builder#build()} is called
         * immediately and its result is passed to {@link #rateCard(List<RateCardItem>)}.
         * 
         * @param rateCard
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.marketplaceagreement.model.RateCardItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rateCard(java.util.Collection<RateCardItem>)
         */
        Builder rateCard(Consumer<RateCardItem.Builder>... rateCard);

        /**
         * <p>
         * Differentiates between the mutually exclusive rate cards in the same pricing term to be selected by the
         * buyer.
         * </p>
         * 
         * @param selector
         *        Differentiates between the mutually exclusive rate cards in the same pricing term to be selected by
         *        the buyer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selector(Selector selector);

        /**
         * <p>
         * Differentiates between the mutually exclusive rate cards in the same pricing term to be selected by the
         * buyer.
         * </p>
         * This is a convenience method that creates an instance of the {@link Selector.Builder} avoiding the need to
         * create one manually via {@link Selector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Selector.Builder#build()} is called immediately and its result is
         * passed to {@link #selector(Selector)}.
         * 
         * @param selector
         *        a consumer that will call methods on {@link Selector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selector(Selector)
         */
        default Builder selector(Consumer<Selector.Builder> selector) {
            return selector(Selector.builder().applyMutation(selector).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Constraints constraints;

        private List<RateCardItem> rateCard = DefaultSdkAutoConstructList.getInstance();

        private Selector selector;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurableUpfrontRateCardItem model) {
            constraints(model.constraints);
            rateCard(model.rateCard);
            selector(model.selector);
        }

        public final Constraints.Builder getConstraints() {
            return constraints != null ? constraints.toBuilder() : null;
        }

        public final void setConstraints(Constraints.BuilderImpl constraints) {
            this.constraints = constraints != null ? constraints.build() : null;
        }

        @Override
        public final Builder constraints(Constraints constraints) {
            this.constraints = constraints;
            return this;
        }

        public final List<RateCardItem.Builder> getRateCard() {
            List<RateCardItem.Builder> result = RateCardListCopier.copyToBuilder(this.rateCard);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRateCard(Collection<RateCardItem.BuilderImpl> rateCard) {
            this.rateCard = RateCardListCopier.copyFromBuilder(rateCard);
        }

        @Override
        public final Builder rateCard(Collection<RateCardItem> rateCard) {
            this.rateCard = RateCardListCopier.copy(rateCard);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rateCard(RateCardItem... rateCard) {
            rateCard(Arrays.asList(rateCard));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rateCard(Consumer<RateCardItem.Builder>... rateCard) {
            rateCard(Stream.of(rateCard).map(c -> RateCardItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Selector.Builder getSelector() {
            return selector != null ? selector.toBuilder() : null;
        }

        public final void setSelector(Selector.BuilderImpl selector) {
            this.selector = selector != null ? selector.build() : null;
        }

        @Override
        public final Builder selector(Selector selector) {
            this.selector = selector;
            return this;
        }

        @Override
        public ConfigurableUpfrontRateCardItem build() {
            return new ConfigurableUpfrontRateCardItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
