/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the dimensions that the acceptor has purchased from the overall set of dimensions presented in the rate card.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Dimension implements SdkPojo, Serializable, ToCopyableBuilder<Dimension.Builder, Dimension> {
    private static final SdkField<String> DIMENSION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dimensionKey").getter(getter(Dimension::dimensionKey)).setter(setter(Builder::dimensionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimensionKey").build()).build();

    private static final SdkField<Integer> DIMENSION_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("dimensionValue").getter(getter(Dimension::dimensionValue)).setter(setter(Builder::dimensionValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimensionValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_KEY_FIELD,
            DIMENSION_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dimensionKey;

    private final Integer dimensionValue;

    private Dimension(BuilderImpl builder) {
        this.dimensionKey = builder.dimensionKey;
        this.dimensionValue = builder.dimensionValue;
    }

    /**
     * <p>
     * The name of key value of the dimension.
     * </p>
     * 
     * @return The name of key value of the dimension.
     */
    public final String dimensionKey() {
        return dimensionKey;
    }

    /**
     * <p>
     * The number of units of the dimension the acceptor has purchased.
     * </p>
     * <note>
     * <p>
     * For Agreements with <code>ConfigurableUpfrontPricingTerm</code>, the <code>RateCard</code> section will define
     * the prices and dimensions defined by the seller (proposer), whereas the <code>Configuration</code> section will
     * define the actual dimensions, prices, and units the buyer has chosen to accept.
     * </p>
     * </note>
     * 
     * @return The number of units of the dimension the acceptor has purchased.</p> <note>
     *         <p>
     *         For Agreements with <code>ConfigurableUpfrontPricingTerm</code>, the <code>RateCard</code> section will
     *         define the prices and dimensions defined by the seller (proposer), whereas the <code>Configuration</code>
     *         section will define the actual dimensions, prices, and units the buyer has chosen to accept.
     *         </p>
     */
    public final Integer dimensionValue() {
        return dimensionValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensionKey());
        hashCode = 31 * hashCode + Objects.hashCode(dimensionValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Dimension)) {
            return false;
        }
        Dimension other = (Dimension) obj;
        return Objects.equals(dimensionKey(), other.dimensionKey()) && Objects.equals(dimensionValue(), other.dimensionValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Dimension").add("DimensionKey", dimensionKey()).add("DimensionValue", dimensionValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dimensionKey":
            return Optional.ofNullable(clazz.cast(dimensionKey()));
        case "dimensionValue":
            return Optional.ofNullable(clazz.cast(dimensionValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dimensionKey", DIMENSION_KEY_FIELD);
        map.put("dimensionValue", DIMENSION_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Dimension, T> g) {
        return obj -> g.apply((Dimension) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Dimension> {
        /**
         * <p>
         * The name of key value of the dimension.
         * </p>
         * 
         * @param dimensionKey
         *        The name of key value of the dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionKey(String dimensionKey);

        /**
         * <p>
         * The number of units of the dimension the acceptor has purchased.
         * </p>
         * <note>
         * <p>
         * For Agreements with <code>ConfigurableUpfrontPricingTerm</code>, the <code>RateCard</code> section will
         * define the prices and dimensions defined by the seller (proposer), whereas the <code>Configuration</code>
         * section will define the actual dimensions, prices, and units the buyer has chosen to accept.
         * </p>
         * </note>
         * 
         * @param dimensionValue
         *        The number of units of the dimension the acceptor has purchased.</p> <note>
         *        <p>
         *        For Agreements with <code>ConfigurableUpfrontPricingTerm</code>, the <code>RateCard</code> section
         *        will define the prices and dimensions defined by the seller (proposer), whereas the
         *        <code>Configuration</code> section will define the actual dimensions, prices, and units the buyer has
         *        chosen to accept.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionValue(Integer dimensionValue);
    }

    static final class BuilderImpl implements Builder {
        private String dimensionKey;

        private Integer dimensionValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Dimension model) {
            dimensionKey(model.dimensionKey);
            dimensionValue(model.dimensionValue);
        }

        public final String getDimensionKey() {
            return dimensionKey;
        }

        public final void setDimensionKey(String dimensionKey) {
            this.dimensionKey = dimensionKey;
        }

        @Override
        public final Builder dimensionKey(String dimensionKey) {
            this.dimensionKey = dimensionKey;
            return this;
        }

        public final Integer getDimensionValue() {
            return dimensionValue;
        }

        public final void setDimensionValue(Integer dimensionValue) {
            this.dimensionValue = dimensionValue;
        }

        @Override
        public final Builder dimensionValue(Integer dimensionValue) {
            this.dimensionValue = dimensionValue;
            return this;
        }

        @Override
        public Dimension build() {
            return new Dimension(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
