/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Includes the list of references to legal resources proposed by the proposer to the acceptor. Each
 * <code>DocumentItem</code> refers to an individual reference.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentItem implements SdkPojo, Serializable, ToCopyableBuilder<DocumentItem.Builder, DocumentItem> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(DocumentItem::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("url")
            .getter(getter(DocumentItem::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(DocumentItem::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, URL_FIELD,
            VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String url;

    private final String version;

    private DocumentItem(BuilderImpl builder) {
        this.type = builder.type;
        this.url = builder.url;
        this.version = builder.version;
    }

    /**
     * <p>
     * Category of the document. Document types include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CustomEula</code> – A custom EULA provided by you as seller. A URL for a EULA stored in an accessible
     * Amazon S3 bucket is required for this document type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CustomDsa</code> – A custom Data Subscription Agreement (DSA) provided by you as seller. A URL for a DSA
     * stored in an accessible Amazon S3 bucket is required for this document type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>StandardEula</code> – The Standard Contract for AWS Marketplace (SCMP). For more information about SCMP,
     * see the AWS Marketplace Seller Guide. You don’t provide a URL for this type because it’s managed by AWS
     * Marketplace.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>StandardDsa</code> – DSA for AWS Marketplace. For more information about the DSA, see the AWS Data Exchange
     * User Guide. You don’t provide a URL for this type because it’s managed by AWS Marketplace.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Category of the document. Document types include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CustomEula</code> – A custom EULA provided by you as seller. A URL for a EULA stored in an
     *         accessible Amazon S3 bucket is required for this document type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CustomDsa</code> – A custom Data Subscription Agreement (DSA) provided by you as seller. A URL for
     *         a DSA stored in an accessible Amazon S3 bucket is required for this document type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>StandardEula</code> – The Standard Contract for AWS Marketplace (SCMP). For more information about
     *         SCMP, see the AWS Marketplace Seller Guide. You don’t provide a URL for this type because it’s managed by
     *         AWS Marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>StandardDsa</code> – DSA for AWS Marketplace. For more information about the DSA, see the AWS Data
     *         Exchange User Guide. You don’t provide a URL for this type because it’s managed by AWS Marketplace.
     *         </p>
     *         </li>
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * A URL to the legal document for buyers to read. Required when <code>Type</code> is <code>CustomEula</code>.
     * </p>
     * 
     * @return A URL to the legal document for buyers to read. Required when <code>Type</code> is
     *         <code>CustomEula</code>.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * Version of standard contracts provided by AWS Marketplace. Required when Type is <code>StandardEula</code> or
     * <code>StandardDsa</code>.
     * </p>
     * 
     * @return Version of standard contracts provided by AWS Marketplace. Required when Type is
     *         <code>StandardEula</code> or <code>StandardDsa</code>.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentItem)) {
            return false;
        }
        DocumentItem other = (DocumentItem) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(url(), other.url())
                && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentItem").add("Type", type()).add("Url", url()).add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "url":
            return Optional.ofNullable(clazz.cast(url()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("url", URL_FIELD);
        map.put("version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentItem, T> g) {
        return obj -> g.apply((DocumentItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentItem> {
        /**
         * <p>
         * Category of the document. Document types include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CustomEula</code> – A custom EULA provided by you as seller. A URL for a EULA stored in an accessible
         * Amazon S3 bucket is required for this document type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CustomDsa</code> – A custom Data Subscription Agreement (DSA) provided by you as seller. A URL for a
         * DSA stored in an accessible Amazon S3 bucket is required for this document type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>StandardEula</code> – The Standard Contract for AWS Marketplace (SCMP). For more information about
         * SCMP, see the AWS Marketplace Seller Guide. You don’t provide a URL for this type because it’s managed by AWS
         * Marketplace.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>StandardDsa</code> – DSA for AWS Marketplace. For more information about the DSA, see the AWS Data
         * Exchange User Guide. You don’t provide a URL for this type because it’s managed by AWS Marketplace.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        Category of the document. Document types include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CustomEula</code> – A custom EULA provided by you as seller. A URL for a EULA stored in an
         *        accessible Amazon S3 bucket is required for this document type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CustomDsa</code> – A custom Data Subscription Agreement (DSA) provided by you as seller. A URL
         *        for a DSA stored in an accessible Amazon S3 bucket is required for this document type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>StandardEula</code> – The Standard Contract for AWS Marketplace (SCMP). For more information
         *        about SCMP, see the AWS Marketplace Seller Guide. You don’t provide a URL for this type because it’s
         *        managed by AWS Marketplace.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>StandardDsa</code> – DSA for AWS Marketplace. For more information about the DSA, see the AWS
         *        Data Exchange User Guide. You don’t provide a URL for this type because it’s managed by AWS
         *        Marketplace.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * A URL to the legal document for buyers to read. Required when <code>Type</code> is <code>CustomEula</code>.
         * </p>
         * 
         * @param url
         *        A URL to the legal document for buyers to read. Required when <code>Type</code> is
         *        <code>CustomEula</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * Version of standard contracts provided by AWS Marketplace. Required when Type is <code>StandardEula</code> or
         * <code>StandardDsa</code>.
         * </p>
         * 
         * @param version
         *        Version of standard contracts provided by AWS Marketplace. Required when Type is
         *        <code>StandardEula</code> or <code>StandardDsa</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String url;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentItem model) {
            type(model.type);
            url(model.url);
            version(model.version);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public DocumentItem build() {
            return new DocumentItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
