/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Estimated cost of the agreement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EstimatedCharges implements SdkPojo, Serializable,
        ToCopyableBuilder<EstimatedCharges.Builder, EstimatedCharges> {
    private static final SdkField<String> AGREEMENT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agreementValue").getter(getter(EstimatedCharges::agreementValue))
            .setter(setter(Builder::agreementValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agreementValue").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currencyCode").getter(getter(EstimatedCharges::currencyCode)).setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencyCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGREEMENT_VALUE_FIELD,
            CURRENCY_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String agreementValue;

    private final String currencyCode;

    private EstimatedCharges(BuilderImpl builder) {
        this.agreementValue = builder.agreementValue;
        this.currencyCode = builder.currencyCode;
    }

    /**
     * <p>
     * The total known amount customer has to pay across the lifecycle of the agreement.
     * </p>
     * <note>
     * <p>
     * This is the total contract value if accepted terms contain <code>ConfigurableUpfrontPricingTerm</code> or
     * <code>FixedUpfrontPricingTerm</code>. In the case of pure contract pricing, this will be the total value of the
     * contract. In the case of contracts with consumption pricing, this will only include the committed value and not
     * include any overages that occur.
     * </p>
     * <p>
     * If the accepted terms contain <code>PaymentScheduleTerm</code>, it will be the total payment schedule amount.
     * This occurs when flexible payment schedule is used, and is the sum of all invoice charges in the payment
     * schedule.
     * </p>
     * <p>
     * In case a customer has amended an agreement, by purchasing more units of any dimension, this will include both
     * the original cost as well as the added cost incurred due to addition of new units.
     * </p>
     * <p>
     * This is <code>0</code> if the accepted terms contain <code>UsageBasedPricingTerm</code> without
     * <code>ConfigurableUpfrontPricingTerm</code> or <code>RecurringPaymentTerm</code>. This occurs for usage-based
     * pricing (such as SaaS metered or AMI/container hourly or monthly), because the exact usage is not known upfront.
     * </p>
     * </note>
     * 
     * @return The total known amount customer has to pay across the lifecycle of the agreement.</p> <note>
     *         <p>
     *         This is the total contract value if accepted terms contain <code>ConfigurableUpfrontPricingTerm</code> or
     *         <code>FixedUpfrontPricingTerm</code>. In the case of pure contract pricing, this will be the total value
     *         of the contract. In the case of contracts with consumption pricing, this will only include the committed
     *         value and not include any overages that occur.
     *         </p>
     *         <p>
     *         If the accepted terms contain <code>PaymentScheduleTerm</code>, it will be the total payment schedule
     *         amount. This occurs when flexible payment schedule is used, and is the sum of all invoice charges in the
     *         payment schedule.
     *         </p>
     *         <p>
     *         In case a customer has amended an agreement, by purchasing more units of any dimension, this will include
     *         both the original cost as well as the added cost incurred due to addition of new units.
     *         </p>
     *         <p>
     *         This is <code>0</code> if the accepted terms contain <code>UsageBasedPricingTerm</code> without
     *         <code>ConfigurableUpfrontPricingTerm</code> or <code>RecurringPaymentTerm</code>. This occurs for
     *         usage-based pricing (such as SaaS metered or AMI/container hourly or monthly), because the exact usage is
     *         not known upfront.
     *         </p>
     */
    public final String agreementValue() {
        return agreementValue;
    }

    /**
     * <p>
     * Defines the currency code for the charge.
     * </p>
     * 
     * @return Defines the currency code for the charge.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agreementValue());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EstimatedCharges)) {
            return false;
        }
        EstimatedCharges other = (EstimatedCharges) obj;
        return Objects.equals(agreementValue(), other.agreementValue()) && Objects.equals(currencyCode(), other.currencyCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EstimatedCharges").add("AgreementValue", agreementValue()).add("CurrencyCode", currencyCode())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agreementValue":
            return Optional.ofNullable(clazz.cast(agreementValue()));
        case "currencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agreementValue", AGREEMENT_VALUE_FIELD);
        map.put("currencyCode", CURRENCY_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EstimatedCharges, T> g) {
        return obj -> g.apply((EstimatedCharges) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EstimatedCharges> {
        /**
         * <p>
         * The total known amount customer has to pay across the lifecycle of the agreement.
         * </p>
         * <note>
         * <p>
         * This is the total contract value if accepted terms contain <code>ConfigurableUpfrontPricingTerm</code> or
         * <code>FixedUpfrontPricingTerm</code>. In the case of pure contract pricing, this will be the total value of
         * the contract. In the case of contracts with consumption pricing, this will only include the committed value
         * and not include any overages that occur.
         * </p>
         * <p>
         * If the accepted terms contain <code>PaymentScheduleTerm</code>, it will be the total payment schedule amount.
         * This occurs when flexible payment schedule is used, and is the sum of all invoice charges in the payment
         * schedule.
         * </p>
         * <p>
         * In case a customer has amended an agreement, by purchasing more units of any dimension, this will include
         * both the original cost as well as the added cost incurred due to addition of new units.
         * </p>
         * <p>
         * This is <code>0</code> if the accepted terms contain <code>UsageBasedPricingTerm</code> without
         * <code>ConfigurableUpfrontPricingTerm</code> or <code>RecurringPaymentTerm</code>. This occurs for usage-based
         * pricing (such as SaaS metered or AMI/container hourly or monthly), because the exact usage is not known
         * upfront.
         * </p>
         * </note>
         * 
         * @param agreementValue
         *        The total known amount customer has to pay across the lifecycle of the agreement.</p> <note>
         *        <p>
         *        This is the total contract value if accepted terms contain <code>ConfigurableUpfrontPricingTerm</code>
         *        or <code>FixedUpfrontPricingTerm</code>. In the case of pure contract pricing, this will be the total
         *        value of the contract. In the case of contracts with consumption pricing, this will only include the
         *        committed value and not include any overages that occur.
         *        </p>
         *        <p>
         *        If the accepted terms contain <code>PaymentScheduleTerm</code>, it will be the total payment schedule
         *        amount. This occurs when flexible payment schedule is used, and is the sum of all invoice charges in
         *        the payment schedule.
         *        </p>
         *        <p>
         *        In case a customer has amended an agreement, by purchasing more units of any dimension, this will
         *        include both the original cost as well as the added cost incurred due to addition of new units.
         *        </p>
         *        <p>
         *        This is <code>0</code> if the accepted terms contain <code>UsageBasedPricingTerm</code> without
         *        <code>ConfigurableUpfrontPricingTerm</code> or <code>RecurringPaymentTerm</code>. This occurs for
         *        usage-based pricing (such as SaaS metered or AMI/container hourly or monthly), because the exact usage
         *        is not known upfront.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agreementValue(String agreementValue);

        /**
         * <p>
         * Defines the currency code for the charge.
         * </p>
         * 
         * @param currencyCode
         *        Defines the currency code for the charge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);
    }

    static final class BuilderImpl implements Builder {
        private String agreementValue;

        private String currencyCode;

        private BuilderImpl() {
        }

        private BuilderImpl(EstimatedCharges model) {
            agreementValue(model.agreementValue);
            currencyCode(model.currencyCode);
        }

        public final String getAgreementValue() {
            return agreementValue;
        }

        public final void setAgreementValue(String agreementValue) {
            this.agreementValue = agreementValue;
        }

        @Override
        public final Builder agreementValue(String agreementValue) {
            this.agreementValue = agreementValue;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public EstimatedCharges build() {
            return new EstimatedCharges(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
