/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Entitlements granted to the acceptor of fixed upfront as part of agreement execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GrantItem implements SdkPojo, Serializable, ToCopyableBuilder<GrantItem.Builder, GrantItem> {
    private static final SdkField<String> DIMENSION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dimensionKey").getter(getter(GrantItem::dimensionKey)).setter(setter(Builder::dimensionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimensionKey").build()).build();

    private static final SdkField<Integer> MAX_QUANTITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxQuantity").getter(getter(GrantItem::maxQuantity)).setter(setter(Builder::maxQuantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxQuantity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_KEY_FIELD,
            MAX_QUANTITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dimensionKey;

    private final Integer maxQuantity;

    private GrantItem(BuilderImpl builder) {
        this.dimensionKey = builder.dimensionKey;
        this.maxQuantity = builder.maxQuantity;
    }

    /**
     * <p>
     * Unique dimension key defined in the product document. Dimensions represent categories of capacity in a product
     * and are specified when the product is listed in AWS Marketplace.
     * </p>
     * 
     * @return Unique dimension key defined in the product document. Dimensions represent categories of capacity in a
     *         product and are specified when the product is listed in AWS Marketplace.
     */
    public final String dimensionKey() {
        return dimensionKey;
    }

    /**
     * <p>
     * Maximum amount of capacity that the buyer can be entitled to the given dimension of the product. If
     * <code>MaxQuantity</code> is not provided, the buyer will be able to use an unlimited amount of the given
     * dimension.
     * </p>
     * 
     * @return Maximum amount of capacity that the buyer can be entitled to the given dimension of the product. If
     *         <code>MaxQuantity</code> is not provided, the buyer will be able to use an unlimited amount of the given
     *         dimension.
     */
    public final Integer maxQuantity() {
        return maxQuantity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensionKey());
        hashCode = 31 * hashCode + Objects.hashCode(maxQuantity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrantItem)) {
            return false;
        }
        GrantItem other = (GrantItem) obj;
        return Objects.equals(dimensionKey(), other.dimensionKey()) && Objects.equals(maxQuantity(), other.maxQuantity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GrantItem").add("DimensionKey", dimensionKey()).add("MaxQuantity", maxQuantity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dimensionKey":
            return Optional.ofNullable(clazz.cast(dimensionKey()));
        case "maxQuantity":
            return Optional.ofNullable(clazz.cast(maxQuantity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dimensionKey", DIMENSION_KEY_FIELD);
        map.put("maxQuantity", MAX_QUANTITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GrantItem, T> g) {
        return obj -> g.apply((GrantItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GrantItem> {
        /**
         * <p>
         * Unique dimension key defined in the product document. Dimensions represent categories of capacity in a
         * product and are specified when the product is listed in AWS Marketplace.
         * </p>
         * 
         * @param dimensionKey
         *        Unique dimension key defined in the product document. Dimensions represent categories of capacity in a
         *        product and are specified when the product is listed in AWS Marketplace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionKey(String dimensionKey);

        /**
         * <p>
         * Maximum amount of capacity that the buyer can be entitled to the given dimension of the product. If
         * <code>MaxQuantity</code> is not provided, the buyer will be able to use an unlimited amount of the given
         * dimension.
         * </p>
         * 
         * @param maxQuantity
         *        Maximum amount of capacity that the buyer can be entitled to the given dimension of the product. If
         *        <code>MaxQuantity</code> is not provided, the buyer will be able to use an unlimited amount of the
         *        given dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxQuantity(Integer maxQuantity);
    }

    static final class BuilderImpl implements Builder {
        private String dimensionKey;

        private Integer maxQuantity;

        private BuilderImpl() {
        }

        private BuilderImpl(GrantItem model) {
            dimensionKey(model.dimensionKey);
            maxQuantity(model.maxQuantity);
        }

        public final String getDimensionKey() {
            return dimensionKey;
        }

        public final void setDimensionKey(String dimensionKey) {
            this.dimensionKey = dimensionKey;
        }

        @Override
        public final Builder dimensionKey(String dimensionKey) {
            this.dimensionKey = dimensionKey;
            return this;
        }

        public final Integer getMaxQuantity() {
            return maxQuantity;
        }

        public final void setMaxQuantity(Integer maxQuantity) {
            this.maxQuantity = maxQuantity;
        }

        @Override
        public final Builder maxQuantity(Integer maxQuantity) {
            this.maxQuantity = maxQuantity;
            return this;
        }

        @Override
        public GrantItem build() {
            return new GrantItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
