/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines that on graceful expiration of the agreement (when the agreement ends on its pre-defined end date), a new
 * agreement will be created using the accepted terms on the existing agreement. In other words, the agreement will be
 * renewed. The presence of <code>RenewalTerm</code> in the offer document means that auto-renewal is allowed. Buyers
 * will have the option to accept or decline auto-renewal at the offer acceptance/agreement creation. Buyers can also
 * change this flag from <code>True</code> to <code>False</code> or <code>False</code> to <code>True</code> at anytime
 * during the agreement's lifecycle.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RenewalTerm implements SdkPojo, Serializable, ToCopyableBuilder<RenewalTerm.Builder, RenewalTerm> {
    private static final SdkField<RenewalTermConfiguration> CONFIGURATION_FIELD = SdkField
            .<RenewalTermConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(RenewalTerm::configuration)).setter(setter(Builder::configuration))
            .constructor(RenewalTermConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(RenewalTerm::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD,
            TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RenewalTermConfiguration configuration;

    private final String type;

    private RenewalTerm(BuilderImpl builder) {
        this.configuration = builder.configuration;
        this.type = builder.type;
    }

    /**
     * <p>
     * Additional parameters specified by the acceptor while accepting the term.
     * </p>
     * 
     * @return Additional parameters specified by the acceptor while accepting the term.
     */
    public final RenewalTermConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * Category of the term being updated.
     * </p>
     * 
     * @return Category of the term being updated.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenewalTerm)) {
            return false;
        }
        RenewalTerm other = (RenewalTerm) obj;
        return Objects.equals(configuration(), other.configuration()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RenewalTerm").add("Configuration", configuration()).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RenewalTerm, T> g) {
        return obj -> g.apply((RenewalTerm) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RenewalTerm> {
        /**
         * <p>
         * Additional parameters specified by the acceptor while accepting the term.
         * </p>
         * 
         * @param configuration
         *        Additional parameters specified by the acceptor while accepting the term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(RenewalTermConfiguration configuration);

        /**
         * <p>
         * Additional parameters specified by the acceptor while accepting the term.
         * </p>
         * This is a convenience method that creates an instance of the {@link RenewalTermConfiguration.Builder}
         * avoiding the need to create one manually via {@link RenewalTermConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RenewalTermConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(RenewalTermConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link RenewalTermConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(RenewalTermConfiguration)
         */
        default Builder configuration(Consumer<RenewalTermConfiguration.Builder> configuration) {
            return configuration(RenewalTermConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * Category of the term being updated.
         * </p>
         * 
         * @param type
         *        Category of the term being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private RenewalTermConfiguration configuration;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RenewalTerm model) {
            configuration(model.configuration);
            type(model.type);
        }

        public final RenewalTermConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(RenewalTermConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(RenewalTermConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public RenewalTerm build() {
            return new RenewalTerm(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
