/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional parameters specified by the acceptor while accepting the term.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RenewalTermConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RenewalTermConfiguration.Builder, RenewalTermConfiguration> {
    private static final SdkField<Boolean> ENABLE_AUTO_RENEW_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableAutoRenew").getter(getter(RenewalTermConfiguration::enableAutoRenew))
            .setter(setter(Builder::enableAutoRenew))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableAutoRenew").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_AUTO_RENEW_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enableAutoRenew;

    private RenewalTermConfiguration(BuilderImpl builder) {
        this.enableAutoRenew = builder.enableAutoRenew;
    }

    /**
     * <p>
     * Defines whether the acceptor has chosen to auto-renew the agreement at the end of its lifecycle. Can be set to
     * <code>True</code> or <code>False</code>.
     * </p>
     * 
     * @return Defines whether the acceptor has chosen to auto-renew the agreement at the end of its lifecycle. Can be
     *         set to <code>True</code> or <code>False</code>.
     */
    public final Boolean enableAutoRenew() {
        return enableAutoRenew;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableAutoRenew());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenewalTermConfiguration)) {
            return false;
        }
        RenewalTermConfiguration other = (RenewalTermConfiguration) obj;
        return Objects.equals(enableAutoRenew(), other.enableAutoRenew());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RenewalTermConfiguration").add("EnableAutoRenew", enableAutoRenew()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enableAutoRenew":
            return Optional.ofNullable(clazz.cast(enableAutoRenew()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enableAutoRenew", ENABLE_AUTO_RENEW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RenewalTermConfiguration, T> g) {
        return obj -> g.apply((RenewalTermConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RenewalTermConfiguration> {
        /**
         * <p>
         * Defines whether the acceptor has chosen to auto-renew the agreement at the end of its lifecycle. Can be set
         * to <code>True</code> or <code>False</code>.
         * </p>
         * 
         * @param enableAutoRenew
         *        Defines whether the acceptor has chosen to auto-renew the agreement at the end of its lifecycle. Can
         *        be set to <code>True</code> or <code>False</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableAutoRenew(Boolean enableAutoRenew);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableAutoRenew;

        private BuilderImpl() {
        }

        private BuilderImpl(RenewalTermConfiguration model) {
            enableAutoRenew(model.enableAutoRenew);
        }

        public final Boolean getEnableAutoRenew() {
            return enableAutoRenew;
        }

        public final void setEnableAutoRenew(Boolean enableAutoRenew) {
            this.enableAutoRenew = enableAutoRenew;
        }

        @Override
        public final Builder enableAutoRenew(Boolean enableAutoRenew) {
            this.enableAutoRenew = enableAutoRenew;
            return this;
        }

        @Override
        public RenewalTermConfiguration build() {
            return new RenewalTermConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
