/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceagreement.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchAgreementsRequest extends MarketplaceAgreementRequest implements
        ToCopyableBuilder<SearchAgreementsRequest.Builder, SearchAgreementsRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("catalog")
            .getter(getter(SearchAgreementsRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalog").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(SearchAgreementsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(SearchAgreementsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(SearchAgreementsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Sort> SORT_FIELD = SdkField.<Sort> builder(MarshallingType.SDK_POJO).memberName("sort")
            .getter(getter(SearchAgreementsRequest::sort)).setter(setter(Builder::sort)).constructor(Sort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sort").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, FILTERS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final List<Filter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private final Sort sort;

    private SearchAgreementsRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sort = builder.sort;
    }

    /**
     * <p>
     * The catalog in which the agreement was created.
     * </p>
     * 
     * @return The catalog in which the agreement was created.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filter name and value pair used to return a specific list of results.
     * </p>
     * <p>
     * The following filters are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ResourceIdentifier</code> – The unique identifier of the resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ResourceType</code> – Type of the resource, which is the product (<code>AmiProduct</code>,
     * <code>ContainerProduct</code>, or <code>SaaSProduct</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PartyType</code> – The party type (either <code>Acceptor</code> or <code>Proposer</code>) of the caller.
     * For agreements where the caller is the proposer, use the <code>Proposer</code> filter. For agreements where the
     * caller is the acceptor, use the <code>Acceptor</code> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AcceptorAccountId</code> – The AWS account ID of the party accepting the agreement terms.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OfferId</code> – The unique identifier of the offer in which the terms are registered in the agreement
     * token.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Status</code> – The current status of the agreement. Values include <code>ACTIVE</code>,
     * <code>ARCHIVED</code>, <code>CANCELLED</code>, <code>EXPIRED</code>, <code>RENEWED</code>, <code>REPLACED</code>,
     * and <code>TERMINATED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BeforeEndTime</code> – A date used to filter agreements with a date before the <code>endTime</code> of an
     * agreement.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AfterEndTime</code> – A date used to filter agreements with a date after the <code>endTime</code> of an
     * agreement.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AgreementType</code> – The type of agreement. Values include <code>PurchaseAgreement</code> or
     * <code>VendorInsightsAgreement</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filter name and value pair used to return a specific list of results.</p>
     *         <p>
     *         The following filters are supported:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ResourceIdentifier</code> – The unique identifier of the resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ResourceType</code> – Type of the resource, which is the product (<code>AmiProduct</code>,
     *         <code>ContainerProduct</code>, or <code>SaaSProduct</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PartyType</code> – The party type (either <code>Acceptor</code> or <code>Proposer</code>) of the
     *         caller. For agreements where the caller is the proposer, use the <code>Proposer</code> filter. For
     *         agreements where the caller is the acceptor, use the <code>Acceptor</code> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AcceptorAccountId</code> – The AWS account ID of the party accepting the agreement terms.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OfferId</code> – The unique identifier of the offer in which the terms are registered in the
     *         agreement token.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Status</code> – The current status of the agreement. Values include <code>ACTIVE</code>,
     *         <code>ARCHIVED</code>, <code>CANCELLED</code>, <code>EXPIRED</code>, <code>RENEWED</code>,
     *         <code>REPLACED</code>, and <code>TERMINATED</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BeforeEndTime</code> – A date used to filter agreements with a date before the <code>endTime</code>
     *         of an agreement.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AfterEndTime</code> – A date used to filter agreements with a date after the <code>endTime</code>
     *         of an agreement.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AgreementType</code> – The type of agreement. Values include <code>PurchaseAgreement</code> or
     *         <code>VendorInsightsAgreement</code>.
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of agreements to return in the response.
     * </p>
     * 
     * @return The maximum number of agreements to return in the response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token to specify where to start pagination.
     * </p>
     * 
     * @return A token to specify where to start pagination.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * An object that contains the <code>SortBy</code> and <code>SortOrder</code> attributes.
     * </p>
     * 
     * @return An object that contains the <code>SortBy</code> and <code>SortOrder</code> attributes.
     */
    public final Sort sort() {
        return sort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sort());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchAgreementsRequest)) {
            return false;
        }
        SearchAgreementsRequest other = (SearchAgreementsRequest) obj;
        return Objects.equals(catalog(), other.catalog()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(sort(), other.sort());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchAgreementsRequest").add("Catalog", catalog())
                .add("Filters", hasFilters() ? filters() : null).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("Sort", sort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "sort":
            return Optional.ofNullable(clazz.cast(sort()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("catalog", CATALOG_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("sort", SORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchAgreementsRequest, T> g) {
        return obj -> g.apply((SearchAgreementsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MarketplaceAgreementRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SearchAgreementsRequest> {
        /**
         * <p>
         * The catalog in which the agreement was created.
         * </p>
         * 
         * @param catalog
         *        The catalog in which the agreement was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The filter name and value pair used to return a specific list of results.
         * </p>
         * <p>
         * The following filters are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ResourceIdentifier</code> – The unique identifier of the resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ResourceType</code> – Type of the resource, which is the product (<code>AmiProduct</code>,
         * <code>ContainerProduct</code>, or <code>SaaSProduct</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PartyType</code> – The party type (either <code>Acceptor</code> or <code>Proposer</code>) of the
         * caller. For agreements where the caller is the proposer, use the <code>Proposer</code> filter. For agreements
         * where the caller is the acceptor, use the <code>Acceptor</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AcceptorAccountId</code> – The AWS account ID of the party accepting the agreement terms.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OfferId</code> – The unique identifier of the offer in which the terms are registered in the agreement
         * token.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Status</code> – The current status of the agreement. Values include <code>ACTIVE</code>,
         * <code>ARCHIVED</code>, <code>CANCELLED</code>, <code>EXPIRED</code>, <code>RENEWED</code>,
         * <code>REPLACED</code>, and <code>TERMINATED</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BeforeEndTime</code> – A date used to filter agreements with a date before the <code>endTime</code> of
         * an agreement.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AfterEndTime</code> – A date used to filter agreements with a date after the <code>endTime</code> of an
         * agreement.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AgreementType</code> – The type of agreement. Values include <code>PurchaseAgreement</code> or
         * <code>VendorInsightsAgreement</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filter name and value pair used to return a specific list of results.</p>
         *        <p>
         *        The following filters are supported:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ResourceIdentifier</code> – The unique identifier of the resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ResourceType</code> – Type of the resource, which is the product (<code>AmiProduct</code>,
         *        <code>ContainerProduct</code>, or <code>SaaSProduct</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PartyType</code> – The party type (either <code>Acceptor</code> or <code>Proposer</code>) of the
         *        caller. For agreements where the caller is the proposer, use the <code>Proposer</code> filter. For
         *        agreements where the caller is the acceptor, use the <code>Acceptor</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AcceptorAccountId</code> – The AWS account ID of the party accepting the agreement terms.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OfferId</code> – The unique identifier of the offer in which the terms are registered in the
         *        agreement token.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Status</code> – The current status of the agreement. Values include <code>ACTIVE</code>,
         *        <code>ARCHIVED</code>, <code>CANCELLED</code>, <code>EXPIRED</code>, <code>RENEWED</code>,
         *        <code>REPLACED</code>, and <code>TERMINATED</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BeforeEndTime</code> – A date used to filter agreements with a date before the
         *        <code>endTime</code> of an agreement.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AfterEndTime</code> – A date used to filter agreements with a date after the
         *        <code>endTime</code> of an agreement.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AgreementType</code> – The type of agreement. Values include <code>PurchaseAgreement</code> or
         *        <code>VendorInsightsAgreement</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filter name and value pair used to return a specific list of results.
         * </p>
         * <p>
         * The following filters are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ResourceIdentifier</code> – The unique identifier of the resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ResourceType</code> – Type of the resource, which is the product (<code>AmiProduct</code>,
         * <code>ContainerProduct</code>, or <code>SaaSProduct</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PartyType</code> – The party type (either <code>Acceptor</code> or <code>Proposer</code>) of the
         * caller. For agreements where the caller is the proposer, use the <code>Proposer</code> filter. For agreements
         * where the caller is the acceptor, use the <code>Acceptor</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AcceptorAccountId</code> – The AWS account ID of the party accepting the agreement terms.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OfferId</code> – The unique identifier of the offer in which the terms are registered in the agreement
         * token.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Status</code> – The current status of the agreement. Values include <code>ACTIVE</code>,
         * <code>ARCHIVED</code>, <code>CANCELLED</code>, <code>EXPIRED</code>, <code>RENEWED</code>,
         * <code>REPLACED</code>, and <code>TERMINATED</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BeforeEndTime</code> – A date used to filter agreements with a date before the <code>endTime</code> of
         * an agreement.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AfterEndTime</code> – A date used to filter agreements with a date after the <code>endTime</code> of an
         * agreement.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AgreementType</code> – The type of agreement. Values include <code>PurchaseAgreement</code> or
         * <code>VendorInsightsAgreement</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filter name and value pair used to return a specific list of results.</p>
         *        <p>
         *        The following filters are supported:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ResourceIdentifier</code> – The unique identifier of the resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ResourceType</code> – Type of the resource, which is the product (<code>AmiProduct</code>,
         *        <code>ContainerProduct</code>, or <code>SaaSProduct</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PartyType</code> – The party type (either <code>Acceptor</code> or <code>Proposer</code>) of the
         *        caller. For agreements where the caller is the proposer, use the <code>Proposer</code> filter. For
         *        agreements where the caller is the acceptor, use the <code>Acceptor</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AcceptorAccountId</code> – The AWS account ID of the party accepting the agreement terms.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OfferId</code> – The unique identifier of the offer in which the terms are registered in the
         *        agreement token.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Status</code> – The current status of the agreement. Values include <code>ACTIVE</code>,
         *        <code>ARCHIVED</code>, <code>CANCELLED</code>, <code>EXPIRED</code>, <code>RENEWED</code>,
         *        <code>REPLACED</code>, and <code>TERMINATED</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BeforeEndTime</code> – A date used to filter agreements with a date before the
         *        <code>endTime</code> of an agreement.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AfterEndTime</code> – A date used to filter agreements with a date after the
         *        <code>endTime</code> of an agreement.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AgreementType</code> – The type of agreement. Values include <code>PurchaseAgreement</code> or
         *        <code>VendorInsightsAgreement</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The filter name and value pair used to return a specific list of results.
         * </p>
         * <p>
         * The following filters are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ResourceIdentifier</code> – The unique identifier of the resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ResourceType</code> – Type of the resource, which is the product (<code>AmiProduct</code>,
         * <code>ContainerProduct</code>, or <code>SaaSProduct</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PartyType</code> – The party type (either <code>Acceptor</code> or <code>Proposer</code>) of the
         * caller. For agreements where the caller is the proposer, use the <code>Proposer</code> filter. For agreements
         * where the caller is the acceptor, use the <code>Acceptor</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AcceptorAccountId</code> – The AWS account ID of the party accepting the agreement terms.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OfferId</code> – The unique identifier of the offer in which the terms are registered in the agreement
         * token.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Status</code> – The current status of the agreement. Values include <code>ACTIVE</code>,
         * <code>ARCHIVED</code>, <code>CANCELLED</code>, <code>EXPIRED</code>, <code>RENEWED</code>,
         * <code>REPLACED</code>, and <code>TERMINATED</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BeforeEndTime</code> – A date used to filter agreements with a date before the <code>endTime</code> of
         * an agreement.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AfterEndTime</code> – A date used to filter agreements with a date after the <code>endTime</code> of an
         * agreement.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AgreementType</code> – The type of agreement. Values include <code>PurchaseAgreement</code> or
         * <code>VendorInsightsAgreement</code>.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.Filter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.marketplaceagreement.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.Filter.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.marketplaceagreement.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The maximum number of agreements to return in the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of agreements to return in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token to specify where to start pagination.
         * </p>
         * 
         * @param nextToken
         *        A token to specify where to start pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An object that contains the <code>SortBy</code> and <code>SortOrder</code> attributes.
         * </p>
         * 
         * @param sort
         *        An object that contains the <code>SortBy</code> and <code>SortOrder</code> attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sort(Sort sort);

        /**
         * <p>
         * An object that contains the <code>SortBy</code> and <code>SortOrder</code> attributes.
         * </p>
         * This is a convenience method that creates an instance of the {@link Sort.Builder} avoiding the need to create
         * one manually via {@link Sort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Sort.Builder#build()} is called immediately and its result is
         * passed to {@link #sort(Sort)}.
         * 
         * @param sort
         *        a consumer that will call methods on {@link Sort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sort(Sort)
         */
        default Builder sort(Consumer<Sort.Builder> sort) {
            return sort(Sort.builder().applyMutation(sort).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MarketplaceAgreementRequest.BuilderImpl implements Builder {
        private String catalog;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private Sort sort;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchAgreementsRequest model) {
            super(model);
            catalog(model.catalog);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            sort(model.sort);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Sort.Builder getSort() {
            return sort != null ? sort.toBuilder() : null;
        }

        public final void setSort(Sort.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(Sort sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchAgreementsRequest build() {
            return new SearchAgreementsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
