/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecommerceanalytics;

import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.marketplacecommerceanalytics.MarketplaceCommerceAnalyticsClient;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.GenerateDataSetRequest;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.GenerateDataSetResponse;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.MarketplaceCommerceAnalyticsException;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.MarketplaceCommerceAnalyticsServiceException;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.StartSupportDataExportRequest;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.StartSupportDataExportResponse;
import software.amazon.awssdk.services.marketplacecommerceanalytics.transform.GenerateDataSetRequestMarshaller;
import software.amazon.awssdk.services.marketplacecommerceanalytics.transform.GenerateDataSetResponseUnmarshaller;
import software.amazon.awssdk.services.marketplacecommerceanalytics.transform.StartSupportDataExportRequestMarshaller;
import software.amazon.awssdk.services.marketplacecommerceanalytics.transform.StartSupportDataExportResponseUnmarshaller;

@SdkInternalApi
final class DefaultMarketplaceCommerceAnalyticsClient
implements MarketplaceCommerceAnalyticsClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final AwsSyncClientParams clientParams;

    protected DefaultMarketplaceCommerceAnalyticsClient(AwsSyncClientParams clientParams) {
        this.clientHandler = new SdkClientHandler(new ClientHandlerParams().withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.clientParams = clientParams;
        this.protocolFactory = this.init();
    }

    @Override
    public GenerateDataSetResponse generateDataSet(GenerateDataSetRequest generateDataSetRequest) throws MarketplaceCommerceAnalyticsServiceException, SdkBaseException, SdkClientException, MarketplaceCommerceAnalyticsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GenerateDataSetResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GenerateDataSetResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)generateDataSetRequest).withMarshaller((Marshaller)new GenerateDataSetRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public StartSupportDataExportResponse startSupportDataExport(StartSupportDataExportRequest startSupportDataExportRequest) throws MarketplaceCommerceAnalyticsServiceException, SdkBaseException, SdkClientException, MarketplaceCommerceAnalyticsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new StartSupportDataExportResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (StartSupportDataExportResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)startSupportDataExportRequest).withMarshaller((Marshaller)new StartSupportDataExportRequestMarshaller(this.protocolFactory))));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(MarketplaceCommerceAnalyticsException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MarketplaceCommerceAnalyticsServiceException").withModeledClass(MarketplaceCommerceAnalyticsServiceException.class)));
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }
}

