/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecommerceanalytics.model;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Container for the parameters to the GenerateDataSet operation.
 */
@Generated("software.amazon.awssdk:codegen")
public class GenerateDataSetRequest extends MarketplaceCommerceAnalyticsRequest implements
        ToCopyableBuilder<GenerateDataSetRequest.Builder, GenerateDataSetRequest> {
    private final String dataSetType;

    private final Instant dataSetPublicationDate;

    private final String roleNameArn;

    private final String destinationS3BucketName;

    private final String destinationS3Prefix;

    private final String snsTopicArn;

    private final Map<String, String> customerDefinedValues;

    private GenerateDataSetRequest(BuilderImpl builder) {
        super(builder);
        this.dataSetType = builder.dataSetType;
        this.dataSetPublicationDate = builder.dataSetPublicationDate;
        this.roleNameArn = builder.roleNameArn;
        this.destinationS3BucketName = builder.destinationS3BucketName;
        this.destinationS3Prefix = builder.destinationS3Prefix;
        this.snsTopicArn = builder.snsTopicArn;
        this.customerDefinedValues = builder.customerDefinedValues;
    }

    /**
     * <p>
     * The desired data set type.
     * </p>
     * <p>
     * <ul>
     * <li><strong>customer_subscriber_hourly_monthly_subscriptions</strong>
     * <p>
     * From 2014-07-21 to present: Available daily by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>customer_subscriber_annual_subscriptions</strong>
     * <p>
     * From 2014-07-21 to present: Available daily by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>daily_business_usage_by_instance_type</strong>
     * <p>
     * From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>daily_business_fees</strong>
     * <p>
     * From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>daily_business_free_trial_conversions</strong>
     * <p>
     * From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>daily_business_new_instances</strong>
     * <p>
     * From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>daily_business_new_product_subscribers</strong>
     * <p>
     * From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>daily_business_canceled_product_subscribers</strong>
     * <p>
     * From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>monthly_revenue_billing_and_revenue_data</strong>
     * <p>
     * From 2015-02 to 2017-06: Available monthly on the 4th day of the month by 5:00pm Pacific Time. Data includes
     * metered transactions (e.g. hourly) from two months prior.
     * </p>
     * <p>
     * From 2017-07 to present: Available monthly on the 15th day of the month by 5:00pm Pacific Time. Data includes
     * metered transactions (e.g. hourly) from one month prior.
     * </p>
     * </li>
     * <li><strong>monthly_revenue_annual_subscriptions</strong>
     * <p>
     * From 2015-02 to 2017-06: Available monthly on the 4th day of the month by 5:00pm Pacific Time. Data includes
     * up-front software charges (e.g. annual) from one month prior.
     * </p>
     * <p>
     * From 2017-07 to present: Available monthly on the 15th day of the month by 5:00pm Pacific Time. Data includes
     * up-front software charges (e.g. annual) from one month prior.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_product</strong>
     * <p>
     * From 2015-01-26 to present: Available every 30 days by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_product_with_uncollected_funds</strong>
     * <p>
     * From 2012-04-19 to 2015-01-25: Available every 30 days by 5:00 PM Pacific Time.
     * </p>
     * <p>
     * From 2015-01-26 to present: This data set was split into three data sets: disbursed_amount_by_product,
     * disbursed_amount_by_age_of_uncollected_funds, and disbursed_amount_by_age_of_disbursed_funds.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_instance_hours</strong>
     * <p>
     * From 2012-09-04 to present: Available every 30 days by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_customer_geo</strong>
     * <p>
     * From 2012-04-19 to present: Available every 30 days by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_age_of_uncollected_funds</strong>
     * <p>
     * From 2015-01-26 to present: Available every 30 days by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_age_of_disbursed_funds</strong>
     * <p>
     * From 2015-01-26 to present: Available every 30 days by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>customer_profile_by_industry</strong>
     * <p>
     * From 2015-10-01 to 2017-06-29: Available daily by 5:00 PM Pacific Time.
     * </p>
     * <p>
     * From 2017-06-30 to present: This data set is no longer available.
     * </p>
     * </li>
     * <li><strong>customer_profile_by_revenue</strong>
     * <p>
     * From 2015-10-01 to 2017-06-29: Available daily by 5:00 PM Pacific Time.
     * </p>
     * <p>
     * From 2017-06-30 to present: This data set is no longer available.
     * </p>
     * </li>
     * <li><strong>customer_profile_by_geography</strong>
     * <p>
     * From 2015-10-01 to 2017-06-29: Available daily by 5:00 PM Pacific Time.
     * </p>
     * <p>
     * From 2017-06-30 to present: This data set is no longer available.
     * </p>
     * </li>
     * <li><strong>sales_compensation_billed_revenue</strong>
     * <p>
     * From 2016-12 to 2017-06: Available monthly on the 4th day of the month by 5:00pm Pacific Time. Data includes
     * metered transactions (e.g. hourly) from two months prior, and up-front software charges (e.g. annual) from one
     * month prior.
     * </p>
     * <p>
     * From 2017-06 to present: Available monthly on the 15th day of the month by 5:00pm Pacific Time. Data includes
     * metered transactions (e.g. hourly) from one month prior, and up-front software charges (e.g. annual) from one
     * month prior.
     * </p>
     * </li>
     * <li><strong>us_sales_and_use_tax_records</strong>
     * <p>
     * From 2017-02-15 to present: Available monthly on the 15th day of the month by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * </ul>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSetType} will
     * return {@link DataSetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataSetTypeAsString}.
     * </p>
     * 
     * @return The desired data set type.</p>
     *         <p>
     *         <ul>
     *         <li><strong>customer_subscriber_hourly_monthly_subscriptions</strong>
     *         <p>
     *         From 2014-07-21 to present: Available daily by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>customer_subscriber_annual_subscriptions</strong>
     *         <p>
     *         From 2014-07-21 to present: Available daily by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>daily_business_usage_by_instance_type</strong>
     *         <p>
     *         From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>daily_business_fees</strong>
     *         <p>
     *         From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>daily_business_free_trial_conversions</strong>
     *         <p>
     *         From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>daily_business_new_instances</strong>
     *         <p>
     *         From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>daily_business_new_product_subscribers</strong>
     *         <p>
     *         From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>daily_business_canceled_product_subscribers</strong>
     *         <p>
     *         From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>monthly_revenue_billing_and_revenue_data</strong>
     *         <p>
     *         From 2015-02 to 2017-06: Available monthly on the 4th day of the month by 5:00pm Pacific Time. Data
     *         includes metered transactions (e.g. hourly) from two months prior.
     *         </p>
     *         <p>
     *         From 2017-07 to present: Available monthly on the 15th day of the month by 5:00pm Pacific Time. Data
     *         includes metered transactions (e.g. hourly) from one month prior.
     *         </p>
     *         </li>
     *         <li><strong>monthly_revenue_annual_subscriptions</strong>
     *         <p>
     *         From 2015-02 to 2017-06: Available monthly on the 4th day of the month by 5:00pm Pacific Time. Data
     *         includes up-front software charges (e.g. annual) from one month prior.
     *         </p>
     *         <p>
     *         From 2017-07 to present: Available monthly on the 15th day of the month by 5:00pm Pacific Time. Data
     *         includes up-front software charges (e.g. annual) from one month prior.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_product</strong>
     *         <p>
     *         From 2015-01-26 to present: Available every 30 days by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_product_with_uncollected_funds</strong>
     *         <p>
     *         From 2012-04-19 to 2015-01-25: Available every 30 days by 5:00 PM Pacific Time.
     *         </p>
     *         <p>
     *         From 2015-01-26 to present: This data set was split into three data sets: disbursed_amount_by_product,
     *         disbursed_amount_by_age_of_uncollected_funds, and disbursed_amount_by_age_of_disbursed_funds.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_instance_hours</strong>
     *         <p>
     *         From 2012-09-04 to present: Available every 30 days by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_customer_geo</strong>
     *         <p>
     *         From 2012-04-19 to present: Available every 30 days by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_age_of_uncollected_funds</strong>
     *         <p>
     *         From 2015-01-26 to present: Available every 30 days by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_age_of_disbursed_funds</strong>
     *         <p>
     *         From 2015-01-26 to present: Available every 30 days by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>customer_profile_by_industry</strong>
     *         <p>
     *         From 2015-10-01 to 2017-06-29: Available daily by 5:00 PM Pacific Time.
     *         </p>
     *         <p>
     *         From 2017-06-30 to present: This data set is no longer available.
     *         </p>
     *         </li>
     *         <li><strong>customer_profile_by_revenue</strong>
     *         <p>
     *         From 2015-10-01 to 2017-06-29: Available daily by 5:00 PM Pacific Time.
     *         </p>
     *         <p>
     *         From 2017-06-30 to present: This data set is no longer available.
     *         </p>
     *         </li>
     *         <li><strong>customer_profile_by_geography</strong>
     *         <p>
     *         From 2015-10-01 to 2017-06-29: Available daily by 5:00 PM Pacific Time.
     *         </p>
     *         <p>
     *         From 2017-06-30 to present: This data set is no longer available.
     *         </p>
     *         </li>
     *         <li><strong>sales_compensation_billed_revenue</strong>
     *         <p>
     *         From 2016-12 to 2017-06: Available monthly on the 4th day of the month by 5:00pm Pacific Time. Data
     *         includes metered transactions (e.g. hourly) from two months prior, and up-front software charges (e.g.
     *         annual) from one month prior.
     *         </p>
     *         <p>
     *         From 2017-06 to present: Available monthly on the 15th day of the month by 5:00pm Pacific Time. Data
     *         includes metered transactions (e.g. hourly) from one month prior, and up-front software charges (e.g.
     *         annual) from one month prior.
     *         </p>
     *         </li>
     *         <li><strong>us_sales_and_use_tax_records</strong>
     *         <p>
     *         From 2017-02-15 to present: Available monthly on the 15th day of the month by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         </ul>
     * @see DataSetType
     */
    public DataSetType dataSetType() {
        return DataSetType.fromValue(dataSetType);
    }

    /**
     * <p>
     * The desired data set type.
     * </p>
     * <p>
     * <ul>
     * <li><strong>customer_subscriber_hourly_monthly_subscriptions</strong>
     * <p>
     * From 2014-07-21 to present: Available daily by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>customer_subscriber_annual_subscriptions</strong>
     * <p>
     * From 2014-07-21 to present: Available daily by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>daily_business_usage_by_instance_type</strong>
     * <p>
     * From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>daily_business_fees</strong>
     * <p>
     * From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>daily_business_free_trial_conversions</strong>
     * <p>
     * From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>daily_business_new_instances</strong>
     * <p>
     * From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>daily_business_new_product_subscribers</strong>
     * <p>
     * From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>daily_business_canceled_product_subscribers</strong>
     * <p>
     * From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>monthly_revenue_billing_and_revenue_data</strong>
     * <p>
     * From 2015-02 to 2017-06: Available monthly on the 4th day of the month by 5:00pm Pacific Time. Data includes
     * metered transactions (e.g. hourly) from two months prior.
     * </p>
     * <p>
     * From 2017-07 to present: Available monthly on the 15th day of the month by 5:00pm Pacific Time. Data includes
     * metered transactions (e.g. hourly) from one month prior.
     * </p>
     * </li>
     * <li><strong>monthly_revenue_annual_subscriptions</strong>
     * <p>
     * From 2015-02 to 2017-06: Available monthly on the 4th day of the month by 5:00pm Pacific Time. Data includes
     * up-front software charges (e.g. annual) from one month prior.
     * </p>
     * <p>
     * From 2017-07 to present: Available monthly on the 15th day of the month by 5:00pm Pacific Time. Data includes
     * up-front software charges (e.g. annual) from one month prior.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_product</strong>
     * <p>
     * From 2015-01-26 to present: Available every 30 days by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_product_with_uncollected_funds</strong>
     * <p>
     * From 2012-04-19 to 2015-01-25: Available every 30 days by 5:00 PM Pacific Time.
     * </p>
     * <p>
     * From 2015-01-26 to present: This data set was split into three data sets: disbursed_amount_by_product,
     * disbursed_amount_by_age_of_uncollected_funds, and disbursed_amount_by_age_of_disbursed_funds.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_instance_hours</strong>
     * <p>
     * From 2012-09-04 to present: Available every 30 days by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_customer_geo</strong>
     * <p>
     * From 2012-04-19 to present: Available every 30 days by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_age_of_uncollected_funds</strong>
     * <p>
     * From 2015-01-26 to present: Available every 30 days by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_age_of_disbursed_funds</strong>
     * <p>
     * From 2015-01-26 to present: Available every 30 days by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * <li><strong>customer_profile_by_industry</strong>
     * <p>
     * From 2015-10-01 to 2017-06-29: Available daily by 5:00 PM Pacific Time.
     * </p>
     * <p>
     * From 2017-06-30 to present: This data set is no longer available.
     * </p>
     * </li>
     * <li><strong>customer_profile_by_revenue</strong>
     * <p>
     * From 2015-10-01 to 2017-06-29: Available daily by 5:00 PM Pacific Time.
     * </p>
     * <p>
     * From 2017-06-30 to present: This data set is no longer available.
     * </p>
     * </li>
     * <li><strong>customer_profile_by_geography</strong>
     * <p>
     * From 2015-10-01 to 2017-06-29: Available daily by 5:00 PM Pacific Time.
     * </p>
     * <p>
     * From 2017-06-30 to present: This data set is no longer available.
     * </p>
     * </li>
     * <li><strong>sales_compensation_billed_revenue</strong>
     * <p>
     * From 2016-12 to 2017-06: Available monthly on the 4th day of the month by 5:00pm Pacific Time. Data includes
     * metered transactions (e.g. hourly) from two months prior, and up-front software charges (e.g. annual) from one
     * month prior.
     * </p>
     * <p>
     * From 2017-06 to present: Available monthly on the 15th day of the month by 5:00pm Pacific Time. Data includes
     * metered transactions (e.g. hourly) from one month prior, and up-front software charges (e.g. annual) from one
     * month prior.
     * </p>
     * </li>
     * <li><strong>us_sales_and_use_tax_records</strong>
     * <p>
     * From 2017-02-15 to present: Available monthly on the 15th day of the month by 5:00 PM Pacific Time.
     * </p>
     * </li>
     * </ul>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSetType} will
     * return {@link DataSetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataSetTypeAsString}.
     * </p>
     * 
     * @return The desired data set type.</p>
     *         <p>
     *         <ul>
     *         <li><strong>customer_subscriber_hourly_monthly_subscriptions</strong>
     *         <p>
     *         From 2014-07-21 to present: Available daily by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>customer_subscriber_annual_subscriptions</strong>
     *         <p>
     *         From 2014-07-21 to present: Available daily by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>daily_business_usage_by_instance_type</strong>
     *         <p>
     *         From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>daily_business_fees</strong>
     *         <p>
     *         From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>daily_business_free_trial_conversions</strong>
     *         <p>
     *         From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>daily_business_new_instances</strong>
     *         <p>
     *         From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>daily_business_new_product_subscribers</strong>
     *         <p>
     *         From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>daily_business_canceled_product_subscribers</strong>
     *         <p>
     *         From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>monthly_revenue_billing_and_revenue_data</strong>
     *         <p>
     *         From 2015-02 to 2017-06: Available monthly on the 4th day of the month by 5:00pm Pacific Time. Data
     *         includes metered transactions (e.g. hourly) from two months prior.
     *         </p>
     *         <p>
     *         From 2017-07 to present: Available monthly on the 15th day of the month by 5:00pm Pacific Time. Data
     *         includes metered transactions (e.g. hourly) from one month prior.
     *         </p>
     *         </li>
     *         <li><strong>monthly_revenue_annual_subscriptions</strong>
     *         <p>
     *         From 2015-02 to 2017-06: Available monthly on the 4th day of the month by 5:00pm Pacific Time. Data
     *         includes up-front software charges (e.g. annual) from one month prior.
     *         </p>
     *         <p>
     *         From 2017-07 to present: Available monthly on the 15th day of the month by 5:00pm Pacific Time. Data
     *         includes up-front software charges (e.g. annual) from one month prior.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_product</strong>
     *         <p>
     *         From 2015-01-26 to present: Available every 30 days by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_product_with_uncollected_funds</strong>
     *         <p>
     *         From 2012-04-19 to 2015-01-25: Available every 30 days by 5:00 PM Pacific Time.
     *         </p>
     *         <p>
     *         From 2015-01-26 to present: This data set was split into three data sets: disbursed_amount_by_product,
     *         disbursed_amount_by_age_of_uncollected_funds, and disbursed_amount_by_age_of_disbursed_funds.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_instance_hours</strong>
     *         <p>
     *         From 2012-09-04 to present: Available every 30 days by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_customer_geo</strong>
     *         <p>
     *         From 2012-04-19 to present: Available every 30 days by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_age_of_uncollected_funds</strong>
     *         <p>
     *         From 2015-01-26 to present: Available every 30 days by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_age_of_disbursed_funds</strong>
     *         <p>
     *         From 2015-01-26 to present: Available every 30 days by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         <li><strong>customer_profile_by_industry</strong>
     *         <p>
     *         From 2015-10-01 to 2017-06-29: Available daily by 5:00 PM Pacific Time.
     *         </p>
     *         <p>
     *         From 2017-06-30 to present: This data set is no longer available.
     *         </p>
     *         </li>
     *         <li><strong>customer_profile_by_revenue</strong>
     *         <p>
     *         From 2015-10-01 to 2017-06-29: Available daily by 5:00 PM Pacific Time.
     *         </p>
     *         <p>
     *         From 2017-06-30 to present: This data set is no longer available.
     *         </p>
     *         </li>
     *         <li><strong>customer_profile_by_geography</strong>
     *         <p>
     *         From 2015-10-01 to 2017-06-29: Available daily by 5:00 PM Pacific Time.
     *         </p>
     *         <p>
     *         From 2017-06-30 to present: This data set is no longer available.
     *         </p>
     *         </li>
     *         <li><strong>sales_compensation_billed_revenue</strong>
     *         <p>
     *         From 2016-12 to 2017-06: Available monthly on the 4th day of the month by 5:00pm Pacific Time. Data
     *         includes metered transactions (e.g. hourly) from two months prior, and up-front software charges (e.g.
     *         annual) from one month prior.
     *         </p>
     *         <p>
     *         From 2017-06 to present: Available monthly on the 15th day of the month by 5:00pm Pacific Time. Data
     *         includes metered transactions (e.g. hourly) from one month prior, and up-front software charges (e.g.
     *         annual) from one month prior.
     *         </p>
     *         </li>
     *         <li><strong>us_sales_and_use_tax_records</strong>
     *         <p>
     *         From 2017-02-15 to present: Available monthly on the 15th day of the month by 5:00 PM Pacific Time.
     *         </p>
     *         </li>
     *         </ul>
     * @see DataSetType
     */
    public String dataSetTypeAsString() {
        return dataSetType;
    }

    /**
     * The date a data set was published. For daily data sets, provide a date with day-level granularity for the desired
     * day. For weekly data sets, provide a date with day-level granularity within the desired week (the day value will
     * be ignored). For monthly data sets, provide a date with month-level granularity for the desired month (the day
     * value will be ignored).
     * 
     * @return The date a data set was published. For daily data sets, provide a date with day-level granularity for the
     *         desired day. For weekly data sets, provide a date with day-level granularity within the desired week (the
     *         day value will be ignored). For monthly data sets, provide a date with month-level granularity for the
     *         desired month (the day value will be ignored).
     */
    public Instant dataSetPublicationDate() {
        return dataSetPublicationDate;
    }

    /**
     * The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the provided AWS
     * services.
     * 
     * @return The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the
     *         provided AWS services.
     */
    public String roleNameArn() {
        return roleNameArn;
    }

    /**
     * The name (friendly name, not ARN) of the destination S3 bucket.
     * 
     * @return The name (friendly name, not ARN) of the destination S3 bucket.
     */
    public String destinationS3BucketName() {
        return destinationS3BucketName;
    }

    /**
     * (Optional) The desired S3 prefix for the published data set, similar to a directory path in standard file
     * systems. For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets", the output file
     * "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile". If the prefix directory
     * structure does not exist, it will be created. If no prefix is provided, the data set will be published to the S3
     * bucket root.
     * 
     * @return (Optional) The desired S3 prefix for the published data set, similar to a directory path in standard file
     *         systems. For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets", the
     *         output file "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile". If the
     *         prefix directory structure does not exist, it will be created. If no prefix is provided, the data set
     *         will be published to the S3 bucket root.
     */
    public String destinationS3Prefix() {
        return destinationS3Prefix;
    }

    /**
     * Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been published or if an
     * error has occurred.
     * 
     * @return Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been published
     *         or if an error has occurred.
     */
    public String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * (Optional) Key-value pairs which will be returned, unmodified, in the Amazon SNS notification message and the
     * data set metadata file. These key-value pairs can be used to correlated responses with tracking information from
     * other systems.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return (Optional) Key-value pairs which will be returned, unmodified, in the Amazon SNS notification message and
     *         the data set metadata file. These key-value pairs can be used to correlated responses with tracking
     *         information from other systems.
     */
    public Map<String, String> customerDefinedValues() {
        return customerDefinedValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetPublicationDate());
        hashCode = 31 * hashCode + Objects.hashCode(roleNameArn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(destinationS3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(customerDefinedValues());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateDataSetRequest)) {
            return false;
        }
        GenerateDataSetRequest other = (GenerateDataSetRequest) obj;
        return Objects.equals(dataSetTypeAsString(), other.dataSetTypeAsString())
                && Objects.equals(dataSetPublicationDate(), other.dataSetPublicationDate())
                && Objects.equals(roleNameArn(), other.roleNameArn())
                && Objects.equals(destinationS3BucketName(), other.destinationS3BucketName())
                && Objects.equals(destinationS3Prefix(), other.destinationS3Prefix())
                && Objects.equals(snsTopicArn(), other.snsTopicArn())
                && Objects.equals(customerDefinedValues(), other.customerDefinedValues());
    }

    @Override
    public String toString() {
        return ToString.builder("GenerateDataSetRequest").add("DataSetType", dataSetTypeAsString())
                .add("DataSetPublicationDate", dataSetPublicationDate()).add("RoleNameArn", roleNameArn())
                .add("DestinationS3BucketName", destinationS3BucketName()).add("DestinationS3Prefix", destinationS3Prefix())
                .add("SnsTopicArn", snsTopicArn()).add("CustomerDefinedValues", customerDefinedValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSetType":
            return Optional.of(clazz.cast(dataSetTypeAsString()));
        case "dataSetPublicationDate":
            return Optional.of(clazz.cast(dataSetPublicationDate()));
        case "roleNameArn":
            return Optional.of(clazz.cast(roleNameArn()));
        case "destinationS3BucketName":
            return Optional.of(clazz.cast(destinationS3BucketName()));
        case "destinationS3Prefix":
            return Optional.of(clazz.cast(destinationS3Prefix()));
        case "snsTopicArn":
            return Optional.of(clazz.cast(snsTopicArn()));
        case "customerDefinedValues":
            return Optional.of(clazz.cast(customerDefinedValues()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MarketplaceCommerceAnalyticsRequest.Builder,
            CopyableBuilder<Builder, GenerateDataSetRequest> {
        /**
         * <p>
         * The desired data set type.
         * </p>
         * <p>
         * <ul>
         * <li><strong>customer_subscriber_hourly_monthly_subscriptions</strong>
         * <p>
         * From 2014-07-21 to present: Available daily by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>customer_subscriber_annual_subscriptions</strong>
         * <p>
         * From 2014-07-21 to present: Available daily by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>daily_business_usage_by_instance_type</strong>
         * <p>
         * From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>daily_business_fees</strong>
         * <p>
         * From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>daily_business_free_trial_conversions</strong>
         * <p>
         * From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>daily_business_new_instances</strong>
         * <p>
         * From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>daily_business_new_product_subscribers</strong>
         * <p>
         * From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>daily_business_canceled_product_subscribers</strong>
         * <p>
         * From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>monthly_revenue_billing_and_revenue_data</strong>
         * <p>
         * From 2015-02 to 2017-06: Available monthly on the 4th day of the month by 5:00pm Pacific Time. Data includes
         * metered transactions (e.g. hourly) from two months prior.
         * </p>
         * <p>
         * From 2017-07 to present: Available monthly on the 15th day of the month by 5:00pm Pacific Time. Data includes
         * metered transactions (e.g. hourly) from one month prior.
         * </p>
         * </li>
         * <li><strong>monthly_revenue_annual_subscriptions</strong>
         * <p>
         * From 2015-02 to 2017-06: Available monthly on the 4th day of the month by 5:00pm Pacific Time. Data includes
         * up-front software charges (e.g. annual) from one month prior.
         * </p>
         * <p>
         * From 2017-07 to present: Available monthly on the 15th day of the month by 5:00pm Pacific Time. Data includes
         * up-front software charges (e.g. annual) from one month prior.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_product</strong>
         * <p>
         * From 2015-01-26 to present: Available every 30 days by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_product_with_uncollected_funds</strong>
         * <p>
         * From 2012-04-19 to 2015-01-25: Available every 30 days by 5:00 PM Pacific Time.
         * </p>
         * <p>
         * From 2015-01-26 to present: This data set was split into three data sets: disbursed_amount_by_product,
         * disbursed_amount_by_age_of_uncollected_funds, and disbursed_amount_by_age_of_disbursed_funds.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_instance_hours</strong>
         * <p>
         * From 2012-09-04 to present: Available every 30 days by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_customer_geo</strong>
         * <p>
         * From 2012-04-19 to present: Available every 30 days by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_age_of_uncollected_funds</strong>
         * <p>
         * From 2015-01-26 to present: Available every 30 days by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_age_of_disbursed_funds</strong>
         * <p>
         * From 2015-01-26 to present: Available every 30 days by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>customer_profile_by_industry</strong>
         * <p>
         * From 2015-10-01 to 2017-06-29: Available daily by 5:00 PM Pacific Time.
         * </p>
         * <p>
         * From 2017-06-30 to present: This data set is no longer available.
         * </p>
         * </li>
         * <li><strong>customer_profile_by_revenue</strong>
         * <p>
         * From 2015-10-01 to 2017-06-29: Available daily by 5:00 PM Pacific Time.
         * </p>
         * <p>
         * From 2017-06-30 to present: This data set is no longer available.
         * </p>
         * </li>
         * <li><strong>customer_profile_by_geography</strong>
         * <p>
         * From 2015-10-01 to 2017-06-29: Available daily by 5:00 PM Pacific Time.
         * </p>
         * <p>
         * From 2017-06-30 to present: This data set is no longer available.
         * </p>
         * </li>
         * <li><strong>sales_compensation_billed_revenue</strong>
         * <p>
         * From 2016-12 to 2017-06: Available monthly on the 4th day of the month by 5:00pm Pacific Time. Data includes
         * metered transactions (e.g. hourly) from two months prior, and up-front software charges (e.g. annual) from
         * one month prior.
         * </p>
         * <p>
         * From 2017-06 to present: Available monthly on the 15th day of the month by 5:00pm Pacific Time. Data includes
         * metered transactions (e.g. hourly) from one month prior, and up-front software charges (e.g. annual) from one
         * month prior.
         * </p>
         * </li>
         * <li><strong>us_sales_and_use_tax_records</strong>
         * <p>
         * From 2017-02-15 to present: Available monthly on the 15th day of the month by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * </ul>
         * </p>
         * 
         * @param dataSetType
         *        The desired data set type.</p>
         *        <p>
         *        <ul>
         *        <li><strong>customer_subscriber_hourly_monthly_subscriptions</strong>
         *        <p>
         *        From 2014-07-21 to present: Available daily by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>customer_subscriber_annual_subscriptions</strong>
         *        <p>
         *        From 2014-07-21 to present: Available daily by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>daily_business_usage_by_instance_type</strong>
         *        <p>
         *        From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>daily_business_fees</strong>
         *        <p>
         *        From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>daily_business_free_trial_conversions</strong>
         *        <p>
         *        From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>daily_business_new_instances</strong>
         *        <p>
         *        From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>daily_business_new_product_subscribers</strong>
         *        <p>
         *        From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>daily_business_canceled_product_subscribers</strong>
         *        <p>
         *        From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>monthly_revenue_billing_and_revenue_data</strong>
         *        <p>
         *        From 2015-02 to 2017-06: Available monthly on the 4th day of the month by 5:00pm Pacific Time. Data
         *        includes metered transactions (e.g. hourly) from two months prior.
         *        </p>
         *        <p>
         *        From 2017-07 to present: Available monthly on the 15th day of the month by 5:00pm Pacific Time. Data
         *        includes metered transactions (e.g. hourly) from one month prior.
         *        </p>
         *        </li>
         *        <li><strong>monthly_revenue_annual_subscriptions</strong>
         *        <p>
         *        From 2015-02 to 2017-06: Available monthly on the 4th day of the month by 5:00pm Pacific Time. Data
         *        includes up-front software charges (e.g. annual) from one month prior.
         *        </p>
         *        <p>
         *        From 2017-07 to present: Available monthly on the 15th day of the month by 5:00pm Pacific Time. Data
         *        includes up-front software charges (e.g. annual) from one month prior.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_product</strong>
         *        <p>
         *        From 2015-01-26 to present: Available every 30 days by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_product_with_uncollected_funds</strong>
         *        <p>
         *        From 2012-04-19 to 2015-01-25: Available every 30 days by 5:00 PM Pacific Time.
         *        </p>
         *        <p>
         *        From 2015-01-26 to present: This data set was split into three data sets: disbursed_amount_by_product,
         *        disbursed_amount_by_age_of_uncollected_funds, and disbursed_amount_by_age_of_disbursed_funds.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_instance_hours</strong>
         *        <p>
         *        From 2012-09-04 to present: Available every 30 days by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_customer_geo</strong>
         *        <p>
         *        From 2012-04-19 to present: Available every 30 days by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_age_of_uncollected_funds</strong>
         *        <p>
         *        From 2015-01-26 to present: Available every 30 days by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_age_of_disbursed_funds</strong>
         *        <p>
         *        From 2015-01-26 to present: Available every 30 days by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>customer_profile_by_industry</strong>
         *        <p>
         *        From 2015-10-01 to 2017-06-29: Available daily by 5:00 PM Pacific Time.
         *        </p>
         *        <p>
         *        From 2017-06-30 to present: This data set is no longer available.
         *        </p>
         *        </li>
         *        <li><strong>customer_profile_by_revenue</strong>
         *        <p>
         *        From 2015-10-01 to 2017-06-29: Available daily by 5:00 PM Pacific Time.
         *        </p>
         *        <p>
         *        From 2017-06-30 to present: This data set is no longer available.
         *        </p>
         *        </li>
         *        <li><strong>customer_profile_by_geography</strong>
         *        <p>
         *        From 2015-10-01 to 2017-06-29: Available daily by 5:00 PM Pacific Time.
         *        </p>
         *        <p>
         *        From 2017-06-30 to present: This data set is no longer available.
         *        </p>
         *        </li>
         *        <li><strong>sales_compensation_billed_revenue</strong>
         *        <p>
         *        From 2016-12 to 2017-06: Available monthly on the 4th day of the month by 5:00pm Pacific Time. Data
         *        includes metered transactions (e.g. hourly) from two months prior, and up-front software charges (e.g.
         *        annual) from one month prior.
         *        </p>
         *        <p>
         *        From 2017-06 to present: Available monthly on the 15th day of the month by 5:00pm Pacific Time. Data
         *        includes metered transactions (e.g. hourly) from one month prior, and up-front software charges (e.g.
         *        annual) from one month prior.
         *        </p>
         *        </li>
         *        <li><strong>us_sales_and_use_tax_records</strong>
         *        <p>
         *        From 2017-02-15 to present: Available monthly on the 15th day of the month by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        </ul>
         * @see DataSetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSetType
         */
        Builder dataSetType(String dataSetType);

        /**
         * <p>
         * The desired data set type.
         * </p>
         * <p>
         * <ul>
         * <li><strong>customer_subscriber_hourly_monthly_subscriptions</strong>
         * <p>
         * From 2014-07-21 to present: Available daily by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>customer_subscriber_annual_subscriptions</strong>
         * <p>
         * From 2014-07-21 to present: Available daily by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>daily_business_usage_by_instance_type</strong>
         * <p>
         * From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>daily_business_fees</strong>
         * <p>
         * From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>daily_business_free_trial_conversions</strong>
         * <p>
         * From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>daily_business_new_instances</strong>
         * <p>
         * From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>daily_business_new_product_subscribers</strong>
         * <p>
         * From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>daily_business_canceled_product_subscribers</strong>
         * <p>
         * From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>monthly_revenue_billing_and_revenue_data</strong>
         * <p>
         * From 2015-02 to 2017-06: Available monthly on the 4th day of the month by 5:00pm Pacific Time. Data includes
         * metered transactions (e.g. hourly) from two months prior.
         * </p>
         * <p>
         * From 2017-07 to present: Available monthly on the 15th day of the month by 5:00pm Pacific Time. Data includes
         * metered transactions (e.g. hourly) from one month prior.
         * </p>
         * </li>
         * <li><strong>monthly_revenue_annual_subscriptions</strong>
         * <p>
         * From 2015-02 to 2017-06: Available monthly on the 4th day of the month by 5:00pm Pacific Time. Data includes
         * up-front software charges (e.g. annual) from one month prior.
         * </p>
         * <p>
         * From 2017-07 to present: Available monthly on the 15th day of the month by 5:00pm Pacific Time. Data includes
         * up-front software charges (e.g. annual) from one month prior.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_product</strong>
         * <p>
         * From 2015-01-26 to present: Available every 30 days by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_product_with_uncollected_funds</strong>
         * <p>
         * From 2012-04-19 to 2015-01-25: Available every 30 days by 5:00 PM Pacific Time.
         * </p>
         * <p>
         * From 2015-01-26 to present: This data set was split into three data sets: disbursed_amount_by_product,
         * disbursed_amount_by_age_of_uncollected_funds, and disbursed_amount_by_age_of_disbursed_funds.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_instance_hours</strong>
         * <p>
         * From 2012-09-04 to present: Available every 30 days by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_customer_geo</strong>
         * <p>
         * From 2012-04-19 to present: Available every 30 days by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_age_of_uncollected_funds</strong>
         * <p>
         * From 2015-01-26 to present: Available every 30 days by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_age_of_disbursed_funds</strong>
         * <p>
         * From 2015-01-26 to present: Available every 30 days by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * <li><strong>customer_profile_by_industry</strong>
         * <p>
         * From 2015-10-01 to 2017-06-29: Available daily by 5:00 PM Pacific Time.
         * </p>
         * <p>
         * From 2017-06-30 to present: This data set is no longer available.
         * </p>
         * </li>
         * <li><strong>customer_profile_by_revenue</strong>
         * <p>
         * From 2015-10-01 to 2017-06-29: Available daily by 5:00 PM Pacific Time.
         * </p>
         * <p>
         * From 2017-06-30 to present: This data set is no longer available.
         * </p>
         * </li>
         * <li><strong>customer_profile_by_geography</strong>
         * <p>
         * From 2015-10-01 to 2017-06-29: Available daily by 5:00 PM Pacific Time.
         * </p>
         * <p>
         * From 2017-06-30 to present: This data set is no longer available.
         * </p>
         * </li>
         * <li><strong>sales_compensation_billed_revenue</strong>
         * <p>
         * From 2016-12 to 2017-06: Available monthly on the 4th day of the month by 5:00pm Pacific Time. Data includes
         * metered transactions (e.g. hourly) from two months prior, and up-front software charges (e.g. annual) from
         * one month prior.
         * </p>
         * <p>
         * From 2017-06 to present: Available monthly on the 15th day of the month by 5:00pm Pacific Time. Data includes
         * metered transactions (e.g. hourly) from one month prior, and up-front software charges (e.g. annual) from one
         * month prior.
         * </p>
         * </li>
         * <li><strong>us_sales_and_use_tax_records</strong>
         * <p>
         * From 2017-02-15 to present: Available monthly on the 15th day of the month by 5:00 PM Pacific Time.
         * </p>
         * </li>
         * </ul>
         * </p>
         * 
         * @param dataSetType
         *        The desired data set type.</p>
         *        <p>
         *        <ul>
         *        <li><strong>customer_subscriber_hourly_monthly_subscriptions</strong>
         *        <p>
         *        From 2014-07-21 to present: Available daily by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>customer_subscriber_annual_subscriptions</strong>
         *        <p>
         *        From 2014-07-21 to present: Available daily by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>daily_business_usage_by_instance_type</strong>
         *        <p>
         *        From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>daily_business_fees</strong>
         *        <p>
         *        From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>daily_business_free_trial_conversions</strong>
         *        <p>
         *        From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>daily_business_new_instances</strong>
         *        <p>
         *        From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>daily_business_new_product_subscribers</strong>
         *        <p>
         *        From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>daily_business_canceled_product_subscribers</strong>
         *        <p>
         *        From 2015-01-26 to present: Available daily by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>monthly_revenue_billing_and_revenue_data</strong>
         *        <p>
         *        From 2015-02 to 2017-06: Available monthly on the 4th day of the month by 5:00pm Pacific Time. Data
         *        includes metered transactions (e.g. hourly) from two months prior.
         *        </p>
         *        <p>
         *        From 2017-07 to present: Available monthly on the 15th day of the month by 5:00pm Pacific Time. Data
         *        includes metered transactions (e.g. hourly) from one month prior.
         *        </p>
         *        </li>
         *        <li><strong>monthly_revenue_annual_subscriptions</strong>
         *        <p>
         *        From 2015-02 to 2017-06: Available monthly on the 4th day of the month by 5:00pm Pacific Time. Data
         *        includes up-front software charges (e.g. annual) from one month prior.
         *        </p>
         *        <p>
         *        From 2017-07 to present: Available monthly on the 15th day of the month by 5:00pm Pacific Time. Data
         *        includes up-front software charges (e.g. annual) from one month prior.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_product</strong>
         *        <p>
         *        From 2015-01-26 to present: Available every 30 days by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_product_with_uncollected_funds</strong>
         *        <p>
         *        From 2012-04-19 to 2015-01-25: Available every 30 days by 5:00 PM Pacific Time.
         *        </p>
         *        <p>
         *        From 2015-01-26 to present: This data set was split into three data sets: disbursed_amount_by_product,
         *        disbursed_amount_by_age_of_uncollected_funds, and disbursed_amount_by_age_of_disbursed_funds.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_instance_hours</strong>
         *        <p>
         *        From 2012-09-04 to present: Available every 30 days by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_customer_geo</strong>
         *        <p>
         *        From 2012-04-19 to present: Available every 30 days by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_age_of_uncollected_funds</strong>
         *        <p>
         *        From 2015-01-26 to present: Available every 30 days by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_age_of_disbursed_funds</strong>
         *        <p>
         *        From 2015-01-26 to present: Available every 30 days by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        <li><strong>customer_profile_by_industry</strong>
         *        <p>
         *        From 2015-10-01 to 2017-06-29: Available daily by 5:00 PM Pacific Time.
         *        </p>
         *        <p>
         *        From 2017-06-30 to present: This data set is no longer available.
         *        </p>
         *        </li>
         *        <li><strong>customer_profile_by_revenue</strong>
         *        <p>
         *        From 2015-10-01 to 2017-06-29: Available daily by 5:00 PM Pacific Time.
         *        </p>
         *        <p>
         *        From 2017-06-30 to present: This data set is no longer available.
         *        </p>
         *        </li>
         *        <li><strong>customer_profile_by_geography</strong>
         *        <p>
         *        From 2015-10-01 to 2017-06-29: Available daily by 5:00 PM Pacific Time.
         *        </p>
         *        <p>
         *        From 2017-06-30 to present: This data set is no longer available.
         *        </p>
         *        </li>
         *        <li><strong>sales_compensation_billed_revenue</strong>
         *        <p>
         *        From 2016-12 to 2017-06: Available monthly on the 4th day of the month by 5:00pm Pacific Time. Data
         *        includes metered transactions (e.g. hourly) from two months prior, and up-front software charges (e.g.
         *        annual) from one month prior.
         *        </p>
         *        <p>
         *        From 2017-06 to present: Available monthly on the 15th day of the month by 5:00pm Pacific Time. Data
         *        includes metered transactions (e.g. hourly) from one month prior, and up-front software charges (e.g.
         *        annual) from one month prior.
         *        </p>
         *        </li>
         *        <li><strong>us_sales_and_use_tax_records</strong>
         *        <p>
         *        From 2017-02-15 to present: Available monthly on the 15th day of the month by 5:00 PM Pacific Time.
         *        </p>
         *        </li>
         *        </ul>
         * @see DataSetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSetType
         */
        Builder dataSetType(DataSetType dataSetType);

        /**
         * The date a data set was published. For daily data sets, provide a date with day-level granularity for the
         * desired day. For weekly data sets, provide a date with day-level granularity within the desired week (the day
         * value will be ignored). For monthly data sets, provide a date with month-level granularity for the desired
         * month (the day value will be ignored).
         * 
         * @param dataSetPublicationDate
         *        The date a data set was published. For daily data sets, provide a date with day-level granularity for
         *        the desired day. For weekly data sets, provide a date with day-level granularity within the desired
         *        week (the day value will be ignored). For monthly data sets, provide a date with month-level
         *        granularity for the desired month (the day value will be ignored).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetPublicationDate(Instant dataSetPublicationDate);

        /**
         * The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the provided
         * AWS services.
         * 
         * @param roleNameArn
         *        The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the
         *        provided AWS services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleNameArn(String roleNameArn);

        /**
         * The name (friendly name, not ARN) of the destination S3 bucket.
         * 
         * @param destinationS3BucketName
         *        The name (friendly name, not ARN) of the destination S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationS3BucketName(String destinationS3BucketName);

        /**
         * (Optional) The desired S3 prefix for the published data set, similar to a directory path in standard file
         * systems. For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets", the output
         * file "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile". If the prefix
         * directory structure does not exist, it will be created. If no prefix is provided, the data set will be
         * published to the S3 bucket root.
         * 
         * @param destinationS3Prefix
         *        (Optional) The desired S3 prefix for the published data set, similar to a directory path in standard
         *        file systems. For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets",
         *        the output file "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile". If
         *        the prefix directory structure does not exist, it will be created. If no prefix is provided, the data
         *        set will be published to the S3 bucket root.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationS3Prefix(String destinationS3Prefix);

        /**
         * Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been published or if
         * an error has occurred.
         * 
         * @param snsTopicArn
         *        Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been
         *        published or if an error has occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * (Optional) Key-value pairs which will be returned, unmodified, in the Amazon SNS notification message and the
         * data set metadata file. These key-value pairs can be used to correlated responses with tracking information
         * from other systems.
         * 
         * @param customerDefinedValues
         *        (Optional) Key-value pairs which will be returned, unmodified, in the Amazon SNS notification message
         *        and the data set metadata file. These key-value pairs can be used to correlated responses with
         *        tracking information from other systems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerDefinedValues(Map<String, String> customerDefinedValues);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MarketplaceCommerceAnalyticsRequest.BuilderImpl implements Builder {
        private String dataSetType;

        private Instant dataSetPublicationDate;

        private String roleNameArn;

        private String destinationS3BucketName;

        private String destinationS3Prefix;

        private String snsTopicArn;

        private Map<String, String> customerDefinedValues;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateDataSetRequest model) {
            super(model);
            dataSetType(model.dataSetType);
            dataSetPublicationDate(model.dataSetPublicationDate);
            roleNameArn(model.roleNameArn);
            destinationS3BucketName(model.destinationS3BucketName);
            destinationS3Prefix(model.destinationS3Prefix);
            snsTopicArn(model.snsTopicArn);
            customerDefinedValues(model.customerDefinedValues);
        }

        public final String getDataSetType() {
            return dataSetType;
        }

        @Override
        public final Builder dataSetType(String dataSetType) {
            this.dataSetType = dataSetType;
            return this;
        }

        @Override
        public final Builder dataSetType(DataSetType dataSetType) {
            this.dataSetType(dataSetType.toString());
            return this;
        }

        public final void setDataSetType(String dataSetType) {
            this.dataSetType = dataSetType;
        }

        public final Instant getDataSetPublicationDate() {
            return dataSetPublicationDate;
        }

        @Override
        public final Builder dataSetPublicationDate(Instant dataSetPublicationDate) {
            this.dataSetPublicationDate = dataSetPublicationDate;
            return this;
        }

        public final void setDataSetPublicationDate(Instant dataSetPublicationDate) {
            this.dataSetPublicationDate = dataSetPublicationDate;
        }

        public final String getRoleNameArn() {
            return roleNameArn;
        }

        @Override
        public final Builder roleNameArn(String roleNameArn) {
            this.roleNameArn = roleNameArn;
            return this;
        }

        public final void setRoleNameArn(String roleNameArn) {
            this.roleNameArn = roleNameArn;
        }

        public final String getDestinationS3BucketName() {
            return destinationS3BucketName;
        }

        @Override
        public final Builder destinationS3BucketName(String destinationS3BucketName) {
            this.destinationS3BucketName = destinationS3BucketName;
            return this;
        }

        public final void setDestinationS3BucketName(String destinationS3BucketName) {
            this.destinationS3BucketName = destinationS3BucketName;
        }

        public final String getDestinationS3Prefix() {
            return destinationS3Prefix;
        }

        @Override
        public final Builder destinationS3Prefix(String destinationS3Prefix) {
            this.destinationS3Prefix = destinationS3Prefix;
            return this;
        }

        public final void setDestinationS3Prefix(String destinationS3Prefix) {
            this.destinationS3Prefix = destinationS3Prefix;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final Map<String, String> getCustomerDefinedValues() {
            return customerDefinedValues;
        }

        @Override
        public final Builder customerDefinedValues(Map<String, String> customerDefinedValues) {
            this.customerDefinedValues = CustomerDefinedValuesCopier.copy(customerDefinedValues);
            return this;
        }

        public final void setCustomerDefinedValues(Map<String, String> customerDefinedValues) {
            this.customerDefinedValues = CustomerDefinedValuesCopier.copy(customerDefinedValues);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GenerateDataSetRequest build() {
            return new GenerateDataSetRequest(this);
        }
    }
}
