/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecommerceanalytics.transform;

import java.time.Instant;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.GenerateDataSetRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link GenerateDataSetRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class GenerateDataSetRequestModelMarshaller {
    private static final MarshallingInfo<String> DATASETTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dataSetType").isBinary(false).build();

    private static final MarshallingInfo<Instant> DATASETPUBLICATIONDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("dataSetPublicationDate").isBinary(false).build();

    private static final MarshallingInfo<String> ROLENAMEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleNameArn").isBinary(false).build();

    private static final MarshallingInfo<String> DESTINATIONS3BUCKETNAME_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("destinationS3BucketName").isBinary(false).build();

    private static final MarshallingInfo<String> DESTINATIONS3PREFIX_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationS3Prefix").isBinary(false).build();

    private static final MarshallingInfo<String> SNSTOPICARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("snsTopicArn").isBinary(false).build();

    private static final MarshallingInfo<Map> CUSTOMERDEFINEDVALUES_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customerDefinedValues").isBinary(false).build();

    private static final GenerateDataSetRequestModelMarshaller INSTANCE = new GenerateDataSetRequestModelMarshaller();

    private GenerateDataSetRequestModelMarshaller() {
    }

    public static GenerateDataSetRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(GenerateDataSetRequest generateDataSetRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(generateDataSetRequest, "generateDataSetRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(generateDataSetRequest.dataSetTypeAsString(), DATASETTYPE_BINDING);
            protocolMarshaller.marshall(generateDataSetRequest.dataSetPublicationDate(), DATASETPUBLICATIONDATE_BINDING);
            protocolMarshaller.marshall(generateDataSetRequest.roleNameArn(), ROLENAMEARN_BINDING);
            protocolMarshaller.marshall(generateDataSetRequest.destinationS3BucketName(), DESTINATIONS3BUCKETNAME_BINDING);
            protocolMarshaller.marshall(generateDataSetRequest.destinationS3Prefix(), DESTINATIONS3PREFIX_BINDING);
            protocolMarshaller.marshall(generateDataSetRequest.snsTopicArn(), SNSTOPICARN_BINDING);
            protocolMarshaller.marshall(generateDataSetRequest.customerDefinedValues(), CUSTOMERDEFINEDVALUES_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
