/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecommerceanalytics.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.StartSupportDataExportRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link StartSupportDataExportRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class StartSupportDataExportRequestModelMarshaller {
    private static final MarshallingInfo<String> DATASETTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dataSetType").isBinary(false).build();

    private static final MarshallingInfo<Instant> FROMDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fromDate").isBinary(false).build();

    private static final MarshallingInfo<String> ROLENAMEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleNameArn").isBinary(false).build();

    private static final MarshallingInfo<String> DESTINATIONS3BUCKETNAME_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("destinationS3BucketName").isBinary(false).build();

    private static final MarshallingInfo<String> DESTINATIONS3PREFIX_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationS3Prefix").isBinary(false).build();

    private static final MarshallingInfo<String> SNSTOPICARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("snsTopicArn").isBinary(false).build();

    private static final MarshallingInfo<Map> CUSTOMERDEFINEDVALUES_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customerDefinedValues").isBinary(false).build();

    private static final StartSupportDataExportRequestModelMarshaller INSTANCE = new StartSupportDataExportRequestModelMarshaller();

    private StartSupportDataExportRequestModelMarshaller() {
    }

    public static StartSupportDataExportRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(StartSupportDataExportRequest startSupportDataExportRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(startSupportDataExportRequest, "startSupportDataExportRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(startSupportDataExportRequest.dataSetTypeAsString(), DATASETTYPE_BINDING);
            protocolMarshaller.marshall(startSupportDataExportRequest.fromDate(), FROMDATE_BINDING);
            protocolMarshaller.marshall(startSupportDataExportRequest.roleNameArn(), ROLENAMEARN_BINDING);
            protocolMarshaller.marshall(startSupportDataExportRequest.destinationS3BucketName(), DESTINATIONS3BUCKETNAME_BINDING);
            protocolMarshaller.marshall(startSupportDataExportRequest.destinationS3Prefix(), DESTINATIONS3PREFIX_BINDING);
            protocolMarshaller.marshall(startSupportDataExportRequest.snsTopicArn(), SNSTOPICARN_BINDING);
            protocolMarshaller.marshall(startSupportDataExportRequest.customerDefinedValues(), CUSTOMERDEFINEDVALUES_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
