/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecommerceanalytics.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.GenerateDataSetRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GenerateDataSetRequestModelMarshaller {
    private static final MarshallingInfo<String> DATASETTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dataSetType").isBinary(false).build();
    private static final MarshallingInfo<Instant> DATASETPUBLICATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dataSetPublicationDate").isBinary(false).build();
    private static final MarshallingInfo<String> ROLENAMEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleNameArn").isBinary(false).build();
    private static final MarshallingInfo<String> DESTINATIONS3BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationS3BucketName").isBinary(false).build();
    private static final MarshallingInfo<String> DESTINATIONS3PREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationS3Prefix").isBinary(false).build();
    private static final MarshallingInfo<String> SNSTOPICARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("snsTopicArn").isBinary(false).build();
    private static final MarshallingInfo<Map> CUSTOMERDEFINEDVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customerDefinedValues").isBinary(false).build();
    private static final GenerateDataSetRequestModelMarshaller INSTANCE = new GenerateDataSetRequestModelMarshaller();

    private GenerateDataSetRequestModelMarshaller() {
    }

    public static GenerateDataSetRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GenerateDataSetRequest generateDataSetRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)generateDataSetRequest), (String)"generateDataSetRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)generateDataSetRequest.dataSetTypeAsString(), DATASETTYPE_BINDING);
            protocolMarshaller.marshall((Object)generateDataSetRequest.dataSetPublicationDate(), DATASETPUBLICATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)generateDataSetRequest.roleNameArn(), ROLENAMEARN_BINDING);
            protocolMarshaller.marshall((Object)generateDataSetRequest.destinationS3BucketName(), DESTINATIONS3BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)generateDataSetRequest.destinationS3Prefix(), DESTINATIONS3PREFIX_BINDING);
            protocolMarshaller.marshall((Object)generateDataSetRequest.snsTopicArn(), SNSTOPICARN_BINDING);
            protocolMarshaller.marshall(generateDataSetRequest.customerDefinedValues(), CUSTOMERDEFINEDVALUES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

