/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecommerceanalytics.model;

import java.time.Instant;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Container for the parameters to the GenerateDataSet operation.
 */
@Generated("software.amazon.awssdk:codegen")
public class GenerateDataSetRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GenerateDataSetRequest.Builder, GenerateDataSetRequest> {
    private final String dataSetType;

    private final Instant dataSetPublicationDate;

    private final String roleNameArn;

    private final String destinationS3BucketName;

    private final String destinationS3Prefix;

    private final String snsTopicArn;

    private final Map<String, String> customerDefinedValues;

    private GenerateDataSetRequest(BuilderImpl builder) {
        this.dataSetType = builder.dataSetType;
        this.dataSetPublicationDate = builder.dataSetPublicationDate;
        this.roleNameArn = builder.roleNameArn;
        this.destinationS3BucketName = builder.destinationS3BucketName;
        this.destinationS3Prefix = builder.destinationS3Prefix;
        this.snsTopicArn = builder.snsTopicArn;
        this.customerDefinedValues = builder.customerDefinedValues;
    }

    /**
     * <p>
     * The desired data set type.
     * </p>
     * <p>
     * <ul>
     * <li><i>customer_subscriber_hourly_monthly_subscriptions</i> - Available daily by 5:00 PM Pacific Time since
     * 2014-07-21.</li>
     * <li><i>customer_subscriber_annual_subscriptions</i> - Available daily by 5:00 PM Pacific Time since 2014-07-21.</li>
     * <li><i>daily_business_usage_by_instance_type</i> - Available daily by 5:00 PM Pacific Time since 2015-01-26.</li>
     * <li><i>daily_business_fees</i> - Available daily by 5:00 PM Pacific Time since 2015-01-26.</li>
     * <li><i>daily_business_free_trial_conversions</i> - Available daily by 5:00 PM Pacific Time since 2015-01-26.</li>
     * <li><i>daily_business_new_instances</i> - Available daily by 5:00 PM Pacific Time since 2015-01-26.</li>
     * <li><i>daily_business_new_product_subscribers</i> - Available daily by 5:00 PM Pacific Time since 2015-01-26.</li>
     * <li><i>daily_business_canceled_product_subscribers</i> - Available daily by 5:00 PM Pacific Time since
     * 2015-01-26.</li>
     * <li><i>monthly_revenue_billing_and_revenue_data</i> - Available monthly on the 4th day of the month by 5:00 PM
     * Pacific Time since 2015-02.</li>
     * <li><i>monthly_revenue_annual_subscriptions</i> - Available monthly on the 4th day of the month by 5:00 PM
     * Pacific Time since 2015-02.</li>
     * <li><i>disbursed_amount_by_product</i> - Available every 30 days by 5:00 PM Pacific Time since 2015-01-26.</li>
     * <li><i>disbursed_amount_by_product_with_uncollected_funds</i> -This data set is only available from 2012-04-19
     * until 2015-01-25. After 2015-01-25, this data set was split into three data sets: disbursed_amount_by_product,
     * disbursed_amount_by_age_of_uncollected_funds, and disbursed_amount_by_age_of_disbursed_funds.</li>
     * <li><i>disbursed_amount_by_instance_hours</i> - Available every 30 days by 5:00 PM Pacific Time since 2012-09-04.
     * </li>
     * <li><i>disbursed_amount_by_customer_geo</i> - Available every 30 days by 5:00 PM Pacific Time since 2012-04-19.</li>
     * <li><i>disbursed_amount_by_age_of_uncollected_funds</i> - Available every 30 days by 5:00 PM Pacific Time since
     * 2015-01-26.</li>
     * <li><i>disbursed_amount_by_age_of_disbursed_funds</i> - Available every 30 days by 5:00 PM Pacific Time since
     * 2015-01-26.</li>
     * <li><i>customer_profile_by_industry</i> - Available daily by 5:00 PM Pacific Time since 2015-10-01.</li>
     * <li><i>customer_profile_by_revenue</i> - Available daily by 5:00 PM Pacific Time since 2015-10-01.</li>
     * <li><i>customer_profile_by_geography</i> - Available daily by 5:00 PM Pacific Time since 2015-10-01.</li>
     * <li><i>sales_compensation_billed_revenue</i> - Available monthly on the 4th day of the month by 5:00 PM Pacific
     * Time since 2016-12.</li>
     * <li><i>us_sales_and_use_tax_records</i> - Available monthly on the 15th day of the month by 5:00 PM Pacific Time
     * since 2017-02-15.</li>
     * </ul>
     * </p>
     * 
     * @return The desired data set type.</p>
     *         <p>
     *         <ul>
     *         <li><i>customer_subscriber_hourly_monthly_subscriptions</i> - Available daily by 5:00 PM Pacific Time
     *         since 2014-07-21.</li>
     *         <li><i>customer_subscriber_annual_subscriptions</i> - Available daily by 5:00 PM Pacific Time since
     *         2014-07-21.</li>
     *         <li><i>daily_business_usage_by_instance_type</i> - Available daily by 5:00 PM Pacific Time since
     *         2015-01-26.</li>
     *         <li><i>daily_business_fees</i> - Available daily by 5:00 PM Pacific Time since 2015-01-26.</li>
     *         <li><i>daily_business_free_trial_conversions</i> - Available daily by 5:00 PM Pacific Time since
     *         2015-01-26.</li>
     *         <li><i>daily_business_new_instances</i> - Available daily by 5:00 PM Pacific Time since 2015-01-26.</li>
     *         <li><i>daily_business_new_product_subscribers</i> - Available daily by 5:00 PM Pacific Time since
     *         2015-01-26.</li>
     *         <li><i>daily_business_canceled_product_subscribers</i> - Available daily by 5:00 PM Pacific Time since
     *         2015-01-26.</li>
     *         <li><i>monthly_revenue_billing_and_revenue_data</i> - Available monthly on the 4th day of the month by
     *         5:00 PM Pacific Time since 2015-02.</li>
     *         <li><i>monthly_revenue_annual_subscriptions</i> - Available monthly on the 4th day of the month by 5:00
     *         PM Pacific Time since 2015-02.</li>
     *         <li><i>disbursed_amount_by_product</i> - Available every 30 days by 5:00 PM Pacific Time since
     *         2015-01-26.</li>
     *         <li><i>disbursed_amount_by_product_with_uncollected_funds</i> -This data set is only available from
     *         2012-04-19 until 2015-01-25. After 2015-01-25, this data set was split into three data sets:
     *         disbursed_amount_by_product, disbursed_amount_by_age_of_uncollected_funds, and
     *         disbursed_amount_by_age_of_disbursed_funds.</li>
     *         <li><i>disbursed_amount_by_instance_hours</i> - Available every 30 days by 5:00 PM Pacific Time since
     *         2012-09-04.</li>
     *         <li><i>disbursed_amount_by_customer_geo</i> - Available every 30 days by 5:00 PM Pacific Time since
     *         2012-04-19.</li>
     *         <li><i>disbursed_amount_by_age_of_uncollected_funds</i> - Available every 30 days by 5:00 PM Pacific Time
     *         since 2015-01-26.</li>
     *         <li><i>disbursed_amount_by_age_of_disbursed_funds</i> - Available every 30 days by 5:00 PM Pacific Time
     *         since 2015-01-26.</li>
     *         <li><i>customer_profile_by_industry</i> - Available daily by 5:00 PM Pacific Time since 2015-10-01.</li>
     *         <li><i>customer_profile_by_revenue</i> - Available daily by 5:00 PM Pacific Time since 2015-10-01.</li>
     *         <li><i>customer_profile_by_geography</i> - Available daily by 5:00 PM Pacific Time since 2015-10-01.</li>
     *         <li><i>sales_compensation_billed_revenue</i> - Available monthly on the 4th day of the month by 5:00 PM
     *         Pacific Time since 2016-12.</li>
     *         <li><i>us_sales_and_use_tax_records</i> - Available monthly on the 15th day of the month by 5:00 PM
     *         Pacific Time since 2017-02-15.</li>
     *         </ul>
     * @see DataSetType
     */
    public String dataSetType() {
        return dataSetType;
    }

    /**
     * The date a data set was published. For daily data sets, provide a date with day-level granularity for the desired
     * day. For weekly data sets, provide a date with day-level granularity within the desired week (the day value will
     * be ignored). For monthly data sets, provide a date with month-level granularity for the desired month (the day
     * value will be ignored).
     * 
     * @return The date a data set was published. For daily data sets, provide a date with day-level granularity for the
     *         desired day. For weekly data sets, provide a date with day-level granularity within the desired week (the
     *         day value will be ignored). For monthly data sets, provide a date with month-level granularity for the
     *         desired month (the day value will be ignored).
     */
    public Instant dataSetPublicationDate() {
        return dataSetPublicationDate;
    }

    /**
     * The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the provided AWS
     * services.
     * 
     * @return The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the
     *         provided AWS services.
     */
    public String roleNameArn() {
        return roleNameArn;
    }

    /**
     * The name (friendly name, not ARN) of the destination S3 bucket.
     * 
     * @return The name (friendly name, not ARN) of the destination S3 bucket.
     */
    public String destinationS3BucketName() {
        return destinationS3BucketName;
    }

    /**
     * (Optional) The desired S3 prefix for the published data set, similar to a directory path in standard file
     * systems. For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets", the output file
     * "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile". If the prefix directory
     * structure does not exist, it will be created. If no prefix is provided, the data set will be published to the S3
     * bucket root.
     * 
     * @return (Optional) The desired S3 prefix for the published data set, similar to a directory path in standard file
     *         systems. For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets", the
     *         output file "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile". If the
     *         prefix directory structure does not exist, it will be created. If no prefix is provided, the data set
     *         will be published to the S3 bucket root.
     */
    public String destinationS3Prefix() {
        return destinationS3Prefix;
    }

    /**
     * Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been published or if an
     * error has occurred.
     * 
     * @return Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been published
     *         or if an error has occurred.
     */
    public String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * (Optional) Key-value pairs which will be returned, unmodified, in the Amazon SNS notification message and the
     * data set metadata file. These key-value pairs can be used to correlated responses with tracking information from
     * other systems.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return (Optional) Key-value pairs which will be returned, unmodified, in the Amazon SNS notification message and
     *         the data set metadata file. These key-value pairs can be used to correlated responses with tracking
     *         information from other systems.
     */
    public Map<String, String> customerDefinedValues() {
        return customerDefinedValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((dataSetType() == null) ? 0 : dataSetType().hashCode());
        hashCode = 31 * hashCode + ((dataSetPublicationDate() == null) ? 0 : dataSetPublicationDate().hashCode());
        hashCode = 31 * hashCode + ((roleNameArn() == null) ? 0 : roleNameArn().hashCode());
        hashCode = 31 * hashCode + ((destinationS3BucketName() == null) ? 0 : destinationS3BucketName().hashCode());
        hashCode = 31 * hashCode + ((destinationS3Prefix() == null) ? 0 : destinationS3Prefix().hashCode());
        hashCode = 31 * hashCode + ((snsTopicArn() == null) ? 0 : snsTopicArn().hashCode());
        hashCode = 31 * hashCode + ((customerDefinedValues() == null) ? 0 : customerDefinedValues().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateDataSetRequest)) {
            return false;
        }
        GenerateDataSetRequest other = (GenerateDataSetRequest) obj;
        if (other.dataSetType() == null ^ this.dataSetType() == null) {
            return false;
        }
        if (other.dataSetType() != null && !other.dataSetType().equals(this.dataSetType())) {
            return false;
        }
        if (other.dataSetPublicationDate() == null ^ this.dataSetPublicationDate() == null) {
            return false;
        }
        if (other.dataSetPublicationDate() != null && !other.dataSetPublicationDate().equals(this.dataSetPublicationDate())) {
            return false;
        }
        if (other.roleNameArn() == null ^ this.roleNameArn() == null) {
            return false;
        }
        if (other.roleNameArn() != null && !other.roleNameArn().equals(this.roleNameArn())) {
            return false;
        }
        if (other.destinationS3BucketName() == null ^ this.destinationS3BucketName() == null) {
            return false;
        }
        if (other.destinationS3BucketName() != null && !other.destinationS3BucketName().equals(this.destinationS3BucketName())) {
            return false;
        }
        if (other.destinationS3Prefix() == null ^ this.destinationS3Prefix() == null) {
            return false;
        }
        if (other.destinationS3Prefix() != null && !other.destinationS3Prefix().equals(this.destinationS3Prefix())) {
            return false;
        }
        if (other.snsTopicArn() == null ^ this.snsTopicArn() == null) {
            return false;
        }
        if (other.snsTopicArn() != null && !other.snsTopicArn().equals(this.snsTopicArn())) {
            return false;
        }
        if (other.customerDefinedValues() == null ^ this.customerDefinedValues() == null) {
            return false;
        }
        if (other.customerDefinedValues() != null && !other.customerDefinedValues().equals(this.customerDefinedValues())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (dataSetType() != null) {
            sb.append("DataSetType: ").append(dataSetType()).append(",");
        }
        if (dataSetPublicationDate() != null) {
            sb.append("DataSetPublicationDate: ").append(dataSetPublicationDate()).append(",");
        }
        if (roleNameArn() != null) {
            sb.append("RoleNameArn: ").append(roleNameArn()).append(",");
        }
        if (destinationS3BucketName() != null) {
            sb.append("DestinationS3BucketName: ").append(destinationS3BucketName()).append(",");
        }
        if (destinationS3Prefix() != null) {
            sb.append("DestinationS3Prefix: ").append(destinationS3Prefix()).append(",");
        }
        if (snsTopicArn() != null) {
            sb.append("SnsTopicArn: ").append(snsTopicArn()).append(",");
        }
        if (customerDefinedValues() != null) {
            sb.append("CustomerDefinedValues: ").append(customerDefinedValues()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GenerateDataSetRequest> {
        /**
         * <p>
         * The desired data set type.
         * </p>
         * <p>
         * <ul>
         * <li><i>customer_subscriber_hourly_monthly_subscriptions</i> - Available daily by 5:00 PM Pacific Time since
         * 2014-07-21.</li>
         * <li><i>customer_subscriber_annual_subscriptions</i> - Available daily by 5:00 PM Pacific Time since
         * 2014-07-21.</li>
         * <li><i>daily_business_usage_by_instance_type</i> - Available daily by 5:00 PM Pacific Time since 2015-01-26.</li>
         * <li><i>daily_business_fees</i> - Available daily by 5:00 PM Pacific Time since 2015-01-26.</li>
         * <li><i>daily_business_free_trial_conversions</i> - Available daily by 5:00 PM Pacific Time since 2015-01-26.</li>
         * <li><i>daily_business_new_instances</i> - Available daily by 5:00 PM Pacific Time since 2015-01-26.</li>
         * <li><i>daily_business_new_product_subscribers</i> - Available daily by 5:00 PM Pacific Time since 2015-01-26.
         * </li>
         * <li><i>daily_business_canceled_product_subscribers</i> - Available daily by 5:00 PM Pacific Time since
         * 2015-01-26.</li>
         * <li><i>monthly_revenue_billing_and_revenue_data</i> - Available monthly on the 4th day of the month by 5:00
         * PM Pacific Time since 2015-02.</li>
         * <li><i>monthly_revenue_annual_subscriptions</i> - Available monthly on the 4th day of the month by 5:00 PM
         * Pacific Time since 2015-02.</li>
         * <li><i>disbursed_amount_by_product</i> - Available every 30 days by 5:00 PM Pacific Time since 2015-01-26.</li>
         * <li><i>disbursed_amount_by_product_with_uncollected_funds</i> -This data set is only available from
         * 2012-04-19 until 2015-01-25. After 2015-01-25, this data set was split into three data sets:
         * disbursed_amount_by_product, disbursed_amount_by_age_of_uncollected_funds, and
         * disbursed_amount_by_age_of_disbursed_funds.</li>
         * <li><i>disbursed_amount_by_instance_hours</i> - Available every 30 days by 5:00 PM Pacific Time since
         * 2012-09-04.</li>
         * <li><i>disbursed_amount_by_customer_geo</i> - Available every 30 days by 5:00 PM Pacific Time since
         * 2012-04-19.</li>
         * <li><i>disbursed_amount_by_age_of_uncollected_funds</i> - Available every 30 days by 5:00 PM Pacific Time
         * since 2015-01-26.</li>
         * <li><i>disbursed_amount_by_age_of_disbursed_funds</i> - Available every 30 days by 5:00 PM Pacific Time since
         * 2015-01-26.</li>
         * <li><i>customer_profile_by_industry</i> - Available daily by 5:00 PM Pacific Time since 2015-10-01.</li>
         * <li><i>customer_profile_by_revenue</i> - Available daily by 5:00 PM Pacific Time since 2015-10-01.</li>
         * <li><i>customer_profile_by_geography</i> - Available daily by 5:00 PM Pacific Time since 2015-10-01.</li>
         * <li><i>sales_compensation_billed_revenue</i> - Available monthly on the 4th day of the month by 5:00 PM
         * Pacific Time since 2016-12.</li>
         * <li><i>us_sales_and_use_tax_records</i> - Available monthly on the 15th day of the month by 5:00 PM Pacific
         * Time since 2017-02-15.</li>
         * </ul>
         * </p>
         * 
         * @param dataSetType
         *        The desired data set type.</p>
         *        <p>
         *        <ul>
         *        <li><i>customer_subscriber_hourly_monthly_subscriptions</i> - Available daily by 5:00 PM Pacific Time
         *        since 2014-07-21.</li>
         *        <li><i>customer_subscriber_annual_subscriptions</i> - Available daily by 5:00 PM Pacific Time since
         *        2014-07-21.</li>
         *        <li><i>daily_business_usage_by_instance_type</i> - Available daily by 5:00 PM Pacific Time since
         *        2015-01-26.</li>
         *        <li><i>daily_business_fees</i> - Available daily by 5:00 PM Pacific Time since 2015-01-26.</li>
         *        <li><i>daily_business_free_trial_conversions</i> - Available daily by 5:00 PM Pacific Time since
         *        2015-01-26.</li>
         *        <li><i>daily_business_new_instances</i> - Available daily by 5:00 PM Pacific Time since 2015-01-26.</li>
         *        <li><i>daily_business_new_product_subscribers</i> - Available daily by 5:00 PM Pacific Time since
         *        2015-01-26.</li>
         *        <li><i>daily_business_canceled_product_subscribers</i> - Available daily by 5:00 PM Pacific Time since
         *        2015-01-26.</li>
         *        <li><i>monthly_revenue_billing_and_revenue_data</i> - Available monthly on the 4th day of the month by
         *        5:00 PM Pacific Time since 2015-02.</li>
         *        <li><i>monthly_revenue_annual_subscriptions</i> - Available monthly on the 4th day of the month by
         *        5:00 PM Pacific Time since 2015-02.</li>
         *        <li><i>disbursed_amount_by_product</i> - Available every 30 days by 5:00 PM Pacific Time since
         *        2015-01-26.</li>
         *        <li><i>disbursed_amount_by_product_with_uncollected_funds</i> -This data set is only available from
         *        2012-04-19 until 2015-01-25. After 2015-01-25, this data set was split into three data sets:
         *        disbursed_amount_by_product, disbursed_amount_by_age_of_uncollected_funds, and
         *        disbursed_amount_by_age_of_disbursed_funds.</li>
         *        <li><i>disbursed_amount_by_instance_hours</i> - Available every 30 days by 5:00 PM Pacific Time since
         *        2012-09-04.</li>
         *        <li><i>disbursed_amount_by_customer_geo</i> - Available every 30 days by 5:00 PM Pacific Time since
         *        2012-04-19.</li>
         *        <li><i>disbursed_amount_by_age_of_uncollected_funds</i> - Available every 30 days by 5:00 PM Pacific
         *        Time since 2015-01-26.</li>
         *        <li><i>disbursed_amount_by_age_of_disbursed_funds</i> - Available every 30 days by 5:00 PM Pacific
         *        Time since 2015-01-26.</li>
         *        <li><i>customer_profile_by_industry</i> - Available daily by 5:00 PM Pacific Time since 2015-10-01.</li>
         *        <li><i>customer_profile_by_revenue</i> - Available daily by 5:00 PM Pacific Time since 2015-10-01.</li>
         *        <li><i>customer_profile_by_geography</i> - Available daily by 5:00 PM Pacific Time since 2015-10-01.</li>
         *        <li><i>sales_compensation_billed_revenue</i> - Available monthly on the 4th day of the month by 5:00
         *        PM Pacific Time since 2016-12.</li>
         *        <li><i>us_sales_and_use_tax_records</i> - Available monthly on the 15th day of the month by 5:00 PM
         *        Pacific Time since 2017-02-15.</li>
         *        </ul>
         * @see DataSetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSetType
         */
        Builder dataSetType(String dataSetType);

        /**
         * <p>
         * The desired data set type.
         * </p>
         * <p>
         * <ul>
         * <li><i>customer_subscriber_hourly_monthly_subscriptions</i> - Available daily by 5:00 PM Pacific Time since
         * 2014-07-21.</li>
         * <li><i>customer_subscriber_annual_subscriptions</i> - Available daily by 5:00 PM Pacific Time since
         * 2014-07-21.</li>
         * <li><i>daily_business_usage_by_instance_type</i> - Available daily by 5:00 PM Pacific Time since 2015-01-26.</li>
         * <li><i>daily_business_fees</i> - Available daily by 5:00 PM Pacific Time since 2015-01-26.</li>
         * <li><i>daily_business_free_trial_conversions</i> - Available daily by 5:00 PM Pacific Time since 2015-01-26.</li>
         * <li><i>daily_business_new_instances</i> - Available daily by 5:00 PM Pacific Time since 2015-01-26.</li>
         * <li><i>daily_business_new_product_subscribers</i> - Available daily by 5:00 PM Pacific Time since 2015-01-26.
         * </li>
         * <li><i>daily_business_canceled_product_subscribers</i> - Available daily by 5:00 PM Pacific Time since
         * 2015-01-26.</li>
         * <li><i>monthly_revenue_billing_and_revenue_data</i> - Available monthly on the 4th day of the month by 5:00
         * PM Pacific Time since 2015-02.</li>
         * <li><i>monthly_revenue_annual_subscriptions</i> - Available monthly on the 4th day of the month by 5:00 PM
         * Pacific Time since 2015-02.</li>
         * <li><i>disbursed_amount_by_product</i> - Available every 30 days by 5:00 PM Pacific Time since 2015-01-26.</li>
         * <li><i>disbursed_amount_by_product_with_uncollected_funds</i> -This data set is only available from
         * 2012-04-19 until 2015-01-25. After 2015-01-25, this data set was split into three data sets:
         * disbursed_amount_by_product, disbursed_amount_by_age_of_uncollected_funds, and
         * disbursed_amount_by_age_of_disbursed_funds.</li>
         * <li><i>disbursed_amount_by_instance_hours</i> - Available every 30 days by 5:00 PM Pacific Time since
         * 2012-09-04.</li>
         * <li><i>disbursed_amount_by_customer_geo</i> - Available every 30 days by 5:00 PM Pacific Time since
         * 2012-04-19.</li>
         * <li><i>disbursed_amount_by_age_of_uncollected_funds</i> - Available every 30 days by 5:00 PM Pacific Time
         * since 2015-01-26.</li>
         * <li><i>disbursed_amount_by_age_of_disbursed_funds</i> - Available every 30 days by 5:00 PM Pacific Time since
         * 2015-01-26.</li>
         * <li><i>customer_profile_by_industry</i> - Available daily by 5:00 PM Pacific Time since 2015-10-01.</li>
         * <li><i>customer_profile_by_revenue</i> - Available daily by 5:00 PM Pacific Time since 2015-10-01.</li>
         * <li><i>customer_profile_by_geography</i> - Available daily by 5:00 PM Pacific Time since 2015-10-01.</li>
         * <li><i>sales_compensation_billed_revenue</i> - Available monthly on the 4th day of the month by 5:00 PM
         * Pacific Time since 2016-12.</li>
         * <li><i>us_sales_and_use_tax_records</i> - Available monthly on the 15th day of the month by 5:00 PM Pacific
         * Time since 2017-02-15.</li>
         * </ul>
         * </p>
         * 
         * @param dataSetType
         *        The desired data set type.</p>
         *        <p>
         *        <ul>
         *        <li><i>customer_subscriber_hourly_monthly_subscriptions</i> - Available daily by 5:00 PM Pacific Time
         *        since 2014-07-21.</li>
         *        <li><i>customer_subscriber_annual_subscriptions</i> - Available daily by 5:00 PM Pacific Time since
         *        2014-07-21.</li>
         *        <li><i>daily_business_usage_by_instance_type</i> - Available daily by 5:00 PM Pacific Time since
         *        2015-01-26.</li>
         *        <li><i>daily_business_fees</i> - Available daily by 5:00 PM Pacific Time since 2015-01-26.</li>
         *        <li><i>daily_business_free_trial_conversions</i> - Available daily by 5:00 PM Pacific Time since
         *        2015-01-26.</li>
         *        <li><i>daily_business_new_instances</i> - Available daily by 5:00 PM Pacific Time since 2015-01-26.</li>
         *        <li><i>daily_business_new_product_subscribers</i> - Available daily by 5:00 PM Pacific Time since
         *        2015-01-26.</li>
         *        <li><i>daily_business_canceled_product_subscribers</i> - Available daily by 5:00 PM Pacific Time since
         *        2015-01-26.</li>
         *        <li><i>monthly_revenue_billing_and_revenue_data</i> - Available monthly on the 4th day of the month by
         *        5:00 PM Pacific Time since 2015-02.</li>
         *        <li><i>monthly_revenue_annual_subscriptions</i> - Available monthly on the 4th day of the month by
         *        5:00 PM Pacific Time since 2015-02.</li>
         *        <li><i>disbursed_amount_by_product</i> - Available every 30 days by 5:00 PM Pacific Time since
         *        2015-01-26.</li>
         *        <li><i>disbursed_amount_by_product_with_uncollected_funds</i> -This data set is only available from
         *        2012-04-19 until 2015-01-25. After 2015-01-25, this data set was split into three data sets:
         *        disbursed_amount_by_product, disbursed_amount_by_age_of_uncollected_funds, and
         *        disbursed_amount_by_age_of_disbursed_funds.</li>
         *        <li><i>disbursed_amount_by_instance_hours</i> - Available every 30 days by 5:00 PM Pacific Time since
         *        2012-09-04.</li>
         *        <li><i>disbursed_amount_by_customer_geo</i> - Available every 30 days by 5:00 PM Pacific Time since
         *        2012-04-19.</li>
         *        <li><i>disbursed_amount_by_age_of_uncollected_funds</i> - Available every 30 days by 5:00 PM Pacific
         *        Time since 2015-01-26.</li>
         *        <li><i>disbursed_amount_by_age_of_disbursed_funds</i> - Available every 30 days by 5:00 PM Pacific
         *        Time since 2015-01-26.</li>
         *        <li><i>customer_profile_by_industry</i> - Available daily by 5:00 PM Pacific Time since 2015-10-01.</li>
         *        <li><i>customer_profile_by_revenue</i> - Available daily by 5:00 PM Pacific Time since 2015-10-01.</li>
         *        <li><i>customer_profile_by_geography</i> - Available daily by 5:00 PM Pacific Time since 2015-10-01.</li>
         *        <li><i>sales_compensation_billed_revenue</i> - Available monthly on the 4th day of the month by 5:00
         *        PM Pacific Time since 2016-12.</li>
         *        <li><i>us_sales_and_use_tax_records</i> - Available monthly on the 15th day of the month by 5:00 PM
         *        Pacific Time since 2017-02-15.</li>
         *        </ul>
         * @see DataSetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSetType
         */
        Builder dataSetType(DataSetType dataSetType);

        /**
         * The date a data set was published. For daily data sets, provide a date with day-level granularity for the
         * desired day. For weekly data sets, provide a date with day-level granularity within the desired week (the day
         * value will be ignored). For monthly data sets, provide a date with month-level granularity for the desired
         * month (the day value will be ignored).
         * 
         * @param dataSetPublicationDate
         *        The date a data set was published. For daily data sets, provide a date with day-level granularity for
         *        the desired day. For weekly data sets, provide a date with day-level granularity within the desired
         *        week (the day value will be ignored). For monthly data sets, provide a date with month-level
         *        granularity for the desired month (the day value will be ignored).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetPublicationDate(Instant dataSetPublicationDate);

        /**
         * The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the provided
         * AWS services.
         * 
         * @param roleNameArn
         *        The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the
         *        provided AWS services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleNameArn(String roleNameArn);

        /**
         * The name (friendly name, not ARN) of the destination S3 bucket.
         * 
         * @param destinationS3BucketName
         *        The name (friendly name, not ARN) of the destination S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationS3BucketName(String destinationS3BucketName);

        /**
         * (Optional) The desired S3 prefix for the published data set, similar to a directory path in standard file
         * systems. For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets", the output
         * file "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile". If the prefix
         * directory structure does not exist, it will be created. If no prefix is provided, the data set will be
         * published to the S3 bucket root.
         * 
         * @param destinationS3Prefix
         *        (Optional) The desired S3 prefix for the published data set, similar to a directory path in standard
         *        file systems. For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets",
         *        the output file "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile". If
         *        the prefix directory structure does not exist, it will be created. If no prefix is provided, the data
         *        set will be published to the S3 bucket root.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationS3Prefix(String destinationS3Prefix);

        /**
         * Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been published or if
         * an error has occurred.
         * 
         * @param snsTopicArn
         *        Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been
         *        published or if an error has occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * (Optional) Key-value pairs which will be returned, unmodified, in the Amazon SNS notification message and the
         * data set metadata file. These key-value pairs can be used to correlated responses with tracking information
         * from other systems.
         * 
         * @param customerDefinedValues
         *        (Optional) Key-value pairs which will be returned, unmodified, in the Amazon SNS notification message
         *        and the data set metadata file. These key-value pairs can be used to correlated responses with
         *        tracking information from other systems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerDefinedValues(Map<String, String> customerDefinedValues);
    }

    private static final class BuilderImpl implements Builder {
        private String dataSetType;

        private Instant dataSetPublicationDate;

        private String roleNameArn;

        private String destinationS3BucketName;

        private String destinationS3Prefix;

        private String snsTopicArn;

        private Map<String, String> customerDefinedValues;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateDataSetRequest model) {
            setDataSetType(model.dataSetType);
            setDataSetPublicationDate(model.dataSetPublicationDate);
            setRoleNameArn(model.roleNameArn);
            setDestinationS3BucketName(model.destinationS3BucketName);
            setDestinationS3Prefix(model.destinationS3Prefix);
            setSnsTopicArn(model.snsTopicArn);
            setCustomerDefinedValues(model.customerDefinedValues);
        }

        public final String getDataSetType() {
            return dataSetType;
        }

        @Override
        public final Builder dataSetType(String dataSetType) {
            this.dataSetType = dataSetType;
            return this;
        }

        @Override
        public final Builder dataSetType(DataSetType dataSetType) {
            this.dataSetType(dataSetType.toString());
            return this;
        }

        public final void setDataSetType(String dataSetType) {
            this.dataSetType = dataSetType;
        }

        public final Instant getDataSetPublicationDate() {
            return dataSetPublicationDate;
        }

        @Override
        public final Builder dataSetPublicationDate(Instant dataSetPublicationDate) {
            this.dataSetPublicationDate = dataSetPublicationDate;
            return this;
        }

        public final void setDataSetPublicationDate(Instant dataSetPublicationDate) {
            this.dataSetPublicationDate = dataSetPublicationDate;
        }

        public final String getRoleNameArn() {
            return roleNameArn;
        }

        @Override
        public final Builder roleNameArn(String roleNameArn) {
            this.roleNameArn = roleNameArn;
            return this;
        }

        public final void setRoleNameArn(String roleNameArn) {
            this.roleNameArn = roleNameArn;
        }

        public final String getDestinationS3BucketName() {
            return destinationS3BucketName;
        }

        @Override
        public final Builder destinationS3BucketName(String destinationS3BucketName) {
            this.destinationS3BucketName = destinationS3BucketName;
            return this;
        }

        public final void setDestinationS3BucketName(String destinationS3BucketName) {
            this.destinationS3BucketName = destinationS3BucketName;
        }

        public final String getDestinationS3Prefix() {
            return destinationS3Prefix;
        }

        @Override
        public final Builder destinationS3Prefix(String destinationS3Prefix) {
            this.destinationS3Prefix = destinationS3Prefix;
            return this;
        }

        public final void setDestinationS3Prefix(String destinationS3Prefix) {
            this.destinationS3Prefix = destinationS3Prefix;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final Map<String, String> getCustomerDefinedValues() {
            return customerDefinedValues;
        }

        @Override
        public final Builder customerDefinedValues(Map<String, String> customerDefinedValues) {
            this.customerDefinedValues = CustomerDefinedValuesCopier.copy(customerDefinedValues);
            return this;
        }

        public final void setCustomerDefinedValues(Map<String, String> customerDefinedValues) {
            this.customerDefinedValues = CustomerDefinedValuesCopier.copy(customerDefinedValues);
        }

        @Override
        public GenerateDataSetRequest build() {
            return new GenerateDataSetRequest(this);
        }
    }
}
