/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecommerceanalytics.model;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.CustomerDefinedValuesCopier;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.DataSetType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GenerateDataSetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GenerateDataSetRequest> {
    private final String dataSetType;
    private final Instant dataSetPublicationDate;
    private final String roleNameArn;
    private final String destinationS3BucketName;
    private final String destinationS3Prefix;
    private final String snsTopicArn;
    private final Map<String, String> customerDefinedValues;

    private GenerateDataSetRequest(BuilderImpl builder) {
        this.dataSetType = builder.dataSetType;
        this.dataSetPublicationDate = builder.dataSetPublicationDate;
        this.roleNameArn = builder.roleNameArn;
        this.destinationS3BucketName = builder.destinationS3BucketName;
        this.destinationS3Prefix = builder.destinationS3Prefix;
        this.snsTopicArn = builder.snsTopicArn;
        this.customerDefinedValues = builder.customerDefinedValues;
    }

    public String dataSetType() {
        return this.dataSetType;
    }

    public Instant dataSetPublicationDate() {
        return this.dataSetPublicationDate;
    }

    public String roleNameArn() {
        return this.roleNameArn;
    }

    public String destinationS3BucketName() {
        return this.destinationS3BucketName;
    }

    public String destinationS3Prefix() {
        return this.destinationS3Prefix;
    }

    public String snsTopicArn() {
        return this.snsTopicArn;
    }

    public Map<String, String> customerDefinedValues() {
        return this.customerDefinedValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dataSetType() == null ? 0 : this.dataSetType().hashCode());
        hashCode = 31 * hashCode + (this.dataSetPublicationDate() == null ? 0 : this.dataSetPublicationDate().hashCode());
        hashCode = 31 * hashCode + (this.roleNameArn() == null ? 0 : this.roleNameArn().hashCode());
        hashCode = 31 * hashCode + (this.destinationS3BucketName() == null ? 0 : this.destinationS3BucketName().hashCode());
        hashCode = 31 * hashCode + (this.destinationS3Prefix() == null ? 0 : this.destinationS3Prefix().hashCode());
        hashCode = 31 * hashCode + (this.snsTopicArn() == null ? 0 : this.snsTopicArn().hashCode());
        hashCode = 31 * hashCode + (this.customerDefinedValues() == null ? 0 : this.customerDefinedValues().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateDataSetRequest)) {
            return false;
        }
        GenerateDataSetRequest other = (GenerateDataSetRequest)((Object)obj);
        if (other.dataSetType() == null ^ this.dataSetType() == null) {
            return false;
        }
        if (other.dataSetType() != null && !other.dataSetType().equals(this.dataSetType())) {
            return false;
        }
        if (other.dataSetPublicationDate() == null ^ this.dataSetPublicationDate() == null) {
            return false;
        }
        if (other.dataSetPublicationDate() != null && !other.dataSetPublicationDate().equals(this.dataSetPublicationDate())) {
            return false;
        }
        if (other.roleNameArn() == null ^ this.roleNameArn() == null) {
            return false;
        }
        if (other.roleNameArn() != null && !other.roleNameArn().equals(this.roleNameArn())) {
            return false;
        }
        if (other.destinationS3BucketName() == null ^ this.destinationS3BucketName() == null) {
            return false;
        }
        if (other.destinationS3BucketName() != null && !other.destinationS3BucketName().equals(this.destinationS3BucketName())) {
            return false;
        }
        if (other.destinationS3Prefix() == null ^ this.destinationS3Prefix() == null) {
            return false;
        }
        if (other.destinationS3Prefix() != null && !other.destinationS3Prefix().equals(this.destinationS3Prefix())) {
            return false;
        }
        if (other.snsTopicArn() == null ^ this.snsTopicArn() == null) {
            return false;
        }
        if (other.snsTopicArn() != null && !other.snsTopicArn().equals(this.snsTopicArn())) {
            return false;
        }
        if (other.customerDefinedValues() == null ^ this.customerDefinedValues() == null) {
            return false;
        }
        return other.customerDefinedValues() == null || other.customerDefinedValues().equals(this.customerDefinedValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dataSetType() != null) {
            sb.append("DataSetType: ").append(this.dataSetType()).append(",");
        }
        if (this.dataSetPublicationDate() != null) {
            sb.append("DataSetPublicationDate: ").append(this.dataSetPublicationDate()).append(",");
        }
        if (this.roleNameArn() != null) {
            sb.append("RoleNameArn: ").append(this.roleNameArn()).append(",");
        }
        if (this.destinationS3BucketName() != null) {
            sb.append("DestinationS3BucketName: ").append(this.destinationS3BucketName()).append(",");
        }
        if (this.destinationS3Prefix() != null) {
            sb.append("DestinationS3Prefix: ").append(this.destinationS3Prefix()).append(",");
        }
        if (this.snsTopicArn() != null) {
            sb.append("SnsTopicArn: ").append(this.snsTopicArn()).append(",");
        }
        if (this.customerDefinedValues() != null) {
            sb.append("CustomerDefinedValues: ").append(this.customerDefinedValues()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String dataSetType;
        private Instant dataSetPublicationDate;
        private String roleNameArn;
        private String destinationS3BucketName;
        private String destinationS3Prefix;
        private String snsTopicArn;
        private Map<String, String> customerDefinedValues;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateDataSetRequest model) {
            this.setDataSetType(model.dataSetType);
            this.setDataSetPublicationDate(model.dataSetPublicationDate);
            this.setRoleNameArn(model.roleNameArn);
            this.setDestinationS3BucketName(model.destinationS3BucketName);
            this.setDestinationS3Prefix(model.destinationS3Prefix);
            this.setSnsTopicArn(model.snsTopicArn);
            this.setCustomerDefinedValues(model.customerDefinedValues);
        }

        public final String getDataSetType() {
            return this.dataSetType;
        }

        @Override
        public final Builder dataSetType(String dataSetType) {
            this.dataSetType = dataSetType;
            return this;
        }

        @Override
        public final Builder dataSetType(DataSetType dataSetType) {
            this.dataSetType(dataSetType.toString());
            return this;
        }

        public final void setDataSetType(String dataSetType) {
            this.dataSetType = dataSetType;
        }

        public final Instant getDataSetPublicationDate() {
            return this.dataSetPublicationDate;
        }

        @Override
        public final Builder dataSetPublicationDate(Instant dataSetPublicationDate) {
            this.dataSetPublicationDate = dataSetPublicationDate;
            return this;
        }

        public final void setDataSetPublicationDate(Instant dataSetPublicationDate) {
            this.dataSetPublicationDate = dataSetPublicationDate;
        }

        public final String getRoleNameArn() {
            return this.roleNameArn;
        }

        @Override
        public final Builder roleNameArn(String roleNameArn) {
            this.roleNameArn = roleNameArn;
            return this;
        }

        public final void setRoleNameArn(String roleNameArn) {
            this.roleNameArn = roleNameArn;
        }

        public final String getDestinationS3BucketName() {
            return this.destinationS3BucketName;
        }

        @Override
        public final Builder destinationS3BucketName(String destinationS3BucketName) {
            this.destinationS3BucketName = destinationS3BucketName;
            return this;
        }

        public final void setDestinationS3BucketName(String destinationS3BucketName) {
            this.destinationS3BucketName = destinationS3BucketName;
        }

        public final String getDestinationS3Prefix() {
            return this.destinationS3Prefix;
        }

        @Override
        public final Builder destinationS3Prefix(String destinationS3Prefix) {
            this.destinationS3Prefix = destinationS3Prefix;
            return this;
        }

        public final void setDestinationS3Prefix(String destinationS3Prefix) {
            this.destinationS3Prefix = destinationS3Prefix;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final Map<String, String> getCustomerDefinedValues() {
            return this.customerDefinedValues;
        }

        @Override
        public final Builder customerDefinedValues(Map<String, String> customerDefinedValues) {
            this.customerDefinedValues = CustomerDefinedValuesCopier.copy(customerDefinedValues);
            return this;
        }

        public final void setCustomerDefinedValues(Map<String, String> customerDefinedValues) {
            this.customerDefinedValues = CustomerDefinedValuesCopier.copy(customerDefinedValues);
        }

        public GenerateDataSetRequest build() {
            return new GenerateDataSetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GenerateDataSetRequest> {
        public Builder dataSetType(String var1);

        public Builder dataSetType(DataSetType var1);

        public Builder dataSetPublicationDate(Instant var1);

        public Builder roleNameArn(String var1);

        public Builder destinationS3BucketName(String var1);

        public Builder destinationS3Prefix(String var1);

        public Builder snsTopicArn(String var1);

        public Builder customerDefinedValues(Map<String, String> var1);
    }
}

