/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecommerceanalytics;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.AmazonServiceException;
import software.amazon.awssdk.core.SdkBaseException;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.ClientHandler;
import software.amazon.awssdk.core.client.SdkClientHandler;
import software.amazon.awssdk.core.config.ClientConfiguration;
import software.amazon.awssdk.core.config.SyncClientConfiguration;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.marketplacecommerceanalytics.MarketplaceCommerceAnalyticsClient;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.GenerateDataSetRequest;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.GenerateDataSetResponse;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.MarketplaceCommerceAnalyticsException;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.MarketplaceCommerceAnalyticsServiceException;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.StartSupportDataExportRequest;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.StartSupportDataExportResponse;
import software.amazon.awssdk.services.marketplacecommerceanalytics.transform.GenerateDataSetRequestMarshaller;
import software.amazon.awssdk.services.marketplacecommerceanalytics.transform.GenerateDataSetResponseUnmarshaller;
import software.amazon.awssdk.services.marketplacecommerceanalytics.transform.StartSupportDataExportRequestMarshaller;
import software.amazon.awssdk.services.marketplacecommerceanalytics.transform.StartSupportDataExportResponseUnmarshaller;

@SdkInternalApi
final class DefaultMarketplaceCommerceAnalyticsClient
implements MarketplaceCommerceAnalyticsClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final ClientConfiguration clientConfiguration;

    protected DefaultMarketplaceCommerceAnalyticsClient(SyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    @Override
    public GenerateDataSetResponse generateDataSet(GenerateDataSetRequest generateDataSetRequest) throws MarketplaceCommerceAnalyticsServiceException, SdkBaseException, SdkClientException, MarketplaceCommerceAnalyticsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GenerateDataSetResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GenerateDataSetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)generateDataSetRequest).withMarshaller((Marshaller)new GenerateDataSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StartSupportDataExportResponse startSupportDataExport(StartSupportDataExportRequest startSupportDataExportRequest) throws MarketplaceCommerceAnalyticsServiceException, SdkBaseException, SdkClientException, MarketplaceCommerceAnalyticsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartSupportDataExportResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (StartSupportDataExportResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startSupportDataExportRequest).withMarshaller((Marshaller)new StartSupportDataExportRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(MarketplaceCommerceAnalyticsException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MarketplaceCommerceAnalyticsServiceException").withModeledClass(MarketplaceCommerceAnalyticsServiceException.class)));
    }

    public void close() {
        this.clientHandler.close();
    }
}

