/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecommerceanalytics.model;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Container for the parameters to the StartSupportDataExport operation.
 */
@Generated("software.amazon.awssdk:codegen")
public class StartSupportDataExportRequest extends MarketplaceCommerceAnalyticsRequest implements
        ToCopyableBuilder<StartSupportDataExportRequest.Builder, StartSupportDataExportRequest> {
    private final String dataSetType;

    private final Instant fromDate;

    private final String roleNameArn;

    private final String destinationS3BucketName;

    private final String destinationS3Prefix;

    private final String snsTopicArn;

    private final Map<String, String> customerDefinedValues;

    private StartSupportDataExportRequest(BuilderImpl builder) {
        super(builder);
        this.dataSetType = builder.dataSetType;
        this.fromDate = builder.fromDate;
        this.roleNameArn = builder.roleNameArn;
        this.destinationS3BucketName = builder.destinationS3BucketName;
        this.destinationS3Prefix = builder.destinationS3Prefix;
        this.snsTopicArn = builder.snsTopicArn;
        this.customerDefinedValues = builder.customerDefinedValues;
    }

    /**
     * <p>
     * Specifies the data set type to be written to the output csv file. The data set types
     * customer_support_contacts_data and test_customer_support_contacts_data both result in a csv file containing the
     * following fields: Product Id, Product Code, Customer Guid, Subscription Guid, Subscription Start Date,
     * Organization, AWS Account Id, Given Name, Surname, Telephone Number, Email, Title, Country Code, ZIP Code,
     * Operation Type, and Operation Time.
     * </p>
     * <p>
     * <ul>
     * <li><i>customer_support_contacts_data</i> Customer support contact data. The data set will contain all changes
     * (Creates, Updates, and Deletes) to customer support contact data from the date specified in the from_date
     * parameter.</li>
     * <li><i>test_customer_support_contacts_data</i> An example data set containing static test data in the same format
     * as customer_support_contacts_data</li>
     * </ul>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSetType} will
     * return {@link SupportDataSetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataSetTypeString}.
     * </p>
     * 
     * @return Specifies the data set type to be written to the output csv file. The data set types
     *         customer_support_contacts_data and test_customer_support_contacts_data both result in a csv file
     *         containing the following fields: Product Id, Product Code, Customer Guid, Subscription Guid, Subscription
     *         Start Date, Organization, AWS Account Id, Given Name, Surname, Telephone Number, Email, Title, Country
     *         Code, ZIP Code, Operation Type, and Operation Time. </p>
     *         <p>
     *         <ul>
     *         <li><i>customer_support_contacts_data</i> Customer support contact data. The data set will contain all
     *         changes (Creates, Updates, and Deletes) to customer support contact data from the date specified in the
     *         from_date parameter.</li>
     *         <li><i>test_customer_support_contacts_data</i> An example data set containing static test data in the
     *         same format as customer_support_contacts_data</li>
     *         </ul>
     * @see SupportDataSetType
     */
    public SupportDataSetType dataSetType() {
        return SupportDataSetType.fromValue(dataSetType);
    }

    /**
     * <p>
     * Specifies the data set type to be written to the output csv file. The data set types
     * customer_support_contacts_data and test_customer_support_contacts_data both result in a csv file containing the
     * following fields: Product Id, Product Code, Customer Guid, Subscription Guid, Subscription Start Date,
     * Organization, AWS Account Id, Given Name, Surname, Telephone Number, Email, Title, Country Code, ZIP Code,
     * Operation Type, and Operation Time.
     * </p>
     * <p>
     * <ul>
     * <li><i>customer_support_contacts_data</i> Customer support contact data. The data set will contain all changes
     * (Creates, Updates, and Deletes) to customer support contact data from the date specified in the from_date
     * parameter.</li>
     * <li><i>test_customer_support_contacts_data</i> An example data set containing static test data in the same format
     * as customer_support_contacts_data</li>
     * </ul>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSetType} will
     * return {@link SupportDataSetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataSetTypeString}.
     * </p>
     * 
     * @return Specifies the data set type to be written to the output csv file. The data set types
     *         customer_support_contacts_data and test_customer_support_contacts_data both result in a csv file
     *         containing the following fields: Product Id, Product Code, Customer Guid, Subscription Guid, Subscription
     *         Start Date, Organization, AWS Account Id, Given Name, Surname, Telephone Number, Email, Title, Country
     *         Code, ZIP Code, Operation Type, and Operation Time. </p>
     *         <p>
     *         <ul>
     *         <li><i>customer_support_contacts_data</i> Customer support contact data. The data set will contain all
     *         changes (Creates, Updates, and Deletes) to customer support contact data from the date specified in the
     *         from_date parameter.</li>
     *         <li><i>test_customer_support_contacts_data</i> An example data set containing static test data in the
     *         same format as customer_support_contacts_data</li>
     *         </ul>
     * @see SupportDataSetType
     */
    public String dataSetTypeString() {
        return dataSetType;
    }

    /**
     * The start date from which to retrieve the data set in UTC. This parameter only affects the
     * customer_support_contacts_data data set type.
     * 
     * @return The start date from which to retrieve the data set in UTC. This parameter only affects the
     *         customer_support_contacts_data data set type.
     */
    public Instant fromDate() {
        return fromDate;
    }

    /**
     * The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the provided AWS
     * services.
     * 
     * @return The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the
     *         provided AWS services.
     */
    public String roleNameArn() {
        return roleNameArn;
    }

    /**
     * The name (friendly name, not ARN) of the destination S3 bucket.
     * 
     * @return The name (friendly name, not ARN) of the destination S3 bucket.
     */
    public String destinationS3BucketName() {
        return destinationS3BucketName;
    }

    /**
     * (Optional) The desired S3 prefix for the published data set, similar to a directory path in standard file
     * systems. For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets", the output file
     * "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile". If the prefix directory
     * structure does not exist, it will be created. If no prefix is provided, the data set will be published to the S3
     * bucket root.
     * 
     * @return (Optional) The desired S3 prefix for the published data set, similar to a directory path in standard file
     *         systems. For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets", the
     *         output file "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile". If the
     *         prefix directory structure does not exist, it will be created. If no prefix is provided, the data set
     *         will be published to the S3 bucket root.
     */
    public String destinationS3Prefix() {
        return destinationS3Prefix;
    }

    /**
     * Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been published or if an
     * error has occurred.
     * 
     * @return Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been published
     *         or if an error has occurred.
     */
    public String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * (Optional) Key-value pairs which will be returned, unmodified, in the Amazon SNS notification message and the
     * data set metadata file.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return (Optional) Key-value pairs which will be returned, unmodified, in the Amazon SNS notification message and
     *         the data set metadata file.
     */
    public Map<String, String> customerDefinedValues() {
        return customerDefinedValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSetTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(fromDate());
        hashCode = 31 * hashCode + Objects.hashCode(roleNameArn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(destinationS3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(customerDefinedValues());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSupportDataExportRequest)) {
            return false;
        }
        StartSupportDataExportRequest other = (StartSupportDataExportRequest) obj;
        return Objects.equals(dataSetTypeString(), other.dataSetTypeString()) && Objects.equals(fromDate(), other.fromDate())
                && Objects.equals(roleNameArn(), other.roleNameArn())
                && Objects.equals(destinationS3BucketName(), other.destinationS3BucketName())
                && Objects.equals(destinationS3Prefix(), other.destinationS3Prefix())
                && Objects.equals(snsTopicArn(), other.snsTopicArn())
                && Objects.equals(customerDefinedValues(), other.customerDefinedValues());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (dataSetTypeString() != null) {
            sb.append("DataSetType: ").append(dataSetTypeString()).append(",");
        }
        if (fromDate() != null) {
            sb.append("FromDate: ").append(fromDate()).append(",");
        }
        if (roleNameArn() != null) {
            sb.append("RoleNameArn: ").append(roleNameArn()).append(",");
        }
        if (destinationS3BucketName() != null) {
            sb.append("DestinationS3BucketName: ").append(destinationS3BucketName()).append(",");
        }
        if (destinationS3Prefix() != null) {
            sb.append("DestinationS3Prefix: ").append(destinationS3Prefix()).append(",");
        }
        if (snsTopicArn() != null) {
            sb.append("SnsTopicArn: ").append(snsTopicArn()).append(",");
        }
        if (customerDefinedValues() != null) {
            sb.append("CustomerDefinedValues: ").append(customerDefinedValues()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSetType":
            return Optional.of(clazz.cast(dataSetTypeString()));
        case "fromDate":
            return Optional.of(clazz.cast(fromDate()));
        case "roleNameArn":
            return Optional.of(clazz.cast(roleNameArn()));
        case "destinationS3BucketName":
            return Optional.of(clazz.cast(destinationS3BucketName()));
        case "destinationS3Prefix":
            return Optional.of(clazz.cast(destinationS3Prefix()));
        case "snsTopicArn":
            return Optional.of(clazz.cast(snsTopicArn()));
        case "customerDefinedValues":
            return Optional.of(clazz.cast(customerDefinedValues()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MarketplaceCommerceAnalyticsRequest.Builder,
            CopyableBuilder<Builder, StartSupportDataExportRequest> {
        /**
         * <p>
         * Specifies the data set type to be written to the output csv file. The data set types
         * customer_support_contacts_data and test_customer_support_contacts_data both result in a csv file containing
         * the following fields: Product Id, Product Code, Customer Guid, Subscription Guid, Subscription Start Date,
         * Organization, AWS Account Id, Given Name, Surname, Telephone Number, Email, Title, Country Code, ZIP Code,
         * Operation Type, and Operation Time.
         * </p>
         * <p>
         * <ul>
         * <li><i>customer_support_contacts_data</i> Customer support contact data. The data set will contain all
         * changes (Creates, Updates, and Deletes) to customer support contact data from the date specified in the
         * from_date parameter.</li>
         * <li><i>test_customer_support_contacts_data</i> An example data set containing static test data in the same
         * format as customer_support_contacts_data</li>
         * </ul>
         * </p>
         * 
         * @param dataSetType
         *        Specifies the data set type to be written to the output csv file. The data set types
         *        customer_support_contacts_data and test_customer_support_contacts_data both result in a csv file
         *        containing the following fields: Product Id, Product Code, Customer Guid, Subscription Guid,
         *        Subscription Start Date, Organization, AWS Account Id, Given Name, Surname, Telephone Number, Email,
         *        Title, Country Code, ZIP Code, Operation Type, and Operation Time. </p>
         *        <p>
         *        <ul>
         *        <li><i>customer_support_contacts_data</i> Customer support contact data. The data set will contain all
         *        changes (Creates, Updates, and Deletes) to customer support contact data from the date specified in
         *        the from_date parameter.</li>
         *        <li><i>test_customer_support_contacts_data</i> An example data set containing static test data in the
         *        same format as customer_support_contacts_data</li>
         *        </ul>
         * @see SupportDataSetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportDataSetType
         */
        Builder dataSetType(String dataSetType);

        /**
         * <p>
         * Specifies the data set type to be written to the output csv file. The data set types
         * customer_support_contacts_data and test_customer_support_contacts_data both result in a csv file containing
         * the following fields: Product Id, Product Code, Customer Guid, Subscription Guid, Subscription Start Date,
         * Organization, AWS Account Id, Given Name, Surname, Telephone Number, Email, Title, Country Code, ZIP Code,
         * Operation Type, and Operation Time.
         * </p>
         * <p>
         * <ul>
         * <li><i>customer_support_contacts_data</i> Customer support contact data. The data set will contain all
         * changes (Creates, Updates, and Deletes) to customer support contact data from the date specified in the
         * from_date parameter.</li>
         * <li><i>test_customer_support_contacts_data</i> An example data set containing static test data in the same
         * format as customer_support_contacts_data</li>
         * </ul>
         * </p>
         * 
         * @param dataSetType
         *        Specifies the data set type to be written to the output csv file. The data set types
         *        customer_support_contacts_data and test_customer_support_contacts_data both result in a csv file
         *        containing the following fields: Product Id, Product Code, Customer Guid, Subscription Guid,
         *        Subscription Start Date, Organization, AWS Account Id, Given Name, Surname, Telephone Number, Email,
         *        Title, Country Code, ZIP Code, Operation Type, and Operation Time. </p>
         *        <p>
         *        <ul>
         *        <li><i>customer_support_contacts_data</i> Customer support contact data. The data set will contain all
         *        changes (Creates, Updates, and Deletes) to customer support contact data from the date specified in
         *        the from_date parameter.</li>
         *        <li><i>test_customer_support_contacts_data</i> An example data set containing static test data in the
         *        same format as customer_support_contacts_data</li>
         *        </ul>
         * @see SupportDataSetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportDataSetType
         */
        Builder dataSetType(SupportDataSetType dataSetType);

        /**
         * The start date from which to retrieve the data set in UTC. This parameter only affects the
         * customer_support_contacts_data data set type.
         * 
         * @param fromDate
         *        The start date from which to retrieve the data set in UTC. This parameter only affects the
         *        customer_support_contacts_data data set type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromDate(Instant fromDate);

        /**
         * The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the provided
         * AWS services.
         * 
         * @param roleNameArn
         *        The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the
         *        provided AWS services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleNameArn(String roleNameArn);

        /**
         * The name (friendly name, not ARN) of the destination S3 bucket.
         * 
         * @param destinationS3BucketName
         *        The name (friendly name, not ARN) of the destination S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationS3BucketName(String destinationS3BucketName);

        /**
         * (Optional) The desired S3 prefix for the published data set, similar to a directory path in standard file
         * systems. For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets", the output
         * file "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile". If the prefix
         * directory structure does not exist, it will be created. If no prefix is provided, the data set will be
         * published to the S3 bucket root.
         * 
         * @param destinationS3Prefix
         *        (Optional) The desired S3 prefix for the published data set, similar to a directory path in standard
         *        file systems. For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets",
         *        the output file "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile". If
         *        the prefix directory structure does not exist, it will be created. If no prefix is provided, the data
         *        set will be published to the S3 bucket root.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationS3Prefix(String destinationS3Prefix);

        /**
         * Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been published or if
         * an error has occurred.
         * 
         * @param snsTopicArn
         *        Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been
         *        published or if an error has occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * (Optional) Key-value pairs which will be returned, unmodified, in the Amazon SNS notification message and the
         * data set metadata file.
         * 
         * @param customerDefinedValues
         *        (Optional) Key-value pairs which will be returned, unmodified, in the Amazon SNS notification message
         *        and the data set metadata file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerDefinedValues(Map<String, String> customerDefinedValues);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends MarketplaceCommerceAnalyticsRequest.BuilderImpl implements Builder {
        private String dataSetType;

        private Instant fromDate;

        private String roleNameArn;

        private String destinationS3BucketName;

        private String destinationS3Prefix;

        private String snsTopicArn;

        private Map<String, String> customerDefinedValues;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSupportDataExportRequest model) {
            dataSetType(model.dataSetType);
            fromDate(model.fromDate);
            roleNameArn(model.roleNameArn);
            destinationS3BucketName(model.destinationS3BucketName);
            destinationS3Prefix(model.destinationS3Prefix);
            snsTopicArn(model.snsTopicArn);
            customerDefinedValues(model.customerDefinedValues);
        }

        public final String getDataSetType() {
            return dataSetType;
        }

        @Override
        public final Builder dataSetType(String dataSetType) {
            this.dataSetType = dataSetType;
            return this;
        }

        @Override
        public final Builder dataSetType(SupportDataSetType dataSetType) {
            this.dataSetType(dataSetType.toString());
            return this;
        }

        public final void setDataSetType(String dataSetType) {
            this.dataSetType = dataSetType;
        }

        public final Instant getFromDate() {
            return fromDate;
        }

        @Override
        public final Builder fromDate(Instant fromDate) {
            this.fromDate = fromDate;
            return this;
        }

        public final void setFromDate(Instant fromDate) {
            this.fromDate = fromDate;
        }

        public final String getRoleNameArn() {
            return roleNameArn;
        }

        @Override
        public final Builder roleNameArn(String roleNameArn) {
            this.roleNameArn = roleNameArn;
            return this;
        }

        public final void setRoleNameArn(String roleNameArn) {
            this.roleNameArn = roleNameArn;
        }

        public final String getDestinationS3BucketName() {
            return destinationS3BucketName;
        }

        @Override
        public final Builder destinationS3BucketName(String destinationS3BucketName) {
            this.destinationS3BucketName = destinationS3BucketName;
            return this;
        }

        public final void setDestinationS3BucketName(String destinationS3BucketName) {
            this.destinationS3BucketName = destinationS3BucketName;
        }

        public final String getDestinationS3Prefix() {
            return destinationS3Prefix;
        }

        @Override
        public final Builder destinationS3Prefix(String destinationS3Prefix) {
            this.destinationS3Prefix = destinationS3Prefix;
            return this;
        }

        public final void setDestinationS3Prefix(String destinationS3Prefix) {
            this.destinationS3Prefix = destinationS3Prefix;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final Map<String, String> getCustomerDefinedValues() {
            return customerDefinedValues;
        }

        @Override
        public final Builder customerDefinedValues(Map<String, String> customerDefinedValues) {
            this.customerDefinedValues = CustomerDefinedValuesCopier.copy(customerDefinedValues);
            return this;
        }

        public final void setCustomerDefinedValues(Map<String, String> customerDefinedValues) {
            this.customerDefinedValues = CustomerDefinedValuesCopier.copy(customerDefinedValues);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public StartSupportDataExportRequest build() {
            return new StartSupportDataExportRequest(this);
        }
    }
}
