/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecommerceanalytics.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Container for the result of the GenerateDataSet operation.
 */
@Generated("software.amazon.awssdk:codegen")
public class GenerateDataSetResponse extends MarketplaceCommerceAnalyticsResponse implements
        ToCopyableBuilder<GenerateDataSetResponse.Builder, GenerateDataSetResponse> {
    private final String dataSetRequestId;

    private GenerateDataSetResponse(BuilderImpl builder) {
        super(builder);
        this.dataSetRequestId = builder.dataSetRequestId;
    }

    /**
     * A unique identifier representing a specific request to the GenerateDataSet operation. This identifier can be used
     * to correlate a request with notifications from the SNS topic.
     * 
     * @return A unique identifier representing a specific request to the GenerateDataSet operation. This identifier can
     *         be used to correlate a request with notifications from the SNS topic.
     */
    public String dataSetRequestId() {
        return dataSetRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSetRequestId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateDataSetResponse)) {
            return false;
        }
        GenerateDataSetResponse other = (GenerateDataSetResponse) obj;
        return Objects.equals(dataSetRequestId(), other.dataSetRequestId());
    }

    @Override
    public String toString() {
        return ToString.builder("GenerateDataSetResponse").add("DataSetRequestId", dataSetRequestId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSetRequestId":
            return Optional.of(clazz.cast(dataSetRequestId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MarketplaceCommerceAnalyticsResponse.Builder,
            CopyableBuilder<Builder, GenerateDataSetResponse> {
        /**
         * A unique identifier representing a specific request to the GenerateDataSet operation. This identifier can be
         * used to correlate a request with notifications from the SNS topic.
         * 
         * @param dataSetRequestId
         *        A unique identifier representing a specific request to the GenerateDataSet operation. This identifier
         *        can be used to correlate a request with notifications from the SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetRequestId(String dataSetRequestId);
    }

    static final class BuilderImpl extends MarketplaceCommerceAnalyticsResponse.BuilderImpl implements Builder {
        private String dataSetRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateDataSetResponse model) {
            dataSetRequestId(model.dataSetRequestId);
        }

        public final String getDataSetRequestId() {
            return dataSetRequestId;
        }

        @Override
        public final Builder dataSetRequestId(String dataSetRequestId) {
            this.dataSetRequestId = dataSetRequestId;
            return this;
        }

        public final void setDataSetRequestId(String dataSetRequestId) {
            this.dataSetRequestId = dataSetRequestId;
        }

        @Override
        public GenerateDataSetResponse build() {
            return new GenerateDataSetResponse(this);
        }
    }
}
