/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecommerceanalytics.model;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.CustomerDefinedValuesCopier;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.DataSetType;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.MarketplaceCommerceAnalyticsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GenerateDataSetRequest
extends MarketplaceCommerceAnalyticsRequest
implements ToCopyableBuilder<Builder, GenerateDataSetRequest> {
    private final String dataSetType;
    private final Instant dataSetPublicationDate;
    private final String roleNameArn;
    private final String destinationS3BucketName;
    private final String destinationS3Prefix;
    private final String snsTopicArn;
    private final Map<String, String> customerDefinedValues;

    private GenerateDataSetRequest(BuilderImpl builder) {
        super(builder);
        this.dataSetType = builder.dataSetType;
        this.dataSetPublicationDate = builder.dataSetPublicationDate;
        this.roleNameArn = builder.roleNameArn;
        this.destinationS3BucketName = builder.destinationS3BucketName;
        this.destinationS3Prefix = builder.destinationS3Prefix;
        this.snsTopicArn = builder.snsTopicArn;
        this.customerDefinedValues = builder.customerDefinedValues;
    }

    public DataSetType dataSetType() {
        return DataSetType.fromValue(this.dataSetType);
    }

    public String dataSetTypeString() {
        return this.dataSetType;
    }

    public Instant dataSetPublicationDate() {
        return this.dataSetPublicationDate;
    }

    public String roleNameArn() {
        return this.roleNameArn;
    }

    public String destinationS3BucketName() {
        return this.destinationS3BucketName;
    }

    public String destinationS3Prefix() {
        return this.destinationS3Prefix;
    }

    public String snsTopicArn() {
        return this.snsTopicArn;
    }

    public Map<String, String> customerDefinedValues() {
        return this.customerDefinedValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetPublicationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleNameArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationS3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerDefinedValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateDataSetRequest)) {
            return false;
        }
        GenerateDataSetRequest other = (GenerateDataSetRequest)((Object)obj);
        return Objects.equals(this.dataSetTypeString(), other.dataSetTypeString()) && Objects.equals(this.dataSetPublicationDate(), other.dataSetPublicationDate()) && Objects.equals(this.roleNameArn(), other.roleNameArn()) && Objects.equals(this.destinationS3BucketName(), other.destinationS3BucketName()) && Objects.equals(this.destinationS3Prefix(), other.destinationS3Prefix()) && Objects.equals(this.snsTopicArn(), other.snsTopicArn()) && Objects.equals(this.customerDefinedValues(), other.customerDefinedValues());
    }

    public String toString() {
        return ToString.builder((String)"GenerateDataSetRequest").add("DataSetType", (Object)this.dataSetTypeString()).add("DataSetPublicationDate", (Object)this.dataSetPublicationDate()).add("RoleNameArn", (Object)this.roleNameArn()).add("DestinationS3BucketName", (Object)this.destinationS3BucketName()).add("DestinationS3Prefix", (Object)this.destinationS3Prefix()).add("SnsTopicArn", (Object)this.snsTopicArn()).add("CustomerDefinedValues", this.customerDefinedValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSetType": {
                return Optional.of(clazz.cast(this.dataSetTypeString()));
            }
            case "dataSetPublicationDate": {
                return Optional.of(clazz.cast(this.dataSetPublicationDate()));
            }
            case "roleNameArn": {
                return Optional.of(clazz.cast(this.roleNameArn()));
            }
            case "destinationS3BucketName": {
                return Optional.of(clazz.cast(this.destinationS3BucketName()));
            }
            case "destinationS3Prefix": {
                return Optional.of(clazz.cast(this.destinationS3Prefix()));
            }
            case "snsTopicArn": {
                return Optional.of(clazz.cast(this.snsTopicArn()));
            }
            case "customerDefinedValues": {
                return Optional.of(clazz.cast(this.customerDefinedValues()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MarketplaceCommerceAnalyticsRequest.BuilderImpl
    implements Builder {
        private String dataSetType;
        private Instant dataSetPublicationDate;
        private String roleNameArn;
        private String destinationS3BucketName;
        private String destinationS3Prefix;
        private String snsTopicArn;
        private Map<String, String> customerDefinedValues;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateDataSetRequest model) {
            this.dataSetType(model.dataSetType);
            this.dataSetPublicationDate(model.dataSetPublicationDate);
            this.roleNameArn(model.roleNameArn);
            this.destinationS3BucketName(model.destinationS3BucketName);
            this.destinationS3Prefix(model.destinationS3Prefix);
            this.snsTopicArn(model.snsTopicArn);
            this.customerDefinedValues(model.customerDefinedValues);
        }

        public final String getDataSetType() {
            return this.dataSetType;
        }

        @Override
        public final Builder dataSetType(String dataSetType) {
            this.dataSetType = dataSetType;
            return this;
        }

        @Override
        public final Builder dataSetType(DataSetType dataSetType) {
            this.dataSetType(dataSetType.toString());
            return this;
        }

        public final void setDataSetType(String dataSetType) {
            this.dataSetType = dataSetType;
        }

        public final Instant getDataSetPublicationDate() {
            return this.dataSetPublicationDate;
        }

        @Override
        public final Builder dataSetPublicationDate(Instant dataSetPublicationDate) {
            this.dataSetPublicationDate = dataSetPublicationDate;
            return this;
        }

        public final void setDataSetPublicationDate(Instant dataSetPublicationDate) {
            this.dataSetPublicationDate = dataSetPublicationDate;
        }

        public final String getRoleNameArn() {
            return this.roleNameArn;
        }

        @Override
        public final Builder roleNameArn(String roleNameArn) {
            this.roleNameArn = roleNameArn;
            return this;
        }

        public final void setRoleNameArn(String roleNameArn) {
            this.roleNameArn = roleNameArn;
        }

        public final String getDestinationS3BucketName() {
            return this.destinationS3BucketName;
        }

        @Override
        public final Builder destinationS3BucketName(String destinationS3BucketName) {
            this.destinationS3BucketName = destinationS3BucketName;
            return this;
        }

        public final void setDestinationS3BucketName(String destinationS3BucketName) {
            this.destinationS3BucketName = destinationS3BucketName;
        }

        public final String getDestinationS3Prefix() {
            return this.destinationS3Prefix;
        }

        @Override
        public final Builder destinationS3Prefix(String destinationS3Prefix) {
            this.destinationS3Prefix = destinationS3Prefix;
            return this;
        }

        public final void setDestinationS3Prefix(String destinationS3Prefix) {
            this.destinationS3Prefix = destinationS3Prefix;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final Map<String, String> getCustomerDefinedValues() {
            return this.customerDefinedValues;
        }

        @Override
        public final Builder customerDefinedValues(Map<String, String> customerDefinedValues) {
            this.customerDefinedValues = CustomerDefinedValuesCopier.copy(customerDefinedValues);
            return this;
        }

        public final void setCustomerDefinedValues(Map<String, String> customerDefinedValues) {
            this.customerDefinedValues = CustomerDefinedValuesCopier.copy(customerDefinedValues);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GenerateDataSetRequest build() {
            return new GenerateDataSetRequest(this);
        }
    }

    public static interface Builder
    extends MarketplaceCommerceAnalyticsRequest.Builder,
    CopyableBuilder<Builder, GenerateDataSetRequest> {
        public Builder dataSetType(String var1);

        public Builder dataSetType(DataSetType var1);

        public Builder dataSetPublicationDate(Instant var1);

        public Builder roleNameArn(String var1);

        public Builder destinationS3BucketName(String var1);

        public Builder destinationS3Prefix(String var1);

        public Builder snsTopicArn(String var1);

        public Builder customerDefinedValues(Map<String, String> var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

