/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecommerceanalytics.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Container for the parameters to the GenerateDataSet operation.
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerateDataSetRequest extends MarketplaceCommerceAnalyticsRequest implements
        ToCopyableBuilder<GenerateDataSetRequest.Builder, GenerateDataSetRequest> {
    private static final SdkField<String> DATA_SET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSetType").getter(getter(GenerateDataSetRequest::dataSetTypeAsString))
            .setter(setter(Builder::dataSetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSetType").build()).build();

    private static final SdkField<Instant> DATA_SET_PUBLICATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("dataSetPublicationDate").getter(getter(GenerateDataSetRequest::dataSetPublicationDate))
            .setter(setter(Builder::dataSetPublicationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSetPublicationDate").build())
            .build();

    private static final SdkField<String> ROLE_NAME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleNameArn").getter(getter(GenerateDataSetRequest::roleNameArn)).setter(setter(Builder::roleNameArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleNameArn").build()).build();

    private static final SdkField<String> DESTINATION_S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationS3BucketName").getter(getter(GenerateDataSetRequest::destinationS3BucketName))
            .setter(setter(Builder::destinationS3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationS3BucketName").build())
            .build();

    private static final SdkField<String> DESTINATION_S3_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationS3Prefix").getter(getter(GenerateDataSetRequest::destinationS3Prefix))
            .setter(setter(Builder::destinationS3Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationS3Prefix").build())
            .build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snsTopicArn").getter(getter(GenerateDataSetRequest::snsTopicArn)).setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snsTopicArn").build()).build();

    private static final SdkField<Map<String, String>> CUSTOMER_DEFINED_VALUES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("customerDefinedValues")
            .getter(getter(GenerateDataSetRequest::customerDefinedValues))
            .setter(setter(Builder::customerDefinedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerDefinedValues").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_TYPE_FIELD,
            DATA_SET_PUBLICATION_DATE_FIELD, ROLE_NAME_ARN_FIELD, DESTINATION_S3_BUCKET_NAME_FIELD, DESTINATION_S3_PREFIX_FIELD,
            SNS_TOPIC_ARN_FIELD, CUSTOMER_DEFINED_VALUES_FIELD));

    private final String dataSetType;

    private final Instant dataSetPublicationDate;

    private final String roleNameArn;

    private final String destinationS3BucketName;

    private final String destinationS3Prefix;

    private final String snsTopicArn;

    private final Map<String, String> customerDefinedValues;

    private GenerateDataSetRequest(BuilderImpl builder) {
        super(builder);
        this.dataSetType = builder.dataSetType;
        this.dataSetPublicationDate = builder.dataSetPublicationDate;
        this.roleNameArn = builder.roleNameArn;
        this.destinationS3BucketName = builder.destinationS3BucketName;
        this.destinationS3Prefix = builder.destinationS3Prefix;
        this.snsTopicArn = builder.snsTopicArn;
        this.customerDefinedValues = builder.customerDefinedValues;
    }

    /**
     * <p>
     * The desired data set type.
     * </p>
     * <p>
     * <ul>
     * <li><strong>customer_subscriber_hourly_monthly_subscriptions</strong>
     * <p>
     * From 2017-09-15 to present: Available daily by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>customer_subscriber_annual_subscriptions</strong>
     * <p>
     * From 2017-09-15 to present: Available daily by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>daily_business_usage_by_instance_type</strong>
     * <p>
     * From 2017-09-15 to present: Available daily by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>daily_business_fees</strong>
     * <p>
     * From 2017-09-15 to present: Available daily by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>daily_business_free_trial_conversions</strong>
     * <p>
     * From 2017-09-15 to present: Available daily by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>daily_business_new_instances</strong>
     * <p>
     * From 2017-09-15 to present: Available daily by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>daily_business_new_product_subscribers</strong>
     * <p>
     * From 2017-09-15 to present: Available daily by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>daily_business_canceled_product_subscribers</strong>
     * <p>
     * From 2017-09-15 to present: Available daily by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>monthly_revenue_billing_and_revenue_data</strong>
     * <p>
     * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes metered
     * transactions (e.g. hourly) from one month prior.
     * </p>
     * </li>
     * <li><strong>monthly_revenue_annual_subscriptions</strong>
     * <p>
     * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes up-front
     * software charges (e.g. annual) from one month prior.
     * </p>
     * </li>
     * <li><strong>monthly_revenue_field_demonstration_usage</strong>
     * <p>
     * From 2018-03-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>monthly_revenue_flexible_payment_schedule</strong>
     * <p>
     * From 2018-11-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_product</strong>
     * <p>
     * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_instance_hours</strong>
     * <p>
     * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_customer_geo</strong>
     * <p>
     * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_age_of_uncollected_funds</strong>
     * <p>
     * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_age_of_disbursed_funds</strong>
     * <p>
     * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_age_of_past_due_funds</strong>
     * <p>
     * From 2018-04-07 to present: Available every 30 days by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_uncollected_funds_breakdown</strong>
     * <p>
     * From 2019-10-04 to present: Available every 30 days by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>sales_compensation_billed_revenue</strong>
     * <p>
     * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes metered
     * transactions (e.g. hourly) from one month prior, and up-front software charges (e.g. annual) from one month
     * prior.
     * </p>
     * </li>
     * <li><strong>us_sales_and_use_tax_records</strong>
     * <p>
     * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_product_with_uncollected_funds</strong>
     * <p>
     * This data set is deprecated. Download related reports from AMMP instead!
     * </p>
     * </li>
     * <li><strong>customer_profile_by_industry</strong>
     * <p>
     * This data set is deprecated. Download related reports from AMMP instead!
     * </p>
     * </li>
     * <li><strong>customer_profile_by_revenue</strong>
     * <p>
     * This data set is deprecated. Download related reports from AMMP instead!
     * </p>
     * </li>
     * <li><strong>customer_profile_by_geography</strong>
     * <p>
     * This data set is deprecated. Download related reports from AMMP instead!
     * </p>
     * </li>
     * </ul>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSetType} will
     * return {@link DataSetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataSetTypeAsString}.
     * </p>
     * 
     * @return The desired data set type.</p>
     *         <p>
     *         <ul>
     *         <li><strong>customer_subscriber_hourly_monthly_subscriptions</strong>
     *         <p>
     *         From 2017-09-15 to present: Available daily by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>customer_subscriber_annual_subscriptions</strong>
     *         <p>
     *         From 2017-09-15 to present: Available daily by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>daily_business_usage_by_instance_type</strong>
     *         <p>
     *         From 2017-09-15 to present: Available daily by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>daily_business_fees</strong>
     *         <p>
     *         From 2017-09-15 to present: Available daily by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>daily_business_free_trial_conversions</strong>
     *         <p>
     *         From 2017-09-15 to present: Available daily by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>daily_business_new_instances</strong>
     *         <p>
     *         From 2017-09-15 to present: Available daily by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>daily_business_new_product_subscribers</strong>
     *         <p>
     *         From 2017-09-15 to present: Available daily by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>daily_business_canceled_product_subscribers</strong>
     *         <p>
     *         From 2017-09-15 to present: Available daily by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>monthly_revenue_billing_and_revenue_data</strong>
     *         <p>
     *         From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes
     *         metered transactions (e.g. hourly) from one month prior.
     *         </p>
     *         </li>
     *         <li><strong>monthly_revenue_annual_subscriptions</strong>
     *         <p>
     *         From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes
     *         up-front software charges (e.g. annual) from one month prior.
     *         </p>
     *         </li>
     *         <li><strong>monthly_revenue_field_demonstration_usage</strong>
     *         <p>
     *         From 2018-03-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>monthly_revenue_flexible_payment_schedule</strong>
     *         <p>
     *         From 2018-11-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_product</strong>
     *         <p>
     *         From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_instance_hours</strong>
     *         <p>
     *         From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_customer_geo</strong>
     *         <p>
     *         From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_age_of_uncollected_funds</strong>
     *         <p>
     *         From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_age_of_disbursed_funds</strong>
     *         <p>
     *         From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_age_of_past_due_funds</strong>
     *         <p>
     *         From 2018-04-07 to present: Available every 30 days by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_uncollected_funds_breakdown</strong>
     *         <p>
     *         From 2019-10-04 to present: Available every 30 days by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>sales_compensation_billed_revenue</strong>
     *         <p>
     *         From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes
     *         metered transactions (e.g. hourly) from one month prior, and up-front software charges (e.g. annual) from
     *         one month prior.
     *         </p>
     *         </li>
     *         <li><strong>us_sales_and_use_tax_records</strong>
     *         <p>
     *         From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_product_with_uncollected_funds</strong>
     *         <p>
     *         This data set is deprecated. Download related reports from AMMP instead!
     *         </p>
     *         </li>
     *         <li><strong>customer_profile_by_industry</strong>
     *         <p>
     *         This data set is deprecated. Download related reports from AMMP instead!
     *         </p>
     *         </li>
     *         <li><strong>customer_profile_by_revenue</strong>
     *         <p>
     *         This data set is deprecated. Download related reports from AMMP instead!
     *         </p>
     *         </li>
     *         <li><strong>customer_profile_by_geography</strong>
     *         <p>
     *         This data set is deprecated. Download related reports from AMMP instead!
     *         </p>
     *         </li>
     *         </ul>
     * @see DataSetType
     */
    public final DataSetType dataSetType() {
        return DataSetType.fromValue(dataSetType);
    }

    /**
     * <p>
     * The desired data set type.
     * </p>
     * <p>
     * <ul>
     * <li><strong>customer_subscriber_hourly_monthly_subscriptions</strong>
     * <p>
     * From 2017-09-15 to present: Available daily by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>customer_subscriber_annual_subscriptions</strong>
     * <p>
     * From 2017-09-15 to present: Available daily by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>daily_business_usage_by_instance_type</strong>
     * <p>
     * From 2017-09-15 to present: Available daily by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>daily_business_fees</strong>
     * <p>
     * From 2017-09-15 to present: Available daily by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>daily_business_free_trial_conversions</strong>
     * <p>
     * From 2017-09-15 to present: Available daily by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>daily_business_new_instances</strong>
     * <p>
     * From 2017-09-15 to present: Available daily by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>daily_business_new_product_subscribers</strong>
     * <p>
     * From 2017-09-15 to present: Available daily by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>daily_business_canceled_product_subscribers</strong>
     * <p>
     * From 2017-09-15 to present: Available daily by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>monthly_revenue_billing_and_revenue_data</strong>
     * <p>
     * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes metered
     * transactions (e.g. hourly) from one month prior.
     * </p>
     * </li>
     * <li><strong>monthly_revenue_annual_subscriptions</strong>
     * <p>
     * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes up-front
     * software charges (e.g. annual) from one month prior.
     * </p>
     * </li>
     * <li><strong>monthly_revenue_field_demonstration_usage</strong>
     * <p>
     * From 2018-03-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>monthly_revenue_flexible_payment_schedule</strong>
     * <p>
     * From 2018-11-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_product</strong>
     * <p>
     * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_instance_hours</strong>
     * <p>
     * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_customer_geo</strong>
     * <p>
     * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_age_of_uncollected_funds</strong>
     * <p>
     * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_age_of_disbursed_funds</strong>
     * <p>
     * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_age_of_past_due_funds</strong>
     * <p>
     * From 2018-04-07 to present: Available every 30 days by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_uncollected_funds_breakdown</strong>
     * <p>
     * From 2019-10-04 to present: Available every 30 days by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>sales_compensation_billed_revenue</strong>
     * <p>
     * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes metered
     * transactions (e.g. hourly) from one month prior, and up-front software charges (e.g. annual) from one month
     * prior.
     * </p>
     * </li>
     * <li><strong>us_sales_and_use_tax_records</strong>
     * <p>
     * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
     * </p>
     * </li>
     * <li><strong>disbursed_amount_by_product_with_uncollected_funds</strong>
     * <p>
     * This data set is deprecated. Download related reports from AMMP instead!
     * </p>
     * </li>
     * <li><strong>customer_profile_by_industry</strong>
     * <p>
     * This data set is deprecated. Download related reports from AMMP instead!
     * </p>
     * </li>
     * <li><strong>customer_profile_by_revenue</strong>
     * <p>
     * This data set is deprecated. Download related reports from AMMP instead!
     * </p>
     * </li>
     * <li><strong>customer_profile_by_geography</strong>
     * <p>
     * This data set is deprecated. Download related reports from AMMP instead!
     * </p>
     * </li>
     * </ul>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSetType} will
     * return {@link DataSetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataSetTypeAsString}.
     * </p>
     * 
     * @return The desired data set type.</p>
     *         <p>
     *         <ul>
     *         <li><strong>customer_subscriber_hourly_monthly_subscriptions</strong>
     *         <p>
     *         From 2017-09-15 to present: Available daily by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>customer_subscriber_annual_subscriptions</strong>
     *         <p>
     *         From 2017-09-15 to present: Available daily by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>daily_business_usage_by_instance_type</strong>
     *         <p>
     *         From 2017-09-15 to present: Available daily by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>daily_business_fees</strong>
     *         <p>
     *         From 2017-09-15 to present: Available daily by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>daily_business_free_trial_conversions</strong>
     *         <p>
     *         From 2017-09-15 to present: Available daily by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>daily_business_new_instances</strong>
     *         <p>
     *         From 2017-09-15 to present: Available daily by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>daily_business_new_product_subscribers</strong>
     *         <p>
     *         From 2017-09-15 to present: Available daily by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>daily_business_canceled_product_subscribers</strong>
     *         <p>
     *         From 2017-09-15 to present: Available daily by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>monthly_revenue_billing_and_revenue_data</strong>
     *         <p>
     *         From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes
     *         metered transactions (e.g. hourly) from one month prior.
     *         </p>
     *         </li>
     *         <li><strong>monthly_revenue_annual_subscriptions</strong>
     *         <p>
     *         From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes
     *         up-front software charges (e.g. annual) from one month prior.
     *         </p>
     *         </li>
     *         <li><strong>monthly_revenue_field_demonstration_usage</strong>
     *         <p>
     *         From 2018-03-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>monthly_revenue_flexible_payment_schedule</strong>
     *         <p>
     *         From 2018-11-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_product</strong>
     *         <p>
     *         From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_instance_hours</strong>
     *         <p>
     *         From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_customer_geo</strong>
     *         <p>
     *         From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_age_of_uncollected_funds</strong>
     *         <p>
     *         From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_age_of_disbursed_funds</strong>
     *         <p>
     *         From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_age_of_past_due_funds</strong>
     *         <p>
     *         From 2018-04-07 to present: Available every 30 days by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_uncollected_funds_breakdown</strong>
     *         <p>
     *         From 2019-10-04 to present: Available every 30 days by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>sales_compensation_billed_revenue</strong>
     *         <p>
     *         From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes
     *         metered transactions (e.g. hourly) from one month prior, and up-front software charges (e.g. annual) from
     *         one month prior.
     *         </p>
     *         </li>
     *         <li><strong>us_sales_and_use_tax_records</strong>
     *         <p>
     *         From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
     *         </p>
     *         </li>
     *         <li><strong>disbursed_amount_by_product_with_uncollected_funds</strong>
     *         <p>
     *         This data set is deprecated. Download related reports from AMMP instead!
     *         </p>
     *         </li>
     *         <li><strong>customer_profile_by_industry</strong>
     *         <p>
     *         This data set is deprecated. Download related reports from AMMP instead!
     *         </p>
     *         </li>
     *         <li><strong>customer_profile_by_revenue</strong>
     *         <p>
     *         This data set is deprecated. Download related reports from AMMP instead!
     *         </p>
     *         </li>
     *         <li><strong>customer_profile_by_geography</strong>
     *         <p>
     *         This data set is deprecated. Download related reports from AMMP instead!
     *         </p>
     *         </li>
     *         </ul>
     * @see DataSetType
     */
    public final String dataSetTypeAsString() {
        return dataSetType;
    }

    /**
     * The date a data set was published. For daily data sets, provide a date with day-level granularity for the desired
     * day. For monthly data sets except those with prefix disbursed_amount, provide a date with month-level granularity
     * for the desired month (the day value will be ignored). For data sets with prefix disbursed_amount, provide a date
     * with day-level granularity for the desired day. For these data sets we will look backwards in time over the range
     * of 31 days until the first data set is found (the latest one).
     * 
     * @return The date a data set was published. For daily data sets, provide a date with day-level granularity for the
     *         desired day. For monthly data sets except those with prefix disbursed_amount, provide a date with
     *         month-level granularity for the desired month (the day value will be ignored). For data sets with prefix
     *         disbursed_amount, provide a date with day-level granularity for the desired day. For these data sets we
     *         will look backwards in time over the range of 31 days until the first data set is found (the latest one).
     */
    public final Instant dataSetPublicationDate() {
        return dataSetPublicationDate;
    }

    /**
     * The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the provided AWS
     * services.
     * 
     * @return The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the
     *         provided AWS services.
     */
    public final String roleNameArn() {
        return roleNameArn;
    }

    /**
     * The name (friendly name, not ARN) of the destination S3 bucket.
     * 
     * @return The name (friendly name, not ARN) of the destination S3 bucket.
     */
    public final String destinationS3BucketName() {
        return destinationS3BucketName;
    }

    /**
     * (Optional) The desired S3 prefix for the published data set, similar to a directory path in standard file
     * systems. For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets", the output file
     * "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile". If the prefix directory
     * structure does not exist, it will be created. If no prefix is provided, the data set will be published to the S3
     * bucket root.
     * 
     * @return (Optional) The desired S3 prefix for the published data set, similar to a directory path in standard file
     *         systems. For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets", the
     *         output file "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile". If the
     *         prefix directory structure does not exist, it will be created. If no prefix is provided, the data set
     *         will be published to the S3 bucket root.
     */
    public final String destinationS3Prefix() {
        return destinationS3Prefix;
    }

    /**
     * Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been published or if an
     * error has occurred.
     * 
     * @return Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been published
     *         or if an error has occurred.
     */
    public final String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * Returns true if the CustomerDefinedValues property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasCustomerDefinedValues() {
        return customerDefinedValues != null && !(customerDefinedValues instanceof SdkAutoConstructMap);
    }

    /**
     * (Optional) Key-value pairs which will be returned, unmodified, in the Amazon SNS notification message and the
     * data set metadata file. These key-value pairs can be used to correlated responses with tracking information from
     * other systems.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCustomerDefinedValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return (Optional) Key-value pairs which will be returned, unmodified, in the Amazon SNS notification message and
     *         the data set metadata file. These key-value pairs can be used to correlated responses with tracking
     *         information from other systems.
     */
    public final Map<String, String> customerDefinedValues() {
        return customerDefinedValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataSetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetPublicationDate());
        hashCode = 31 * hashCode + Objects.hashCode(roleNameArn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(destinationS3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomerDefinedValues() ? customerDefinedValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateDataSetRequest)) {
            return false;
        }
        GenerateDataSetRequest other = (GenerateDataSetRequest) obj;
        return Objects.equals(dataSetTypeAsString(), other.dataSetTypeAsString())
                && Objects.equals(dataSetPublicationDate(), other.dataSetPublicationDate())
                && Objects.equals(roleNameArn(), other.roleNameArn())
                && Objects.equals(destinationS3BucketName(), other.destinationS3BucketName())
                && Objects.equals(destinationS3Prefix(), other.destinationS3Prefix())
                && Objects.equals(snsTopicArn(), other.snsTopicArn())
                && hasCustomerDefinedValues() == other.hasCustomerDefinedValues()
                && Objects.equals(customerDefinedValues(), other.customerDefinedValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerateDataSetRequest").add("DataSetType", dataSetTypeAsString())
                .add("DataSetPublicationDate", dataSetPublicationDate()).add("RoleNameArn", roleNameArn())
                .add("DestinationS3BucketName", destinationS3BucketName()).add("DestinationS3Prefix", destinationS3Prefix())
                .add("SnsTopicArn", snsTopicArn())
                .add("CustomerDefinedValues", hasCustomerDefinedValues() ? customerDefinedValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSetType":
            return Optional.ofNullable(clazz.cast(dataSetTypeAsString()));
        case "dataSetPublicationDate":
            return Optional.ofNullable(clazz.cast(dataSetPublicationDate()));
        case "roleNameArn":
            return Optional.ofNullable(clazz.cast(roleNameArn()));
        case "destinationS3BucketName":
            return Optional.ofNullable(clazz.cast(destinationS3BucketName()));
        case "destinationS3Prefix":
            return Optional.ofNullable(clazz.cast(destinationS3Prefix()));
        case "snsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "customerDefinedValues":
            return Optional.ofNullable(clazz.cast(customerDefinedValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GenerateDataSetRequest, T> g) {
        return obj -> g.apply((GenerateDataSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MarketplaceCommerceAnalyticsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GenerateDataSetRequest> {
        /**
         * <p>
         * The desired data set type.
         * </p>
         * <p>
         * <ul>
         * <li><strong>customer_subscriber_hourly_monthly_subscriptions</strong>
         * <p>
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>customer_subscriber_annual_subscriptions</strong>
         * <p>
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>daily_business_usage_by_instance_type</strong>
         * <p>
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>daily_business_fees</strong>
         * <p>
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>daily_business_free_trial_conversions</strong>
         * <p>
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>daily_business_new_instances</strong>
         * <p>
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>daily_business_new_product_subscribers</strong>
         * <p>
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>daily_business_canceled_product_subscribers</strong>
         * <p>
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>monthly_revenue_billing_and_revenue_data</strong>
         * <p>
         * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes
         * metered transactions (e.g. hourly) from one month prior.
         * </p>
         * </li>
         * <li><strong>monthly_revenue_annual_subscriptions</strong>
         * <p>
         * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes
         * up-front software charges (e.g. annual) from one month prior.
         * </p>
         * </li>
         * <li><strong>monthly_revenue_field_demonstration_usage</strong>
         * <p>
         * From 2018-03-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>monthly_revenue_flexible_payment_schedule</strong>
         * <p>
         * From 2018-11-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_product</strong>
         * <p>
         * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_instance_hours</strong>
         * <p>
         * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_customer_geo</strong>
         * <p>
         * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_age_of_uncollected_funds</strong>
         * <p>
         * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_age_of_disbursed_funds</strong>
         * <p>
         * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_age_of_past_due_funds</strong>
         * <p>
         * From 2018-04-07 to present: Available every 30 days by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_uncollected_funds_breakdown</strong>
         * <p>
         * From 2019-10-04 to present: Available every 30 days by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>sales_compensation_billed_revenue</strong>
         * <p>
         * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes
         * metered transactions (e.g. hourly) from one month prior, and up-front software charges (e.g. annual) from one
         * month prior.
         * </p>
         * </li>
         * <li><strong>us_sales_and_use_tax_records</strong>
         * <p>
         * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_product_with_uncollected_funds</strong>
         * <p>
         * This data set is deprecated. Download related reports from AMMP instead!
         * </p>
         * </li>
         * <li><strong>customer_profile_by_industry</strong>
         * <p>
         * This data set is deprecated. Download related reports from AMMP instead!
         * </p>
         * </li>
         * <li><strong>customer_profile_by_revenue</strong>
         * <p>
         * This data set is deprecated. Download related reports from AMMP instead!
         * </p>
         * </li>
         * <li><strong>customer_profile_by_geography</strong>
         * <p>
         * This data set is deprecated. Download related reports from AMMP instead!
         * </p>
         * </li>
         * </ul>
         * </p>
         * 
         * @param dataSetType
         *        The desired data set type.</p>
         *        <p>
         *        <ul>
         *        <li><strong>customer_subscriber_hourly_monthly_subscriptions</strong>
         *        <p>
         *        From 2017-09-15 to present: Available daily by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>customer_subscriber_annual_subscriptions</strong>
         *        <p>
         *        From 2017-09-15 to present: Available daily by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>daily_business_usage_by_instance_type</strong>
         *        <p>
         *        From 2017-09-15 to present: Available daily by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>daily_business_fees</strong>
         *        <p>
         *        From 2017-09-15 to present: Available daily by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>daily_business_free_trial_conversions</strong>
         *        <p>
         *        From 2017-09-15 to present: Available daily by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>daily_business_new_instances</strong>
         *        <p>
         *        From 2017-09-15 to present: Available daily by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>daily_business_new_product_subscribers</strong>
         *        <p>
         *        From 2017-09-15 to present: Available daily by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>daily_business_canceled_product_subscribers</strong>
         *        <p>
         *        From 2017-09-15 to present: Available daily by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>monthly_revenue_billing_and_revenue_data</strong>
         *        <p>
         *        From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes
         *        metered transactions (e.g. hourly) from one month prior.
         *        </p>
         *        </li>
         *        <li><strong>monthly_revenue_annual_subscriptions</strong>
         *        <p>
         *        From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes
         *        up-front software charges (e.g. annual) from one month prior.
         *        </p>
         *        </li>
         *        <li><strong>monthly_revenue_field_demonstration_usage</strong>
         *        <p>
         *        From 2018-03-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>monthly_revenue_flexible_payment_schedule</strong>
         *        <p>
         *        From 2018-11-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_product</strong>
         *        <p>
         *        From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_instance_hours</strong>
         *        <p>
         *        From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_customer_geo</strong>
         *        <p>
         *        From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_age_of_uncollected_funds</strong>
         *        <p>
         *        From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_age_of_disbursed_funds</strong>
         *        <p>
         *        From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_age_of_past_due_funds</strong>
         *        <p>
         *        From 2018-04-07 to present: Available every 30 days by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_uncollected_funds_breakdown</strong>
         *        <p>
         *        From 2019-10-04 to present: Available every 30 days by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>sales_compensation_billed_revenue</strong>
         *        <p>
         *        From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes
         *        metered transactions (e.g. hourly) from one month prior, and up-front software charges (e.g. annual)
         *        from one month prior.
         *        </p>
         *        </li>
         *        <li><strong>us_sales_and_use_tax_records</strong>
         *        <p>
         *        From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_product_with_uncollected_funds</strong>
         *        <p>
         *        This data set is deprecated. Download related reports from AMMP instead!
         *        </p>
         *        </li>
         *        <li><strong>customer_profile_by_industry</strong>
         *        <p>
         *        This data set is deprecated. Download related reports from AMMP instead!
         *        </p>
         *        </li>
         *        <li><strong>customer_profile_by_revenue</strong>
         *        <p>
         *        This data set is deprecated. Download related reports from AMMP instead!
         *        </p>
         *        </li>
         *        <li><strong>customer_profile_by_geography</strong>
         *        <p>
         *        This data set is deprecated. Download related reports from AMMP instead!
         *        </p>
         *        </li>
         *        </ul>
         * @see DataSetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSetType
         */
        Builder dataSetType(String dataSetType);

        /**
         * <p>
         * The desired data set type.
         * </p>
         * <p>
         * <ul>
         * <li><strong>customer_subscriber_hourly_monthly_subscriptions</strong>
         * <p>
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>customer_subscriber_annual_subscriptions</strong>
         * <p>
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>daily_business_usage_by_instance_type</strong>
         * <p>
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>daily_business_fees</strong>
         * <p>
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>daily_business_free_trial_conversions</strong>
         * <p>
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>daily_business_new_instances</strong>
         * <p>
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>daily_business_new_product_subscribers</strong>
         * <p>
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>daily_business_canceled_product_subscribers</strong>
         * <p>
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>monthly_revenue_billing_and_revenue_data</strong>
         * <p>
         * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes
         * metered transactions (e.g. hourly) from one month prior.
         * </p>
         * </li>
         * <li><strong>monthly_revenue_annual_subscriptions</strong>
         * <p>
         * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes
         * up-front software charges (e.g. annual) from one month prior.
         * </p>
         * </li>
         * <li><strong>monthly_revenue_field_demonstration_usage</strong>
         * <p>
         * From 2018-03-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>monthly_revenue_flexible_payment_schedule</strong>
         * <p>
         * From 2018-11-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_product</strong>
         * <p>
         * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_instance_hours</strong>
         * <p>
         * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_customer_geo</strong>
         * <p>
         * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_age_of_uncollected_funds</strong>
         * <p>
         * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_age_of_disbursed_funds</strong>
         * <p>
         * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_age_of_past_due_funds</strong>
         * <p>
         * From 2018-04-07 to present: Available every 30 days by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_uncollected_funds_breakdown</strong>
         * <p>
         * From 2019-10-04 to present: Available every 30 days by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>sales_compensation_billed_revenue</strong>
         * <p>
         * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes
         * metered transactions (e.g. hourly) from one month prior, and up-front software charges (e.g. annual) from one
         * month prior.
         * </p>
         * </li>
         * <li><strong>us_sales_and_use_tax_records</strong>
         * <p>
         * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
         * </p>
         * </li>
         * <li><strong>disbursed_amount_by_product_with_uncollected_funds</strong>
         * <p>
         * This data set is deprecated. Download related reports from AMMP instead!
         * </p>
         * </li>
         * <li><strong>customer_profile_by_industry</strong>
         * <p>
         * This data set is deprecated. Download related reports from AMMP instead!
         * </p>
         * </li>
         * <li><strong>customer_profile_by_revenue</strong>
         * <p>
         * This data set is deprecated. Download related reports from AMMP instead!
         * </p>
         * </li>
         * <li><strong>customer_profile_by_geography</strong>
         * <p>
         * This data set is deprecated. Download related reports from AMMP instead!
         * </p>
         * </li>
         * </ul>
         * </p>
         * 
         * @param dataSetType
         *        The desired data set type.</p>
         *        <p>
         *        <ul>
         *        <li><strong>customer_subscriber_hourly_monthly_subscriptions</strong>
         *        <p>
         *        From 2017-09-15 to present: Available daily by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>customer_subscriber_annual_subscriptions</strong>
         *        <p>
         *        From 2017-09-15 to present: Available daily by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>daily_business_usage_by_instance_type</strong>
         *        <p>
         *        From 2017-09-15 to present: Available daily by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>daily_business_fees</strong>
         *        <p>
         *        From 2017-09-15 to present: Available daily by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>daily_business_free_trial_conversions</strong>
         *        <p>
         *        From 2017-09-15 to present: Available daily by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>daily_business_new_instances</strong>
         *        <p>
         *        From 2017-09-15 to present: Available daily by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>daily_business_new_product_subscribers</strong>
         *        <p>
         *        From 2017-09-15 to present: Available daily by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>daily_business_canceled_product_subscribers</strong>
         *        <p>
         *        From 2017-09-15 to present: Available daily by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>monthly_revenue_billing_and_revenue_data</strong>
         *        <p>
         *        From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes
         *        metered transactions (e.g. hourly) from one month prior.
         *        </p>
         *        </li>
         *        <li><strong>monthly_revenue_annual_subscriptions</strong>
         *        <p>
         *        From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes
         *        up-front software charges (e.g. annual) from one month prior.
         *        </p>
         *        </li>
         *        <li><strong>monthly_revenue_field_demonstration_usage</strong>
         *        <p>
         *        From 2018-03-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>monthly_revenue_flexible_payment_schedule</strong>
         *        <p>
         *        From 2018-11-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_product</strong>
         *        <p>
         *        From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_instance_hours</strong>
         *        <p>
         *        From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_customer_geo</strong>
         *        <p>
         *        From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_age_of_uncollected_funds</strong>
         *        <p>
         *        From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_age_of_disbursed_funds</strong>
         *        <p>
         *        From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_age_of_past_due_funds</strong>
         *        <p>
         *        From 2018-04-07 to present: Available every 30 days by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_uncollected_funds_breakdown</strong>
         *        <p>
         *        From 2019-10-04 to present: Available every 30 days by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>sales_compensation_billed_revenue</strong>
         *        <p>
         *        From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes
         *        metered transactions (e.g. hourly) from one month prior, and up-front software charges (e.g. annual)
         *        from one month prior.
         *        </p>
         *        </li>
         *        <li><strong>us_sales_and_use_tax_records</strong>
         *        <p>
         *        From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
         *        </p>
         *        </li>
         *        <li><strong>disbursed_amount_by_product_with_uncollected_funds</strong>
         *        <p>
         *        This data set is deprecated. Download related reports from AMMP instead!
         *        </p>
         *        </li>
         *        <li><strong>customer_profile_by_industry</strong>
         *        <p>
         *        This data set is deprecated. Download related reports from AMMP instead!
         *        </p>
         *        </li>
         *        <li><strong>customer_profile_by_revenue</strong>
         *        <p>
         *        This data set is deprecated. Download related reports from AMMP instead!
         *        </p>
         *        </li>
         *        <li><strong>customer_profile_by_geography</strong>
         *        <p>
         *        This data set is deprecated. Download related reports from AMMP instead!
         *        </p>
         *        </li>
         *        </ul>
         * @see DataSetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSetType
         */
        Builder dataSetType(DataSetType dataSetType);

        /**
         * The date a data set was published. For daily data sets, provide a date with day-level granularity for the
         * desired day. For monthly data sets except those with prefix disbursed_amount, provide a date with month-level
         * granularity for the desired month (the day value will be ignored). For data sets with prefix
         * disbursed_amount, provide a date with day-level granularity for the desired day. For these data sets we will
         * look backwards in time over the range of 31 days until the first data set is found (the latest one).
         * 
         * @param dataSetPublicationDate
         *        The date a data set was published. For daily data sets, provide a date with day-level granularity for
         *        the desired day. For monthly data sets except those with prefix disbursed_amount, provide a date with
         *        month-level granularity for the desired month (the day value will be ignored). For data sets with
         *        prefix disbursed_amount, provide a date with day-level granularity for the desired day. For these data
         *        sets we will look backwards in time over the range of 31 days until the first data set is found (the
         *        latest one).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetPublicationDate(Instant dataSetPublicationDate);

        /**
         * The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the provided
         * AWS services.
         * 
         * @param roleNameArn
         *        The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the
         *        provided AWS services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleNameArn(String roleNameArn);

        /**
         * The name (friendly name, not ARN) of the destination S3 bucket.
         * 
         * @param destinationS3BucketName
         *        The name (friendly name, not ARN) of the destination S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationS3BucketName(String destinationS3BucketName);

        /**
         * (Optional) The desired S3 prefix for the published data set, similar to a directory path in standard file
         * systems. For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets", the output
         * file "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile". If the prefix
         * directory structure does not exist, it will be created. If no prefix is provided, the data set will be
         * published to the S3 bucket root.
         * 
         * @param destinationS3Prefix
         *        (Optional) The desired S3 prefix for the published data set, similar to a directory path in standard
         *        file systems. For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets",
         *        the output file "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile". If
         *        the prefix directory structure does not exist, it will be created. If no prefix is provided, the data
         *        set will be published to the S3 bucket root.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationS3Prefix(String destinationS3Prefix);

        /**
         * Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been published or if
         * an error has occurred.
         * 
         * @param snsTopicArn
         *        Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been
         *        published or if an error has occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * (Optional) Key-value pairs which will be returned, unmodified, in the Amazon SNS notification message and the
         * data set metadata file. These key-value pairs can be used to correlated responses with tracking information
         * from other systems.
         * 
         * @param customerDefinedValues
         *        (Optional) Key-value pairs which will be returned, unmodified, in the Amazon SNS notification message
         *        and the data set metadata file. These key-value pairs can be used to correlated responses with
         *        tracking information from other systems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerDefinedValues(Map<String, String> customerDefinedValues);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MarketplaceCommerceAnalyticsRequest.BuilderImpl implements Builder {
        private String dataSetType;

        private Instant dataSetPublicationDate;

        private String roleNameArn;

        private String destinationS3BucketName;

        private String destinationS3Prefix;

        private String snsTopicArn;

        private Map<String, String> customerDefinedValues = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateDataSetRequest model) {
            super(model);
            dataSetType(model.dataSetType);
            dataSetPublicationDate(model.dataSetPublicationDate);
            roleNameArn(model.roleNameArn);
            destinationS3BucketName(model.destinationS3BucketName);
            destinationS3Prefix(model.destinationS3Prefix);
            snsTopicArn(model.snsTopicArn);
            customerDefinedValues(model.customerDefinedValues);
        }

        public final String getDataSetType() {
            return dataSetType;
        }

        public final void setDataSetType(String dataSetType) {
            this.dataSetType = dataSetType;
        }

        @Override
        @Transient
        public final Builder dataSetType(String dataSetType) {
            this.dataSetType = dataSetType;
            return this;
        }

        @Override
        @Transient
        public final Builder dataSetType(DataSetType dataSetType) {
            this.dataSetType(dataSetType == null ? null : dataSetType.toString());
            return this;
        }

        public final Instant getDataSetPublicationDate() {
            return dataSetPublicationDate;
        }

        public final void setDataSetPublicationDate(Instant dataSetPublicationDate) {
            this.dataSetPublicationDate = dataSetPublicationDate;
        }

        @Override
        @Transient
        public final Builder dataSetPublicationDate(Instant dataSetPublicationDate) {
            this.dataSetPublicationDate = dataSetPublicationDate;
            return this;
        }

        public final String getRoleNameArn() {
            return roleNameArn;
        }

        public final void setRoleNameArn(String roleNameArn) {
            this.roleNameArn = roleNameArn;
        }

        @Override
        @Transient
        public final Builder roleNameArn(String roleNameArn) {
            this.roleNameArn = roleNameArn;
            return this;
        }

        public final String getDestinationS3BucketName() {
            return destinationS3BucketName;
        }

        public final void setDestinationS3BucketName(String destinationS3BucketName) {
            this.destinationS3BucketName = destinationS3BucketName;
        }

        @Override
        @Transient
        public final Builder destinationS3BucketName(String destinationS3BucketName) {
            this.destinationS3BucketName = destinationS3BucketName;
            return this;
        }

        public final String getDestinationS3Prefix() {
            return destinationS3Prefix;
        }

        public final void setDestinationS3Prefix(String destinationS3Prefix) {
            this.destinationS3Prefix = destinationS3Prefix;
        }

        @Override
        @Transient
        public final Builder destinationS3Prefix(String destinationS3Prefix) {
            this.destinationS3Prefix = destinationS3Prefix;
            return this;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        @Transient
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final Map<String, String> getCustomerDefinedValues() {
            if (customerDefinedValues instanceof SdkAutoConstructMap) {
                return null;
            }
            return customerDefinedValues;
        }

        public final void setCustomerDefinedValues(Map<String, String> customerDefinedValues) {
            this.customerDefinedValues = CustomerDefinedValuesCopier.copy(customerDefinedValues);
        }

        @Override
        @Transient
        public final Builder customerDefinedValues(Map<String, String> customerDefinedValues) {
            this.customerDefinedValues = CustomerDefinedValuesCopier.copy(customerDefinedValues);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateDataSetRequest build() {
            return new GenerateDataSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
