/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecommerceanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Container for the result of the StartSupportDataExport operation.
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSupportDataExportResponse extends MarketplaceCommerceAnalyticsResponse implements
        ToCopyableBuilder<StartSupportDataExportResponse.Builder, StartSupportDataExportResponse> {
    private static final SdkField<String> DATA_SET_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartSupportDataExportResponse::dataSetRequestId)).setter(setter(Builder::dataSetRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSetRequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_REQUEST_ID_FIELD));

    private final String dataSetRequestId;

    private StartSupportDataExportResponse(BuilderImpl builder) {
        super(builder);
        this.dataSetRequestId = builder.dataSetRequestId;
    }

    /**
     * A unique identifier representing a specific request to the StartSupportDataExport operation. This identifier can
     * be used to correlate a request with notifications from the SNS topic.
     * 
     * @return A unique identifier representing a specific request to the StartSupportDataExport operation. This
     *         identifier can be used to correlate a request with notifications from the SNS topic.
     */
    public String dataSetRequestId() {
        return dataSetRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSetRequestId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSupportDataExportResponse)) {
            return false;
        }
        StartSupportDataExportResponse other = (StartSupportDataExportResponse) obj;
        return Objects.equals(dataSetRequestId(), other.dataSetRequestId());
    }

    @Override
    public String toString() {
        return ToString.builder("StartSupportDataExportResponse").add("DataSetRequestId", dataSetRequestId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSetRequestId":
            return Optional.ofNullable(clazz.cast(dataSetRequestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSupportDataExportResponse, T> g) {
        return obj -> g.apply((StartSupportDataExportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MarketplaceCommerceAnalyticsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartSupportDataExportResponse> {
        /**
         * A unique identifier representing a specific request to the StartSupportDataExport operation. This identifier
         * can be used to correlate a request with notifications from the SNS topic.
         * 
         * @param dataSetRequestId
         *        A unique identifier representing a specific request to the StartSupportDataExport operation. This
         *        identifier can be used to correlate a request with notifications from the SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetRequestId(String dataSetRequestId);
    }

    static final class BuilderImpl extends MarketplaceCommerceAnalyticsResponse.BuilderImpl implements Builder {
        private String dataSetRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSupportDataExportResponse model) {
            super(model);
            dataSetRequestId(model.dataSetRequestId);
        }

        public final String getDataSetRequestId() {
            return dataSetRequestId;
        }

        @Override
        public final Builder dataSetRequestId(String dataSetRequestId) {
            this.dataSetRequestId = dataSetRequestId;
            return this;
        }

        public final void setDataSetRequestId(String dataSetRequestId) {
            this.dataSetRequestId = dataSetRequestId;
        }

        @Override
        public StartSupportDataExportResponse build() {
            return new StartSupportDataExportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
