/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecommerceanalytics;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.GenerateDataSetRequest;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.GenerateDataSetResponse;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.StartSupportDataExportRequest;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.StartSupportDataExportResponse;

/**
 * Service client for accessing AWS Marketplace Commerce Analytics asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * Provides AWS Marketplace business intelligence data on-demand.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MarketplaceCommerceAnalyticsAsyncClient extends SdkClient {
    String SERVICE_NAME = "marketplacecommerceanalytics";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "marketplacecommerceanalytics";

    /**
     * Given a data set type and data set publication date, asynchronously publishes the requested data set to the
     * specified S3 bucket and notifies the specified SNS topic once the data is available. Returns a unique request
     * identifier that can be used to correlate requests with notifications from the SNS topic. Data sets will be
     * published in comma-separated values (CSV) format with the file name {data_set_type}_YYYY-MM-DD.csv. If a file
     * with the same name already exists (e.g. if the same data set is requested twice), the original file will be
     * overwritten by the new file. Requires a Role with an attached permissions policy providing Allow permissions for
     * the following actions: s3:PutObject, s3:GetBucketLocation, sns:GetTopicAttributes, sns:Publish,
     * iam:GetRolePolicy.
     *
     * @param generateDataSetRequest
     *        Container for the parameters to the GenerateDataSet operation.
     * @return A Java Future containing the result of the GenerateDataSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MarketplaceCommerceAnalyticsServiceException This exception is thrown when an internal service error
     *         occurs.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCommerceAnalyticsException Base class for all service exceptions. Unknown exceptions will
     *         be thrown as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCommerceAnalyticsAsyncClient.GenerateDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplacecommerceanalytics-2015-07-01/GenerateDataSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GenerateDataSetResponse> generateDataSet(GenerateDataSetRequest generateDataSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Given a data set type and data set publication date, asynchronously publishes the requested data set to the
     * specified S3 bucket and notifies the specified SNS topic once the data is available. Returns a unique request
     * identifier that can be used to correlate requests with notifications from the SNS topic. Data sets will be
     * published in comma-separated values (CSV) format with the file name {data_set_type}_YYYY-MM-DD.csv. If a file
     * with the same name already exists (e.g. if the same data set is requested twice), the original file will be
     * overwritten by the new file. Requires a Role with an attached permissions policy providing Allow permissions for
     * the following actions: s3:PutObject, s3:GetBucketLocation, sns:GetTopicAttributes, sns:Publish,
     * iam:GetRolePolicy.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GenerateDataSetRequest.Builder} avoiding the need
     * to create one manually via {@link GenerateDataSetRequest#builder()}
     * </p>
     *
     * @param generateDataSetRequest
     *        A {@link Consumer} that will call methods on {@link GenerateDataSetRequest.Builder} to create a request.
     *        Container for the parameters to the GenerateDataSet operation.
     * @return A Java Future containing the result of the GenerateDataSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MarketplaceCommerceAnalyticsServiceException This exception is thrown when an internal service error
     *         occurs.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCommerceAnalyticsException Base class for all service exceptions. Unknown exceptions will
     *         be thrown as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCommerceAnalyticsAsyncClient.GenerateDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplacecommerceanalytics-2015-07-01/GenerateDataSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GenerateDataSetResponse> generateDataSet(
            Consumer<GenerateDataSetRequest.Builder> generateDataSetRequest) {
        return generateDataSet(GenerateDataSetRequest.builder().applyMutation(generateDataSetRequest).build());
    }

    /**
     * Given a data set type and a from date, asynchronously publishes the requested customer support data to the
     * specified S3 bucket and notifies the specified SNS topic once the data is available. Returns a unique request
     * identifier that can be used to correlate requests with notifications from the SNS topic. Data sets will be
     * published in comma-separated values (CSV) format with the file name {data_set_type}_YYYY-MM-DD'T'HH-mm-ss'Z'.csv.
     * If a file with the same name already exists (e.g. if the same data set is requested twice), the original file
     * will be overwritten by the new file. Requires a Role with an attached permissions policy providing Allow
     * permissions for the following actions: s3:PutObject, s3:GetBucketLocation, sns:GetTopicAttributes, sns:Publish,
     * iam:GetRolePolicy.
     *
     * @param startSupportDataExportRequest
     *        Container for the parameters to the StartSupportDataExport operation.
     * @return A Java Future containing the result of the StartSupportDataExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MarketplaceCommerceAnalyticsServiceException This exception is thrown when an internal service error
     *         occurs.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCommerceAnalyticsException Base class for all service exceptions. Unknown exceptions will
     *         be thrown as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCommerceAnalyticsAsyncClient.StartSupportDataExport
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/marketplacecommerceanalytics-2015-07-01/StartSupportDataExport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartSupportDataExportResponse> startSupportDataExport(
            StartSupportDataExportRequest startSupportDataExportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Given a data set type and a from date, asynchronously publishes the requested customer support data to the
     * specified S3 bucket and notifies the specified SNS topic once the data is available. Returns a unique request
     * identifier that can be used to correlate requests with notifications from the SNS topic. Data sets will be
     * published in comma-separated values (CSV) format with the file name {data_set_type}_YYYY-MM-DD'T'HH-mm-ss'Z'.csv.
     * If a file with the same name already exists (e.g. if the same data set is requested twice), the original file
     * will be overwritten by the new file. Requires a Role with an attached permissions policy providing Allow
     * permissions for the following actions: s3:PutObject, s3:GetBucketLocation, sns:GetTopicAttributes, sns:Publish,
     * iam:GetRolePolicy.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSupportDataExportRequest.Builder} avoiding the
     * need to create one manually via {@link StartSupportDataExportRequest#builder()}
     * </p>
     *
     * @param startSupportDataExportRequest
     *        A {@link Consumer} that will call methods on {@link StartSupportDataExportRequest.Builder} to create a
     *        request. Container for the parameters to the StartSupportDataExport operation.
     * @return A Java Future containing the result of the StartSupportDataExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MarketplaceCommerceAnalyticsServiceException This exception is thrown when an internal service error
     *         occurs.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCommerceAnalyticsException Base class for all service exceptions. Unknown exceptions will
     *         be thrown as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCommerceAnalyticsAsyncClient.StartSupportDataExport
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/marketplacecommerceanalytics-2015-07-01/StartSupportDataExport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartSupportDataExportResponse> startSupportDataExport(
            Consumer<StartSupportDataExportRequest.Builder> startSupportDataExportRequest) {
        return startSupportDataExport(StartSupportDataExportRequest.builder().applyMutation(startSupportDataExportRequest)
                .build());
    }

    /**
     * Create a {@link MarketplaceCommerceAnalyticsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MarketplaceCommerceAnalyticsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MarketplaceCommerceAnalyticsAsyncClient}.
     */
    static MarketplaceCommerceAnalyticsAsyncClientBuilder builder() {
        return new DefaultMarketplaceCommerceAnalyticsAsyncClientBuilder();
    }
}
