/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecommerceanalytics.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum DataSetType {
    CUSTOMER_SUBSCRIBER_HOURLY_MONTHLY_SUBSCRIPTIONS("customer_subscriber_hourly_monthly_subscriptions"),

    CUSTOMER_SUBSCRIBER_ANNUAL_SUBSCRIPTIONS("customer_subscriber_annual_subscriptions"),

    DAILY_BUSINESS_USAGE_BY_INSTANCE_TYPE("daily_business_usage_by_instance_type"),

    DAILY_BUSINESS_FEES("daily_business_fees"),

    DAILY_BUSINESS_FREE_TRIAL_CONVERSIONS("daily_business_free_trial_conversions"),

    DAILY_BUSINESS_NEW_INSTANCES("daily_business_new_instances"),

    DAILY_BUSINESS_NEW_PRODUCT_SUBSCRIBERS("daily_business_new_product_subscribers"),

    DAILY_BUSINESS_CANCELED_PRODUCT_SUBSCRIBERS("daily_business_canceled_product_subscribers"),

    MONTHLY_REVENUE_BILLING_AND_REVENUE_DATA("monthly_revenue_billing_and_revenue_data"),

    MONTHLY_REVENUE_ANNUAL_SUBSCRIPTIONS("monthly_revenue_annual_subscriptions"),

    DISBURSED_AMOUNT_BY_PRODUCT("disbursed_amount_by_product"),

    DISBURSED_AMOUNT_BY_PRODUCT_WITH_UNCOLLECTED_FUNDS("disbursed_amount_by_product_with_uncollected_funds"),

    DISBURSED_AMOUNT_BY_INSTANCE_HOURS("disbursed_amount_by_instance_hours"),

    DISBURSED_AMOUNT_BY_CUSTOMER_GEO("disbursed_amount_by_customer_geo"),

    DISBURSED_AMOUNT_BY_AGE_OF_UNCOLLECTED_FUNDS("disbursed_amount_by_age_of_uncollected_funds"),

    DISBURSED_AMOUNT_BY_AGE_OF_DISBURSED_FUNDS("disbursed_amount_by_age_of_disbursed_funds"),

    CUSTOMER_PROFILE_BY_INDUSTRY("customer_profile_by_industry"),

    CUSTOMER_PROFILE_BY_REVENUE("customer_profile_by_revenue"),

    CUSTOMER_PROFILE_BY_GEOGRAPHY("customer_profile_by_geography"),

    SALES_COMPENSATION_BILLED_REVENUE("sales_compensation_billed_revenue"),

    US_SALES_AND_USE_TAX_RECORDS("us_sales_and_use_tax_records"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DataSetType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return DataSetType corresponding to the value
     */
    public static DataSetType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DataSetType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link DataSetType}s
     */
    public static Set<DataSetType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
