/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacedeployment.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutDeploymentParameterResponse extends MarketplaceDeploymentResponse implements
        ToCopyableBuilder<PutDeploymentParameterResponse.Builder, PutDeploymentParameterResponse> {
    private static final SdkField<String> AGREEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agreementId").getter(getter(PutDeploymentParameterResponse::agreementId))
            .setter(setter(Builder::agreementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agreementId").build()).build();

    private static final SdkField<String> DEPLOYMENT_PARAMETER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentParameterId").getter(getter(PutDeploymentParameterResponse::deploymentParameterId))
            .setter(setter(Builder::deploymentParameterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentParameterId").build())
            .build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(PutDeploymentParameterResponse::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(PutDeploymentParameterResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGREEMENT_ID_FIELD,
            DEPLOYMENT_PARAMETER_ID_FIELD, RESOURCE_ARN_FIELD, TAGS_FIELD));

    private final String agreementId;

    private final String deploymentParameterId;

    private final String resourceArn;

    private final Map<String, String> tags;

    private PutDeploymentParameterResponse(BuilderImpl builder) {
        super(builder);
        this.agreementId = builder.agreementId;
        this.deploymentParameterId = builder.deploymentParameterId;
        this.resourceArn = builder.resourceArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique identifier of the agreement.
     * </p>
     * 
     * @return The unique identifier of the agreement.
     */
    public final String agreementId() {
        return agreementId;
    }

    /**
     * <p>
     * The unique identifier of the deployment parameter.
     * </p>
     * 
     * @return The unique identifier of the deployment parameter.
     */
    public final String deploymentParameterId() {
        return deploymentParameterId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) associated with the deployment parameter resource you want to create or update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) associated with the deployment parameter resource you want to create or
     *         update.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key-value pairs, where each pair represents a tag saved to the resource. Tags will only be applied for
     * create operations, and they'll be ignored if the resource already exists.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of key-value pairs, where each pair represents a tag saved to the resource. Tags will only be
     *         applied for create operations, and they'll be ignored if the resource already exists.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agreementId());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentParameterId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDeploymentParameterResponse)) {
            return false;
        }
        PutDeploymentParameterResponse other = (PutDeploymentParameterResponse) obj;
        return Objects.equals(agreementId(), other.agreementId())
                && Objects.equals(deploymentParameterId(), other.deploymentParameterId())
                && Objects.equals(resourceArn(), other.resourceArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutDeploymentParameterResponse").add("AgreementId", agreementId())
                .add("DeploymentParameterId", deploymentParameterId()).add("ResourceArn", resourceArn())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agreementId":
            return Optional.ofNullable(clazz.cast(agreementId()));
        case "deploymentParameterId":
            return Optional.ofNullable(clazz.cast(deploymentParameterId()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutDeploymentParameterResponse, T> g) {
        return obj -> g.apply((PutDeploymentParameterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MarketplaceDeploymentResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutDeploymentParameterResponse> {
        /**
         * <p>
         * The unique identifier of the agreement.
         * </p>
         * 
         * @param agreementId
         *        The unique identifier of the agreement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agreementId(String agreementId);

        /**
         * <p>
         * The unique identifier of the deployment parameter.
         * </p>
         * 
         * @param deploymentParameterId
         *        The unique identifier of the deployment parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentParameterId(String deploymentParameterId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) associated with the deployment parameter resource you want to create or
         * update.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) associated with the deployment parameter resource you want to create or
         *        update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * A map of key-value pairs, where each pair represents a tag saved to the resource. Tags will only be applied
         * for create operations, and they'll be ignored if the resource already exists.
         * </p>
         * 
         * @param tags
         *        A map of key-value pairs, where each pair represents a tag saved to the resource. Tags will only be
         *        applied for create operations, and they'll be ignored if the resource already exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends MarketplaceDeploymentResponse.BuilderImpl implements Builder {
        private String agreementId;

        private String deploymentParameterId;

        private String resourceArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutDeploymentParameterResponse model) {
            super(model);
            agreementId(model.agreementId);
            deploymentParameterId(model.deploymentParameterId);
            resourceArn(model.resourceArn);
            tags(model.tags);
        }

        public final String getAgreementId() {
            return agreementId;
        }

        public final void setAgreementId(String agreementId) {
            this.agreementId = agreementId;
        }

        @Override
        public final Builder agreementId(String agreementId) {
            this.agreementId = agreementId;
            return this;
        }

        public final String getDeploymentParameterId() {
            return deploymentParameterId;
        }

        public final void setDeploymentParameterId(String deploymentParameterId) {
            this.deploymentParameterId = deploymentParameterId;
        }

        @Override
        public final Builder deploymentParameterId(String deploymentParameterId) {
            this.deploymentParameterId = deploymentParameterId;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public PutDeploymentParameterResponse build() {
            return new PutDeploymentParameterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
