/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacedeployment;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.marketplacedeployment.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.marketplacedeployment.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.marketplacedeployment.model.PutDeploymentParameterRequest;
import software.amazon.awssdk.services.marketplacedeployment.model.PutDeploymentParameterResponse;
import software.amazon.awssdk.services.marketplacedeployment.model.TagResourceRequest;
import software.amazon.awssdk.services.marketplacedeployment.model.TagResourceResponse;
import software.amazon.awssdk.services.marketplacedeployment.model.UntagResourceRequest;
import software.amazon.awssdk.services.marketplacedeployment.model.UntagResourceResponse;

/**
 * Service client for accessing AWS Marketplace Deployment Service asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * The AWS Marketplace Deployment Service supports the Quick Launch experience, which is a deployment option for
 * software as a service (SaaS) products. Quick Launch simplifies and reduces the time, resources, and steps required to
 * configure, deploy, and launch a products. The AWS Marketplace Deployment Service provides sellers with a secure
 * method for passing deployment parameters (for example, API keys and external IDs) to buyers during the Quick Launch
 * experience.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MarketplaceDeploymentAsyncClient extends AwsClient {
    String SERVICE_NAME = "aws-marketplace";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "deployment-marketplace";

    /**
     * <p>
     * Lists all tags that have been added to a deployment parameter resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Too many requests.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</li>
     *         <li>ValidationException An error occurred during validation.</li>
     *         <li>InternalServerException There was an internal service exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceDeploymentException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceDeploymentAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-deployment-2023-01-25/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags that have been added to a deployment parameter resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.marketplacedeployment.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Too many requests.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</li>
     *         <li>ValidationException An error occurred during validation.</li>
     *         <li>InternalServerException There was an internal service exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceDeploymentException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceDeploymentAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-deployment-2023-01-25/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Creates or updates a deployment parameter and is targeted by <code>catalog</code> and <code>agreementId</code>.
     * </p>
     *
     * @param putDeploymentParameterRequest
     * @return A Java Future containing the result of the PutDeploymentParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Too many requests.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</li>
     *         <li>ServiceQuotaExceededException The maximum number of requests per account has been exceeded.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ValidationException An error occurred during validation.</li>
     *         <li>InternalServerException There was an internal service exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceDeploymentException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceDeploymentAsyncClient.PutDeploymentParameter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-deployment-2023-01-25/PutDeploymentParameter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutDeploymentParameterResponse> putDeploymentParameter(
            PutDeploymentParameterRequest putDeploymentParameterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a deployment parameter and is targeted by <code>catalog</code> and <code>agreementId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDeploymentParameterRequest.Builder} avoiding the
     * need to create one manually via {@link PutDeploymentParameterRequest#builder()}
     * </p>
     *
     * @param putDeploymentParameterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.marketplacedeployment.model.PutDeploymentParameterRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the PutDeploymentParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Too many requests.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</li>
     *         <li>ServiceQuotaExceededException The maximum number of requests per account has been exceeded.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ValidationException An error occurred during validation.</li>
     *         <li>InternalServerException There was an internal service exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceDeploymentException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceDeploymentAsyncClient.PutDeploymentParameter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-deployment-2023-01-25/PutDeploymentParameter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutDeploymentParameterResponse> putDeploymentParameter(
            Consumer<PutDeploymentParameterRequest.Builder> putDeploymentParameterRequest) {
        return putDeploymentParameter(PutDeploymentParameterRequest.builder().applyMutation(putDeploymentParameterRequest)
                .build());
    }

    /**
     * <p>
     * Tags a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Too many requests.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ValidationException An error occurred during validation.</li>
     *         <li>InternalServerException There was an internal service exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceDeploymentException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceDeploymentAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-deployment-2023-01-25/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.marketplacedeployment.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Too many requests.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ValidationException An error occurred during validation.</li>
     *         <li>InternalServerException There was an internal service exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceDeploymentException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceDeploymentAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-deployment-2023-01-25/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag or list of tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Too many requests.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ValidationException An error occurred during validation.</li>
     *         <li>InternalServerException There was an internal service exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceDeploymentException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceDeploymentAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-deployment-2023-01-25/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag or list of tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.marketplacedeployment.model.UntagResourceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Too many requests.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ValidationException An error occurred during validation.</li>
     *         <li>InternalServerException There was an internal service exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceDeploymentException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceDeploymentAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-deployment-2023-01-25/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    @Override
    default MarketplaceDeploymentServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link MarketplaceDeploymentAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MarketplaceDeploymentAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MarketplaceDeploymentAsyncClient}.
     */
    static MarketplaceDeploymentAsyncClientBuilder builder() {
        return new DefaultMarketplaceDeploymentAsyncClientBuilder();
    }
}
