/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacedeployment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutDeploymentParameterRequest extends MarketplaceDeploymentRequest implements
        ToCopyableBuilder<PutDeploymentParameterRequest.Builder, PutDeploymentParameterRequest> {
    private static final SdkField<String> AGREEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agreementId").getter(getter(PutDeploymentParameterRequest::agreementId))
            .setter(setter(Builder::agreementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agreementId").build()).build();

    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("catalog")
            .getter(getter(PutDeploymentParameterRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("catalog").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(PutDeploymentParameterRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<DeploymentParameterInput> DEPLOYMENT_PARAMETER_FIELD = SdkField
            .<DeploymentParameterInput> builder(MarshallingType.SDK_POJO).memberName("deploymentParameter")
            .getter(getter(PutDeploymentParameterRequest::deploymentParameter)).setter(setter(Builder::deploymentParameter))
            .constructor(DeploymentParameterInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentParameter").build())
            .build();

    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("expirationDate")
            .getter(getter(PutDeploymentParameterRequest::expirationDate))
            .setter(setter(Builder::expirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("productId").getter(getter(PutDeploymentParameterRequest::productId)).setter(setter(Builder::productId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("productId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(PutDeploymentParameterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGREEMENT_ID_FIELD,
            CATALOG_FIELD, CLIENT_TOKEN_FIELD, DEPLOYMENT_PARAMETER_FIELD, EXPIRATION_DATE_FIELD, PRODUCT_ID_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String agreementId;

    private final String catalog;

    private final String clientToken;

    private final DeploymentParameterInput deploymentParameter;

    private final Instant expirationDate;

    private final String productId;

    private final Map<String, String> tags;

    private PutDeploymentParameterRequest(BuilderImpl builder) {
        super(builder);
        this.agreementId = builder.agreementId;
        this.catalog = builder.catalog;
        this.clientToken = builder.clientToken;
        this.deploymentParameter = builder.deploymentParameter;
        this.expirationDate = builder.expirationDate;
        this.productId = builder.productId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique identifier of the agreement.
     * </p>
     * 
     * @return The unique identifier of the agreement.
     */
    public final String agreementId() {
        return agreementId;
    }

    /**
     * <p>
     * The catalog related to the request. Fixed value: <code>AWS Marketplace</code>
     * </p>
     * 
     * @return The catalog related to the request. Fixed value: <code>AWS Marketplace</code>
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The idempotency token for deployment parameters. A unique identifier for the new version.
     * </p>
     * 
     * @return The idempotency token for deployment parameters. A unique identifier for the new version.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The deployment parameter targeted to the acceptor of an agreement for which to create the AWS Secret Manager
     * resource.
     * </p>
     * 
     * @return The deployment parameter targeted to the acceptor of an agreement for which to create the AWS Secret
     *         Manager resource.
     */
    public final DeploymentParameterInput deploymentParameter() {
        return deploymentParameter;
    }

    /**
     * <p>
     * The date when deployment parameters expire and are scheduled for deletion.
     * </p>
     * 
     * @return The date when deployment parameters expire and are scheduled for deletion.
     */
    public final Instant expirationDate() {
        return expirationDate;
    }

    /**
     * <p>
     * The product for which AWS Marketplace will save secrets for the buyer’s account.
     * </p>
     * 
     * @return The product for which AWS Marketplace will save secrets for the buyer’s account.
     */
    public final String productId() {
        return productId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key-value pairs, where each pair represents a tag saved to the resource. Tags will only be applied for
     * create operations, and they'll be ignored if the resource already exists.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of key-value pairs, where each pair represents a tag saved to the resource. Tags will only be
     *         applied for create operations, and they'll be ignored if the resource already exists.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agreementId());
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentParameter());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(productId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDeploymentParameterRequest)) {
            return false;
        }
        PutDeploymentParameterRequest other = (PutDeploymentParameterRequest) obj;
        return Objects.equals(agreementId(), other.agreementId()) && Objects.equals(catalog(), other.catalog())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(deploymentParameter(), other.deploymentParameter())
                && Objects.equals(expirationDate(), other.expirationDate()) && Objects.equals(productId(), other.productId())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutDeploymentParameterRequest").add("AgreementId", agreementId()).add("Catalog", catalog())
                .add("ClientToken", clientToken()).add("DeploymentParameter", deploymentParameter())
                .add("ExpirationDate", expirationDate()).add("ProductId", productId()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agreementId":
            return Optional.ofNullable(clazz.cast(agreementId()));
        case "catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "deploymentParameter":
            return Optional.ofNullable(clazz.cast(deploymentParameter()));
        case "expirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        case "productId":
            return Optional.ofNullable(clazz.cast(productId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agreementId", AGREEMENT_ID_FIELD);
        map.put("catalog", CATALOG_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("deploymentParameter", DEPLOYMENT_PARAMETER_FIELD);
        map.put("expirationDate", EXPIRATION_DATE_FIELD);
        map.put("productId", PRODUCT_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutDeploymentParameterRequest, T> g) {
        return obj -> g.apply((PutDeploymentParameterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MarketplaceDeploymentRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutDeploymentParameterRequest> {
        /**
         * <p>
         * The unique identifier of the agreement.
         * </p>
         * 
         * @param agreementId
         *        The unique identifier of the agreement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agreementId(String agreementId);

        /**
         * <p>
         * The catalog related to the request. Fixed value: <code>AWS Marketplace</code>
         * </p>
         * 
         * @param catalog
         *        The catalog related to the request. Fixed value: <code>AWS Marketplace</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The idempotency token for deployment parameters. A unique identifier for the new version.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token for deployment parameters. A unique identifier for the new version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The deployment parameter targeted to the acceptor of an agreement for which to create the AWS Secret Manager
         * resource.
         * </p>
         * 
         * @param deploymentParameter
         *        The deployment parameter targeted to the acceptor of an agreement for which to create the AWS Secret
         *        Manager resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentParameter(DeploymentParameterInput deploymentParameter);

        /**
         * <p>
         * The deployment parameter targeted to the acceptor of an agreement for which to create the AWS Secret Manager
         * resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentParameterInput.Builder}
         * avoiding the need to create one manually via {@link DeploymentParameterInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeploymentParameterInput.Builder#build()} is called immediately
         * and its result is passed to {@link #deploymentParameter(DeploymentParameterInput)}.
         * 
         * @param deploymentParameter
         *        a consumer that will call methods on {@link DeploymentParameterInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentParameter(DeploymentParameterInput)
         */
        default Builder deploymentParameter(Consumer<DeploymentParameterInput.Builder> deploymentParameter) {
            return deploymentParameter(DeploymentParameterInput.builder().applyMutation(deploymentParameter).build());
        }

        /**
         * <p>
         * The date when deployment parameters expire and are scheduled for deletion.
         * </p>
         * 
         * @param expirationDate
         *        The date when deployment parameters expire and are scheduled for deletion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(Instant expirationDate);

        /**
         * <p>
         * The product for which AWS Marketplace will save secrets for the buyer’s account.
         * </p>
         * 
         * @param productId
         *        The product for which AWS Marketplace will save secrets for the buyer’s account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productId(String productId);

        /**
         * <p>
         * A map of key-value pairs, where each pair represents a tag saved to the resource. Tags will only be applied
         * for create operations, and they'll be ignored if the resource already exists.
         * </p>
         * 
         * @param tags
         *        A map of key-value pairs, where each pair represents a tag saved to the resource. Tags will only be
         *        applied for create operations, and they'll be ignored if the resource already exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MarketplaceDeploymentRequest.BuilderImpl implements Builder {
        private String agreementId;

        private String catalog;

        private String clientToken;

        private DeploymentParameterInput deploymentParameter;

        private Instant expirationDate;

        private String productId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutDeploymentParameterRequest model) {
            super(model);
            agreementId(model.agreementId);
            catalog(model.catalog);
            clientToken(model.clientToken);
            deploymentParameter(model.deploymentParameter);
            expirationDate(model.expirationDate);
            productId(model.productId);
            tags(model.tags);
        }

        public final String getAgreementId() {
            return agreementId;
        }

        public final void setAgreementId(String agreementId) {
            this.agreementId = agreementId;
        }

        @Override
        public final Builder agreementId(String agreementId) {
            this.agreementId = agreementId;
            return this;
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final DeploymentParameterInput.Builder getDeploymentParameter() {
            return deploymentParameter != null ? deploymentParameter.toBuilder() : null;
        }

        public final void setDeploymentParameter(DeploymentParameterInput.BuilderImpl deploymentParameter) {
            this.deploymentParameter = deploymentParameter != null ? deploymentParameter.build() : null;
        }

        @Override
        public final Builder deploymentParameter(DeploymentParameterInput deploymentParameter) {
            this.deploymentParameter = deploymentParameter;
            return this;
        }

        public final Instant getExpirationDate() {
            return expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final String getProductId() {
            return productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDeploymentParameterRequest build() {
            return new PutDeploymentParameterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
