/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceentitlement.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.marketplaceentitlement.model.GetEntitlementFilterName;
import software.amazon.awssdk.services.marketplaceentitlement.model.GetEntitlementFiltersCopier;
import software.amazon.awssdk.services.marketplaceentitlement.model.MarketplaceEntitlementRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEntitlementsRequest
extends MarketplaceEntitlementRequest
implements ToCopyableBuilder<Builder, GetEntitlementsRequest> {
    private static final SdkField<String> PRODUCT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductCode").getter(GetEntitlementsRequest.getter(GetEntitlementsRequest::productCode)).setter(GetEntitlementsRequest.setter(Builder::productCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").build()}).build();
    private static final SdkField<Map<String, List<String>>> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Filter").getter(GetEntitlementsRequest.getter(GetEntitlementsRequest::filterAsStrings)).setter(GetEntitlementsRequest.setter(Builder::filterWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetEntitlementsRequest.getter(GetEntitlementsRequest::nextToken)).setter(GetEntitlementsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetEntitlementsRequest.getter(GetEntitlementsRequest::maxResults)).setter(GetEntitlementsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_CODE_FIELD, FILTER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String productCode;
    private final Map<String, List<String>> filter;
    private final String nextToken;
    private final Integer maxResults;

    private GetEntitlementsRequest(BuilderImpl builder) {
        super(builder);
        this.productCode = builder.productCode;
        this.filter = builder.filter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String productCode() {
        return this.productCode;
    }

    public Map<GetEntitlementFilterName, List<String>> filter() {
        return GetEntitlementFiltersCopier.copyStringToEnum(this.filter);
    }

    public boolean hasFilter() {
        return this.filter != null && !(this.filter instanceof SdkAutoConstructMap);
    }

    public Map<String, List<String>> filterAsStrings() {
        return this.filter;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.productCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilter() ? this.filterAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEntitlementsRequest)) {
            return false;
        }
        GetEntitlementsRequest other = (GetEntitlementsRequest)((Object)obj);
        return Objects.equals(this.productCode(), other.productCode()) && this.hasFilter() == other.hasFilter() && Objects.equals(this.filterAsStrings(), other.filterAsStrings()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"GetEntitlementsRequest").add("ProductCode", (Object)this.productCode()).add("Filter", this.hasFilter() ? this.filterAsStrings() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductCode": {
                return Optional.ofNullable(clazz.cast(this.productCode()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filterAsStrings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEntitlementsRequest, T> g) {
        return obj -> g.apply((GetEntitlementsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MarketplaceEntitlementRequest.BuilderImpl
    implements Builder {
        private String productCode;
        private Map<String, List<String>> filter = DefaultSdkAutoConstructMap.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEntitlementsRequest model) {
            super(model);
            this.productCode(model.productCode);
            this.filterWithStrings(model.filter);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getProductCode() {
            return this.productCode;
        }

        @Override
        public final Builder productCode(String productCode) {
            this.productCode = productCode;
            return this;
        }

        public final void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        public final Map<String, ? extends Collection<String>> getFilter() {
            if (this.filter instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.filter;
        }

        @Override
        public final Builder filterWithStrings(Map<String, ? extends Collection<String>> filter) {
            this.filter = GetEntitlementFiltersCopier.copy(filter);
            return this;
        }

        @Override
        public final Builder filter(Map<GetEntitlementFilterName, ? extends Collection<String>> filter) {
            this.filter = GetEntitlementFiltersCopier.copyEnumToString(filter);
            return this;
        }

        public final void setFilter(Map<String, ? extends Collection<String>> filter) {
            this.filter = GetEntitlementFiltersCopier.copy(filter);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEntitlementsRequest build() {
            return new GetEntitlementsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MarketplaceEntitlementRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEntitlementsRequest> {
        public Builder productCode(String var1);

        public Builder filterWithStrings(Map<String, ? extends Collection<String>> var1);

        public Builder filter(Map<GetEntitlementFilterName, ? extends Collection<String>> var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

