/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceentitlement;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.marketplaceentitlement.model.GetEntitlementsRequest;
import software.amazon.awssdk.services.marketplaceentitlement.model.GetEntitlementsResponse;
import software.amazon.awssdk.services.marketplaceentitlement.model.InternalServiceErrorException;
import software.amazon.awssdk.services.marketplaceentitlement.model.InvalidParameterException;
import software.amazon.awssdk.services.marketplaceentitlement.model.MarketplaceEntitlementException;
import software.amazon.awssdk.services.marketplaceentitlement.model.ThrottlingException;

/**
 * Service client for accessing AWS Marketplace Entitlement Service. This can be created using the static
 * {@link #builder()} method.
 *
 * <fullname>AWS Marketplace Entitlement Service</fullname>
 * <p>
 * This reference provides descriptions of the AWS Marketplace Entitlement Service API.
 * </p>
 * <p>
 * AWS Marketplace Entitlement Service is used to determine the entitlement of a customer to a given product. An
 * entitlement represents capacity in a product owned by the customer. For example, a customer might own some number of
 * users or seats in an SaaS application or some amount of data capacity in a multi-tenant database.
 * </p>
 * <p>
 * <b>Getting Entitlement Records</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <i>GetEntitlements</i>- Gets the entitlements for a Marketplace product.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MarketplaceEntitlementClient extends SdkClient {
    String SERVICE_NAME = "aws-marketplace";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "entitlement.marketplace";

    /**
     * Create a {@link MarketplaceEntitlementClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MarketplaceEntitlementClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MarketplaceEntitlementClient}.
     */
    static MarketplaceEntitlementClientBuilder builder() {
        return new DefaultMarketplaceEntitlementClientBuilder();
    }

    /**
     * <p>
     * GetEntitlements retrieves entitlement values for a given product. The results can be filtered based on customer
     * identifier or product dimensions.
     * </p>
     *
     * @param getEntitlementsRequest
     *        The GetEntitlementsRequest contains parameters for the GetEntitlements operation.
     * @return Result of the GetEntitlements operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in your request was invalid.
     * @throws ThrottlingException
     *         The calls to the GetEntitlements API are throttled.
     * @throws InternalServiceErrorException
     *         An internal error has occurred. Retry your request. If the problem persists, post a message with details
     *         on the AWS forums.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceEntitlementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceEntitlementClient.GetEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entitlement.marketplace-2017-01-11/GetEntitlements"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEntitlementsResponse getEntitlements(GetEntitlementsRequest getEntitlementsRequest)
            throws InvalidParameterException, ThrottlingException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, MarketplaceEntitlementException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * GetEntitlements retrieves entitlement values for a given product. The results can be filtered based on customer
     * identifier or product dimensions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEntitlementsRequest.Builder} avoiding the need
     * to create one manually via {@link GetEntitlementsRequest#builder()}
     * </p>
     *
     * @param getEntitlementsRequest
     *        A {@link Consumer} that will call methods on {@link GetEntitlementsRequest.Builder} to create a request.
     *        The GetEntitlementsRequest contains parameters for the GetEntitlements operation.
     * @return Result of the GetEntitlements operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in your request was invalid.
     * @throws ThrottlingException
     *         The calls to the GetEntitlements API are throttled.
     * @throws InternalServiceErrorException
     *         An internal error has occurred. Retry your request. If the problem persists, post a message with details
     *         on the AWS forums.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceEntitlementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceEntitlementClient.GetEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entitlement.marketplace-2017-01-11/GetEntitlements"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEntitlementsResponse getEntitlements(Consumer<GetEntitlementsRequest.Builder> getEntitlementsRequest)
            throws InvalidParameterException, ThrottlingException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, MarketplaceEntitlementException {
        return getEntitlements(GetEntitlementsRequest.builder().applyMutation(getEntitlementsRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
