/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceentitlement.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplaceentitlement.model.Entitlement;
import software.amazon.awssdk.services.marketplaceentitlement.model.EntitlementListCopier;
import software.amazon.awssdk.services.marketplaceentitlement.model.MarketplaceEntitlementResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEntitlementsResponse
extends MarketplaceEntitlementResponse
implements ToCopyableBuilder<Builder, GetEntitlementsResponse> {
    private static final SdkField<List<Entitlement>> ENTITLEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Entitlements").getter(GetEntitlementsResponse.getter(GetEntitlementsResponse::entitlements)).setter(GetEntitlementsResponse.setter(Builder::entitlements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entitlements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Entitlement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetEntitlementsResponse.getter(GetEntitlementsResponse::nextToken)).setter(GetEntitlementsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITLEMENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Entitlement> entitlements;
    private final String nextToken;

    private GetEntitlementsResponse(BuilderImpl builder) {
        super(builder);
        this.entitlements = builder.entitlements;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEntitlements() {
        return this.entitlements != null && !(this.entitlements instanceof SdkAutoConstructList);
    }

    public final List<Entitlement> entitlements() {
        return this.entitlements;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntitlements() ? this.entitlements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEntitlementsResponse)) {
            return false;
        }
        GetEntitlementsResponse other = (GetEntitlementsResponse)((Object)obj);
        return this.hasEntitlements() == other.hasEntitlements() && Objects.equals(this.entitlements(), other.entitlements()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetEntitlementsResponse").add("Entitlements", this.hasEntitlements() ? this.entitlements() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Entitlements": {
                return Optional.ofNullable(clazz.cast(this.entitlements()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEntitlementsResponse, T> g) {
        return obj -> g.apply((GetEntitlementsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MarketplaceEntitlementResponse.BuilderImpl
    implements Builder {
        private List<Entitlement> entitlements = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEntitlementsResponse model) {
            super(model);
            this.entitlements(model.entitlements);
            this.nextToken(model.nextToken);
        }

        public final List<Entitlement.Builder> getEntitlements() {
            List<Entitlement.Builder> result = EntitlementListCopier.copyToBuilder(this.entitlements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder entitlements(Collection<Entitlement> entitlements) {
            this.entitlements = EntitlementListCopier.copy(entitlements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Entitlement ... entitlements) {
            this.entitlements(Arrays.asList(entitlements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Consumer<Entitlement.Builder> ... entitlements) {
            this.entitlements(Stream.of(entitlements).map(c -> (Entitlement)((Entitlement.Builder)Entitlement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntitlements(Collection<Entitlement.BuilderImpl> entitlements) {
            this.entitlements = EntitlementListCopier.copyFromBuilder(entitlements);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetEntitlementsResponse build() {
            return new GetEntitlementsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MarketplaceEntitlementResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEntitlementsResponse> {
        public Builder entitlements(Collection<Entitlement> var1);

        public Builder entitlements(Entitlement ... var1);

        public Builder entitlements(Consumer<Entitlement.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

