/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceentitlement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The EntitlementValue represents the amount of capacity that the customer is entitled to for the product.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntitlementValue implements SdkPojo, Serializable,
        ToCopyableBuilder<EntitlementValue.Builder, EntitlementValue> {
    private static final SdkField<Integer> INTEGER_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("IntegerValue").getter(getter(EntitlementValue::integerValue)).setter(setter(Builder::integerValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegerValue").build()).build();

    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("DoubleValue").getter(getter(EntitlementValue::doubleValue)).setter(setter(Builder::doubleValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DoubleValue").build()).build();

    private static final SdkField<Boolean> BOOLEAN_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("BooleanValue").getter(getter(EntitlementValue::booleanValue)).setter(setter(Builder::booleanValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BooleanValue").build()).build();

    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StringValue").getter(getter(EntitlementValue::stringValue)).setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGER_VALUE_FIELD,
            DOUBLE_VALUE_FIELD, BOOLEAN_VALUE_FIELD, STRING_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer integerValue;

    private final Double doubleValue;

    private final Boolean booleanValue;

    private final String stringValue;

    private final Type type;

    private EntitlementValue(BuilderImpl builder) {
        this.integerValue = builder.integerValue;
        this.doubleValue = builder.doubleValue;
        this.booleanValue = builder.booleanValue;
        this.stringValue = builder.stringValue;
        this.type = builder.type;
    }

    /**
     * <p>
     * The IntegerValue field will be populated with an integer value when the entitlement is an integer type.
     * Otherwise, the field will not be set.
     * </p>
     * 
     * @return The IntegerValue field will be populated with an integer value when the entitlement is an integer type.
     *         Otherwise, the field will not be set.
     */
    public final Integer integerValue() {
        return integerValue;
    }

    /**
     * <p>
     * The DoubleValue field will be populated with a double value when the entitlement is a double type. Otherwise, the
     * field will not be set.
     * </p>
     * 
     * @return The DoubleValue field will be populated with a double value when the entitlement is a double type.
     *         Otherwise, the field will not be set.
     */
    public final Double doubleValue() {
        return doubleValue;
    }

    /**
     * <p>
     * The BooleanValue field will be populated with a boolean value when the entitlement is a boolean type. Otherwise,
     * the field will not be set.
     * </p>
     * 
     * @return The BooleanValue field will be populated with a boolean value when the entitlement is a boolean type.
     *         Otherwise, the field will not be set.
     */
    public final Boolean booleanValue() {
        return booleanValue;
    }

    /**
     * <p>
     * The StringValue field will be populated with a string value when the entitlement is a string type. Otherwise, the
     * field will not be set.
     * </p>
     * 
     * @return The StringValue field will be populated with a string value when the entitlement is a string type.
     *         Otherwise, the field will not be set.
     */
    public final String stringValue() {
        return stringValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(integerValue());
        hashCode = 31 * hashCode + Objects.hashCode(doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntitlementValue)) {
            return false;
        }
        EntitlementValue other = (EntitlementValue) obj;
        return Objects.equals(integerValue(), other.integerValue()) && Objects.equals(doubleValue(), other.doubleValue())
                && Objects.equals(booleanValue(), other.booleanValue()) && Objects.equals(stringValue(), other.stringValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EntitlementValue").add("IntegerValue", integerValue()).add("DoubleValue", doubleValue())
                .add("BooleanValue", booleanValue()).add("StringValue", stringValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IntegerValue":
            return Optional.ofNullable(clazz.cast(integerValue()));
        case "DoubleValue":
            return Optional.ofNullable(clazz.cast(doubleValue()));
        case "BooleanValue":
            return Optional.ofNullable(clazz.cast(booleanValue()));
        case "StringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #integerValue()} initialized to the given value.
     *
     * <p>
     * The IntegerValue field will be populated with an integer value when the entitlement is an integer type.
     * Otherwise, the field will not be set.
     * </p>
     * 
     * @param integerValue
     *        The IntegerValue field will be populated with an integer value when the entitlement is an integer type.
     *        Otherwise, the field will not be set.
     */
    public static EntitlementValue fromIntegerValue(Integer integerValue) {
        return builder().integerValue(integerValue).build();
    }

    /**
     * Create an instance of this class with {@link #doubleValue()} initialized to the given value.
     *
     * <p>
     * The DoubleValue field will be populated with a double value when the entitlement is a double type. Otherwise, the
     * field will not be set.
     * </p>
     * 
     * @param doubleValue
     *        The DoubleValue field will be populated with a double value when the entitlement is a double type.
     *        Otherwise, the field will not be set.
     */
    public static EntitlementValue fromDoubleValue(Double doubleValue) {
        return builder().doubleValue(doubleValue).build();
    }

    /**
     * Create an instance of this class with {@link #booleanValue()} initialized to the given value.
     *
     * <p>
     * The BooleanValue field will be populated with a boolean value when the entitlement is a boolean type. Otherwise,
     * the field will not be set.
     * </p>
     * 
     * @param booleanValue
     *        The BooleanValue field will be populated with a boolean value when the entitlement is a boolean type.
     *        Otherwise, the field will not be set.
     */
    public static EntitlementValue fromBooleanValue(Boolean booleanValue) {
        return builder().booleanValue(booleanValue).build();
    }

    /**
     * Create an instance of this class with {@link #stringValue()} initialized to the given value.
     *
     * <p>
     * The StringValue field will be populated with a string value when the entitlement is a string type. Otherwise, the
     * field will not be set.
     * </p>
     * 
     * @param stringValue
     *        The StringValue field will be populated with a string value when the entitlement is a string type.
     *        Otherwise, the field will not be set.
     */
    public static EntitlementValue fromStringValue(String stringValue) {
        return builder().stringValue(stringValue).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IntegerValue", INTEGER_VALUE_FIELD);
        map.put("DoubleValue", DOUBLE_VALUE_FIELD);
        map.put("BooleanValue", BOOLEAN_VALUE_FIELD);
        map.put("StringValue", STRING_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EntitlementValue, T> g) {
        return obj -> g.apply((EntitlementValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntitlementValue> {
        /**
         * <p>
         * The IntegerValue field will be populated with an integer value when the entitlement is an integer type.
         * Otherwise, the field will not be set.
         * </p>
         * 
         * @param integerValue
         *        The IntegerValue field will be populated with an integer value when the entitlement is an integer
         *        type. Otherwise, the field will not be set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerValue(Integer integerValue);

        /**
         * <p>
         * The DoubleValue field will be populated with a double value when the entitlement is a double type. Otherwise,
         * the field will not be set.
         * </p>
         * 
         * @param doubleValue
         *        The DoubleValue field will be populated with a double value when the entitlement is a double type.
         *        Otherwise, the field will not be set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleValue(Double doubleValue);

        /**
         * <p>
         * The BooleanValue field will be populated with a boolean value when the entitlement is a boolean type.
         * Otherwise, the field will not be set.
         * </p>
         * 
         * @param booleanValue
         *        The BooleanValue field will be populated with a boolean value when the entitlement is a boolean type.
         *        Otherwise, the field will not be set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanValue(Boolean booleanValue);

        /**
         * <p>
         * The StringValue field will be populated with a string value when the entitlement is a string type. Otherwise,
         * the field will not be set.
         * </p>
         * 
         * @param stringValue
         *        The StringValue field will be populated with a string value when the entitlement is a string type.
         *        Otherwise, the field will not be set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);
    }

    static final class BuilderImpl implements Builder {
        private Integer integerValue;

        private Double doubleValue;

        private Boolean booleanValue;

        private String stringValue;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EntitlementValue model) {
            integerValue(model.integerValue);
            doubleValue(model.doubleValue);
            booleanValue(model.booleanValue);
            stringValue(model.stringValue);
        }

        public final Integer getIntegerValue() {
            return integerValue;
        }

        public final void setIntegerValue(Integer integerValue) {
            Object oldValue = this.integerValue;
            this.integerValue = integerValue;
            handleUnionValueChange(Type.INTEGER_VALUE, oldValue, this.integerValue);
        }

        @Override
        public final Builder integerValue(Integer integerValue) {
            Object oldValue = this.integerValue;
            this.integerValue = integerValue;
            handleUnionValueChange(Type.INTEGER_VALUE, oldValue, this.integerValue);
            return this;
        }

        public final Double getDoubleValue() {
            return doubleValue;
        }

        public final void setDoubleValue(Double doubleValue) {
            Object oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
        }

        @Override
        public final Builder doubleValue(Double doubleValue) {
            Object oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
            return this;
        }

        public final Boolean getBooleanValue() {
            return booleanValue;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            Object oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            Object oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
            return this;
        }

        public final String getStringValue() {
            return stringValue;
        }

        public final void setStringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        @Override
        public EntitlementValue build() {
            return new EntitlementValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EntitlementValue#type()
     */
    public enum Type {
        INTEGER_VALUE,

        DOUBLE_VALUE,

        BOOLEAN_VALUE,

        STRING_VALUE,

        UNKNOWN_TO_SDK_VERSION
    }
}
