/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceentitlement.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The GetEntitlementsRequest contains parameters for the GetEntitlements operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEntitlementsRequest extends MarketplaceEntitlementRequest implements
        ToCopyableBuilder<GetEntitlementsRequest.Builder, GetEntitlementsRequest> {
    private static final SdkField<String> PRODUCT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductCode").getter(getter(GetEntitlementsRequest::productCode)).setter(setter(Builder::productCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").build()).build();

    private static final SdkField<Map<String, List<String>>> FILTER_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("Filter")
            .getter(getter(GetEntitlementsRequest::filterAsStrings))
            .setter(setter(Builder::filterWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetEntitlementsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetEntitlementsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_CODE_FIELD,
            FILTER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String productCode;

    private final Map<String, List<String>> filter;

    private final String nextToken;

    private final Integer maxResults;

    private GetEntitlementsRequest(BuilderImpl builder) {
        super(builder);
        this.productCode = builder.productCode;
        this.filter = builder.filter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Product code is used to uniquely identify a product in AWS Marketplace. The product code will be provided by AWS
     * Marketplace when the product listing is created.
     * </p>
     * 
     * @return Product code is used to uniquely identify a product in AWS Marketplace. The product code will be provided
     *         by AWS Marketplace when the product listing is created.
     */
    public final String productCode() {
        return productCode;
    }

    /**
     * <p>
     * Filter is used to return entitlements for a specific customer or for a specific dimension. Filters are described
     * as keys mapped to a lists of values. Filtered requests are <i>unioned</i> for each value in the value list, and
     * then <i>intersected</i> for each filter key.
     * </p>
     * <p>
     * <code>CustomerIdentifier</code> and <code>CustomerAWSAccountID</code> are mutually exclusive. You can't specify
     * both in the same request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilter} method.
     * </p>
     * 
     * @return Filter is used to return entitlements for a specific customer or for a specific dimension. Filters are
     *         described as keys mapped to a lists of values. Filtered requests are <i>unioned</i> for each value in the
     *         value list, and then <i>intersected</i> for each filter key.</p>
     *         <p>
     *         <code>CustomerIdentifier</code> and <code>CustomerAWSAccountID</code> are mutually exclusive. You can't
     *         specify both in the same request.
     */
    public final Map<GetEntitlementFilterName, List<String>> filter() {
        return GetEntitlementFiltersCopier.copyStringToEnum(filter);
    }

    /**
     * For responses, this returns true if the service returned a value for the Filter property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilter() {
        return filter != null && !(filter instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Filter is used to return entitlements for a specific customer or for a specific dimension. Filters are described
     * as keys mapped to a lists of values. Filtered requests are <i>unioned</i> for each value in the value list, and
     * then <i>intersected</i> for each filter key.
     * </p>
     * <p>
     * <code>CustomerIdentifier</code> and <code>CustomerAWSAccountID</code> are mutually exclusive. You can't specify
     * both in the same request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilter} method.
     * </p>
     * 
     * @return Filter is used to return entitlements for a specific customer or for a specific dimension. Filters are
     *         described as keys mapped to a lists of values. Filtered requests are <i>unioned</i> for each value in the
     *         value list, and then <i>intersected</i> for each filter key.</p>
     *         <p>
     *         <code>CustomerIdentifier</code> and <code>CustomerAWSAccountID</code> are mutually exclusive. You can't
     *         specify both in the same request.
     */
    public final Map<String, List<String>> filterAsStrings() {
        return filter;
    }

    /**
     * <p>
     * For paginated calls to GetEntitlements, pass the NextToken from the previous GetEntitlementsResult.
     * </p>
     * 
     * @return For paginated calls to GetEntitlements, pass the NextToken from the previous GetEntitlementsResult.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to retrieve from the GetEntitlements operation. For pagination, use the NextToken
     * field in subsequent calls to GetEntitlements.
     * </p>
     * 
     * @return The maximum number of items to retrieve from the GetEntitlements operation. For pagination, use the
     *         NextToken field in subsequent calls to GetEntitlements.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(productCode());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilter() ? filterAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEntitlementsRequest)) {
            return false;
        }
        GetEntitlementsRequest other = (GetEntitlementsRequest) obj;
        return Objects.equals(productCode(), other.productCode()) && hasFilter() == other.hasFilter()
                && Objects.equals(filterAsStrings(), other.filterAsStrings()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEntitlementsRequest").add("ProductCode", productCode())
                .add("Filter", hasFilter() ? filterAsStrings() : null).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductCode":
            return Optional.ofNullable(clazz.cast(productCode()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filterAsStrings()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProductCode", PRODUCT_CODE_FIELD);
        map.put("Filter", FILTER_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEntitlementsRequest, T> g) {
        return obj -> g.apply((GetEntitlementsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MarketplaceEntitlementRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEntitlementsRequest> {
        /**
         * <p>
         * Product code is used to uniquely identify a product in AWS Marketplace. The product code will be provided by
         * AWS Marketplace when the product listing is created.
         * </p>
         * 
         * @param productCode
         *        Product code is used to uniquely identify a product in AWS Marketplace. The product code will be
         *        provided by AWS Marketplace when the product listing is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCode(String productCode);

        /**
         * <p>
         * Filter is used to return entitlements for a specific customer or for a specific dimension. Filters are
         * described as keys mapped to a lists of values. Filtered requests are <i>unioned</i> for each value in the
         * value list, and then <i>intersected</i> for each filter key.
         * </p>
         * <p>
         * <code>CustomerIdentifier</code> and <code>CustomerAWSAccountID</code> are mutually exclusive. You can't
         * specify both in the same request.
         * </p>
         * 
         * @param filter
         *        Filter is used to return entitlements for a specific customer or for a specific dimension. Filters are
         *        described as keys mapped to a lists of values. Filtered requests are <i>unioned</i> for each value in
         *        the value list, and then <i>intersected</i> for each filter key.</p>
         *        <p>
         *        <code>CustomerIdentifier</code> and <code>CustomerAWSAccountID</code> are mutually exclusive. You
         *        can't specify both in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterWithStrings(Map<String, ? extends Collection<String>> filter);

        /**
         * <p>
         * Filter is used to return entitlements for a specific customer or for a specific dimension. Filters are
         * described as keys mapped to a lists of values. Filtered requests are <i>unioned</i> for each value in the
         * value list, and then <i>intersected</i> for each filter key.
         * </p>
         * <p>
         * <code>CustomerIdentifier</code> and <code>CustomerAWSAccountID</code> are mutually exclusive. You can't
         * specify both in the same request.
         * </p>
         * 
         * @param filter
         *        Filter is used to return entitlements for a specific customer or for a specific dimension. Filters are
         *        described as keys mapped to a lists of values. Filtered requests are <i>unioned</i> for each value in
         *        the value list, and then <i>intersected</i> for each filter key.</p>
         *        <p>
         *        <code>CustomerIdentifier</code> and <code>CustomerAWSAccountID</code> are mutually exclusive. You
         *        can't specify both in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Map<GetEntitlementFilterName, ? extends Collection<String>> filter);

        /**
         * <p>
         * For paginated calls to GetEntitlements, pass the NextToken from the previous GetEntitlementsResult.
         * </p>
         * 
         * @param nextToken
         *        For paginated calls to GetEntitlements, pass the NextToken from the previous GetEntitlementsResult.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to retrieve from the GetEntitlements operation. For pagination, use the NextToken
         * field in subsequent calls to GetEntitlements.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to retrieve from the GetEntitlements operation. For pagination, use the
         *        NextToken field in subsequent calls to GetEntitlements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MarketplaceEntitlementRequest.BuilderImpl implements Builder {
        private String productCode;

        private Map<String, List<String>> filter = DefaultSdkAutoConstructMap.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEntitlementsRequest model) {
            super(model);
            productCode(model.productCode);
            filterWithStrings(model.filter);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getProductCode() {
            return productCode;
        }

        public final void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        @Override
        public final Builder productCode(String productCode) {
            this.productCode = productCode;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getFilter() {
            if (filter instanceof SdkAutoConstructMap) {
                return null;
            }
            return filter;
        }

        public final void setFilter(Map<String, ? extends Collection<String>> filter) {
            this.filter = GetEntitlementFiltersCopier.copy(filter);
        }

        @Override
        public final Builder filterWithStrings(Map<String, ? extends Collection<String>> filter) {
            this.filter = GetEntitlementFiltersCopier.copy(filter);
            return this;
        }

        @Override
        public final Builder filter(Map<GetEntitlementFilterName, ? extends Collection<String>> filter) {
            this.filter = GetEntitlementFiltersCopier.copyEnumToString(filter);
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEntitlementsRequest build() {
            return new GetEntitlementsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
