/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacemetering.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UsageRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UsageRecord> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(UsageRecord.getter(UsageRecord::timestamp)).setter(UsageRecord.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<String> CUSTOMER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UsageRecord.getter(UsageRecord::customerIdentifier)).setter(UsageRecord.setter(Builder::customerIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerIdentifier").build()}).build();
    private static final SdkField<String> DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UsageRecord.getter(UsageRecord::dimension)).setter(UsageRecord.setter(Builder::dimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimension").build()}).build();
    private static final SdkField<Integer> QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UsageRecord.getter(UsageRecord::quantity)).setter(UsageRecord.setter(Builder::quantity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, CUSTOMER_IDENTIFIER_FIELD, DIMENSION_FIELD, QUANTITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant timestamp;
    private final String customerIdentifier;
    private final String dimension;
    private final Integer quantity;

    private UsageRecord(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.customerIdentifier = builder.customerIdentifier;
        this.dimension = builder.dimension;
        this.quantity = builder.quantity;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public String customerIdentifier() {
        return this.customerIdentifier;
    }

    public String dimension() {
        return this.dimension;
    }

    public Integer quantity() {
        return this.quantity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimension());
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageRecord)) {
            return false;
        }
        UsageRecord other = (UsageRecord)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.customerIdentifier(), other.customerIdentifier()) && Objects.equals(this.dimension(), other.dimension()) && Objects.equals(this.quantity(), other.quantity());
    }

    public String toString() {
        return ToString.builder((String)"UsageRecord").add("Timestamp", (Object)this.timestamp()).add("CustomerIdentifier", (Object)this.customerIdentifier()).add("Dimension", (Object)this.dimension()).add("Quantity", (Object)this.quantity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "CustomerIdentifier": {
                return Optional.ofNullable(clazz.cast(this.customerIdentifier()));
            }
            case "Dimension": {
                return Optional.ofNullable(clazz.cast(this.dimension()));
            }
            case "Quantity": {
                return Optional.ofNullable(clazz.cast(this.quantity()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UsageRecord, T> g) {
        return obj -> g.apply((UsageRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant timestamp;
        private String customerIdentifier;
        private String dimension;
        private Integer quantity;

        private BuilderImpl() {
        }

        private BuilderImpl(UsageRecord model) {
            this.timestamp(model.timestamp);
            this.customerIdentifier(model.customerIdentifier);
            this.dimension(model.dimension);
            this.quantity(model.quantity);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final String getCustomerIdentifier() {
            return this.customerIdentifier;
        }

        @Override
        public final Builder customerIdentifier(String customerIdentifier) {
            this.customerIdentifier = customerIdentifier;
            return this;
        }

        public final void setCustomerIdentifier(String customerIdentifier) {
            this.customerIdentifier = customerIdentifier;
        }

        public final String getDimension() {
            return this.dimension;
        }

        @Override
        public final Builder dimension(String dimension) {
            this.dimension = dimension;
            return this;
        }

        public final void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public UsageRecord build() {
            return new UsageRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UsageRecord> {
        public Builder timestamp(Instant var1);

        public Builder customerIdentifier(String var1);

        public Builder dimension(String var1);

        public Builder quantity(Integer var1);
    }
}

