/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacemetering.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the UsageRecords processed by BatchMeterUsage and any records that have failed due to transient error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchMeterUsageResponse extends MarketplaceMeteringResponse implements
        ToCopyableBuilder<BatchMeterUsageResponse.Builder, BatchMeterUsageResponse> {
    private static final SdkField<List<UsageRecordResult>> RESULTS_FIELD = SdkField
            .<List<UsageRecordResult>> builder(MarshallingType.LIST)
            .memberName("Results")
            .getter(getter(BatchMeterUsageResponse::results))
            .setter(setter(Builder::results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageRecordResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageRecordResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UsageRecord>> UNPROCESSED_RECORDS_FIELD = SdkField
            .<List<UsageRecord>> builder(MarshallingType.LIST)
            .memberName("UnprocessedRecords")
            .getter(getter(BatchMeterUsageResponse::unprocessedRecords))
            .setter(setter(Builder::unprocessedRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedRecords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD,
            UNPROCESSED_RECORDS_FIELD));

    private final List<UsageRecordResult> results;

    private final List<UsageRecord> unprocessedRecords;

    private BatchMeterUsageResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.unprocessedRecords = builder.unprocessedRecords;
    }

    /**
     * For responses, this returns true if the service returned a value for the Results property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResults() {
        return results != null && !(results instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains all UsageRecords processed by BatchMeterUsage. These records were either honored by AWS Marketplace
     * Metering Service or were invalid.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResults} method.
     * </p>
     * 
     * @return Contains all UsageRecords processed by BatchMeterUsage. These records were either honored by AWS
     *         Marketplace Metering Service or were invalid.
     */
    public final List<UsageRecordResult> results() {
        return results;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnprocessedRecords property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnprocessedRecords() {
        return unprocessedRecords != null && !(unprocessedRecords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains all UsageRecords that were not processed by BatchMeterUsage. This is a list of UsageRecords. You can
     * retry the failed request by making another BatchMeterUsage call with this list as input in the
     * BatchMeterUsageRequest.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnprocessedRecords} method.
     * </p>
     * 
     * @return Contains all UsageRecords that were not processed by BatchMeterUsage. This is a list of UsageRecords. You
     *         can retry the failed request by making another BatchMeterUsage call with this list as input in the
     *         BatchMeterUsageRequest.
     */
    public final List<UsageRecord> unprocessedRecords() {
        return unprocessedRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResults() ? results() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedRecords() ? unprocessedRecords() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchMeterUsageResponse)) {
            return false;
        }
        BatchMeterUsageResponse other = (BatchMeterUsageResponse) obj;
        return hasResults() == other.hasResults() && Objects.equals(results(), other.results())
                && hasUnprocessedRecords() == other.hasUnprocessedRecords()
                && Objects.equals(unprocessedRecords(), other.unprocessedRecords());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchMeterUsageResponse").add("Results", hasResults() ? results() : null)
                .add("UnprocessedRecords", hasUnprocessedRecords() ? unprocessedRecords() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Results":
            return Optional.ofNullable(clazz.cast(results()));
        case "UnprocessedRecords":
            return Optional.ofNullable(clazz.cast(unprocessedRecords()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchMeterUsageResponse, T> g) {
        return obj -> g.apply((BatchMeterUsageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MarketplaceMeteringResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchMeterUsageResponse> {
        /**
         * <p>
         * Contains all UsageRecords processed by BatchMeterUsage. These records were either honored by AWS Marketplace
         * Metering Service or were invalid.
         * </p>
         * 
         * @param results
         *        Contains all UsageRecords processed by BatchMeterUsage. These records were either honored by AWS
         *        Marketplace Metering Service or were invalid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<UsageRecordResult> results);

        /**
         * <p>
         * Contains all UsageRecords processed by BatchMeterUsage. These records were either honored by AWS Marketplace
         * Metering Service or were invalid.
         * </p>
         * 
         * @param results
         *        Contains all UsageRecords processed by BatchMeterUsage. These records were either honored by AWS
         *        Marketplace Metering Service or were invalid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(UsageRecordResult... results);

        /**
         * <p>
         * Contains all UsageRecords processed by BatchMeterUsage. These records were either honored by AWS Marketplace
         * Metering Service or were invalid.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UsageRecordResult>.Builder} avoiding the
         * need to create one manually via {@link List<UsageRecordResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UsageRecordResult>.Builder#build()} is called immediately
         * and its result is passed to {@link #results(List<UsageRecordResult>)}.
         * 
         * @param results
         *        a consumer that will call methods on {@link List<UsageRecordResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #results(List<UsageRecordResult>)
         */
        Builder results(Consumer<UsageRecordResult.Builder>... results);

        /**
         * <p>
         * Contains all UsageRecords that were not processed by BatchMeterUsage. This is a list of UsageRecords. You can
         * retry the failed request by making another BatchMeterUsage call with this list as input in the
         * BatchMeterUsageRequest.
         * </p>
         * 
         * @param unprocessedRecords
         *        Contains all UsageRecords that were not processed by BatchMeterUsage. This is a list of UsageRecords.
         *        You can retry the failed request by making another BatchMeterUsage call with this list as input in the
         *        BatchMeterUsageRequest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedRecords(Collection<UsageRecord> unprocessedRecords);

        /**
         * <p>
         * Contains all UsageRecords that were not processed by BatchMeterUsage. This is a list of UsageRecords. You can
         * retry the failed request by making another BatchMeterUsage call with this list as input in the
         * BatchMeterUsageRequest.
         * </p>
         * 
         * @param unprocessedRecords
         *        Contains all UsageRecords that were not processed by BatchMeterUsage. This is a list of UsageRecords.
         *        You can retry the failed request by making another BatchMeterUsage call with this list as input in the
         *        BatchMeterUsageRequest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedRecords(UsageRecord... unprocessedRecords);

        /**
         * <p>
         * Contains all UsageRecords that were not processed by BatchMeterUsage. This is a list of UsageRecords. You can
         * retry the failed request by making another BatchMeterUsage call with this list as input in the
         * BatchMeterUsageRequest.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UsageRecord>.Builder} avoiding the need to
         * create one manually via {@link List<UsageRecord>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UsageRecord>.Builder#build()} is called immediately and its
         * result is passed to {@link #unprocessedRecords(List<UsageRecord>)}.
         * 
         * @param unprocessedRecords
         *        a consumer that will call methods on {@link List<UsageRecord>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedRecords(List<UsageRecord>)
         */
        Builder unprocessedRecords(Consumer<UsageRecord.Builder>... unprocessedRecords);
    }

    static final class BuilderImpl extends MarketplaceMeteringResponse.BuilderImpl implements Builder {
        private List<UsageRecordResult> results = DefaultSdkAutoConstructList.getInstance();

        private List<UsageRecord> unprocessedRecords = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchMeterUsageResponse model) {
            super(model);
            results(model.results);
            unprocessedRecords(model.unprocessedRecords);
        }

        public final List<UsageRecordResult.Builder> getResults() {
            List<UsageRecordResult.Builder> result = UsageRecordResultListCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResults(Collection<UsageRecordResult.BuilderImpl> results) {
            this.results = UsageRecordResultListCopier.copyFromBuilder(results);
        }

        @Override
        @Transient
        public final Builder results(Collection<UsageRecordResult> results) {
            this.results = UsageRecordResultListCopier.copy(results);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder results(UsageRecordResult... results) {
            results(Arrays.asList(results));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder results(Consumer<UsageRecordResult.Builder>... results) {
            results(Stream.of(results).map(c -> UsageRecordResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<UsageRecord.Builder> getUnprocessedRecords() {
            List<UsageRecord.Builder> result = UsageRecordListCopier.copyToBuilder(this.unprocessedRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedRecords(Collection<UsageRecord.BuilderImpl> unprocessedRecords) {
            this.unprocessedRecords = UsageRecordListCopier.copyFromBuilder(unprocessedRecords);
        }

        @Override
        @Transient
        public final Builder unprocessedRecords(Collection<UsageRecord> unprocessedRecords) {
            this.unprocessedRecords = UsageRecordListCopier.copy(unprocessedRecords);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder unprocessedRecords(UsageRecord... unprocessedRecords) {
            unprocessedRecords(Arrays.asList(unprocessedRecords));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder unprocessedRecords(Consumer<UsageRecord.Builder>... unprocessedRecords) {
            unprocessedRecords(Stream.of(unprocessedRecords).map(c -> UsageRecord.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchMeterUsageResponse build() {
            return new BatchMeterUsageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
