/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacemetering.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>BatchMeterUsageRequest</code> contains <code>UsageRecords</code>, which indicate quantities of usage within
 * your application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchMeterUsageRequest extends MarketplaceMeteringRequest implements
        ToCopyableBuilder<BatchMeterUsageRequest.Builder, BatchMeterUsageRequest> {
    private static final SdkField<List<UsageRecord>> USAGE_RECORDS_FIELD = SdkField
            .<List<UsageRecord>> builder(MarshallingType.LIST)
            .memberName("UsageRecords")
            .getter(getter(BatchMeterUsageRequest::usageRecords))
            .setter(setter(Builder::usageRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageRecords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PRODUCT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductCode").getter(getter(BatchMeterUsageRequest::productCode)).setter(setter(Builder::productCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_RECORDS_FIELD,
            PRODUCT_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<UsageRecord> usageRecords;

    private final String productCode;

    private BatchMeterUsageRequest(BuilderImpl builder) {
        super(builder);
        this.usageRecords = builder.usageRecords;
        this.productCode = builder.productCode;
    }

    /**
     * For responses, this returns true if the service returned a value for the UsageRecords property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUsageRecords() {
        return usageRecords != null && !(usageRecords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The set of <code>UsageRecords</code> to submit. <code>BatchMeterUsage</code> accepts up to 25
     * <code>UsageRecords</code> at a time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsageRecords} method.
     * </p>
     * 
     * @return The set of <code>UsageRecords</code> to submit. <code>BatchMeterUsage</code> accepts up to 25
     *         <code>UsageRecords</code> at a time.
     */
    public final List<UsageRecord> usageRecords() {
        return usageRecords;
    }

    /**
     * <p>
     * Product code is used to uniquely identify a product in AWS Marketplace. The product code should be the same as
     * the one used during the publishing of a new product.
     * </p>
     * 
     * @return Product code is used to uniquely identify a product in AWS Marketplace. The product code should be the
     *         same as the one used during the publishing of a new product.
     */
    public final String productCode() {
        return productCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUsageRecords() ? usageRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(productCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchMeterUsageRequest)) {
            return false;
        }
        BatchMeterUsageRequest other = (BatchMeterUsageRequest) obj;
        return hasUsageRecords() == other.hasUsageRecords() && Objects.equals(usageRecords(), other.usageRecords())
                && Objects.equals(productCode(), other.productCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchMeterUsageRequest").add("UsageRecords", hasUsageRecords() ? usageRecords() : null)
                .add("ProductCode", productCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UsageRecords":
            return Optional.ofNullable(clazz.cast(usageRecords()));
        case "ProductCode":
            return Optional.ofNullable(clazz.cast(productCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UsageRecords", USAGE_RECORDS_FIELD);
        map.put("ProductCode", PRODUCT_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchMeterUsageRequest, T> g) {
        return obj -> g.apply((BatchMeterUsageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MarketplaceMeteringRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchMeterUsageRequest> {
        /**
         * <p>
         * The set of <code>UsageRecords</code> to submit. <code>BatchMeterUsage</code> accepts up to 25
         * <code>UsageRecords</code> at a time.
         * </p>
         * 
         * @param usageRecords
         *        The set of <code>UsageRecords</code> to submit. <code>BatchMeterUsage</code> accepts up to 25
         *        <code>UsageRecords</code> at a time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageRecords(Collection<UsageRecord> usageRecords);

        /**
         * <p>
         * The set of <code>UsageRecords</code> to submit. <code>BatchMeterUsage</code> accepts up to 25
         * <code>UsageRecords</code> at a time.
         * </p>
         * 
         * @param usageRecords
         *        The set of <code>UsageRecords</code> to submit. <code>BatchMeterUsage</code> accepts up to 25
         *        <code>UsageRecords</code> at a time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageRecords(UsageRecord... usageRecords);

        /**
         * <p>
         * The set of <code>UsageRecords</code> to submit. <code>BatchMeterUsage</code> accepts up to 25
         * <code>UsageRecords</code> at a time.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.marketplacemetering.model.UsageRecord.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.marketplacemetering.model.UsageRecord#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.marketplacemetering.model.UsageRecord.Builder#build()} is called
         * immediately and its result is passed to {@link #usageRecords(List<UsageRecord>)}.
         * 
         * @param usageRecords
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.marketplacemetering.model.UsageRecord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usageRecords(java.util.Collection<UsageRecord>)
         */
        Builder usageRecords(Consumer<UsageRecord.Builder>... usageRecords);

        /**
         * <p>
         * Product code is used to uniquely identify a product in AWS Marketplace. The product code should be the same
         * as the one used during the publishing of a new product.
         * </p>
         * 
         * @param productCode
         *        Product code is used to uniquely identify a product in AWS Marketplace. The product code should be the
         *        same as the one used during the publishing of a new product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCode(String productCode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MarketplaceMeteringRequest.BuilderImpl implements Builder {
        private List<UsageRecord> usageRecords = DefaultSdkAutoConstructList.getInstance();

        private String productCode;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchMeterUsageRequest model) {
            super(model);
            usageRecords(model.usageRecords);
            productCode(model.productCode);
        }

        public final List<UsageRecord.Builder> getUsageRecords() {
            List<UsageRecord.Builder> result = UsageRecordListCopier.copyToBuilder(this.usageRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsageRecords(Collection<UsageRecord.BuilderImpl> usageRecords) {
            this.usageRecords = UsageRecordListCopier.copyFromBuilder(usageRecords);
        }

        @Override
        public final Builder usageRecords(Collection<UsageRecord> usageRecords) {
            this.usageRecords = UsageRecordListCopier.copy(usageRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageRecords(UsageRecord... usageRecords) {
            usageRecords(Arrays.asList(usageRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageRecords(Consumer<UsageRecord.Builder>... usageRecords) {
            usageRecords(Stream.of(usageRecords).map(c -> UsageRecord.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getProductCode() {
            return productCode;
        }

        public final void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        @Override
        public final Builder productCode(String productCode) {
            this.productCode = productCode;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchMeterUsageRequest build() {
            return new BatchMeterUsageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
