/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacemetering.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterUsageResponse extends MarketplaceMeteringResponse implements
        ToCopyableBuilder<RegisterUsageResponse.Builder, RegisterUsageResponse> {
    private static final SdkField<Instant> PUBLIC_KEY_ROTATION_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("PublicKeyRotationTimestamp")
            .getter(getter(RegisterUsageResponse::publicKeyRotationTimestamp))
            .setter(setter(Builder::publicKeyRotationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeyRotationTimestamp").build())
            .build();

    private static final SdkField<String> SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Signature").getter(getter(RegisterUsageResponse::signature)).setter(setter(Builder::signature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Signature").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PUBLIC_KEY_ROTATION_TIMESTAMP_FIELD, SIGNATURE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant publicKeyRotationTimestamp;

    private final String signature;

    private RegisterUsageResponse(BuilderImpl builder) {
        super(builder);
        this.publicKeyRotationTimestamp = builder.publicKeyRotationTimestamp;
        this.signature = builder.signature;
    }

    /**
     * <p>
     * (Optional) Only included when public key version has expired
     * </p>
     * 
     * @return (Optional) Only included when public key version has expired
     */
    public final Instant publicKeyRotationTimestamp() {
        return publicKeyRotationTimestamp;
    }

    /**
     * <p>
     * JWT Token
     * </p>
     * 
     * @return JWT Token
     */
    public final String signature() {
        return signature;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(publicKeyRotationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(signature());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterUsageResponse)) {
            return false;
        }
        RegisterUsageResponse other = (RegisterUsageResponse) obj;
        return Objects.equals(publicKeyRotationTimestamp(), other.publicKeyRotationTimestamp())
                && Objects.equals(signature(), other.signature());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterUsageResponse").add("PublicKeyRotationTimestamp", publicKeyRotationTimestamp())
                .add("Signature", signature()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublicKeyRotationTimestamp":
            return Optional.ofNullable(clazz.cast(publicKeyRotationTimestamp()));
        case "Signature":
            return Optional.ofNullable(clazz.cast(signature()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PublicKeyRotationTimestamp", PUBLIC_KEY_ROTATION_TIMESTAMP_FIELD);
        map.put("Signature", SIGNATURE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterUsageResponse, T> g) {
        return obj -> g.apply((RegisterUsageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MarketplaceMeteringResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RegisterUsageResponse> {
        /**
         * <p>
         * (Optional) Only included when public key version has expired
         * </p>
         * 
         * @param publicKeyRotationTimestamp
         *        (Optional) Only included when public key version has expired
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKeyRotationTimestamp(Instant publicKeyRotationTimestamp);

        /**
         * <p>
         * JWT Token
         * </p>
         * 
         * @param signature
         *        JWT Token
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signature(String signature);
    }

    static final class BuilderImpl extends MarketplaceMeteringResponse.BuilderImpl implements Builder {
        private Instant publicKeyRotationTimestamp;

        private String signature;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterUsageResponse model) {
            super(model);
            publicKeyRotationTimestamp(model.publicKeyRotationTimestamp);
            signature(model.signature);
        }

        public final Instant getPublicKeyRotationTimestamp() {
            return publicKeyRotationTimestamp;
        }

        public final void setPublicKeyRotationTimestamp(Instant publicKeyRotationTimestamp) {
            this.publicKeyRotationTimestamp = publicKeyRotationTimestamp;
        }

        @Override
        public final Builder publicKeyRotationTimestamp(Instant publicKeyRotationTimestamp) {
            this.publicKeyRotationTimestamp = publicKeyRotationTimestamp;
            return this;
        }

        public final String getSignature() {
            return signature;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        @Override
        public RegisterUsageResponse build() {
            return new RegisterUsageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
