/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacemetering.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of the <code>ResolveCustomer</code> operation. Contains the <code>CustomerIdentifier</code> along with the
 * <code>CustomerAWSAccountId</code> and <code>ProductCode</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResolveCustomerResponse extends MarketplaceMeteringResponse implements
        ToCopyableBuilder<ResolveCustomerResponse.Builder, ResolveCustomerResponse> {
    private static final SdkField<String> CUSTOMER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomerIdentifier").getter(getter(ResolveCustomerResponse::customerIdentifier))
            .setter(setter(Builder::customerIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerIdentifier").build())
            .build();

    private static final SdkField<String> PRODUCT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductCode").getter(getter(ResolveCustomerResponse::productCode)).setter(setter(Builder::productCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").build()).build();

    private static final SdkField<String> CUSTOMER_AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomerAWSAccountId").getter(getter(ResolveCustomerResponse::customerAWSAccountId))
            .setter(setter(Builder::customerAWSAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerAWSAccountId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_IDENTIFIER_FIELD,
            PRODUCT_CODE_FIELD, CUSTOMER_AWS_ACCOUNT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String customerIdentifier;

    private final String productCode;

    private final String customerAWSAccountId;

    private ResolveCustomerResponse(BuilderImpl builder) {
        super(builder);
        this.customerIdentifier = builder.customerIdentifier;
        this.productCode = builder.productCode;
        this.customerAWSAccountId = builder.customerAWSAccountId;
    }

    /**
     * <p>
     * The <code>CustomerIdentifier</code> is used to identify an individual customer in your application. Calls to
     * <code>BatchMeterUsage</code> require <code>CustomerIdentifiers</code> for each <code>UsageRecord</code>.
     * </p>
     * 
     * @return The <code>CustomerIdentifier</code> is used to identify an individual customer in your application. Calls
     *         to <code>BatchMeterUsage</code> require <code>CustomerIdentifiers</code> for each
     *         <code>UsageRecord</code>.
     */
    public final String customerIdentifier() {
        return customerIdentifier;
    }

    /**
     * <p>
     * The product code is returned to confirm that the buyer is registering for your product. Subsequent
     * <code>BatchMeterUsage</code> calls should be made using this product code.
     * </p>
     * 
     * @return The product code is returned to confirm that the buyer is registering for your product. Subsequent
     *         <code>BatchMeterUsage</code> calls should be made using this product code.
     */
    public final String productCode() {
        return productCode;
    }

    /**
     * <p>
     * The <code>CustomerAWSAccountId</code> provides the AWS account ID associated with the
     * <code>CustomerIdentifier</code> for the individual customer.
     * </p>
     * 
     * @return The <code>CustomerAWSAccountId</code> provides the AWS account ID associated with the
     *         <code>CustomerIdentifier</code> for the individual customer.
     */
    public final String customerAWSAccountId() {
        return customerAWSAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(customerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(productCode());
        hashCode = 31 * hashCode + Objects.hashCode(customerAWSAccountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolveCustomerResponse)) {
            return false;
        }
        ResolveCustomerResponse other = (ResolveCustomerResponse) obj;
        return Objects.equals(customerIdentifier(), other.customerIdentifier())
                && Objects.equals(productCode(), other.productCode())
                && Objects.equals(customerAWSAccountId(), other.customerAWSAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResolveCustomerResponse").add("CustomerIdentifier", customerIdentifier())
                .add("ProductCode", productCode()).add("CustomerAWSAccountId", customerAWSAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomerIdentifier":
            return Optional.ofNullable(clazz.cast(customerIdentifier()));
        case "ProductCode":
            return Optional.ofNullable(clazz.cast(productCode()));
        case "CustomerAWSAccountId":
            return Optional.ofNullable(clazz.cast(customerAWSAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CustomerIdentifier", CUSTOMER_IDENTIFIER_FIELD);
        map.put("ProductCode", PRODUCT_CODE_FIELD);
        map.put("CustomerAWSAccountId", CUSTOMER_AWS_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResolveCustomerResponse, T> g) {
        return obj -> g.apply((ResolveCustomerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MarketplaceMeteringResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ResolveCustomerResponse> {
        /**
         * <p>
         * The <code>CustomerIdentifier</code> is used to identify an individual customer in your application. Calls to
         * <code>BatchMeterUsage</code> require <code>CustomerIdentifiers</code> for each <code>UsageRecord</code>.
         * </p>
         * 
         * @param customerIdentifier
         *        The <code>CustomerIdentifier</code> is used to identify an individual customer in your application.
         *        Calls to <code>BatchMeterUsage</code> require <code>CustomerIdentifiers</code> for each
         *        <code>UsageRecord</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerIdentifier(String customerIdentifier);

        /**
         * <p>
         * The product code is returned to confirm that the buyer is registering for your product. Subsequent
         * <code>BatchMeterUsage</code> calls should be made using this product code.
         * </p>
         * 
         * @param productCode
         *        The product code is returned to confirm that the buyer is registering for your product. Subsequent
         *        <code>BatchMeterUsage</code> calls should be made using this product code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCode(String productCode);

        /**
         * <p>
         * The <code>CustomerAWSAccountId</code> provides the AWS account ID associated with the
         * <code>CustomerIdentifier</code> for the individual customer.
         * </p>
         * 
         * @param customerAWSAccountId
         *        The <code>CustomerAWSAccountId</code> provides the AWS account ID associated with the
         *        <code>CustomerIdentifier</code> for the individual customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerAWSAccountId(String customerAWSAccountId);
    }

    static final class BuilderImpl extends MarketplaceMeteringResponse.BuilderImpl implements Builder {
        private String customerIdentifier;

        private String productCode;

        private String customerAWSAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolveCustomerResponse model) {
            super(model);
            customerIdentifier(model.customerIdentifier);
            productCode(model.productCode);
            customerAWSAccountId(model.customerAWSAccountId);
        }

        public final String getCustomerIdentifier() {
            return customerIdentifier;
        }

        public final void setCustomerIdentifier(String customerIdentifier) {
            this.customerIdentifier = customerIdentifier;
        }

        @Override
        public final Builder customerIdentifier(String customerIdentifier) {
            this.customerIdentifier = customerIdentifier;
            return this;
        }

        public final String getProductCode() {
            return productCode;
        }

        public final void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        @Override
        public final Builder productCode(String productCode) {
            this.productCode = productCode;
            return this;
        }

        public final String getCustomerAWSAccountId() {
            return customerAWSAccountId;
        }

        public final void setCustomerAWSAccountId(String customerAWSAccountId) {
            this.customerAWSAccountId = customerAWSAccountId;
        }

        @Override
        public final Builder customerAWSAccountId(String customerAWSAccountId) {
            this.customerAWSAccountId = customerAWSAccountId;
            return this;
        }

        @Override
        public ResolveCustomerResponse build() {
            return new ResolveCustomerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
